/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ClassArrayEditor
extends PropertyEditorSupport {
    private final ClassLoader classLoader;

    public ClassArrayEditor() {
        this(null);
    }

    public ClassArrayEditor(ClassLoader classLoader) {
        this.classLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    public void setAsText(String text2) throws IllegalArgumentException {
        if (StringUtils.hasText(text2)) {
            String[] classNames = StringUtils.commaDelimitedListToStringArray(text2);
            Class[] classes = new Class[classNames.length];
            for (int i = 0; i < classNames.length; ++i) {
                String className = classNames[i].trim();
                classes[i] = ClassUtils.resolveClassName(className, this.classLoader);
            }
            this.setValue(classes);
        } else {
            this.setValue(null);
        }
    }

    public String getAsText() {
        Class[] classes = (Class[])this.getValue();
        if (classes == null || classes.length == 0) {
            return "";
        }
        return ClassArrayEditor.toCommaDelimitedString(classes);
    }

    private static String toCommaDelimitedString(Class[] classes) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < classes.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(ClassUtils.getQualifiedName(classes[i]));
        }
        return buffer.toString();
    }
}

