/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import org.springframework.util.StringUtils;

public class CharacterEditor
extends PropertyEditorSupport {
    private static final String UNICODE_PREFIX = "\\u";
    private static final int UNICODE_LENGTH = 6;
    private final boolean allowEmpty;

    public CharacterEditor(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }

    public void setAsText(String text2) throws IllegalArgumentException {
        if (this.allowEmpty && !StringUtils.hasLength(text2)) {
            this.setValue(null);
        } else {
            if (text2 == null) {
                throw new IllegalArgumentException("null String cannot be converted to char type");
            }
            if (this.isUnicodeCharacterSequence(text2)) {
                this.setAsUnicode(text2);
            } else {
                if (text2.length() != 1) {
                    throw new IllegalArgumentException("String [" + text2 + "] with length " + text2.length() + " cannot be converted to char type");
                }
                this.setValue(new Character(text2.charAt(0)));
            }
        }
    }

    public String getAsText() {
        Object value = this.getValue();
        return value != null ? value.toString() : "";
    }

    private boolean isUnicodeCharacterSequence(String sequence2) {
        return sequence2.startsWith(UNICODE_PREFIX) && sequence2.length() == 6;
    }

    private void setAsUnicode(String text2) {
        int code = Integer.parseInt(text2.substring(UNICODE_PREFIX.length()), 16);
        this.setValue(new Character((char)code));
    }
}

