/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class UtilNamespaceHandler
extends NamespaceHandlerSupport {
    private static final String SCOPE_ATTRIBUTE = "scope";
    static /* synthetic */ Class class$org$springframework$beans$factory$config$FieldRetrievingFactoryBean;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$PropertyPathFactoryBean;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$ListFactoryBean;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$SetFactoryBean;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$MapFactoryBean;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$PropertiesFactoryBean;

    public void init() {
        this.registerBeanDefinitionParser("constant", new ConstantBeanDefinitionParser());
        this.registerBeanDefinitionParser("property-path", new PropertyPathBeanDefinitionParser());
        this.registerBeanDefinitionParser("list", new ListBeanDefinitionParser());
        this.registerBeanDefinitionParser("set", new SetBeanDefinitionParser());
        this.registerBeanDefinitionParser("map", new MapBeanDefinitionParser());
        this.registerBeanDefinitionParser("properties", new PropertiesBeanDefinitionParser());
    }

    private static class PropertiesBeanDefinitionParser
    extends AbstractSimpleBeanDefinitionParser {
        private PropertiesBeanDefinitionParser() {
        }

        protected Class getBeanClass(Element element2) {
            return class$org$springframework$beans$factory$config$PropertiesFactoryBean == null ? (class$org$springframework$beans$factory$config$PropertiesFactoryBean = UtilNamespaceHandler.class$("org.springframework.beans.factory.config.PropertiesFactoryBean")) : class$org$springframework$beans$factory$config$PropertiesFactoryBean;
        }

        protected boolean isEligibleAttribute(String attributeName) {
            return super.isEligibleAttribute(attributeName) && !UtilNamespaceHandler.SCOPE_ATTRIBUTE.equals(attributeName);
        }

        protected void doParse(Element element2, ParserContext parserContext, BeanDefinitionBuilder builder) {
            super.doParse(element2, parserContext, builder);
            Properties parsedProps = parserContext.getDelegate().parsePropsElement(element2);
            builder.addPropertyValue("properties", parsedProps);
            String scope = element2.getAttribute(UtilNamespaceHandler.SCOPE_ATTRIBUTE);
            if (StringUtils.hasLength(scope)) {
                builder.setScope(scope);
            }
        }
    }

    private static class MapBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private MapBeanDefinitionParser() {
        }

        protected Class getBeanClass(Element element2) {
            return class$org$springframework$beans$factory$config$MapFactoryBean == null ? (class$org$springframework$beans$factory$config$MapFactoryBean = UtilNamespaceHandler.class$("org.springframework.beans.factory.config.MapFactoryBean")) : class$org$springframework$beans$factory$config$MapFactoryBean;
        }

        protected void doParse(Element element2, ParserContext parserContext, BeanDefinitionBuilder builder) {
            String scope;
            String mapClass = element2.getAttribute("map-class");
            Map parsedMap = parserContext.getDelegate().parseMapElement(element2, builder.getRawBeanDefinition());
            builder.addPropertyValue("sourceMap", parsedMap);
            if (StringUtils.hasText(mapClass)) {
                builder.addPropertyValue("targetMapClass", mapClass);
            }
            if (StringUtils.hasLength(scope = element2.getAttribute(UtilNamespaceHandler.SCOPE_ATTRIBUTE))) {
                builder.setScope(scope);
            }
        }
    }

    private static class SetBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private SetBeanDefinitionParser() {
        }

        protected Class getBeanClass(Element element2) {
            return class$org$springframework$beans$factory$config$SetFactoryBean == null ? (class$org$springframework$beans$factory$config$SetFactoryBean = UtilNamespaceHandler.class$("org.springframework.beans.factory.config.SetFactoryBean")) : class$org$springframework$beans$factory$config$SetFactoryBean;
        }

        protected void doParse(Element element2, ParserContext parserContext, BeanDefinitionBuilder builder) {
            String scope;
            String setClass = element2.getAttribute("set-class");
            Set parsedSet = parserContext.getDelegate().parseSetElement(element2, builder.getRawBeanDefinition());
            builder.addPropertyValue("sourceSet", parsedSet);
            if (StringUtils.hasText(setClass)) {
                builder.addPropertyValue("targetSetClass", setClass);
            }
            if (StringUtils.hasLength(scope = element2.getAttribute(UtilNamespaceHandler.SCOPE_ATTRIBUTE))) {
                builder.setScope(scope);
            }
        }
    }

    private static class ListBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private ListBeanDefinitionParser() {
        }

        protected Class getBeanClass(Element element2) {
            return class$org$springframework$beans$factory$config$ListFactoryBean == null ? (class$org$springframework$beans$factory$config$ListFactoryBean = UtilNamespaceHandler.class$("org.springframework.beans.factory.config.ListFactoryBean")) : class$org$springframework$beans$factory$config$ListFactoryBean;
        }

        protected void doParse(Element element2, ParserContext parserContext, BeanDefinitionBuilder builder) {
            String scope;
            String listClass = element2.getAttribute("list-class");
            List parsedList = parserContext.getDelegate().parseListElement(element2, builder.getRawBeanDefinition());
            builder.addPropertyValue("sourceList", parsedList);
            if (StringUtils.hasText(listClass)) {
                builder.addPropertyValue("targetListClass", listClass);
            }
            if (StringUtils.hasLength(scope = element2.getAttribute(UtilNamespaceHandler.SCOPE_ATTRIBUTE))) {
                builder.setScope(scope);
            }
        }
    }

    private static class PropertyPathBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private PropertyPathBeanDefinitionParser() {
        }

        protected Class getBeanClass(Element element2) {
            return class$org$springframework$beans$factory$config$PropertyPathFactoryBean == null ? (class$org$springframework$beans$factory$config$PropertyPathFactoryBean = UtilNamespaceHandler.class$("org.springframework.beans.factory.config.PropertyPathFactoryBean")) : class$org$springframework$beans$factory$config$PropertyPathFactoryBean;
        }

        protected void doParse(Element element2, ParserContext parserContext, BeanDefinitionBuilder builder) {
            String path = element2.getAttribute("path");
            if (!StringUtils.hasText(path)) {
                parserContext.getReaderContext().error("Attribute 'path' must not be empty", element2);
                return;
            }
            int dotIndex = path.indexOf(".");
            if (dotIndex == -1) {
                parserContext.getReaderContext().error("Attribute 'path' must follow pattern 'beanName.propertyName'", element2);
                return;
            }
            String beanName = path.substring(0, dotIndex);
            String propertyPath = path.substring(dotIndex + 1);
            builder.addPropertyValue("targetBeanName", beanName);
            builder.addPropertyValue("propertyPath", propertyPath);
        }

        protected String resolveId(Element element2, AbstractBeanDefinition definition, ParserContext parserContext) {
            String id = super.resolveId(element2, definition, parserContext);
            if (!StringUtils.hasText(id)) {
                id = element2.getAttribute("path");
            }
            return id;
        }
    }

    private static class ConstantBeanDefinitionParser
    extends AbstractSimpleBeanDefinitionParser {
        private ConstantBeanDefinitionParser() {
        }

        protected Class getBeanClass(Element element2) {
            return class$org$springframework$beans$factory$config$FieldRetrievingFactoryBean == null ? (class$org$springframework$beans$factory$config$FieldRetrievingFactoryBean = UtilNamespaceHandler.class$("org.springframework.beans.factory.config.FieldRetrievingFactoryBean")) : class$org$springframework$beans$factory$config$FieldRetrievingFactoryBean;
        }

        protected String resolveId(Element element2, AbstractBeanDefinition definition, ParserContext parserContext) {
            String id = super.resolveId(element2, definition, parserContext);
            if (!StringUtils.hasText(id)) {
                id = element2.getAttribute("static-field");
            }
            return id;
        }
    }
}

