/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanIsAbstractException;
import org.springframework.beans.factory.BeanIsNotAFactoryException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.DisposableBeanAdapter;
import org.springframework.beans.factory.support.FactoryBeanRegistrySupport;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.CollectionFactory;
import org.springframework.core.DecoratingClassLoader;
import org.springframework.core.NamedThreadLocal;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractBeanFactory
extends FactoryBeanRegistrySupport
implements ConfigurableBeanFactory {
    private BeanFactory parentBeanFactory;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private ClassLoader tempClassLoader;
    private boolean cacheBeanMetadata = true;
    private final Set propertyEditorRegistrars = new LinkedHashSet(4);
    private final Map customEditors = new HashMap(4);
    private TypeConverter typeConverter;
    private final List beanPostProcessors = new ArrayList();
    private boolean hasInstantiationAwareBeanPostProcessors;
    private boolean hasDestructionAwareBeanPostProcessors;
    private final Map scopes = new HashMap();
    private final Map mergedBeanDefinitions = CollectionFactory.createConcurrentMapIfPossible(16);
    private final Set alreadyCreated = Collections.synchronizedSet(new HashSet());
    private final ThreadLocal prototypesCurrentlyInCreation = new NamedThreadLocal("Prototype beans currently in creation");

    public AbstractBeanFactory() {
    }

    public AbstractBeanFactory(BeanFactory parentBeanFactory) {
        this.parentBeanFactory = parentBeanFactory;
    }

    public Object getBean(String name2) throws BeansException {
        return this.getBean(name2, null, null);
    }

    public Object getBean(String name2, Class requiredType) throws BeansException {
        return this.getBean(name2, requiredType, null);
    }

    public Object getBean(String name2, Object[] args) throws BeansException {
        return this.getBean(name2, null, args);
    }

    public Object getBean(String name2, Class requiredType, Object[] args) throws BeansException {
        return this.doGetBean(name2, requiredType, args, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doGetBean(String name2, Class requiredType, final Object[] args, boolean typeCheckOnly) throws BeansException {
        final String beanName = this.transformedBeanName(name2);
        Object bean = null;
        Object sharedInstance = this.getSingleton(beanName);
        if (sharedInstance != null && args == null) {
            if (this.logger.isDebugEnabled()) {
                if (this.isSingletonCurrentlyInCreation(beanName)) {
                    this.logger.debug("Returning eagerly cached instance of singleton bean '" + beanName + "' that is not fully initialized yet - a consequence of a circular reference");
                } else {
                    this.logger.debug("Returning cached instance of singleton bean '" + beanName + "'");
                }
            }
            bean = this.getObjectForBeanInstance(sharedInstance, name2, beanName, null);
        } else {
            if (this.isPrototypeCurrentlyInCreation(beanName)) {
                throw new BeanCurrentlyInCreationException(beanName);
            }
            BeanFactory parentBeanFactory = this.getParentBeanFactory();
            if (parentBeanFactory != null && !this.containsBeanDefinition(beanName)) {
                String nameToLookup = this.originalBeanName(name2);
                if (args != null) {
                    return parentBeanFactory.getBean(nameToLookup, args);
                }
                return parentBeanFactory.getBean(nameToLookup, requiredType);
            }
            if (!typeCheckOnly) {
                this.markBeanAsCreated(beanName);
            }
            final RootBeanDefinition mbd = this.getMergedLocalBeanDefinition(beanName);
            this.checkMergedBeanDefinition(mbd, beanName, args);
            String[] dependsOn = mbd.getDependsOn();
            if (dependsOn != null) {
                for (int i = 0; i < dependsOn.length; ++i) {
                    String dependsOnBean = dependsOn[i];
                    this.getBean(dependsOnBean);
                    this.registerDependentBean(dependsOnBean, beanName);
                }
            }
            if (mbd.isSingleton()) {
                sharedInstance = this.getSingleton(beanName, new ObjectFactory(){

                    public Object getObject() throws BeansException {
                        try {
                            return AbstractBeanFactory.this.createBean(beanName, mbd, args);
                        }
                        catch (BeansException ex) {
                            AbstractBeanFactory.this.destroySingleton(beanName);
                            throw ex;
                        }
                    }
                });
                bean = this.getObjectForBeanInstance(sharedInstance, name2, beanName, mbd);
            } else if (mbd.isPrototype()) {
                Object prototypeInstance = null;
                try {
                    this.beforePrototypeCreation(beanName);
                    prototypeInstance = this.createBean(beanName, mbd, args);
                    Object var14_16 = null;
                    this.afterPrototypeCreation(beanName);
                }
                catch (Throwable throwable) {
                    Object var14_17 = null;
                    this.afterPrototypeCreation(beanName);
                    throw throwable;
                }
                bean = this.getObjectForBeanInstance(prototypeInstance, name2, beanName, mbd);
            } else {
                String scopeName = mbd.getScope();
                Scope scope = (Scope)this.scopes.get(scopeName);
                if (scope == null) {
                    throw new IllegalStateException("No Scope registered for scope '" + scopeName + "'");
                }
                try {
                    Object scopedInstance = scope.get(beanName, new ObjectFactory(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Object getObject() throws BeansException {
                            AbstractBeanFactory.this.beforePrototypeCreation(beanName);
                            try {
                                Object object = AbstractBeanFactory.this.createBean(beanName, mbd, args);
                                Object var3_2 = null;
                                AbstractBeanFactory.this.afterPrototypeCreation(beanName);
                                return object;
                            }
                            catch (Throwable throwable) {
                                Object var3_3 = null;
                                AbstractBeanFactory.this.afterPrototypeCreation(beanName);
                                throw throwable;
                            }
                        }
                    });
                    bean = this.getObjectForBeanInstance(scopedInstance, name2, beanName, mbd);
                }
                catch (IllegalStateException ex) {
                    throw new BeanCreationException(beanName, "Scope '" + scopeName + "' is not active for the current thread; " + "consider defining a scoped proxy for this bean if you intend to refer to it from a singleton", ex);
                }
            }
        }
        if (requiredType != null && bean != null && !requiredType.isAssignableFrom(bean.getClass())) {
            throw new BeanNotOfRequiredTypeException(name2, requiredType, bean.getClass());
        }
        return bean;
    }

    public boolean containsBean(String name2) {
        String beanName = this.transformedBeanName(name2);
        if (this.containsSingleton(beanName) || this.containsBeanDefinition(beanName)) {
            return !BeanFactoryUtils.isFactoryDereference(name2) || this.isFactoryBean(name2);
        }
        BeanFactory parentBeanFactory = this.getParentBeanFactory();
        return parentBeanFactory != null && parentBeanFactory.containsBean(this.originalBeanName(name2));
    }

    public boolean isSingleton(String name2) throws NoSuchBeanDefinitionException {
        String beanName = this.transformedBeanName(name2);
        Object beanInstance = this.getSingleton(beanName, false);
        if (beanInstance != null) {
            if (beanInstance instanceof FactoryBean) {
                return BeanFactoryUtils.isFactoryDereference(name2) || ((FactoryBean)beanInstance).isSingleton();
            }
            return !BeanFactoryUtils.isFactoryDereference(name2);
        }
        BeanFactory parentBeanFactory = this.getParentBeanFactory();
        if (parentBeanFactory != null && !this.containsBeanDefinition(beanName)) {
            return parentBeanFactory.isSingleton(this.originalBeanName(name2));
        }
        RootBeanDefinition mbd = this.getMergedLocalBeanDefinition(beanName);
        if (mbd.isSingleton()) {
            if (this.isFactoryBean(beanName, mbd)) {
                if (BeanFactoryUtils.isFactoryDereference(name2)) {
                    return true;
                }
                FactoryBean factoryBean = (FactoryBean)this.getBean("&" + beanName);
                return factoryBean.isSingleton();
            }
            return !BeanFactoryUtils.isFactoryDereference(name2);
        }
        return false;
    }

    public boolean isPrototype(String name2) throws NoSuchBeanDefinitionException {
        String beanName = this.transformedBeanName(name2);
        BeanFactory parentBeanFactory = this.getParentBeanFactory();
        if (parentBeanFactory != null && !this.containsBeanDefinition(beanName)) {
            return parentBeanFactory.isPrototype(this.originalBeanName(name2));
        }
        RootBeanDefinition mbd = this.getMergedLocalBeanDefinition(beanName);
        if (mbd.isPrototype()) {
            return !BeanFactoryUtils.isFactoryDereference(name2) || this.isFactoryBean(beanName, mbd);
        }
        if (BeanFactoryUtils.isFactoryDereference(name2)) {
            return false;
        }
        if (this.isFactoryBean(beanName, mbd)) {
            FactoryBean factoryBean = (FactoryBean)this.getBean("&" + beanName);
            return factoryBean instanceof SmartFactoryBean && ((SmartFactoryBean)factoryBean).isPrototype() || !factoryBean.isSingleton();
        }
        return false;
    }

    public boolean isTypeMatch(String name2, Class targetType) throws NoSuchBeanDefinitionException {
        String beanName = this.transformedBeanName(name2);
        Class typeToMatch = targetType != null ? targetType : Object.class;
        Object beanInstance = this.getSingleton(beanName, false);
        if (beanInstance != null) {
            if (beanInstance instanceof FactoryBean) {
                if (!BeanFactoryUtils.isFactoryDereference(name2)) {
                    Class type = this.getTypeForFactoryBean((FactoryBean)beanInstance);
                    return type != null && typeToMatch.isAssignableFrom(type);
                }
                return typeToMatch.isAssignableFrom(beanInstance.getClass());
            }
            return !BeanFactoryUtils.isFactoryDereference(name2) && typeToMatch.isAssignableFrom(beanInstance.getClass());
        }
        BeanFactory parentBeanFactory = this.getParentBeanFactory();
        if (parentBeanFactory != null && !this.containsBeanDefinition(beanName)) {
            return parentBeanFactory.isTypeMatch(this.originalBeanName(name2), targetType);
        }
        RootBeanDefinition mbd = this.getMergedLocalBeanDefinition(beanName);
        Class beanClass = this.predictBeanType(beanName, mbd, new Class[]{FactoryBean.class, typeToMatch});
        if (beanClass == null) {
            return false;
        }
        if (FactoryBean.class.isAssignableFrom(beanClass)) {
            if (!BeanFactoryUtils.isFactoryDereference(name2)) {
                Class type = this.getTypeForFactoryBean(beanName, mbd);
                return type != null && typeToMatch.isAssignableFrom(type);
            }
            return typeToMatch.isAssignableFrom(beanClass);
        }
        return !BeanFactoryUtils.isFactoryDereference(name2) && typeToMatch.isAssignableFrom(beanClass);
    }

    public Class getType(String name2) throws NoSuchBeanDefinitionException {
        String beanName = this.transformedBeanName(name2);
        Object beanInstance = this.getSingleton(beanName, false);
        if (beanInstance != null) {
            if (beanInstance instanceof FactoryBean && !BeanFactoryUtils.isFactoryDereference(name2)) {
                return this.getTypeForFactoryBean((FactoryBean)beanInstance);
            }
            return beanInstance.getClass();
        }
        BeanFactory parentBeanFactory = this.getParentBeanFactory();
        if (parentBeanFactory != null && !this.containsBeanDefinition(beanName)) {
            return parentBeanFactory.getType(this.originalBeanName(name2));
        }
        RootBeanDefinition mbd = this.getMergedLocalBeanDefinition(beanName);
        Class beanClass = this.predictBeanType(beanName, mbd, null);
        if (beanClass != null && FactoryBean.class.isAssignableFrom(beanClass)) {
            if (!BeanFactoryUtils.isFactoryDereference(name2)) {
                return this.getTypeForFactoryBean(beanName, mbd);
            }
            return beanClass;
        }
        return !BeanFactoryUtils.isFactoryDereference(name2) ? beanClass : null;
    }

    public String[] getAliases(String name2) {
        BeanFactory parentBeanFactory;
        String beanName = this.transformedBeanName(name2);
        ArrayList<String> aliases = new ArrayList<String>();
        boolean factoryPrefix = name2.startsWith("&");
        String fullBeanName = beanName;
        if (factoryPrefix) {
            fullBeanName = "&" + beanName;
        }
        if (!fullBeanName.equals(name2)) {
            aliases.add(fullBeanName);
        }
        String[] retrievedAliases = super.getAliases(beanName);
        for (int i = 0; i < retrievedAliases.length; ++i) {
            String alias = (factoryPrefix ? "&" : "") + retrievedAliases[i];
            if (alias.equals(name2)) continue;
            aliases.add(alias);
        }
        if (!this.containsSingleton(beanName) && !this.containsBeanDefinition(beanName) && (parentBeanFactory = this.getParentBeanFactory()) != null) {
            aliases.addAll(Arrays.asList(parentBeanFactory.getAliases(fullBeanName)));
        }
        return StringUtils.toStringArray(aliases);
    }

    public BeanFactory getParentBeanFactory() {
        return this.parentBeanFactory;
    }

    public boolean containsLocalBean(String name2) {
        String beanName = this.transformedBeanName(name2);
        return !(!this.containsSingleton(beanName) && !this.containsBeanDefinition(beanName) || BeanFactoryUtils.isFactoryDereference(name2) && !this.isFactoryBean(beanName));
    }

    public void setParentBeanFactory(BeanFactory parentBeanFactory) {
        if (this.parentBeanFactory != null && this.parentBeanFactory != parentBeanFactory) {
            throw new IllegalStateException("Already associated with parent BeanFactory: " + this.parentBeanFactory);
        }
        this.parentBeanFactory = parentBeanFactory;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader != null ? beanClassLoader : ClassUtils.getDefaultClassLoader();
    }

    public ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    public void setTempClassLoader(ClassLoader tempClassLoader) {
        this.tempClassLoader = tempClassLoader;
    }

    public ClassLoader getTempClassLoader() {
        return this.tempClassLoader;
    }

    public void setCacheBeanMetadata(boolean cacheBeanMetadata) {
        this.cacheBeanMetadata = cacheBeanMetadata;
    }

    public boolean isCacheBeanMetadata() {
        return this.cacheBeanMetadata;
    }

    public void addPropertyEditorRegistrar(PropertyEditorRegistrar registrar) {
        Assert.notNull(registrar, "PropertyEditorRegistrar must not be null");
        this.propertyEditorRegistrars.add(registrar);
    }

    public Set getPropertyEditorRegistrars() {
        return this.propertyEditorRegistrars;
    }

    public void registerCustomEditor(Class requiredType, Class propertyEditorClass) {
        Assert.notNull(requiredType, "Required type must not be null");
        Assert.isAssignable(PropertyEditor.class, propertyEditorClass);
        this.customEditors.put(requiredType, propertyEditorClass);
    }

    public void registerCustomEditor(Class requiredType, PropertyEditor propertyEditor) {
        Assert.notNull(requiredType, "Required type must not be null");
        Assert.notNull(propertyEditor, "PropertyEditor must not be null");
        this.customEditors.put(requiredType, propertyEditor);
    }

    public void copyRegisteredEditorsTo(PropertyEditorRegistry registry) {
        this.registerCustomEditors(registry);
    }

    public Map getCustomEditors() {
        return this.customEditors;
    }

    public void setTypeConverter(TypeConverter typeConverter) {
        this.typeConverter = typeConverter;
    }

    protected TypeConverter getCustomTypeConverter() {
        return this.typeConverter;
    }

    public TypeConverter getTypeConverter() {
        TypeConverter customConverter = this.getCustomTypeConverter();
        if (customConverter != null) {
            return customConverter;
        }
        SimpleTypeConverter typeConverter = new SimpleTypeConverter();
        this.registerCustomEditors(typeConverter);
        return typeConverter;
    }

    public void addBeanPostProcessor(BeanPostProcessor beanPostProcessor) {
        Assert.notNull(beanPostProcessor, "BeanPostProcessor must not be null");
        this.beanPostProcessors.add(beanPostProcessor);
        if (beanPostProcessor instanceof InstantiationAwareBeanPostProcessor) {
            this.hasInstantiationAwareBeanPostProcessors = true;
        }
        if (beanPostProcessor instanceof DestructionAwareBeanPostProcessor) {
            this.hasDestructionAwareBeanPostProcessors = true;
        }
    }

    public int getBeanPostProcessorCount() {
        return this.beanPostProcessors.size();
    }

    public List getBeanPostProcessors() {
        return this.beanPostProcessors;
    }

    protected boolean hasInstantiationAwareBeanPostProcessors() {
        return this.hasInstantiationAwareBeanPostProcessors;
    }

    protected boolean hasDestructionAwareBeanPostProcessors() {
        return this.hasDestructionAwareBeanPostProcessors;
    }

    public void registerScope(String scopeName, Scope scope) {
        Assert.notNull(scopeName, "Scope identifier must not be null");
        Assert.notNull(scope, "Scope must not be null");
        if ("singleton".equals(scopeName) || "prototype".equals(scopeName)) {
            throw new IllegalArgumentException("Cannot replace existing scopes 'singleton' and 'prototype'");
        }
        this.scopes.put(scopeName, scope);
    }

    public String[] getRegisteredScopeNames() {
        return StringUtils.toStringArray(this.scopes.keySet());
    }

    public Scope getRegisteredScope(String scopeName) {
        Assert.notNull(scopeName, "Scope identifier must not be null");
        return (Scope)this.scopes.get(scopeName);
    }

    public void copyConfigurationFrom(ConfigurableBeanFactory otherFactory) {
        Assert.notNull(otherFactory, "BeanFactory must not be null");
        this.setBeanClassLoader(otherFactory.getBeanClassLoader());
        this.setCacheBeanMetadata(otherFactory.isCacheBeanMetadata());
        if (otherFactory instanceof AbstractBeanFactory) {
            AbstractBeanFactory otherAbstractFactory = (AbstractBeanFactory)otherFactory;
            this.customEditors.putAll(otherAbstractFactory.customEditors);
            this.propertyEditorRegistrars.addAll(otherAbstractFactory.propertyEditorRegistrars);
            this.beanPostProcessors.addAll(otherAbstractFactory.beanPostProcessors);
            this.hasInstantiationAwareBeanPostProcessors = this.hasInstantiationAwareBeanPostProcessors || otherAbstractFactory.hasInstantiationAwareBeanPostProcessors;
            this.hasDestructionAwareBeanPostProcessors = this.hasDestructionAwareBeanPostProcessors || otherAbstractFactory.hasDestructionAwareBeanPostProcessors;
            this.scopes.putAll(otherAbstractFactory.scopes);
        }
    }

    public BeanDefinition getMergedBeanDefinition(String name2) throws BeansException {
        String beanName = this.transformedBeanName(name2);
        if (!this.containsBeanDefinition(beanName) && this.getParentBeanFactory() instanceof ConfigurableBeanFactory) {
            return ((ConfigurableBeanFactory)this.getParentBeanFactory()).getMergedBeanDefinition(beanName);
        }
        return this.getMergedLocalBeanDefinition(beanName);
    }

    public boolean isFactoryBean(String name2) throws NoSuchBeanDefinitionException {
        String beanName = this.transformedBeanName(name2);
        Object beanInstance = this.getSingleton(beanName, false);
        if (beanInstance != null) {
            return beanInstance instanceof FactoryBean;
        }
        if (!this.containsBeanDefinition(beanName) && this.getParentBeanFactory() instanceof ConfigurableBeanFactory) {
            return ((ConfigurableBeanFactory)this.getParentBeanFactory()).isFactoryBean(name2);
        }
        return this.isFactoryBean(beanName, this.getMergedLocalBeanDefinition(beanName));
    }

    protected void beforePrototypeCreation(String beanName) {
        Object curVal = this.prototypesCurrentlyInCreation.get();
        if (curVal == null) {
            this.prototypesCurrentlyInCreation.set(beanName);
        } else if (curVal instanceof String) {
            HashSet<Object> beanNameSet = new HashSet<Object>(2);
            beanNameSet.add(curVal);
            beanNameSet.add(beanName);
            this.prototypesCurrentlyInCreation.set(beanNameSet);
        } else {
            Set beanNameSet = (Set)curVal;
            beanNameSet.add(beanName);
        }
    }

    protected void afterPrototypeCreation(String beanName) {
        Object curVal = this.prototypesCurrentlyInCreation.get();
        if (curVal instanceof String) {
            this.prototypesCurrentlyInCreation.set(null);
        } else if (curVal instanceof Set) {
            Set beanNameSet = (Set)curVal;
            beanNameSet.remove(beanName);
            if (beanNameSet.isEmpty()) {
                this.prototypesCurrentlyInCreation.set(null);
            }
        }
    }

    protected final boolean isPrototypeCurrentlyInCreation(String beanName) {
        Object curVal = this.prototypesCurrentlyInCreation.get();
        return curVal != null && (curVal.equals(beanName) || curVal instanceof Set && ((Set)curVal).contains(beanName));
    }

    public boolean isCurrentlyInCreation(String beanName) {
        return this.isSingletonCurrentlyInCreation(beanName) || this.isPrototypeCurrentlyInCreation(beanName);
    }

    public void destroyBean(String beanName, Object beanInstance) {
        this.destroyBean(beanName, beanInstance, this.getMergedLocalBeanDefinition(beanName));
    }

    protected void destroyBean(String beanName, Object beanInstance, RootBeanDefinition mbd) {
        new DisposableBeanAdapter(beanInstance, beanName, mbd, this.getBeanPostProcessors()).destroy();
    }

    public void destroyScopedBean(String beanName) {
        RootBeanDefinition mbd = this.getMergedLocalBeanDefinition(beanName);
        if (mbd.isSingleton() || mbd.isPrototype()) {
            throw new IllegalArgumentException("Bean name '" + beanName + "' does not correspond to an object in a Scope");
        }
        String scopeName = mbd.getScope();
        Scope scope = (Scope)this.scopes.get(scopeName);
        if (scope == null) {
            throw new IllegalStateException("No Scope registered for scope '" + scopeName + "'");
        }
        Object bean = scope.remove(beanName);
        if (bean != null) {
            this.destroyBean(beanName, bean, mbd);
        }
    }

    protected String transformedBeanName(String name2) {
        return this.canonicalName(BeanFactoryUtils.transformedBeanName(name2));
    }

    protected String originalBeanName(String name2) {
        String beanName = this.transformedBeanName(name2);
        if (name2.startsWith("&")) {
            beanName = "&" + beanName;
        }
        return beanName;
    }

    protected void initBeanWrapper(BeanWrapper bw) {
        this.registerCustomEditors(bw);
    }

    protected void registerCustomEditors(PropertyEditorRegistry registry) {
        Iterator<Object> it;
        PropertyEditorRegistrySupport registrySupport;
        PropertyEditorRegistrySupport propertyEditorRegistrySupport = registrySupport = registry instanceof PropertyEditorRegistrySupport ? (PropertyEditorRegistrySupport)registry : null;
        if (registrySupport != null) {
            registrySupport.useConfigValueEditors();
        }
        if (!this.propertyEditorRegistrars.isEmpty()) {
            it = this.propertyEditorRegistrars.iterator();
            while (it.hasNext()) {
                PropertyEditorRegistrar registrar = (PropertyEditorRegistrar)it.next();
                try {
                    registrar.registerCustomEditors(registry);
                }
                catch (BeanCreationException ex) {
                    BeanCreationException bce;
                    Throwable rootCause = ex.getMostSpecificCause();
                    if (rootCause instanceof BeanCurrentlyInCreationException && this.isCurrentlyInCreation((bce = (BeanCreationException)rootCause).getBeanName())) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("PropertyEditorRegistrar [" + registrar.getClass().getName() + "] failed because it tried to obtain currently created bean '" + ex.getBeanName() + "': " + ex.getMessage());
                        }
                        this.onSuppressedException(ex);
                        continue;
                    }
                    throw ex;
                }
            }
        }
        if (!this.customEditors.isEmpty()) {
            it = this.customEditors.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                Class requiredType = (Class)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof PropertyEditor) {
                    PropertyEditor editor = (PropertyEditor)value;
                    if (registrySupport != null) {
                        registrySupport.registerSharedEditor(requiredType, editor);
                        continue;
                    }
                    registry.registerCustomEditor(requiredType, editor);
                    continue;
                }
                if (value instanceof Class) {
                    Class editorClass = (Class)value;
                    registry.registerCustomEditor(requiredType, (PropertyEditor)BeanUtils.instantiateClass(editorClass));
                    continue;
                }
                throw new IllegalStateException("Illegal custom editor value type: " + value.getClass().getName());
            }
        }
    }

    protected RootBeanDefinition getMergedLocalBeanDefinition(String beanName) throws BeansException {
        RootBeanDefinition mbd = (RootBeanDefinition)this.mergedBeanDefinitions.get(beanName);
        if (mbd != null) {
            return mbd;
        }
        return this.getMergedBeanDefinition(beanName, this.getBeanDefinition(beanName));
    }

    protected RootBeanDefinition getMergedBeanDefinition(String beanName, BeanDefinition bd) throws BeanDefinitionStoreException {
        return this.getMergedBeanDefinition(beanName, bd, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RootBeanDefinition getMergedBeanDefinition(String beanName, BeanDefinition bd, BeanDefinition containingBd) throws BeanDefinitionStoreException {
        Map map2 = this.mergedBeanDefinitions;
        synchronized (map2) {
            RootBeanDefinition mbd = null;
            if (containingBd == null) {
                mbd = (RootBeanDefinition)this.mergedBeanDefinitions.get(beanName);
            }
            if (mbd == null) {
                if (bd.getParentName() == null) {
                    mbd = new RootBeanDefinition(bd);
                } else {
                    BeanDefinition pbd;
                    block13: {
                        pbd = null;
                        try {
                            String parentBeanName = this.transformedBeanName(bd.getParentName());
                            if (!beanName.equals(parentBeanName)) {
                                pbd = this.getMergedBeanDefinition(parentBeanName);
                                break block13;
                            }
                            if (this.getParentBeanFactory() instanceof ConfigurableBeanFactory) {
                                pbd = ((ConfigurableBeanFactory)this.getParentBeanFactory()).getMergedBeanDefinition(parentBeanName);
                                break block13;
                            }
                            throw new NoSuchBeanDefinitionException(bd.getParentName(), "Parent name '" + bd.getParentName() + "' is equal to bean name '" + beanName + "': cannot be resolved without an AbstractBeanFactory parent");
                        }
                        catch (NoSuchBeanDefinitionException ex) {
                            throw new BeanDefinitionStoreException(bd.getResourceDescription(), beanName, "Could not resolve parent bean definition '" + bd.getParentName() + "'", ex);
                        }
                    }
                    mbd = new RootBeanDefinition(pbd);
                    mbd.overrideFrom(bd);
                }
                if (containingBd != null && !containingBd.isSingleton() && mbd.isSingleton()) {
                    mbd.setScope(containingBd.getScope());
                }
                if (containingBd == null && this.isCacheBeanMetadata() && this.isBeanEligibleForMetadataCaching(beanName)) {
                    this.mergedBeanDefinitions.put(beanName, mbd);
                }
            }
            return mbd;
        }
    }

    protected void checkMergedBeanDefinition(RootBeanDefinition mbd, String beanName, Object[] args) throws BeanDefinitionStoreException {
        if (mbd.isAbstract()) {
            throw new BeanIsAbstractException(beanName);
        }
        if (args != null && !mbd.isPrototype()) {
            throw new BeanDefinitionStoreException("Can only specify arguments for the getBean method when referring to a prototype bean definition");
        }
    }

    protected void clearMergedBeanDefinition(String beanName) {
        this.mergedBeanDefinitions.remove(beanName);
    }

    protected Class resolveBeanClass(RootBeanDefinition mbd, String beanName) {
        return this.resolveBeanClass(mbd, beanName, null);
    }

    protected Class resolveBeanClass(RootBeanDefinition mbd, String beanName, Class[] typesToMatch) throws CannotLoadBeanClassException {
        try {
            ClassLoader tempClassLoader;
            if (mbd.hasBeanClass()) {
                return mbd.getBeanClass();
            }
            if (typesToMatch != null && (tempClassLoader = this.getTempClassLoader()) != null) {
                String className;
                if (tempClassLoader instanceof DecoratingClassLoader) {
                    DecoratingClassLoader dcl = (DecoratingClassLoader)tempClassLoader;
                    for (int i = 0; i < typesToMatch.length; ++i) {
                        dcl.excludeClass(typesToMatch[i].getName());
                    }
                }
                return (className = mbd.getBeanClassName()) != null ? ClassUtils.forName(className, tempClassLoader) : null;
            }
            return mbd.resolveBeanClass(this.getBeanClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new CannotLoadBeanClassException(mbd.getResourceDescription(), beanName, mbd.getBeanClassName(), ex);
        }
        catch (LinkageError err) {
            throw new CannotLoadBeanClassException(mbd.getResourceDescription(), beanName, mbd.getBeanClassName(), err);
        }
    }

    protected Class predictBeanType(String beanName, RootBeanDefinition mbd, Class[] typesToMatch) {
        if (mbd.getFactoryMethodName() != null) {
            return null;
        }
        return this.resolveBeanClass(mbd, beanName, typesToMatch);
    }

    protected boolean isFactoryBean(String beanName, RootBeanDefinition mbd) {
        Class beanClass = this.predictBeanType(beanName, mbd, new Class[]{FactoryBean.class});
        return beanClass != null && FactoryBean.class.isAssignableFrom(beanClass);
    }

    protected Class getTypeForFactoryBean(String beanName, RootBeanDefinition mbd) {
        if (!mbd.isSingleton()) {
            return null;
        }
        try {
            FactoryBean factoryBean = (FactoryBean)this.doGetBean("&" + beanName, FactoryBean.class, null, true);
            return this.getTypeForFactoryBean(factoryBean);
        }
        catch (BeanCreationException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Ignoring bean creation exception on FactoryBean type check: " + ex);
            }
            this.onSuppressedException(ex);
            return null;
        }
    }

    protected void markBeanAsCreated(String beanName) {
        this.alreadyCreated.add(beanName);
    }

    protected boolean isBeanEligibleForMetadataCaching(String beanName) {
        return this.alreadyCreated.contains(beanName);
    }

    protected boolean removeSingletonIfCreatedForTypeCheckOnly(String beanName) {
        if (!this.alreadyCreated.contains(beanName)) {
            this.removeSingleton(beanName);
            return true;
        }
        return false;
    }

    protected Object getObjectForBeanInstance(Object beanInstance, String name2, String beanName, RootBeanDefinition mbd) {
        if (BeanFactoryUtils.isFactoryDereference(name2) && !(beanInstance instanceof FactoryBean)) {
            throw new BeanIsNotAFactoryException(this.transformedBeanName(name2), beanInstance.getClass());
        }
        if (!(beanInstance instanceof FactoryBean) || BeanFactoryUtils.isFactoryDereference(name2)) {
            return beanInstance;
        }
        Object object = null;
        if (mbd == null) {
            object = this.getCachedObjectForFactoryBean(beanName);
        }
        if (object == null) {
            FactoryBean factory = (FactoryBean)beanInstance;
            if (mbd == null && this.containsBeanDefinition(beanName)) {
                mbd = this.getMergedLocalBeanDefinition(beanName);
            }
            boolean synthetic = mbd != null && mbd.isSynthetic();
            object = this.getObjectFromFactoryBean(factory, beanName, !synthetic);
        }
        return object;
    }

    public boolean isBeanNameInUse(String beanName) {
        return this.isAlias(beanName) || this.containsLocalBean(beanName) || this.hasDependentBean(beanName);
    }

    protected boolean requiresDestruction(Object bean, RootBeanDefinition mbd) {
        return bean instanceof DisposableBean || mbd.getDestroyMethodName() != null || this.hasDestructionAwareBeanPostProcessors();
    }

    protected void registerDisposableBeanIfNecessary(String beanName, Object bean, RootBeanDefinition mbd) {
        if (!mbd.isPrototype() && this.requiresDestruction(bean, mbd)) {
            if (mbd.isSingleton()) {
                this.registerDisposableBean(beanName, new DisposableBeanAdapter(bean, beanName, mbd, this.getBeanPostProcessors()));
            } else {
                Scope scope = (Scope)this.scopes.get(mbd.getScope());
                if (scope == null) {
                    throw new IllegalStateException("No Scope registered for scope '" + mbd.getScope() + "'");
                }
                scope.registerDestructionCallback(beanName, new DisposableBeanAdapter(bean, beanName, mbd, this.getBeanPostProcessors()));
            }
        }
    }

    protected abstract boolean containsBeanDefinition(String var1);

    protected abstract BeanDefinition getBeanDefinition(String var1) throws BeansException;

    protected abstract Object createBean(String var1, RootBeanDefinition var2, Object[] var3) throws BeanCreationException;
}

