/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.generic;

import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericBeanFactoryAccessor {
    private final ListableBeanFactory beanFactory;

    public GenericBeanFactoryAccessor(ListableBeanFactory beanFactory) {
        Assert.notNull(beanFactory, "Bean factory must not be null");
        this.beanFactory = beanFactory;
    }

    public final ListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public <T> T getBean(String name2) throws BeansException {
        return (T)this.beanFactory.getBean(name2);
    }

    public <T> T getBean(String name2, Class<T> requiredType) throws BeansException {
        return (T)this.beanFactory.getBean(name2, requiredType);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type) throws BeansException {
        return this.beanFactory.getBeansOfType(type);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        return this.beanFactory.getBeansOfType(type, includeNonSingletons, allowEagerInit);
    }

    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) {
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        for (String beanName : this.beanFactory.getBeanNamesForType(Object.class)) {
            if (this.findAnnotationOnBean(beanName, annotationType) == null) continue;
            results.put(beanName, this.beanFactory.getBean(beanName));
        }
        return results;
    }

    public <A extends Annotation> A findAnnotationOnBean(String beanName, Class<A> annotationType) {
        AbstractBeanDefinition abd;
        ConfigurableBeanFactory cbf;
        BeanDefinition bd;
        Class handlerType = this.beanFactory.getType(beanName);
        A ann = AnnotationUtils.findAnnotation(handlerType, annotationType);
        if (ann == null && this.beanFactory instanceof ConfigurableBeanFactory && this.beanFactory.containsBeanDefinition(beanName) && (bd = (cbf = (ConfigurableBeanFactory)((Object)this.beanFactory)).getMergedBeanDefinition(beanName)) instanceof AbstractBeanDefinition && (abd = (AbstractBeanDefinition)bd).hasBeanClass()) {
            Class beanClass = abd.getBeanClass();
            ann = AnnotationUtils.findAnnotation(beanClass, annotationType);
        }
        return ann;
    }
}

