/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.JdkVersion;

public class MapFactoryBean
extends AbstractFactoryBean {
    private Map sourceMap;
    private Class targetMapClass;

    public void setSourceMap(Map sourceMap) {
        this.sourceMap = sourceMap;
    }

    public void setTargetMapClass(Class targetMapClass) {
        if (targetMapClass == null) {
            throw new IllegalArgumentException("'targetMapClass' must not be null");
        }
        if (!Map.class.isAssignableFrom(targetMapClass)) {
            throw new IllegalArgumentException("'targetMapClass' must implement [java.util.Map]");
        }
        this.targetMapClass = targetMapClass;
    }

    public Class getObjectType() {
        return Map.class;
    }

    protected Object createInstance() {
        if (this.sourceMap == null) {
            throw new IllegalArgumentException("'sourceMap' is required");
        }
        LinkedHashMap<Object, Object> result2 = null;
        result2 = this.targetMapClass != null ? (LinkedHashMap<Object, Object>)BeanUtils.instantiateClass(this.targetMapClass) : new LinkedHashMap<Object, Object>(this.sourceMap.size());
        Class keyType = null;
        Class valueType = null;
        if (this.targetMapClass != null && JdkVersion.isAtLeastJava15()) {
            keyType = GenericCollectionTypeResolver.getMapKeyType(this.targetMapClass);
            valueType = GenericCollectionTypeResolver.getMapValueType(this.targetMapClass);
        }
        if (keyType != null || valueType != null) {
            TypeConverter converter = this.getBeanTypeConverter();
            Iterator it = this.sourceMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object convertedKey = converter.convertIfNecessary(entry.getKey(), keyType);
                Object convertedValue = converter.convertIfNecessary(entry.getValue(), valueType);
                result2.put(convertedKey, convertedValue);
            }
        } else {
            result2.putAll(this.sourceMap);
        }
        return result2;
    }
}

