/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.annotation;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredAnnotationBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements PriorityOrdered {
    private Class<? extends Annotation> requiredAnnotationType = Required.class;
    private int order = 0x7FFFFFFE;
    private final Set<String> validatedBeanNames = Collections.synchronizedSet(new HashSet());

    public void setRequiredAnnotationType(Class<? extends Annotation> requiredAnnotationType) {
        Assert.notNull(requiredAnnotationType, "'requiredAnnotationType' must not be null");
        this.requiredAnnotationType = requiredAnnotationType;
    }

    protected Class<? extends Annotation> getRequiredAnnotationType() {
        return this.requiredAnnotationType;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        if (!this.validatedBeanNames.contains(beanName)) {
            ArrayList<String> invalidProperties = new ArrayList<String>();
            for (PropertyDescriptor pd : pds) {
                if (!this.isRequiredProperty(pd) || pvs.contains(pd.getName())) continue;
                invalidProperties.add(pd.getName());
            }
            if (!invalidProperties.isEmpty()) {
                throw new BeanInitializationException(this.buildExceptionMessage(invalidProperties, beanName));
            }
            this.validatedBeanNames.add(beanName);
        }
        return pvs;
    }

    protected boolean isRequiredProperty(PropertyDescriptor propertyDescriptor) {
        Method setter2 = propertyDescriptor.getWriteMethod();
        return setter2 != null && AnnotationUtils.getAnnotation(setter2, this.getRequiredAnnotationType()) != null;
    }

    private String buildExceptionMessage(List<String> invalidProperties, String beanName) {
        int size2 = invalidProperties.size();
        StringBuilder sb = new StringBuilder();
        sb.append(size2 == 1 ? "Property" : "Properties");
        for (int i = 0; i < size2; ++i) {
            String propertyName = invalidProperties.get(i);
            if (i > 0) {
                if (i == size2 - 1) {
                    sb.append(" and");
                } else {
                    sb.append(",");
                }
            }
            sb.append(" '").append(propertyName).append("'");
        }
        sb.append(size2 == 1 ? " is" : " are");
        sb.append(" required for bean '").append(beanName).append("'");
        return sb.toString();
    }
}

