/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.AbstractPropertyAccessor;
import org.springframework.beans.BeansException;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.TypeConverterDelegate;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class DirectFieldAccessor
extends AbstractPropertyAccessor {
    private final Object target;
    private final Map fieldMap = new HashMap();
    private final TypeConverterDelegate typeConverterDelegate;

    public DirectFieldAccessor(Object target) {
        Assert.notNull(target, "Target object must not be null");
        this.target = target;
        ReflectionUtils.doWithFields(this.target.getClass(), new ReflectionUtils.FieldCallback(){

            public void doWith(Field field2) {
                DirectFieldAccessor.this.fieldMap.put(field2.getName(), field2);
            }
        });
        this.typeConverterDelegate = new TypeConverterDelegate(this, target);
        this.registerDefaultEditors();
        this.setExtractOldValueForEditor(true);
    }

    public boolean isReadableProperty(String propertyName) throws BeansException {
        return this.fieldMap.containsKey(propertyName);
    }

    public boolean isWritableProperty(String propertyName) throws BeansException {
        return this.fieldMap.containsKey(propertyName);
    }

    public Class getPropertyType(String propertyName) throws BeansException {
        Field field2 = (Field)this.fieldMap.get(propertyName);
        if (field2 != null) {
            return field2.getType();
        }
        return null;
    }

    public Object getPropertyValue(String propertyName) throws BeansException {
        Field field2 = (Field)this.fieldMap.get(propertyName);
        if (field2 == null) {
            throw new NotReadablePropertyException(this.target.getClass(), propertyName, "Field '" + propertyName + "' does not exist");
        }
        try {
            ReflectionUtils.makeAccessible(field2);
            return field2.get(this.target);
        }
        catch (IllegalAccessException ex) {
            throw new InvalidPropertyException(this.target.getClass(), propertyName, "Field is not accessible", ex);
        }
    }

    public void setPropertyValue(String propertyName, Object newValue) throws BeansException {
        Field field2 = (Field)this.fieldMap.get(propertyName);
        if (field2 == null) {
            throw new NotWritablePropertyException(this.target.getClass(), propertyName, "Field '" + propertyName + "' does not exist");
        }
        Object oldValue = null;
        try {
            ReflectionUtils.makeAccessible(field2);
            oldValue = field2.get(this.target);
            Object convertedValue = this.typeConverterDelegate.convertIfNecessary(propertyName, oldValue, newValue, field2.getType());
            field2.set(this.target, convertedValue);
        }
        catch (IllegalAccessException ex) {
            throw new InvalidPropertyException(this.target.getClass(), propertyName, "Field is not accessible", ex);
        }
        catch (IllegalArgumentException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.target, propertyName, oldValue, newValue);
            throw new TypeMismatchException(pce, field2.getType(), (Throwable)ex);
        }
    }

    public Object convertIfNecessary(Object value, Class requiredType, MethodParameter methodParam) throws TypeMismatchException {
        try {
            return this.typeConverterDelegate.convertIfNecessary(value, requiredType, methodParam);
        }
        catch (IllegalArgumentException ex) {
            throw new TypeMismatchException(value, requiredType, (Throwable)ex);
        }
    }
}

