/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.tools.cmdline;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RdfDocumentWriter;
import org.openrdf.rio.rdfxml.RdfXmlWriter;
import org.openrdf.sesame.query.GraphQueryResultListener;

class StreamedGraphWriter
implements GraphQueryResultListener {
    protected RdfDocumentWriter writer = null;

    public StreamedGraphWriter(OutputStream os) throws IOException {
        OutputStreamWriter oswriter = new OutputStreamWriter(os, "utf8");
        this.writer = new RdfXmlWriter((Writer)oswriter);
    }

    public void triple(Resource subj, URI pred, Value obj) throws IOException {
        this.writer.writeStatement(subj, pred, obj);
    }

    public void namespace(String prefix, String name2) throws IOException {
        this.writer.setNamespace(prefix, name2);
    }

    public void startGraphQueryResult() throws IOException {
        this.writer.startDocument();
    }

    public void endGraphQueryResult() throws IOException {
        this.writer.endDocument();
    }

    public void reportError(String msg) {
        System.err.println("ERROR: " + msg);
    }
}

