/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.tools.cmdline;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import org.openrdf.sesame.Sesame;
import org.openrdf.sesame.admin.AdminListener;
import org.openrdf.sesame.admin.XmlAdminMsgWriter;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.constants.QueryLanguage;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.query.MalformedQueryException;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.XmlQueryResultWriter;
import org.openrdf.sesame.repository.SesameRepository;
import org.openrdf.sesame.repository.remote.HTTPService;
import org.openrdf.tools.cmdline.StreamedGraphWriter;

class SesameClient {
    protected SesameRepository _repository = null;

    public SesameClient(URL serverURL, String repository) throws Exception {
        HTTPService service = Sesame.getService(serverURL);
        String user = System.getProperty("user");
        String passwd = System.getProperty("passwd");
        if (user != null && passwd != null) {
            service.login(user, passwd);
        }
        this._repository = service.getRepository(repository);
    }

    public void constructQuery(String q) throws IOException, MalformedQueryException, AccessDeniedException, QueryEvaluationException {
        StreamedGraphWriter l = new StreamedGraphWriter(System.out);
        this._repository.performGraphQuery(QueryLanguage.SERQL, q, l);
    }

    public void selectQuery(String q) throws IOException, MalformedQueryException, AccessDeniedException, QueryEvaluationException {
        XmlQueryResultWriter l = new XmlQueryResultWriter(System.out);
        this._repository.performTableQuery(QueryLanguage.SERQL, q, l);
    }

    public void clear() throws IOException, AccessDeniedException {
        XmlAdminMsgWriter report = new XmlAdminMsgWriter(System.err);
        this._repository.clear(report);
    }

    public void upload(String file, String baseURI) throws IOException, AccessDeniedException {
        FileInputStream is = new FileInputStream(file);
        String base = baseURI;
        RDFFormat format2 = RDFFormat.RDFXML;
        boolean verify = true;
        XmlAdminMsgWriter report = new XmlAdminMsgWriter(System.err);
        this._repository.addData(is, base, format2, verify, (AdminListener)report);
    }

    public static void main(String[] args) throws Exception {
        String server = System.getProperty("server");
        if (server == null || server.equals("")) {
            throw new IOException("No -Dserver=<URL> option provided");
        }
        URL serverURL = new URL(server);
        String repository = System.getProperty("repository");
        if (repository == null || repository.equals("")) {
            throw new IOException("No -Drepository=<name> option provided");
        }
        String command = System.getProperty("command");
        if (command == null || command.equals("")) {
            throw new IOException("No -Dcommand=<command> provided");
        }
        SesameClient client = new SesameClient(serverURL, repository);
        if (command.startsWith("construct")) {
            client.constructQuery(command);
        } else if (command.startsWith("select")) {
            client.selectQuery(command);
        } else if (command.startsWith("clear")) {
            client.clear();
        } else if (command.startsWith("upload")) {
            String RDFfile = System.getProperty("file");
            if (RDFfile == null || RDFfile.equals("")) {
                throw new IOException("upload but no -Dfile=<filename> provided");
            }
            String BaseURL = System.getProperty("base");
            if (BaseURL == null || BaseURL.equals("")) {
                throw new IOException("upload but no -Dbase=<URI> provided");
            }
            client.upload(RDFfile, BaseURL);
        } else {
            throw new IOException("Unknown command: " + command);
        }
    }
}

