/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.server.soap;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Vector;
import org.apache.soap.Fault;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.Response;

public class SoapClient {
    String SERVER_URL = "http://62.213.161.156:8888/soap/servlet/rpcrouter";
    String SERVICE_NAME = "urn:SesameSoap";
    private static final String encodingStyleURI = "http://schemas.xmlsoap.org/soap/encoding/";
    private URL url;
    private Call call = new Call();
    private static Method addDataFromUrl_0;
    private static Method clearRepository_0;
    private static Method evalRdqlQuery_0;
    private static Method evalRqlQuery_0;
    private static Method extractRDF_0;
    private static Method getClasses_0;
    private static Method getClassesOf_0;
    private static Method getInstancesOf_0;
    private static Method getProperties_0;
    private static Method getStatements_0;
    private static Method hasStatement_0;
    private static Method getSubClassesOf_0;
    private static Method getSubPropertiesOf_0;
    private static Method getSuperClassesOf_0;
    private static Method getSuperPropertiesOf_0;
    private static Method isClass_0;
    private static Method isProperty_0;
    private static Method isInstanceOf_0;
    private static Method isSubClassOf_0;
    private static Method isSubPropertyOf_0;
    private static Method listRepositories_0;
    private static Method getRepositoryTitle_0;
    private static Method login_0;
    private static Method removeStatements_0;
    private static Method selectRepository_0;
    private static Method uploadData_0;
    private static Method labelState_0;
    private static Method labelCurrentState_0;
    private static Method revertToState_0;
    private static Method workWithState_0;
    private static Method branchState_0;
    private static Method getVersions_0;
    private static Method getUpdateIds_0;
    private static Method pauseCounterIncrement_0;
    private static Method continueCounterIncrement_0;
    private static Method isPausedCounterIncrement_0;
    private static Method getVersionIds_0;
    private static Method getMetaInfo_0;
    private static Method getVersionMetaInfo_0;
    private static Method getUpdateMetaInfo_0;

    public SoapClient(String ServerUrl, String ServiceName) throws MalformedURLException {
        this.SERVER_URL = ServerUrl;
        this.SERVICE_NAME = ServiceName;
        this.url = new URL(this.SERVER_URL);
        this.call.setEncodingStyleURI(encodingStyleURI);
        this.call.setSOAPMappingRegistry(new SOAPMappingRegistry());
        this.call.setTargetObjectURI(this.SERVICE_NAME);
    }

    private Object invoke(Method method, String[] names2, Object[] values) {
        Response resp;
        this.call.setMethodName(method.getName());
        Vector<Parameter> params = new Vector<Parameter>();
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int i = 0; i < names2.length; ++i) {
            Parameter p = new Parameter(names2[i], paramTypes[i], (Object)this.SERVICE_NAME, null);
            p.setValue(values[i]);
            params.addElement(p);
        }
        this.call.setParams(params);
        try {
            resp = this.call.invoke(this.url, "");
        }
        catch (SOAPException e) {
            System.err.println("Caught SOAPException (" + e.getFaultCode() + "): " + e.getMessage() + "\n");
            e.printStackTrace(System.err);
            return null;
        }
        if (!resp.generatedFault()) {
            Parameter ret = resp.getReturnValue();
            if (null != ret) {
                return ret.getValue();
            }
            return ret;
        }
        Fault fault = resp.getFault();
        System.err.println("Generated fault: " + fault);
        return null;
    }

    public String[] listRepositories() {
        return (String[])this.invoke(listRepositories_0, new String[0], new Object[0]);
    }

    public String getRepositoryTitle(String repositoryId) {
        return (String)this.invoke(getRepositoryTitle_0, new String[]{"repositoryId"}, new Object[]{repositoryId});
    }

    public boolean selectRepository(String repos) {
        Object o = this.invoke(selectRepository_0, new String[]{"repos"}, new Object[]{repos});
        return (Boolean)o;
    }

    public boolean login(String userID, String pass) {
        Object o = this.invoke(login_0, new String[]{"userID", "pass"}, new Object[]{userID, pass});
        return (Boolean)o;
    }

    public int addDataFromUrl(String dataUrl, String baseURL) {
        Object o = this.invoke(addDataFromUrl_0, new String[]{"dataUrl", "baseURL"}, new Object[]{dataUrl, baseURL});
        return (Integer)o;
    }

    public boolean clearRepository() {
        Object o = this.invoke(clearRepository_0, new String[0], new Object[0]);
        return (Boolean)o;
    }

    public Vector evalRdqlQuery(String query2) {
        return (Vector)this.invoke(evalRdqlQuery_0, new String[]{"query"}, new Object[]{query2});
    }

    public Vector evalRqlQuery(String query2) {
        return (Vector)this.invoke(evalRqlQuery_0, new String[]{"query"}, new Object[]{query2});
    }

    public String extractRDF(boolean ontology, boolean instances, boolean explicit) {
        return (String)this.invoke(extractRDF_0, new String[]{"ontology", "instances", "explicit"}, new Object[]{ontology, instances, explicit});
    }

    public Vector getClasses() {
        return (Vector)this.invoke(getClasses_0, new String[0], new Object[0]);
    }

    public Vector getClassesOf(String anInstance, boolean mostSpecific) {
        return (Vector)this.invoke(getClassesOf_0, new String[]{"anInstance", "mostSpecific"}, new Object[]{anInstance, mostSpecific});
    }

    public Vector getInstancesOf(String aClass, boolean proper) {
        return (Vector)this.invoke(getInstancesOf_0, new String[]{"aClass", "proper"}, new Object[]{aClass, proper});
    }

    public Vector getProperties() {
        return (Vector)this.invoke(getProperties_0, new String[0], new Object[0]);
    }

    public Vector getStatements(String subj, String pred, String obj, boolean explicitOnly, boolean objIsLiteral) {
        return (Vector)this.invoke(getStatements_0, new String[]{"subj", "pred", "obj", "explicitOnly", "objIsLiteral"}, new Object[]{subj, pred, obj, explicitOnly, objIsLiteral});
    }

    public boolean hasStatement(String subj, String pred, String obj, boolean explicitOnly, boolean objIsLiteral) {
        Object o = this.invoke(hasStatement_0, new String[]{"subj", "pred", "obj", "explicitOnly", "objIsLiteral"}, new Object[]{subj, pred, obj, explicitOnly, objIsLiteral});
        return (Boolean)o;
    }

    public Vector getSubClassesOf(String resource, boolean direct) {
        return (Vector)this.invoke(getSubClassesOf_0, new String[]{"resource", "direct"}, new Object[]{resource, direct});
    }

    public Vector getSubPropertiesOf(String resource, boolean direct) {
        return (Vector)this.invoke(getSubPropertiesOf_0, new String[]{"resource", "direct"}, new Object[]{resource, direct});
    }

    public Vector getSuperClassesOf(String resource, boolean direct) {
        return (Vector)this.invoke(getSuperClassesOf_0, new String[]{"resource", "direct"}, new Object[]{resource, direct});
    }

    public Vector getSuperPropertiesOf(String resource, boolean direct) {
        return (Vector)this.invoke(getSuperPropertiesOf_0, new String[]{"resource", "direct"}, new Object[]{resource, direct});
    }

    public boolean isClass(String resource) {
        Object o = this.invoke(isClass_0, new String[]{"resource"}, new Object[]{resource});
        return (Boolean)o;
    }

    public boolean isProperty(String resource) {
        Object o = this.invoke(isProperty_0, new String[]{"resource"}, new Object[]{resource});
        return (Boolean)o;
    }

    public boolean isInstanceOf(String anInstance, String aClass, boolean proper) {
        Object o = this.invoke(isInstanceOf_0, new String[]{"anInstance", "aClass", "proper"}, new Object[]{anInstance, aClass, proper});
        return (Boolean)o;
    }

    public boolean isSubClassOf(String subClass, String superClass, boolean direct) {
        Object o = this.invoke(isSubClassOf_0, new String[]{"subClass", "superClass", "direct"}, new Object[]{subClass, superClass, direct});
        return (Boolean)o;
    }

    public boolean isSubPropertyOf(String subProperty, String superProperty, boolean direct) {
        Object o = this.invoke(isSubPropertyOf_0, new String[]{"subProperty", "superProperty", "direct"}, new Object[]{subProperty, superProperty, direct});
        return (Boolean)o;
    }

    public int removeStatements(String subjURI, String predURI, String objURI, boolean bObjectIsLiteral) {
        Object o = this.invoke(removeStatements_0, new String[]{"subjURI", "predURI", "objURI", "bObjectIsLiteral"}, new Object[]{subjURI, predURI, objURI, bObjectIsLiteral});
        return (Integer)o;
    }

    public int uploadData(String data, String baseURL) {
        Object o = this.invoke(uploadData_0, new String[]{"data", "baseURL"}, new Object[]{data, baseURL});
        return (Integer)o;
    }

    public void labelState(String stateUID, String label) {
        this.invoke(labelState_0, new String[]{"stateUID", "label"}, new Object[]{stateUID, label});
    }

    public void labelCurrentState(String label) {
        this.invoke(labelCurrentState_0, new String[]{"label"}, new Object[]{label});
    }

    public void revertToState(String stateUID) {
        this.invoke(revertToState_0, new String[]{"stateUID"}, new Object[]{stateUID});
    }

    public void workWithState(String stateUID) {
        this.invoke(workWithState_0, new String[]{"stateUID"}, new Object[]{stateUID});
    }

    public String branchState(String stateUID) {
        Object o = this.invoke(branchState_0, new String[]{"stateUID"}, new Object[]{stateUID});
        return (String)o;
    }

    public Vector getVersions() {
        Object o = this.invoke(getVersions_0, new String[0], new Object[0]);
        return (Vector)o;
    }

    public Vector getUpdateIds() {
        Object o = this.invoke(getUpdateIds_0, new String[0], new Object[0]);
        Vector v = (Vector)o;
        return v;
    }

    public void pauseCounterIncrement() {
        this.invoke(pauseCounterIncrement_0, new String[0], new Object[0]);
    }

    public void continueCounterIncrement() {
        this.invoke(continueCounterIncrement_0, new String[0], new Object[0]);
    }

    public boolean isPausedCounterIncrement() {
        Object o = this.invoke(isPausedCounterIncrement_0, new String[0], new Object[0]);
        return (Boolean)o;
    }

    public Vector getVersionIds() {
        Object o = this.invoke(getVersionIds_0, new String[0], new Object[0]);
        Vector v = (Vector)o;
        return v;
    }

    public Map getMetaInfo(String subj, String pred, String obj) {
        Object o = this.invoke(getMetaInfo_0, new String[]{"subj", "pred", "obj"}, new Object[]{subj, pred, obj});
        Map map2 = (Map)o;
        return map2;
    }

    public Map getVersionMetaInfo(String versionId) {
        Object o = this.invoke(getVersionMetaInfo_0, new String[]{"versionId"}, new Object[]{versionId});
        Map map2 = (Map)o;
        return map2;
    }

    public Map getUpdateMetaInfo(String updateId) {
        Object o = this.invoke(getUpdateMetaInfo_0, new String[]{"updateId"}, new Object[]{updateId});
        Map map2 = (Map)o;
        return map2;
    }

    static {
        try {
            addDataFromUrl_0 = SoapClient.class.getMethod("addDataFromUrl", String.class, String.class);
            clearRepository_0 = SoapClient.class.getMethod("clearRepository", new Class[0]);
            evalRdqlQuery_0 = SoapClient.class.getMethod("evalRdqlQuery", String.class);
            evalRqlQuery_0 = SoapClient.class.getMethod("evalRqlQuery", String.class);
            extractRDF_0 = SoapClient.class.getMethod("extractRDF", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
            getClasses_0 = SoapClient.class.getMethod("getClasses", new Class[0]);
            getClassesOf_0 = SoapClient.class.getMethod("getClassesOf", String.class, Boolean.TYPE);
            getInstancesOf_0 = SoapClient.class.getMethod("getInstancesOf", String.class, Boolean.TYPE);
            getProperties_0 = SoapClient.class.getMethod("getProperties", new Class[0]);
            getStatements_0 = SoapClient.class.getMethod("getStatements", String.class, String.class, String.class, Boolean.TYPE, Boolean.TYPE);
            hasStatement_0 = SoapClient.class.getMethod("hasStatement", String.class, String.class, String.class, Boolean.TYPE, Boolean.TYPE);
            getSubClassesOf_0 = SoapClient.class.getMethod("getSubClassesOf", String.class, Boolean.TYPE);
            getSubPropertiesOf_0 = SoapClient.class.getMethod("getSubPropertiesOf", String.class, Boolean.TYPE);
            getSuperClassesOf_0 = SoapClient.class.getMethod("getSuperClassesOf", String.class, Boolean.TYPE);
            getSuperPropertiesOf_0 = SoapClient.class.getMethod("getSuperPropertiesOf", String.class, Boolean.TYPE);
            isClass_0 = SoapClient.class.getMethod("isClass", String.class);
            isProperty_0 = SoapClient.class.getMethod("isProperty", String.class);
            isInstanceOf_0 = SoapClient.class.getMethod("isInstanceOf", String.class, String.class, Boolean.TYPE);
            isSubClassOf_0 = SoapClient.class.getMethod("isSubClassOf", String.class, String.class, Boolean.TYPE);
            isSubPropertyOf_0 = SoapClient.class.getMethod("isSubPropertyOf", String.class, String.class, Boolean.TYPE);
            listRepositories_0 = SoapClient.class.getMethod("listRepositories", new Class[0]);
            getRepositoryTitle_0 = SoapClient.class.getMethod("getRepositoryTitle", String.class);
            login_0 = SoapClient.class.getMethod("login", String.class, String.class);
            removeStatements_0 = SoapClient.class.getMethod("removeStatements", String.class, String.class, String.class, Boolean.TYPE);
            selectRepository_0 = SoapClient.class.getMethod("selectRepository", String.class);
            uploadData_0 = SoapClient.class.getMethod("uploadData", String.class, String.class);
            labelState_0 = SoapClient.class.getMethod("labelState", String.class, String.class);
            labelCurrentState_0 = SoapClient.class.getMethod("labelCurrentState", String.class);
            revertToState_0 = SoapClient.class.getMethod("revertToState", String.class);
            workWithState_0 = SoapClient.class.getMethod("workWithState", String.class);
            branchState_0 = SoapClient.class.getMethod("branchState", String.class);
            getVersions_0 = SoapClient.class.getMethod("getVersions", new Class[0]);
            getUpdateIds_0 = SoapClient.class.getMethod("getUpdateIds", new Class[0]);
            pauseCounterIncrement_0 = SoapClient.class.getMethod("pauseCounterIncrement", new Class[0]);
            continueCounterIncrement_0 = SoapClient.class.getMethod("continueCounterIncrement", new Class[0]);
            isPausedCounterIncrement_0 = SoapClient.class.getMethod("isPausedCounterIncrement", new Class[0]);
            getVersionIds_0 = SoapClient.class.getMethod("getVersionIds", new Class[0]);
            getMetaInfo_0 = SoapClient.class.getMethod("getMetaInfo", String.class, String.class, String.class);
            getVersionMetaInfo_0 = SoapClient.class.getMethod("getVersionMetaInfo", String.class);
            getUpdateMetaInfo_0 = SoapClient.class.getMethod("getUpdateMetaInfo", String.class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }
}

