/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.server.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.sesame.admin.AdminListener;
import org.openrdf.sesame.admin.HtmlAdminMsgWriter;
import org.openrdf.sesame.admin.XmlAdminMsgWriter;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.config.ConfigurationException;
import org.openrdf.sesame.config.UnknownRepositoryException;
import org.openrdf.sesame.constants.AdminResultFormat;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.repository.SesameRepository;
import org.openrdf.sesame.repository.local.LocalService;
import org.openrdf.sesame.repository.remote.HTTPErrorType;
import org.openrdf.sesame.server.SesameServer;
import org.openrdf.sesame.server.http.HTTPOutputStream;
import org.openrdf.sesame.server.http.SesameServlet;
import org.openrdf.util.http.HttpServerUtil;
import org.openrdf.util.log.ThreadLog;

public class FileUploadServlet
extends SesameServlet {
    protected void _doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Map fileItemMap = HttpServerUtil.parseMultipartFormRequest((HttpServletRequest)request);
        InputStream rdfStream = HttpServerUtil.getStreamParameter((Map)fileItemMap, (String)"fileData");
        String repository = HttpServerUtil.getParameter((Map)fileItemMap, (String)"repository");
        String baseURI = HttpServerUtil.getParameter((Map)fileItemMap, (String)"baseURI");
        String dataFormatString = HttpServerUtil.getParameter((Map)fileItemMap, (String)"dataFormat");
        String format2 = HttpServerUtil.getParameter((Map)fileItemMap, (String)"resultFormat");
        String verify = HttpServerUtil.getParameter((Map)fileItemMap, (String)"verifyData");
        SesameServer.setThreadLogFileForRepository(repository);
        this._logIP(request);
        ThreadLog.log((String)">>> upload file");
        ThreadLog.trace((String)("repository = " + repository));
        ThreadLog.trace((String)("baseURI = " + baseURI));
        ThreadLog.trace((String)("dataFormat = " + dataFormatString));
        ThreadLog.trace((String)("resultFormat = " + format2));
        ThreadLog.trace((String)("verifyData = " + verify));
        if (rdfStream == null) {
            this._sendBadRequest("RDF data is missing", response);
            return;
        }
        if (baseURI == null || baseURI.length() == 0) {
            baseURI = "foo:bar";
        }
        if (repository == null || repository.length() == 0) {
            this._sendBadRequest("No repository specified", response);
            return;
        }
        RDFFormat dataFormat = dataFormatString == null || dataFormatString.length() == 0 ? RDFFormat.RDFXML : RDFFormat.forValue(dataFormatString);
        if (dataFormat != RDFFormat.RDFXML && dataFormat != RDFFormat.NTRIPLES && dataFormat != RDFFormat.TURTLE) {
            this._sendBadRequest("Unsupported data format: " + dataFormatString, response);
            return;
        }
        HTTPOutputStream httpOut = new HTTPOutputStream(response);
        httpOut.setCacheableResult(false);
        AdminListener report = null;
        AdminResultFormat resultFormat = null;
        resultFormat = format2 == null || format2.length() == 0 ? AdminResultFormat.XML : AdminResultFormat.forValue(format2);
        if (resultFormat == AdminResultFormat.XML) {
            httpOut.setContentType("text/xml");
            report = new XmlAdminMsgWriter(httpOut);
        } else if (resultFormat == AdminResultFormat.HTML) {
            httpOut.setContentType("text/html");
            report = new HtmlAdminMsgWriter(httpOut);
        } else {
            this._sendBadRequest("Unknown result format: " + format2, response);
            return;
        }
        boolean verifyData = verify != null && verify.equals("on");
        try {
            LocalService service = SesameServer.getLocalService();
            this._login(service);
            SesameRepository rep = service.getRepository(repository);
            long startTime = System.currentTimeMillis();
            rep.addData(rdfStream, baseURI, dataFormat, verifyData, report);
            rdfStream.close();
            long endTime = System.currentTimeMillis();
            ThreadLog.trace((String)("data added in " + (endTime - startTime) + "ms"));
        }
        catch (AccessDeniedException e) {
            this._sendForbidden("Access denied", response);
        }
        catch (ConfigurationException e) {
            this._sendInternalError("Configuration error", e, response);
        }
        catch (UnknownRepositoryException e) {
            this._sendBadRequest(HTTPErrorType.UNKNOWN_REPOSITORY, "Unknown repository: " + repository, response);
        }
        catch (RuntimeException e) {
            ThreadLog.error((String)("Unknown error on adding RDF data to repository " + repository), (Object)e);
        }
    }
}

