/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.server.http;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.ParseErrorListener;
import org.openrdf.rio.StatementHandler;
import org.openrdf.rio.StatementHandlerException;
import org.openrdf.rio.ntriples.NTriplesParser;
import org.openrdf.rio.rdfxml.RdfXmlParser;
import org.openrdf.rio.turtle.TurtleParser;
import org.openrdf.sesame.admin.AdminListener;
import org.openrdf.sesame.admin.HtmlAdminMsgWriter;
import org.openrdf.sesame.admin.XmlAdminMsgWriter;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.config.UnknownRepositoryException;
import org.openrdf.sesame.constants.AdminResultFormat;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.repository.local.LocalRepository;
import org.openrdf.sesame.repository.local.LocalService;
import org.openrdf.sesame.repository.remote.HTTPErrorType;
import org.openrdf.sesame.sail.RdfRepository;
import org.openrdf.sesame.sail.SailUpdateException;
import org.openrdf.sesame.server.SesameServer;
import org.openrdf.sesame.server.http.HTTPOutputStream;
import org.openrdf.sesame.server.http.SesameServlet;
import org.openrdf.util.http.HttpServerUtil;
import org.openrdf.util.log.ThreadLog;

public class DataMergeServlet
extends SesameServlet {
    protected void _doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (HttpServerUtil.isMultipartFormRequest((HttpServletRequest)request)) {
            this._handleMultipartFormRequest(request, response);
        } else {
            this._handleFormURLEncodedRequest(request, response);
        }
    }

    private void _handleFormURLEncodedRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String repository = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"repository");
        String resultFormatStr = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"resultFormat", (String)AdminResultFormat.XML.toString());
        String data = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"data");
        String baseURI = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"baseURI", (String)"foo:bar");
        String dataFormatStr = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"dataFormat");
        this._handleRequest(request, response, repository, resultFormatStr, data, baseURI, dataFormatStr);
    }

    private void _handleMultipartFormRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map fileItemMap = HttpServerUtil.parseMultipartFormRequest((HttpServletRequest)request);
        String repository = HttpServerUtil.getParameter((Map)fileItemMap, (String)"repository");
        String resultFormatStr = HttpServerUtil.getParameter((Map)fileItemMap, (String)"resultFormat", (String)AdminResultFormat.XML.toString());
        String data = HttpServerUtil.getParameter((Map)fileItemMap, (String)"data");
        String baseURI = HttpServerUtil.getParameter((Map)fileItemMap, (String)"baseURI", (String)"foo:bar");
        String dataFormatStr = HttpServerUtil.getParameter((Map)fileItemMap, (String)"dataFormat");
        this._handleRequest(request, response, repository, resultFormatStr, data, baseURI, dataFormatStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _handleRequest(HttpServletRequest request, HttpServletResponse response, String repository, String resultFormatStr, String data, String baseURI, String dataFormatStr) throws IOException {
        RdfRepository rdfRepository;
        AdminListener report;
        block29: {
            block28: {
                block27: {
                    SesameServer.setThreadLogFileForRepository(repository);
                    this._logIP(request);
                    ThreadLog.log((String)">>> merge data");
                    ThreadLog.trace((String)("repository = " + repository));
                    ThreadLog.trace((String)("resultFormat = " + resultFormatStr));
                    ThreadLog.trace((String)("data file sent: " + (data != null)));
                    ThreadLog.trace((String)("dataFormat = " + dataFormatStr));
                    if (repository == null) {
                        this._sendBadRequest("No repository specified", response);
                        return;
                    }
                    if (data == null) {
                        this._sendBadRequest("No data specified", response);
                        return;
                    }
                    HTTPOutputStream httpOut = new HTTPOutputStream(response);
                    httpOut.setCacheableResult(false);
                    AdminResultFormat resultFormat = AdminResultFormat.forValue(resultFormatStr);
                    report = null;
                    if (resultFormat == AdminResultFormat.XML) {
                        httpOut.setContentType("text/xml");
                        report = new XmlAdminMsgWriter(httpOut);
                    } else {
                        if (resultFormat != AdminResultFormat.HTML) {
                            this._sendBadRequest("Unknown result format: " + resultFormatStr, response);
                            return;
                        }
                        httpOut.setContentType("text/html");
                        report = new HtmlAdminMsgWriter(httpOut);
                    }
                    rdfRepository = null;
                    try {
                        try {
                            LocalService service = SesameServer.getLocalService();
                            this._login(service);
                            LocalRepository rep = (LocalRepository)service.getRepository(repository);
                            if (!rep.hasWriteAccess()) {
                                this._sendForbidden("Access denied", response);
                                Object var20_17 = null;
                                if (rdfRepository != null && rdfRepository.transactionStarted()) {
                                    rdfRepository.commitTransaction();
                                }
                                report.transactionEnd();
                                return;
                            }
                            rdfRepository = (RdfRepository)rep.getSail();
                            if (dataFormatStr == null) {
                                this._sendBadRequest("no data serialization format specified", response);
                                break block27;
                            }
                            TurtleParser parser = null;
                            RDFFormat dataFormat = RDFFormat.forValue(dataFormatStr);
                            if (dataFormat.equals((Object)RDFFormat.TURTLE)) {
                                parser = new TurtleParser();
                            } else if (dataFormat.equals((Object)RDFFormat.RDFXML)) {
                                parser = new RdfXmlParser();
                            } else {
                                if (!dataFormat.equals((Object)RDFFormat.NTRIPLES)) {
                                    this._sendBadRequest("unknown data serialization format: " + dataFormatStr, response);
                                    break block28;
                                }
                                parser = new NTriplesParser();
                            }
                            StatementMerger merger = new StatementMerger(rdfRepository);
                            parser.setStatementHandler((StatementHandler)merger);
                            ErrorHandler errorListener = new ErrorHandler(report);
                            parser.setParseErrorListener((ParseErrorListener)errorListener);
                            parser.setPreserveBNodeIds(true);
                            StringReader reader2 = new StringReader(data);
                            rdfRepository.startTransaction();
                            report.transactionStart();
                            parser.parse((Reader)reader2, baseURI);
                            break block29;
                        }
                        catch (UnknownRepositoryException e) {
                            this._sendBadRequest(HTTPErrorType.UNKNOWN_REPOSITORY, "Unknown repository: " + repository, response);
                            Object var20_21 = null;
                            if (rdfRepository != null && rdfRepository.transactionStarted()) {
                                rdfRepository.commitTransaction();
                            }
                            report.transactionEnd();
                            return;
                        }
                        catch (AccessDeniedException e) {
                            this._sendForbidden("Access denied", response);
                            Object var20_22 = null;
                            if (rdfRepository != null && rdfRepository.transactionStarted()) {
                                rdfRepository.commitTransaction();
                            }
                            report.transactionEnd();
                            return;
                        }
                        catch (Exception e) {
                            ThreadLog.error((String)("Unknown error on removing RDF data from repository " + repository), (Object)e);
                            report.error("The server generated an unknown error; Please inform the server administrator", -1, -1, null);
                            Object var20_23 = null;
                            if (rdfRepository != null && rdfRepository.transactionStarted()) {
                                rdfRepository.commitTransaction();
                            }
                            report.transactionEnd();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var20_24 = null;
                        if (rdfRepository != null && rdfRepository.transactionStarted()) {
                            rdfRepository.commitTransaction();
                        }
                        report.transactionEnd();
                        throw throwable;
                    }
                }
                Object var20_18 = null;
                if (rdfRepository != null && rdfRepository.transactionStarted()) {
                    rdfRepository.commitTransaction();
                }
                report.transactionEnd();
                return;
            }
            Object var20_19 = null;
            if (rdfRepository != null && rdfRepository.transactionStarted()) {
                rdfRepository.commitTransaction();
            }
            report.transactionEnd();
            return;
        }
        Object var20_20 = null;
        if (rdfRepository != null && rdfRepository.transactionStarted()) {
            rdfRepository.commitTransaction();
        }
        report.transactionEnd();
    }

    private static class ErrorHandler
    implements ParseErrorListener {
        private int _errorCount = 0;
        private int _statementCount = 0;
        private AdminListener _report;

        public ErrorHandler(AdminListener report) {
            this._report = report;
        }

        public int getErrorCount() {
            return this._errorCount;
        }

        public void resetErrorCount() {
            this._errorCount = 0;
        }

        public int getStatementCount() {
            return this._statementCount;
        }

        public void resetStatementCount() {
            this._statementCount = 0;
        }

        public void warning(String msg, int lineNo, int colNo) {
            this._report.notification(msg, lineNo, colNo, null);
        }

        public void error(String msg, int lineNo, int colNo) {
            this._report.warning(msg, lineNo, colNo, null);
            ++this._errorCount;
        }

        public void fatalError(String msg, int lineNo, int colNo) {
            this._report.error(msg, lineNo, colNo, null);
            ++this._errorCount;
        }
    }

    private static class StatementMerger
    implements StatementHandler {
        RdfRepository _rep;

        public StatementMerger(RdfRepository rep) {
            this._rep = rep;
        }

        public void handleStatement(Resource subject, URI predicate, Value object) throws StatementHandlerException {
            try {
                this._rep.addStatement(subject, predicate, object);
            }
            catch (SailUpdateException e) {
                throw new StatementHandlerException((Exception)e);
            }
        }
    }
}

