/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.server;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openrdf.sesame.config.SystemConfigHandler;
import org.openrdf.sesame.omm.SessionContext;
import org.openrdf.sesame.omm.SessionKilled;
import org.openrdf.sesame.server.SesameServer;

public final class SesameStartup {
    private static final String PARSER_KEY = "org.xml.sax.driver";
    private static final String DEFAULT_CONFIG_HANDLER = "org.openrdf.sesame.config.handlers.SystemConfigFileHandler";

    public static void initialize(String configHandlerClass, Map configParams) throws Exception {
        String parserValue = (String)configParams.get(PARSER_KEY);
        if (parserValue != null && parserValue.length() > 0) {
            System.setProperty(PARSER_KEY, parserValue);
        }
        SystemConfigHandler sch = null;
        sch = (SystemConfigHandler)Class.forName(configHandlerClass).newInstance();
        Iterator iter2 = sch.getParameterNames().iterator();
        while (iter2.hasNext()) {
            Object key = iter2.next();
            if (configParams.containsKey(key)) continue;
            throw new IllegalArgumentException(key + " is not found in the Params Map");
        }
        sch.setParameters(configParams);
        SesameServer.setSystemConfig(sch.loadConfig());
        SessionContext sc = SessionContext.getContext();
        if (sc == null) {
            sc = new SessionContext();
            SessionContext.put("main", sc);
            SessionContext.setContext(sc);
            new ThreadLocal<SessionKilled>().set(new SessionKilled("main"));
        }
    }

    public static void initialize(String fileName) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("systemConfigFile", fileName);
        SesameStartup.initialize(DEFAULT_CONFIG_HANDLER, params);
    }

    public static void initialize(String fileName, String parser) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("systemConfigFile", fileName);
        params.put(PARSER_KEY, parser);
        SesameStartup.initialize(DEFAULT_CONFIG_HANDLER, params);
    }
}

