/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.rdbms.rules;

public class Component
implements Comparable {
    public static final int VAR = 1;
    public static final int URI = 2;
    public static final int REGEXP = 3;
    private int type;
    private String value;
    private String regexpTemplate;
    private String escapeChar;

    public Component(String value, int type) {
        this.type = type;
        this.value = value;
    }

    public boolean isVar() {
        return this.type == 1 || this.type == 3;
    }

    public boolean isUri() {
        return this.type == 2;
    }

    public boolean isRegExp() {
        return this.type == 3;
    }

    public int getType() {
        return this.type;
    }

    public String value() {
        return this.value;
    }

    public int compareTo(Object obj) {
        if (obj instanceof Component) {
            if (this.value.length() == 0) {
                return -1;
            }
            return this.value.compareTo(((Component)obj).value());
        }
        return -1;
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public void setRegExpTemplate(String template, String escape2) {
        this.type = 3;
        this.regexpTemplate = template;
        if (escape2 != null) {
            this.escapeChar = escape2;
        }
    }

    String getRegExpTemplate() {
        return this.regexpTemplate;
    }

    String getRegExpEsc() {
        return this.escapeChar;
    }
}

