/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.rdbms;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import org.openrdf.sesame.sailimpl.rdbms.RDBMS;
import org.openrdf.sesame.sailimpl.rdbms.RdfSchemaRepository;
import org.openrdf.util.log.ThreadLog;

public class OptimizeThread
implements Runnable {
    static final int UNIT = 1000;
    private RdfSchemaRepository _sail;
    private static OptimizeThread theOnlyOptimizeThread = null;
    private static int minutes = 0;
    private static boolean bForceBreak = true;
    protected long ticksStart = 0L;
    protected HashSet tables;
    static Thread semafor = null;

    public static void onShutDown() {
        if (theOnlyOptimizeThread != null) {
            theOnlyOptimizeThread.forceBreak();
        }
    }

    public static void setTimeout(int minutes) {
        OptimizeThread.minutes = minutes;
    }

    public static void optimizeTable(RdfSchemaRepository sail, String table) {
        if (minutes == 0) {
            try {
                sail.getRDBMS().optimizeTable(table);
            }
            catch (SQLException e) {
                ThreadLog.warning((String)("SQLException while optimizing table " + table));
            }
            return;
        }
        if (theOnlyOptimizeThread == null) {
            theOnlyOptimizeThread = new OptimizeThread(sail);
            theOnlyOptimizeThread.add(table);
            new Thread(theOnlyOptimizeThread).start();
        } else {
            theOnlyOptimizeThread.add(table);
        }
    }

    protected OptimizeThread(RdfSchemaRepository sail) {
        this._sail = sail;
        this.tables = new HashSet();
        this.ticksStart = System.currentTimeMillis();
    }

    protected synchronized void add(String table) {
        long timeleft = this.ticksStart + (long)(minutes * 60 * 1000) - System.currentTimeMillis();
        System.out.println("table added: " + table + ". expected to start after" + timeleft);
        this.tables.add(table);
    }

    protected void commit() {
        RDBMS rdbms = null;
        if (this._sail != null) {
            rdbms = this._sail.getRDBMS();
        }
        Iterator iter2 = this.tables.iterator();
        while (iter2.hasNext()) {
            String table = (String)iter2.next();
            try {
                if (rdbms != null) {
                    long start2 = System.currentTimeMillis();
                    rdbms.optimizeTable(table);
                    System.out.println(table + " optimized for " + (System.currentTimeMillis() - start2) + "ms");
                } else {
                    System.out.println(table);
                }
                if (semafor == null) continue;
                System.out.println(table + " optimized");
            }
            catch (SQLException e) {
                ThreadLog.warning((String)("SQLException during OPTIMIZE(" + table + ")"));
            }
        }
        if (semafor != null) {
            semafor.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        OptimizeThread optimizeThread = this;
        synchronized (optimizeThread) {
            while (bForceBreak) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    this.notifyAll();
                }
                if (this.ticksStart + (long)(minutes * 60 * 1000) >= System.currentTimeMillis()) continue;
            }
            if (theOnlyOptimizeThread == this) {
                theOnlyOptimizeThread = null;
            }
            this.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceBreak() {
        bForceBreak = false;
        if (semafor == null) {
            try {
                Thread thread = semafor = Thread.currentThread();
                synchronized (thread) {
                    semafor.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        bForceBreak = true;
    }
}

