/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.rdbms;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.sesame.sail.SailInternalException;
import org.openrdf.sesame.sail.SailUpdateException;
import org.openrdf.sesame.sailimpl.rdbms.InferenceServices;
import org.openrdf.sesame.sailimpl.rdbms.PostgreSQL;
import org.openrdf.sesame.sailimpl.rdbms.RdfSchemaRepository;
import org.openrdf.sesame.sailimpl.rdbms.rules.Rule;
import org.openrdf.sesame.sailimpl.rdbms.rules.RuleParser;
import org.openrdf.sesame.sailimpl.rdbms.rules.TripleTemplate;
import org.openrdf.util.log.ThreadLog;
import org.xml.sax.SAXException;

public class CustomInferenceServices
implements InferenceServices {
    public static final String PARAM_RULE_FILE = "rule-file";
    static final String DEFAULT_RULE_FILE = "org/openrdf/sesame/sailimpl/rdbms/entailment-rdfmt-REC.xml";
    private static int maxTemplateCountsPerRule = 2;
    private boolean _useDependencyInferencer = true;
    ArrayList rules = null;
    ArrayList axioms = null;
    RdfSchemaRepository _sail = null;
    protected Connection _insertCon;
    protected PreparedStatement _insertSt;
    protected int iteration;
    protected int _nofInferred = 0;
    protected int _totalInferred = 0;
    protected int[] _ruleCount = null;
    protected long[] _ruleTime = null;
    ArrayList inferenceSQLs = null;
    ArrayList dependenceSQLs = null;
    protected boolean[][] _ruleTrigers = null;
    protected boolean[] _ruleIsApplied = null;

    public static int getMaxTemplateCountsPerRule() {
        return maxTemplateCountsPerRule;
    }

    public void setDependencyInferencer(boolean useDependencyInferencer) {
        this._useDependencyInferencer = useDependencyInferencer;
    }

    public void initialize(RdfSchemaRepository sail, Map configParams) {
        this._sail = sail;
        String ruleFileName = (String)configParams.get(PARAM_RULE_FILE);
        if (ruleFileName == null) {
            ThreadLog.warning((String)"No rule file defined. using default.");
            ruleFileName = DEFAULT_RULE_FILE;
        }
        ThreadLog.trace((String)("Using rule file: " + ruleFileName));
        RuleParser parser = new RuleParser();
        try {
            parser.load(ruleFileName);
        }
        catch (IOException e) {
            ThreadLog.error((String)("Rule parser i/o error: " + e.getMessage()));
            throw new SailInternalException(e);
        }
        catch (SAXException e) {
            ThreadLog.error((String)("Error parsing entailment rules: " + e.getMessage()));
            throw new SailInternalException(e);
        }
        this.rules = parser.getRules();
        this.axioms = parser.getAxioms();
        Iterator iter2 = this.rules.iterator();
        int max2 = 0;
        while (iter2.hasNext()) {
            Rule r = (Rule)iter2.next();
            if (max2 >= r.getPremiseCount()) continue;
            max2 = r.getPremiseCount();
        }
        maxTemplateCountsPerRule = max2;
    }

    public void initRdfSchema() {
        Iterator iter2 = Rule.constantsIter();
        while (iter2.hasNext()) {
            String uri2 = (String)iter2.next();
            int id = this._sail._insertURI(new URIImpl(uri2));
            Rule.setId(uri2, id);
        }
        this._initialize();
    }

    protected void _buildSQLs() {
        this.inferenceSQLs = new ArrayList();
        this.dependenceSQLs = new ArrayList();
        Iterator iter2 = this.rules.iterator();
        while (iter2.hasNext()) {
            Rule r = (Rule)iter2.next();
            ArrayList list = r.getAllSQLs();
            this.inferenceSQLs.addAll(list);
            list = r.getDependSQL();
            this.dependenceSQLs.addAll(list);
        }
        this._ruleCount = new int[this.inferenceSQLs.size()];
        this._ruleTime = new long[this.inferenceSQLs.size()];
        this._ruleIsApplied = new boolean[this.inferenceSQLs.size()];
        this._ruleTrigers = this.buildTriggers(this.rules);
    }

    void _initialize() {
        try {
            this._addAxioms();
            this._buildSQLs();
            this.doInferencing();
        }
        catch (SailUpdateException e) {
            throw new SailInternalException(e);
        }
    }

    public void doInferencing() {
        this.iteration = 1;
        this._totalInferred = 0;
        for (int i = 0; i < this.inferenceSQLs.size(); ++i) {
            this._ruleCount[i] = 0;
            this._ruleTime[i] = 0L;
        }
        try {
            this._nofInferred = 1;
            ThreadLog.trace((String)"starting inferencing");
            boolean[] rulesToApply = new boolean[this._ruleIsApplied.length];
            Arrays.fill(rulesToApply, true);
            while (this._nofInferred > 0) {
                this._nofInferred = 0;
                Arrays.fill(this._ruleIsApplied, false);
                for (int ruleNo = 0; ruleNo < this.inferenceSQLs.size(); ++ruleNo) {
                    if (!rulesToApply[ruleNo]) continue;
                    int newTriplesInferred = this._applyRule(ruleNo, (String)this.inferenceSQLs.get(ruleNo));
                    this._ruleIsApplied[ruleNo] = newTriplesInferred > 0;
                    this._nofInferred += newTriplesInferred;
                }
                this._totalInferred += this._nofInferred;
                Arrays.fill(rulesToApply, false);
                if (this._nofInferred > 0) {
                    for (int riRow = 0; riRow < rulesToApply.length; ++riRow) {
                        if (!this._ruleIsApplied[riRow]) continue;
                        boolean[] ruleRowFromTrigers = this._ruleTrigers[riRow];
                        for (int riColumn = 0; riColumn < rulesToApply.length; ++riColumn) {
                            rulesToApply[riColumn] = rulesToApply[riColumn] || ruleRowFromTrigers[riColumn];
                        }
                    }
                }
                this._sail._rdbms.clearTable("newtriples");
                if (this._nofInferred > 0) {
                    this._sail._rdbms.copyRows("allinferred", "newtriples");
                    this._sail._rdbms.copyRows("allinferred", "allnewtriples");
                    this._sail._rdbms.clearTable("allinferred");
                    this._sail._rdbms.optimizeTable("newtriples");
                    this._sail._rdbms.optimizeTable("triples");
                }
                ThreadLog.trace((String)("iteration " + this.iteration + " done; " + "inferred " + this._nofInferred + " new statements"));
                ++this.iteration;
            }
            this._sail._rdbms.optimizeTable("allnewtriples");
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
        catch (SailUpdateException e) {
            throw new SailInternalException(e);
        }
        ThreadLog.trace((String)"---RdfMTInferencer statistics:---");
        ThreadLog.trace((String)("total statements inferred = " + this._totalInferred));
        for (int i = 0; i < this.inferenceSQLs.size(); ++i) {
            ThreadLog.trace((String)("rule " + i + ": time=" + this._ruleTime[i] + ";\t#inferred=" + this._ruleCount[i]));
        }
        ThreadLog.trace((String)"---end of statistics:---");
    }

    public void removeExpiredStatements() throws SQLException {
        if (this._useDependencyInferencer) {
            this._makeExpiredStatementsInferred();
            this._determineGroundedStatements();
            Connection con = this._sail._rdbms.getConnection();
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery("SELECT t.id FROM triples t LEFT JOIN groundedtriples g ON t.id = g.id WHERE g.id IS NULL");
            String[] idChunks = this._sail._chunkIdSet(rs, 3500);
            rs.close();
            st.close();
            con.setAutoCommit(false);
            st = con.createStatement();
            for (int i = 0; i < idChunks.length; ++i) {
                st.executeUpdate("DELETE FROM triples WHERE id IN " + idChunks[i]);
                st.executeUpdate("DELETE FROM depend WHERE id IN " + idChunks[i]);
                for (int j = 1; j <= maxTemplateCountsPerRule; ++j) {
                    st.executeUpdate("DELETE FROM depend WHERE dep" + j + " IN " + idChunks[i]);
                }
                this._sail._processChunkFromRemoveExpiredStatements(idChunks[i]);
            }
            con.commit();
            st.close();
            con.close();
            this._sail._rdbms.clearTable("groundedtriples");
            this._sail._rdbms.clearTable("newgroundedtriples");
        } else {
            this._makeExpiredStatementsInferred();
            this._removeAllInferred();
            this._sail._rdbms.copyRows("triples", "newtriples");
            this._sail._rdbms.clearTable("triples");
            this._initialize();
        }
    }

    protected void _makeExpiredStatementsInferred() throws SQLException {
        Connection con = this._sail._rdbms.getConnection();
        Statement st = con.createStatement();
        ResultSet rs = st.executeQuery("SELECT DISTINCT id FROM expiredtriples");
        String[] idChunks = this._sail._chunkIdSet(rs, 3500);
        rs.close();
        st.close();
        con.setAutoCommit(false);
        st = con.createStatement();
        for (int i = 0; i < idChunks.length; ++i) {
            st.executeUpdate("UPDATE triples SET explicit = " + this._sail._rdbms.FALSE + " WHERE id IN " + idChunks[i]);
        }
        con.commit();
        st.close();
        con.close();
    }

    protected void _determineGroundedStatements() throws SQLException {
        int count2;
        this._sail._rdbms.executeUpdate("INSERT INTO groundedtriples VALUES(0)");
        this._sail._rdbms.executeUpdate("INSERT INTO groundedtriples SELECT id FROM triples WHERE explicit = " + this._sail._rdbms.TRUE);
        do {
            int i;
            String query2 = "INSERT INTO newgroundedtriples SELECT DISTINCT d.id FROM depend d LEFT JOIN groundedtriples g ON d.id = g.id";
            for (i = 1; i <= maxTemplateCountsPerRule; ++i) {
                query2 = query2 + " LEFT JOIN groundedtriples g" + i + " ON d.dep" + i + " = g" + i + ".id";
            }
            query2 = query2 + " WHERE g.id IS NULL";
            for (i = 1; i <= maxTemplateCountsPerRule; ++i) {
                query2 = query2 + " AND g" + i + ".id IS NOT NULL";
            }
            count2 = this._sail._rdbms.executeUpdate(query2);
            if (count2 <= 0) continue;
            this._sail._rdbms.copyRows("newgroundedtriples", "groundedtriples");
            this._sail._rdbms.clearTable("newgroundedtriples");
            this._sail._rdbms.optimizeTable("groundedtriples");
        } while (count2 > 0);
    }

    public void processNewStatements() {
        if (this._useDependencyInferencer) {
            Iterator iter2 = this.dependenceSQLs.iterator();
            while (iter2.hasNext()) {
                String s2 = (String)iter2.next();
                try {
                    this._sail._rdbms.executeUpdate(s2);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void markAxioms() {
        if (this._useDependencyInferencer) {
            ThreadLog.trace((String)"adding dependencies for axioms");
            try {
                String query2 = "INSERT INTO depend SELECT id";
                for (int i = 1; i <= maxTemplateCountsPerRule; ++i) {
                    query2 = query2 + ", 0";
                }
                query2 = query2 + " FROM allnewtriples";
                this._sail._rdbms.executeUpdate(query2);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            ThreadLog.trace((String)"dependencies for axioms added");
        }
    }

    protected void _prepareInsertConnection() throws SQLException {
        this._insertCon = this._sail._rdbms.getConnection();
        this._insertCon.setAutoCommit(false);
        this._insertSt = this._insertCon.prepareStatement("INSERT INTO inferred VALUES(?, ?, ?, ?, ?)");
        this._insertSt.setBoolean(5, false);
    }

    protected void _closeInsertConnection(boolean mustCommit) throws SQLException {
        if (mustCommit) {
            this._insertCon.commit();
        }
        this._insertSt.close();
        this._insertCon.close();
    }

    protected void _addAxioms() throws SailUpdateException {
        ThreadLog.trace((String)"adding axioms");
        try {
            this._prepareInsertConnection();
            Iterator iter2 = this.axioms.iterator();
            while (iter2.hasNext()) {
                TripleTemplate t = (TripleTemplate)iter2.next();
                this._insertSt.setInt(1, this._sail._getNextStatementId());
                this._insertSt.setInt(2, Rule.getIntId(t.subject));
                this._insertSt.setInt(3, Rule.getIntId(t.predicate));
                this._insertSt.setInt(4, Rule.getIntId(t.object));
                this._insertSt.executeUpdate();
            }
            this._closeInsertConnection(true);
            int newAxioms = this._sail._rdbms.executeUpdate("INSERT INTO newtriples SELECT inf.* FROM inferred inf LEFT JOIN triples t ON inf.subj = t.subj AND inf.pred = t.pred AND inf.obj = t.obj WHERE t.subj IS NULL");
            if (newAxioms > 0) {
                this._sail._rdbms.copyRows("newtriples", "triples");
                this._sail._rdbms.copyRows("newtriples", "allnewtriples");
            }
            this._sail._rdbms.clearTable("inferred");
        }
        catch (SQLException e) {
            throw new SailUpdateException(e);
        }
    }

    protected int _applyRule(int ruleNo, String query2) throws SailUpdateException {
        long startTime = System.currentTimeMillis();
        int nofInferred = 0;
        try {
            this._prepareInsertConnection();
            Connection queryCon = this._sail._rdbms.getConnection();
            Statement querySt = queryCon.createStatement();
            ResultSet rs = querySt.executeQuery(query2);
            while (rs.next()) {
                this._insertSt.setInt(1, this._sail._getNextStatementId());
                this._insertSt.setInt(2, rs.getInt(1));
                this._insertSt.setInt(3, rs.getInt(2));
                this._insertSt.setInt(4, rs.getInt(3));
                this._insertSt.executeUpdate();
                ++nofInferred;
            }
            rs.close();
            querySt.close();
            queryCon.close();
            this._closeInsertConnection(nofInferred > 0);
            if (nofInferred > 0) {
                int n = ruleNo;
                this._ruleCount[n] = this._ruleCount[n] + nofInferred;
                this._sail._rdbms.copyRows("inferred", "allinferred");
                this._sail._rdbms.copyRows("inferred", "triples");
                this._sail._rdbms.clearTable("inferred");
            }
        }
        catch (SQLException e) {
            ThreadLog.error((String)("SQL error on rule(" + ruleNo + "): " + query2));
            throw new SailUpdateException(e);
        }
        long endTime = System.currentTimeMillis();
        int n = ruleNo;
        this._ruleTime[n] = this._ruleTime[n] + (endTime - startTime);
        return nofInferred;
    }

    public void createDependenciesTable() throws SQLException {
        if (this._useDependencyInferencer) {
            String[] index1Opts = new String[maxTemplateCountsPerRule + 1];
            String[] index2Opts = new String[maxTemplateCountsPerRule];
            index1Opts[0] = "id";
            index1Opts[1] = "dep1";
            index1Opts[2] = "dep2";
            index2Opts[0] = "dep1";
            index2Opts[1] = "dep2";
            String query2 = "CREATE TABLE depend (id " + this._sail._rdbms.ID_INT + " NOT NULL ";
            for (int i = 1; i <= maxTemplateCountsPerRule; ++i) {
                query2 = query2 + ", dep" + i + " " + this._sail._rdbms.ID_INT + " NOT NULL";
                index1Opts[i] = "dep" + i;
                index2Opts[i - 1] = "dep" + i;
            }
            query2 = query2 + ")";
            this._sail._rdbms.executeUpdate(query2);
            this._sail._rdbms.createIndex("depend", index1Opts, false);
            this._sail._rdbms.createIndex("depend", index2Opts, false);
        }
    }

    public void afterInitialize() {
        block3: {
            if (this._sail._rdbms instanceof PostgreSQL) {
                try {
                    this._sail._rdbms.executeUpdate("CREATE FUNCTION \"concat\" (text,text) RETURNS text AS 'SELECT $1 || $2;' LANGUAGE 'sql';");
                }
                catch (SQLException e) {
                    String msg = e.getMessage();
                    if (msg.indexOf("already exists") > -1) break block3;
                    throw new SailInternalException(e);
                }
            }
        }
    }

    protected boolean matchTriples(TripleTemplate t1, TripleTemplate t2) {
        if (t1.subject.isVar() && t1.object.isVar() && t2.subject.isVar() && t2.object.isVar() && t1.subject.value().equalsIgnoreCase(t1.object.value()) && !t2.subject.value().equalsIgnoreCase(t2.object.value())) {
            return false;
        }
        if (!(t1.subject.isVar() || t2.subject.isVar() || t1.subject.value().equalsIgnoreCase(t2.subject.value()))) {
            return false;
        }
        if (!(t1.predicate.isVar() || t2.predicate.isVar() || t1.predicate.value().equalsIgnoreCase(t2.predicate.value()))) {
            return false;
        }
        return t1.object.isVar() || t2.object.isVar() || t1.object.value().equalsIgnoreCase(t2.object.value());
    }

    protected boolean[][] buildTriggers(ArrayList rules) {
        int num_rule_variants = 0;
        for (int i = 0; i < rules.size(); ++i) {
            Rule r = (Rule)rules.get(i);
            num_rule_variants += r.getPremiseCount();
        }
        boolean[][] result2 = new boolean[num_rule_variants][num_rule_variants];
        int rowIndex = 0;
        for (int i = 0; i < rules.size(); ++i) {
            Rule activator = (Rule)rules.get(i);
            int colIndex = 0;
            for (int j = 0; j < rules.size(); ++j) {
                Rule activated = (Rule)rules.get(j);
                boolean inTrigersList = false;
                if (activator.getTriggersRule() != null) {
                    Iterator trIter = activator.getTriggersRule().iterator();
                    while (trIter.hasNext()) {
                        String toCheck = (String)trIter.next();
                        if (!toCheck.equalsIgnoreCase(activated.getName())) continue;
                        inTrigersList = true;
                        break;
                    }
                }
                if (inTrigersList) {
                    TripleTemplate consequent = activator.getConsequent();
                    for (int indexActivated = 0; indexActivated < activated.getPremiseCount(); ++indexActivated) {
                        TripleTemplate premiseToCheck = (TripleTemplate)activated.getPremiseCollection().get(indexActivated);
                        boolean valueToSet = this.matchTriples(consequent, premiseToCheck);
                        for (int activatorSize = 0; activatorSize < activator.getPremiseCount(); ++activatorSize) {
                            result2[rowIndex + activatorSize][colIndex + indexActivated] = valueToSet;
                        }
                    }
                }
                colIndex += activated.getPremiseCount();
            }
            rowIndex += activator.getPremiseCount();
        }
        return result2;
    }

    private void _removeAllInferred() throws SQLException {
        this._sail._rdbms.executeUpdate("DELETE FROM triples WHERE explicit = " + this._sail._rdbms.FALSE);
    }
}

