/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.omm.security;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.sesame.config.UserInfo;
import org.openrdf.sesame.sailimpl.omm.security.NullParameterException;
import org.openrdf.sesame.sailimpl.omm.security.Role;
import org.openrdf.sesame.sailimpl.omm.security.Rule;
import org.openrdf.sesame.sailimpl.omm.security.User;

public class UserImpl
implements User {
    public static final String ANONYMOUS = "ANONYMOUS";
    private int id;
    private String login = null;
    private String name = null;
    private String password = null;
    private Set roles = new HashSet(1);
    private Set rules = new HashSet(1);
    private String uri = null;
    private UserInfo userInfo = null;

    public UserImpl(int id, String login, String password, String name2) throws NullParameterException {
        if (null == login || null == password || null == name2) {
            throw new NullParameterException("User's [login], [name] and [password] should not be [null].");
        }
        this.id = id;
        this.password = password;
        this.login = login;
        this.name = name2;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String thePassword) throws NullParameterException {
        if (null == thePassword) {
            throw new NullParameterException("User [password] should not be [null].");
        }
        this.password = thePassword;
    }

    public Set getRoles() {
        return this.roles;
    }

    public void setRoles(Set roleIDs) throws NullParameterException {
        if (null == roleIDs) {
            throw new NullParameterException("The set of [User roles] should not be [null].");
        }
        this.roles = roleIDs;
    }

    public Set getRules() {
        return this.rules;
    }

    public void setRules(Set rules) throws NullParameterException {
        if (null == rules) {
            throw new NullParameterException("The set of [User rules] should not be [null].");
        }
        this.rules = rules;
    }

    public void setUserInfo(UserInfo ui) throws NullParameterException {
        if (ui == null) {
            throw new NullParameterException("User's [User Info] should not be [null].");
        }
        this.userInfo = ui;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public ArrayList toSql() {
        ArrayList<String> list = new ArrayList<String>(3);
        StringBuffer query2 = new StringBuffer();
        ArrayList rulz = new ArrayList(this.rules);
        for (int ri = 0; ri < rulz.size(); ++ri) {
            query2 = new StringBuffer();
            Rule rule = (Rule)rulz.get(ri);
            query2.append("INSERT INTO ");
            query2.append("users_rules");
            query2.append(" VALUES ");
            query2.append("(").append(this.id);
            query2.append(",");
            query2.append(rule.getId());
            query2.append(");");
            list.add(query2.toString());
        }
        ArrayList rolez = new ArrayList(this.roles);
        for (int ri = 0; ri < rolez.size(); ++ri) {
            query2 = new StringBuffer();
            Role role = (Role)rolez.get(ri);
            query2.append("INSERT INTO ");
            query2.append("users_roles");
            query2.append(" VALUES ");
            query2.append("(").append(this.id);
            query2.append(",");
            query2.append(role.getId());
            query2.append(");");
            list.add(query2.toString());
        }
        return list;
    }

    public void setUri(String uri2) {
        this.uri = uri2;
    }

    public String getUri() {
        return this.uri;
    }
}

