/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.omm.security;

import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.sesame.Sesame;
import org.openrdf.sesame.admin.AdminListener;
import org.openrdf.sesame.admin.XmlAdminMsgWriter;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.omm.SecurityServices;
import org.openrdf.sesame.omm.SessionContext;
import org.openrdf.sesame.omm.VersionManagement;
import org.openrdf.sesame.query.MalformedQueryException;
import org.openrdf.sesame.query.QueryErrorType;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.query.rql.RqlEngine;
import org.openrdf.sesame.query.rql.model.Query;
import org.openrdf.sesame.repository.local.LocalRepository;
import org.openrdf.sesame.repository.local.LocalService;
import org.openrdf.sesame.sail.LiteralIterator;
import org.openrdf.sesame.sail.NamespaceIterator;
import org.openrdf.sesame.sail.RdfRepository;
import org.openrdf.sesame.sail.RdfSchemaRepository;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.sesame.sail.Sail;
import org.openrdf.sesame.sail.SailChangedListener;
import org.openrdf.sesame.sail.SailInitializationException;
import org.openrdf.sesame.sail.SailInternalException;
import org.openrdf.sesame.sail.SailUpdateException;
import org.openrdf.sesame.sail.StackedSail;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sail.util.QuerySailStack;
import org.openrdf.sesame.sailimpl.omm.security.ClassesOverSchemaRestriction;
import org.openrdf.sesame.sailimpl.omm.security.ClassesRestriction;
import org.openrdf.sesame.sailimpl.omm.security.InstancesRestriction;
import org.openrdf.sesame.sailimpl.omm.security.NullParameterException;
import org.openrdf.sesame.sailimpl.omm.security.PatternRestriction;
import org.openrdf.sesame.sailimpl.omm.security.PropertiesRestriction;
import org.openrdf.sesame.sailimpl.omm.security.QueryRestriction;
import org.openrdf.sesame.sailimpl.omm.security.ResourceRestriction;
import org.openrdf.sesame.sailimpl.omm.security.Restriction;
import org.openrdf.sesame.sailimpl.omm.security.Right;
import org.openrdf.sesame.sailimpl.omm.security.Role;
import org.openrdf.sesame.sailimpl.omm.security.RoleImpl;
import org.openrdf.sesame.sailimpl.omm.security.Rule;
import org.openrdf.sesame.sailimpl.omm.security.RuleImpl;
import org.openrdf.sesame.sailimpl.omm.security.SecurityException;
import org.openrdf.sesame.sailimpl.omm.security.StatementFilterIterator;
import org.openrdf.sesame.sailimpl.omm.security.User;
import org.openrdf.sesame.sailimpl.omm.security.UserImpl;
import org.openrdf.sesame.sailimpl.rdbms.RdbmsNamespace;
import org.openrdf.util.jdbc.ConnectionPool;
import org.openrdf.util.log.ThreadLog;

public class SecuritySail
implements RdfSchemaRepository,
StackedSail,
SecurityServices,
VersionManagement,
TableQueryResultListener {
    private ArrayList transients = new ArrayList();
    private static int lastResourceId = 0;
    private static int lastLiteralId = 0;
    private Sail baseSail = null;
    private RdfSchemaSource baseRdfSchemaSource = null;
    private RdfRepository baseRdfRepository = null;
    private RdfSource baseRdfSource = null;
    private VersionManagement versionMngmt = null;
    private ArrayList queryResult = new ArrayList();
    Map queryResults = new HashMap();
    boolean isQueryReady = true;
    private static final String VERSION_SAIL = "org.openrdf.sesame.omm.VersionManagement";
    private static final String SKILL = "http://www.ontotext.com/otk/2002/05/skills.rdfs#Skill";
    private static final String SKILL_LEVEL = "http://www.ontotext.com/otk/2002/05/skills.rdfs#SkillLevel";
    private static final String BUS_SKILL = "http://www.ontotext.com/otk/2002/05/sirma_skills_hier.rdfs#BusinessSkill";
    private static final String ESPIONAGE_SKILL = "http://www.ontotext.com/otk/2002/05/sirma_skills_hier.rdfs#BusinessEspionage";
    private static final String TECH_SKILL = "http://www.ontotext.com/otk/2002/05/sirma_skills_hier.rdfs#TechnicalSkill";
    private static final String SWING_SKILL = "http://www.ontotext.com/otk/2002/05/sirma_skills_hier.rdfs#Swing";
    private static final String DEMO_SWING_SKILL = "http://www.ontotext.com/otk/2002/05/sirma_enter_kb.rdf#DemoSwingSkill";
    private static final String RDF_TYPE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
    private static final String RESOURCE = "http://www.w3.org/2000/01/rdf-schema#Resource";
    private static final String PERSON = "http://www.ontotext.com/otk/2002/05/enterprise.rdfs#Person";
    private static final String HAS_SKILL = "http://www.ontotext.com/otk/2002/05/skills.rdfs#hasSkill";
    private static final String HAS_POSITION = "http://www.ontotext.com/otk/2002/05/enterprise.rdfs#hasPosition";
    private static final String SUB_CLASS_OF = "http://www.w3.org/2000/01/rdf-schema#subClassOf";
    private static final String AI_SKILL_QUERY = "select * from {X} http://www.w3.org/2000/01/rdf-schema#subClassOf {Y} where X = http://www.ontotext.com/otk/2002/05/sirma_skills_hier.rdfs#AISkill";
    private static final String HAS_POSITION_QUERY = "select * from {X} http://www.ontotext.com/otk/2002/05/enterprise.rdfs#hasPosition {Y}";
    private static final String AI_SKILL = "http://www.ontotext.com/otk/2002/05/sirma_skills_hier.rdfs#AISkill";
    private static final String MITAC = "http://www.ontotext.com/otk/2002/05/sirma_enter_kb.rdf#DimitarManov";
    private static final String KCS_URI = "http://www.ontotext.com/otk/2002/03/KCS.rdfs";
    private static final String BASE_KCS_URI = "http://www.ontotext.com/otk/2002/03/kcs.rdfs#";
    public static final String USERS_TABLE = "users";
    public static final String USERS_ROLES_TABLE = "users_roles";
    public static final String USERS_RULES_TABLE = "users_rules";
    public static final String ROLES_TABLE = "roles";
    public static final String ROLES_HIERARCHY_TABLE = "roles_hierarchy";
    public static final String ROLES_RULES_TABLE = "roles_rules";
    public static final String SECURITY_RULES_TABLE = "security_rules";
    public static final String RESTRICTIONS_TABLE = "restrictions";
    public static final String RES_PROP_RESTRS_TABLE = "res_propr_restrs";
    public static final String PATTERN_RESTRS_TABLE = "pattern_restrs";
    public static final String QUERY_RESTRS_TABLE = "query_restrs";
    public static final String RESOURCES_TABLE = "resources";
    public static final String LITERALS_TABLE = "literals";
    public static final String NAMESPACES_TABLE = "namespaces";
    public static final String DROP_TABLE = "DROP TABLE ";
    public static final String SELECT = "SELECT * FROM ";
    public static final String INSERT = "INSERT INTO ";
    public static final String VALUES = " VALUES ";
    protected static final String INT = "INTEGER UNSIGNED";
    protected static final String CHR20 = "character varying(20)";
    protected static final String CHR255 = "character varying(255)";
    static Map resIdsByUri = new HashMap();
    protected ConnectionPool conPool = null;
    private Set users = new HashSet();
    private Map usersByLogin = new HashMap();
    private Map usersById = new HashMap();
    private Set roles = new HashSet();
    private Map rolesById = new HashMap();
    private Map rolesByName = new HashMap();
    private Map restrictionsById = new HashMap();
    private Map rulesById = new HashMap();
    private Map resById = new HashMap();
    private Map idByRes = new HashMap();
    private int lastResId = 0;
    private Map namespaces = new HashMap();
    private Map literalById = new HashMap();
    private Map idByLiteral = new HashMap();

    public StatementIterator getExplicitStatements(Resource subj, URI pred, Value obj) {
        StatementIterator si = this.baseRdfSchemaSource.getExplicitStatements(subj, pred, obj);
        try {
            si = new StatementFilterIterator(si, this, Right.READ);
        }
        catch (Exception e) {
            throw new SailInternalException(e);
        }
        return si;
    }

    public boolean hasExplicitStatement(Resource subj, URI pred, Value obj) {
        boolean has = this.baseRdfSchemaSource.hasExplicitStatement(subj, pred, obj);
        if (has) {
            has = this.isStatementAccessible(subj, pred, obj, Right.READ);
        }
        return has;
    }

    public org.openrdf.sesame.sail.query.Query optimizeQuery(org.openrdf.sesame.sail.query.Query qc) {
        return qc;
    }

    public StatementIterator getClasses() {
        StatementIterator si = this.baseRdfSchemaSource.getClasses();
        try {
            si = new StatementFilterIterator(si, this, Right.READ);
        }
        catch (Exception e) {
            throw new SailInternalException(e);
        }
        return si;
    }

    public boolean isClass(Resource resource) {
        boolean is = this.baseRdfSchemaSource.isClass(resource);
        if (is) {
            is = is && this.isResourceAccessible(resource);
        }
        return is;
    }

    public StatementIterator getProperties() {
        StatementIterator si = this.baseRdfSchemaSource.getProperties();
        return si;
    }

    public boolean isProperty(Resource resource) {
        boolean is = this.baseRdfSchemaSource.isProperty(resource);
        if (is) {
            is = is && this.isResourceAccessible(resource);
        }
        return is;
    }

    public StatementIterator getSubClassOf(Resource subClass, Resource superClass) {
        StatementIterator si = this.baseRdfSchemaSource.getSubClassOf(subClass, superClass);
        try {
            si = new StatementFilterIterator(si, this, Right.READ);
        }
        catch (Exception e) {
            throw new SailInternalException(e);
        }
        return si;
    }

    public StatementIterator getDirectSubClassOf(Resource subClass, Resource superClass) {
        StatementIterator si = this.baseRdfSchemaSource.getDirectSubClassOf(subClass, superClass);
        try {
            si = new StatementFilterIterator(si, this, Right.READ);
        }
        catch (Exception e) {
            throw new SailInternalException(e);
        }
        return si;
    }

    public boolean isSubClassOf(Resource subClass, Resource superClass) {
        boolean is = this.baseRdfSchemaSource.isSubClassOf(subClass, superClass);
        if (is) {
            is = is && this.isResourceAccessible(subClass);
            is = is && this.isResourceAccessible(superClass);
        }
        return is;
    }

    public boolean isDirectSubClassOf(Resource subClass, Resource superClass) {
        boolean is = this.baseRdfSchemaSource.isDirectSubClassOf(subClass, superClass);
        if (is) {
            is = is && this.isResourceAccessible(subClass);
            is = is && this.isResourceAccessible(superClass);
        }
        return is;
    }

    public StatementIterator getSubPropertyOf(Resource subProperty, Resource superProperty) {
        StatementIterator si = this.baseRdfSchemaSource.getSubPropertyOf(subProperty, superProperty);
        try {
            si = new StatementFilterIterator(si, this, Right.READ);
        }
        catch (Exception e) {
            throw new SailInternalException(e);
        }
        return si;
    }

    public StatementIterator getDirectSubPropertyOf(Resource subProperty, Resource superProperty) {
        StatementIterator si = this.baseRdfSchemaSource.getDirectSubPropertyOf(subProperty, superProperty);
        try {
            si = new StatementFilterIterator(si, this, Right.READ);
        }
        catch (Exception e) {
            throw new SailInternalException(e);
        }
        return si;
    }

    public boolean isSubPropertyOf(Resource subProperty, Resource superProperty) {
        boolean is = this.baseRdfSchemaSource.isSubPropertyOf(subProperty, superProperty);
        if (is) {
            is = is && this.isResourceAccessible(subProperty);
            is = is && this.isResourceAccessible(superProperty);
        }
        return is;
    }

    public boolean isDirectSubPropertyOf(Resource subProperty, Resource superProperty) {
        boolean is = this.baseRdfSchemaSource.isDirectSubPropertyOf(subProperty, superProperty);
        if (is) {
            is = is && this.isResourceAccessible(subProperty);
            is = is && this.isResourceAccessible(superProperty);
        }
        return is;
    }

    public StatementIterator getDomain(Resource prop, Resource domain) {
        StatementIterator si = this.baseRdfSchemaSource.getDomain(prop, domain);
        try {
            si = new StatementFilterIterator(si, this, Right.READ);
        }
        catch (Exception e) {
            throw new SailInternalException(e);
        }
        return si;
    }

    public StatementIterator getRange(Resource prop, Resource range2) {
        StatementIterator si = this.baseRdfSchemaSource.getRange(prop, range2);
        try {
            si = new StatementFilterIterator(si, this, Right.READ);
        }
        catch (Exception e) {
            throw new SailInternalException(e);
        }
        return si;
    }

    public StatementIterator getType(Resource anInstance, Resource aClass) {
        StatementIterator si = this.baseRdfSchemaSource.getType(anInstance, aClass);
        try {
            si = new StatementFilterIterator(si, this, Right.READ);
        }
        catch (Exception e) {
            throw new SailInternalException(e);
        }
        return si;
    }

    public StatementIterator getDirectType(Resource anInstance, Resource aClass) {
        StatementIterator si = this.baseRdfSchemaSource.getDirectType(anInstance, aClass);
        try {
            si = new StatementFilterIterator(si, this, Right.READ);
        }
        catch (Exception e) {
            throw new SailInternalException(e);
        }
        return si;
    }

    public boolean isType(Resource anInstance, Resource aClass) {
        boolean is = false;
        if (this.isResourceAccessible(anInstance) && this.isResourceAccessible(aClass)) {
            is = this.baseRdfSchemaSource.isType(anInstance, aClass);
        }
        return is;
    }

    public boolean isDirectType(Resource anInstance, Resource aClass) {
        boolean is = false;
        if (this.isResourceAccessible(anInstance) && this.isResourceAccessible(aClass)) {
            is = this.baseRdfSchemaSource.isDirectType(anInstance, aClass);
        }
        return is;
    }

    public LiteralIterator getLiterals(String label, String language2, URI datatype) {
        return this.baseRdfSchemaSource.getLiterals(label, language2, datatype);
    }

    public void startTransaction() {
        this.baseRdfRepository.startTransaction();
        this.queryResults = new HashMap();
    }

    public void commitTransaction() {
        String status = "";
        if (this.areThereTransients()) {
            if (null != this.versionMngmt) {
                this.versionMngmt.pauseCounterIncrement();
            }
            this.baseRdfRepository.commitTransaction();
            this.baseRdfRepository.startTransaction();
            status = this.removeIrrelevantTransients();
            if (null != this.versionMngmt) {
                this.versionMngmt.continueCounterIncrement();
            }
        }
        this.baseRdfRepository.commitTransaction();
        if (status.length() > 0) {
            ThreadLog.trace((String)status);
            throw new SailInternalException(status);
        }
    }

    public boolean transactionStarted() {
        return this.baseRdfRepository.transactionStarted();
    }

    public void addStatement(Resource subj, URI pred, Value obj) throws SailUpdateException {
        this.baseRdfRepository.addStatement(subj, pred, obj);
        if (!this.isStatementAccessible(subj, pred, obj, Right.ADD)) {
            this.addTransient(subj, pred, obj);
            throw new SailUpdateException("Statement Added temporarily.\n The permissions will be checked at the end of the transaction.");
        }
    }

    public int removeStatements(Resource subj, URI pred, Value obj) throws SailUpdateException {
        StatementIterator si = this.baseRdfRepository.getStatements(subj, pred, obj);
        StatementFilterIterator sfi = null;
        try {
            sfi = new StatementFilterIterator(si, this, Right.REMOVE);
        }
        catch (Exception e) {
            throw new SailInternalException(e);
        }
        int removed = 0;
        while (sfi.hasNext()) {
            org.openrdf.model.Statement st = sfi.next();
            removed += this.baseRdfRepository.removeStatements(st.getSubject(), st.getPredicate(), st.getObject());
        }
        return removed;
    }

    public void clearRepository() throws SailUpdateException {
        if (!this.isRepositoryAccessible(Right.REMOVE) && !this.isRepositoryAccessible(Right.ADMIN)) {
            throw new SailInternalException("Cannot Clear the Repository. Access Denied.");
        }
        this.baseRdfRepository.clearRepository();
    }

    public void changeNamespacePrefix(String namespace, String prefix) throws SailUpdateException {
        this.baseRdfRepository.changeNamespacePrefix(namespace, prefix);
    }

    public ValueFactory getValueFactory() {
        return null;
    }

    public StatementIterator getStatements(Resource subj, URI pred, Value obj) {
        StatementIterator si = this.baseRdfSource.getStatements(subj, pred, obj);
        try {
            si = new StatementFilterIterator(si, this, Right.READ);
        }
        catch (Exception e) {
            throw new SailInternalException(e);
        }
        return si;
    }

    public boolean hasStatement(Resource subj, URI pred, Value obj) {
        boolean has = this.baseRdfSource.hasStatement(subj, pred, obj);
        if (has) {
            has = has && this.isStatementAccessible(subj, pred, obj, Right.READ);
        }
        return has;
    }

    public NamespaceIterator getNamespaces() {
        return this.baseRdfSource.getNamespaces();
    }

    public void initialize(Map configParams) throws SailInitializationException {
        ThreadLog.trace((String)"initializing SecuritySail>>>");
        String jdbcDriver = (String)configParams.get("jdbcDriver");
        String jdbcUrl = (String)configParams.get("jdbcUrl");
        String user = (String)configParams.get("user");
        String password = (String)configParams.get("password");
        String securitySetup = (String)configParams.get("security_setup");
        if (jdbcDriver == null) {
            throw new SailInitializationException("parameter 'jdbcDriver' missing");
        }
        if (jdbcUrl == null) {
            throw new SailInitializationException("parameter 'jdbcUrl' missing");
        }
        if (user == null) {
            throw new SailInitializationException("parameter 'user' missing");
        }
        if (password == null) {
            throw new SailInitializationException("parameter 'password' missing");
        }
        try {
            Class.forName(jdbcDriver);
        }
        catch (ClassNotFoundException e) {
            throw new SailInitializationException("Unable to load JDBC-driver '" + jdbcDriver + "'", e);
        }
        this.conPool = new ConnectionPool(jdbcUrl, user, password);
        this.initDatabase();
        Connection con = null;
        Statement st = null;
        try {
            con = this.conPool.getConnection();
            st = con.createStatement();
            this.loadNameSpaceTable(con, st);
            this.loadResourcesTable(con, st);
            this.loadLiteralsTable(con, st);
            if (null != securitySetup) {
                ThreadLog.trace((String)("Loading Security Policy from url == " + securitySetup));
                URL surl = new URL(securitySetup);
                LocalService service = Sesame.getService();
                LocalRepository repository = service.createRepository("tempSecurityRep", false);
                repository.addData(surl, "", RDFFormat.RDFXML, true, (AdminListener)new XmlAdminMsgWriter(new FileOutputStream("ImportSecurityPolicy.Log")));
                this.baseRdfRepository.startTransaction();
                this.importPolicy(repository.getGraph());
                this.baseRdfRepository.commitTransaction();
                service.removeRepository(repository.getRepositoryId());
                repository = null;
                this.loadNameSpaceTable(con, st);
                this.loadResourcesTable(con, st);
                this.loadLiteralsTable(con, st);
                this.storeSecuritySetup();
            } else {
                ThreadLog.trace((String)"Loading Security Policy from the database");
                this.loadSecuritySetup();
            }
        }
        catch (Exception x) {
            throw new SailInternalException("While reading the security setup.", x);
        }
        ThreadLog.trace((String)"<<<SecuritySail initialized successfully");
    }

    public void shutDown() {
        this.baseSail.shutDown();
    }

    public void setBaseSail(Sail baseSail) {
        this.baseSail = baseSail;
        if (baseSail instanceof RdfSchemaSource) {
            this.baseRdfSchemaSource = (RdfSchemaSource)baseSail;
        }
        if (baseSail instanceof RdfSource) {
            this.baseRdfSource = (RdfSource)baseSail;
        }
        if (baseSail instanceof RdfRepository) {
            this.baseRdfRepository = (RdfRepository)baseSail;
        }
        this.versionMngmt = (VersionManagement)QuerySailStack.queryInterface(baseSail, VERSION_SAIL);
    }

    public Sail getBaseSail() {
        return this.baseSail;
    }

    public void labelState(long stateUID, String label) {
        if (this.isVersionTrackingAccessible()) {
            this.versionMngmt.labelState(stateUID, label);
        }
    }

    public void labelCurrentState(String label) {
        if (this.isVersionTrackingAccessible()) {
            this.versionMngmt.labelCurrentState(label);
        }
    }

    public void revertToState(long stateUID) {
        if (this.isVersionTrackingAccessible()) {
            this.versionMngmt.revertToState(stateUID);
        }
    }

    public String branchState(long stateUID) {
        String result2 = "";
        if (this.isVersionTrackingAccessible()) {
            result2 = this.versionMngmt.branchState(stateUID);
        }
        return result2;
    }

    public void workWithState(long stateUID) {
        if (this.isVersionTrackingAccessible()) {
            this.versionMngmt.workWithState(stateUID);
        }
    }

    public Iterator getVersions() {
        Iterator i = new ArrayList().iterator();
        if (this.isVersionTrackingAccessible()) {
            i = this.versionMngmt.getVersions();
        }
        return i;
    }

    public void lockStatements(Iterator statementsList) {
        if (this.isVersionTrackingAccessible()) {
            this.versionMngmt.lockStatements(statementsList);
        }
    }

    public void unlockStatements(Iterator statementsList) {
        if (this.isVersionTrackingAccessible()) {
            this.versionMngmt.unlockStatements(statementsList);
        }
    }

    public Iterator getUpdateIds() {
        Iterator i = new ArrayList().iterator();
        if (this.isVersionTrackingAccessible()) {
            i = this.versionMngmt.getUpdateIds();
        }
        return i;
    }

    public void pauseCounterIncrement() {
        if (this.isVersionTrackingAccessible()) {
            this.versionMngmt.pauseCounterIncrement();
        }
    }

    public void continueCounterIncrement() {
        if (this.isVersionTrackingAccessible()) {
            this.versionMngmt.continueCounterIncrement();
        }
    }

    public boolean isPausedCounterIncrement() {
        if (this.isVersionTrackingAccessible()) {
            return this.versionMngmt.isPausedCounterIncrement();
        }
        return false;
    }

    public Iterator getVersionIds() {
        Iterator i = new ArrayList().iterator();
        if (this.isVersionTrackingAccessible()) {
            i = this.versionMngmt.getVersionIds();
        }
        return i;
    }

    public Map getMetaInfo(String subj, String pred, String obj) {
        Map mi = new HashMap();
        if (this.isVersionTrackingAccessible()) {
            mi = this.versionMngmt.getMetaInfo(subj, pred, obj);
        }
        return mi;
    }

    public Map getUpdateMetaInfo(String updateId) {
        Map mi = new HashMap();
        if (this.isVersionTrackingAccessible()) {
            mi = this.versionMngmt.getUpdateMetaInfo(updateId);
        }
        return mi;
    }

    public Map getVersionMetaInfo(String versionId) {
        Map mi = new HashMap();
        if (this.isVersionTrackingAccessible()) {
            mi = this.versionMngmt.getVersionMetaInfo(versionId);
        }
        return mi;
    }

    public int getResourceId(Resource res) throws SecurityException {
        Integer i = (Integer)this.idByRes.get(res);
        if (null == i) {
            throw new SecurityException("Id not found for resource:\n" + res);
        }
        int ii = i;
        return ii;
    }

    public Resource getResource(int id) {
        Resource res = (Resource)this.resById.get(new Integer(id));
        return res;
    }

    public boolean isVersionTrackingAccessible() {
        return this.isRepositoryAccessible(Right.ADMIN) && this.versionMngmt != null;
    }

    public boolean isSchemaAccessible(Right right) {
        boolean result2 = false;
        SessionContext context = SessionContext.getContext();
        int userId = context.userID;
        User user = (User)this.usersById.get(new Integer(userId));
        if (null != user) {
            Set rulz = user.getRules();
            rulz.addAll(RoleImpl.getRules(user.getRoles(), false));
            ArrayList rulis = new ArrayList(rulz);
            for (int i = 0; i < rulis.size(); ++i) {
                Rule ru = (Rule)rulis.get(i);
                Restriction rst = ru.getRestriction();
                if (rst.getType() != 1 && rst.getType() != 2) continue;
                if (right.equals((Object)Right.READ) && ru.getReadRight()) {
                    result2 = true;
                    break;
                }
                if (right.equals((Object)Right.ADD) && ru.getAddRight()) {
                    result2 = true;
                    break;
                }
                if (!right.equals((Object)Right.REMOVE) || !ru.getRemoveRight()) continue;
                result2 = true;
                break;
            }
        }
        return result2;
    }

    public boolean isRepositoryAccessible(Right right) {
        boolean result2 = false;
        SessionContext context = SessionContext.getContext();
        int userId = context.userID;
        User user = (User)this.usersById.get(new Integer(userId));
        if (null != user) {
            Set rulz = user.getRules();
            rulz.addAll(RoleImpl.getRules(user.getRoles(), false));
            ArrayList rulis = new ArrayList(rulz);
            for (int i = 0; i < rulis.size(); ++i) {
                Rule ru = (Rule)rulis.get(i);
                Restriction rst = ru.getRestriction();
                if (rst.getType() != 1) continue;
                if (right.equals((Object)Right.READ) && ru.getReadRight()) {
                    result2 = true;
                    break;
                }
                if (right.equals((Object)Right.REMOVE) && ru.getRemoveRight()) {
                    result2 = true;
                    break;
                }
                if (right.equals((Object)Right.ADMIN) && ru.getAdminRight()) {
                    result2 = true;
                    break;
                }
                if (!right.equals((Object)Right.HISTORY) || !ru.getHistoryRight()) continue;
                result2 = true;
                break;
            }
        }
        return result2;
    }

    public boolean isStatementAccessible(Resource subj, URI pred, Value obj, Right right) {
        boolean result2 = false;
        SessionContext context = SessionContext.getContext();
        int userId = context.userID;
        User user = (User)this.usersById.get(new Integer(userId));
        if (null != user) {
            Set rulz = user.getRules();
            rulz.addAll(RoleImpl.getRules(user.getRoles(), false));
            ArrayList rulis = new ArrayList(rulz);
            for (int i = 0; i < rulis.size(); ++i) {
                Rule ru = (Rule)rulis.get(i);
                if (!ru.getAddRight() && !ru.getRemoveRight() && !ru.getReadRight() || right.equals((Object)Right.READ) && !ru.getReadRight() || right.equals((Object)Right.REMOVE) && !ru.getRemoveRight() || right.equals((Object)Right.ADD) && !ru.getAddRight()) continue;
                Restriction rst = ru.getRestriction();
                if (rst.type == 1) {
                    result2 = true;
                    break;
                }
                if (rst.type == 2 && (this.baseRdfSchemaSource.isType(subj, URIImpl.RDFS_CLASS) || this.baseRdfSchemaSource.isType(subj, URIImpl.RDF_PROPERTY))) {
                    result2 = true;
                    break;
                }
                if (this.isResourceAccessible(subj, right)) {
                    result2 = true;
                    break;
                }
                if (rst.type == 5) {
                    PropertiesRestriction propr = (PropertiesRestriction)rst;
                    ArrayList props = new ArrayList(propr.getProperties());
                    for (int pi = 0; pi < props.size(); ++pi) {
                        Resource prop = (Resource)props.get(pi);
                        if (!this.baseRdfSchemaSource.isSubPropertyOf(pred, prop)) continue;
                        result2 = true;
                        break;
                    }
                    if (result2) break;
                }
                if (rst.type != 6) continue;
                boolean subjAccessible = true;
                boolean predAccessible = true;
                boolean objAccessible = true;
                PatternRestriction pat = (PatternRestriction)rst;
                ArrayList subjs = new ArrayList(pat.getSubjectRestrictions());
                for (int si = 0; si < subjs.size(); ++si) {
                    subjAccessible = false;
                    ResourceRestriction sr = (ResourceRestriction)subjs.get(si);
                    ArrayList resList = new ArrayList(sr.getResources());
                    for (int ri = 0; ri < resList.size(); ++ri) {
                        Resource reso = (Resource)resList.get(ri);
                        if (sr.getType() == 3) {
                            if (!this.baseRdfSchemaSource.isType(subj, reso)) continue;
                            subjAccessible = true;
                            break;
                        }
                        if (sr.getType() == 8) {
                            if (!this.baseRdfSchemaSource.isSubClassOf(subj, reso)) continue;
                            subjAccessible = true;
                            break;
                        }
                        if (sr.getType() == 4) {
                            if (!subj.equals(reso)) continue;
                            subjAccessible = true;
                            break;
                        }
                        throw new SailInternalException("Object Restrictions (part of the Pattern Restriction)\n should be of type ClassesRestriction or InstancesRestriction");
                    }
                    if (subjAccessible) break;
                }
                ArrayList preds = new ArrayList(pat.getPredicateRestrictions());
                for (int predi = 0; predi < preds.size(); ++predi) {
                    predAccessible = false;
                    PropertiesRestriction pr = (PropertiesRestriction)preds.get(predi);
                    ArrayList propList = new ArrayList(pr.getProperties());
                    for (int propi = 0; propi < propList.size(); ++propi) {
                        Resource prop = (Resource)propList.get(propi);
                        if (!this.baseRdfSchemaSource.isSubPropertyOf(pred, prop)) continue;
                        predAccessible = true;
                        break;
                    }
                    if (predAccessible) break;
                }
                ArrayList objs = new ArrayList(pat.getObjectRestrictions());
                for (int obji = 0; obji < objs.size(); ++obji) {
                    objAccessible = false;
                    Object objRestr = objs.get(obji);
                    if (objRestr instanceof Literal) {
                        Value val = (Value)objRestr;
                        if (val.equals(obj)) {
                            objAccessible = true;
                            break;
                        }
                    } else if (objRestr instanceof ResourceRestriction) {
                        ResourceRestriction rr = (ResourceRestriction)objRestr;
                        ArrayList resList = new ArrayList(rr.getResources());
                        for (int ri = 0; ri < resList.size(); ++ri) {
                            Resource reso = (Resource)resList.get(ri);
                            if (rr.getType() == 3) {
                                if (!(obj instanceof Resource) || !this.baseRdfSchemaSource.isType((Resource)obj, reso)) continue;
                                objAccessible = true;
                            } else if (rr.getType() == 8) {
                                if (!(obj instanceof Resource) || !this.baseRdfSchemaSource.isSubClassOf((Resource)obj, reso)) continue;
                                objAccessible = true;
                            } else {
                                if (rr.getType() != 4 || !obj.equals(reso)) continue;
                                objAccessible = true;
                            }
                            break;
                        }
                    } else {
                        throw new SailInternalException("The Object's Restrictions (in a Pattern restriction) should be \neither a Literal, either a ResourceRestriction.");
                    }
                    if (objAccessible) break;
                }
                if (!subjAccessible || !predAccessible || !objAccessible) continue;
                result2 = true;
                break;
            }
        }
        return result2;
    }

    public boolean isStatementAccessible(org.openrdf.model.Statement st, Right right) {
        return this.isStatementAccessible(st.getSubject(), st.getPredicate(), st.getObject(), right);
    }

    public boolean isValueAccessible(Value val) {
        boolean is = true;
        if (val instanceof Resource) {
            is = this.isResourceAccessible((Resource)val);
        }
        return is;
    }

    public boolean isResourceAccessible(Resource res, Right right) {
        boolean result2 = false;
        SessionContext context = SessionContext.getContext();
        int userId = context.userID;
        User user = (User)this.usersById.get(new Integer(userId));
        if (null != user) {
            Set rulz = user.getRules();
            rulz.addAll(RoleImpl.getRules(user.getRoles(), false));
            ArrayList rulis = new ArrayList(rulz);
            for (int i = 0; i < rulis.size(); ++i) {
                Resource clas;
                int j;
                ArrayList classes;
                Rule ru = (Rule)rulis.get(i);
                if (!ru.getAddRight() && !ru.getRemoveRight() && !ru.getReadRight() || right.equals((Object)Right.READ) && !ru.getReadRight() || right.equals((Object)Right.REMOVE) && !ru.getRemoveRight() || right.equals((Object)Right.ADD) && !ru.getAddRight()) continue;
                Restriction rst = ru.getRestriction();
                if (rst.type == 1) {
                    result2 = true;
                    break;
                }
                if (rst.type == 2 && (this.baseRdfSchemaSource.isType(res, URIImpl.RDFS_CLASS) || this.baseRdfSchemaSource.isType(res, URIImpl.RDF_PROPERTY))) {
                    result2 = true;
                    break;
                }
                if (rst.type == 3) {
                    ClassesRestriction cr = (ClassesRestriction)rst;
                    classes = new ArrayList(cr.getResources());
                    for (j = 0; j < classes.size(); ++j) {
                        clas = (Resource)classes.get(j);
                        if (!this.baseRdfSchemaSource.isType(res, clas)) continue;
                        result2 = true;
                        break;
                    }
                    if (result2) break;
                }
                if (rst.type == 8) {
                    ResourceRestriction rr = (ResourceRestriction)rst;
                    classes = new ArrayList(rr.getResources());
                    for (j = 0; j < classes.size(); ++j) {
                        clas = (Resource)classes.get(j);
                        if (!this.baseRdfSchemaSource.isSubClassOf(res, clas)) continue;
                        result2 = true;
                        break;
                    }
                    if (result2) break;
                }
                if (rst.type == 4) {
                    InstancesRestriction ir = (InstancesRestriction)rst;
                    ArrayList instances = new ArrayList(ir.getResources());
                    for (j = 0; j < instances.size(); ++j) {
                        clas = (URI)instances.get(j);
                        if (!(res instanceof URI) || !((URI)res).getLocalName().equals(clas.getLocalName()) || !((URI)res).getNamespace().equals(clas.getNamespace())) continue;
                        result2 = true;
                        break;
                    }
                    if (result2) break;
                }
                if (rst.type == 7 && (result2 = this.isQuAccessible((QueryRestriction)rst, res))) break;
            }
        }
        return result2;
    }

    public boolean isResourceAccessible(Resource res) {
        return this.isResourceAccessible(res, Right.READ);
    }

    public void addUser(int id, String login, String password, String name2) {
        try {
            UserImpl user = new UserImpl(id, login, password, name2);
            this.users.add(user);
            this.usersByLogin.put(login, user);
            this.usersById.put(new Integer(id), user);
        }
        catch (Exception e) {
            throw new SailInternalException(e);
        }
    }

    public void removeUser(String login) {
        User user = (User)this.usersByLogin.get(login);
        if (null != user) {
            this.usersByLogin.remove(login);
            this.users.remove(user);
        }
    }

    public Set getUsers() {
        return this.users;
    }

    public User getUser(String login) {
        return (User)this.usersByLogin.get(login);
    }

    public User getUser(int id) {
        return (User)this.usersById.get(new Integer(id));
    }

    public Role createRole(int id, String name2, String description, Set parents) {
        try {
            RoleImpl role = new RoleImpl(id, name2, description);
            role.setParentRoles(parents);
            this.roles.add(role);
            this.rolesByName.put(name2, role);
            return role;
        }
        catch (Exception e) {
            throw new SailInternalException(e);
        }
    }

    public void removeRole(String name2) {
        Role role = (Role)this.rolesByName.get(name2);
        if (null != role) {
            this.rolesById.remove(new Integer(role.getId()));
            this.rolesByName.remove(name2);
            this.roles.remove(role);
        }
    }

    public void removeRole(int id) {
        Role role = (Role)this.rolesById.get(new Integer(id));
        if (null != role) {
            this.rolesById.remove(new Integer(id));
            this.rolesByName.remove(role.getName());
            this.roles.remove(role);
        }
    }

    public Set getRoles() {
        return this.roles;
    }

    public Role getRole(String name2) {
        return (Role)this.rolesByName.get(name2);
    }

    public Role getRole(int id) {
        return (Role)this.rolesById.get(new Integer(id));
    }

    public Restriction createRestriction(int id, int type, String name2, String description) throws NullParameterException {
        Restriction restr = null;
        switch (type) {
            case 1: {
                restr = Restriction.createRepositoryRestriction(id, name2, description);
                break;
            }
            case 2: {
                restr = Restriction.createSchemaRestriction(id, name2, description);
                break;
            }
            case 7: {
                restr = Restriction.createQueryRestriction(id, name2, description);
                break;
            }
            case 4: {
                restr = Restriction.createInstancesRestriction(id, name2, description);
                break;
            }
            case 6: {
                restr = Restriction.createPatternRestriction(id, name2, description);
                break;
            }
            case 5: {
                restr = Restriction.createPropertiesRestriction(id, name2, description);
                break;
            }
            case 3: {
                restr = Restriction.createClassesRestriction(id, name2, description);
                break;
            }
            case 8: {
                restr = Restriction.createClassesOverSchemaRestriction(id, name2, description);
                break;
            }
            default: {
                throw new SailInternalException("Unknown restriction type [" + type + "].");
            }
        }
        this.restrictionsById.put(new Integer(id), restr);
        return restr;
    }

    public Restriction getRestriction(int id) {
        return (Restriction)this.restrictionsById.get(new Integer(id));
    }

    public void exportPolicy(RdfRepository repos) {
        int i;
        URIImpl proId = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#id");
        URIImpl proName = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#name");
        URIImpl proDescr = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#descritpion");
        URIImpl proSuperRole = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#superRole");
        URIImpl proIncludeRule = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#includeRule");
        URIImpl proRuleRestriction = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#ruleRestriction");
        URIImpl proRightsGranted = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#rightsGranted");
        URIImpl proRestrictionType = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#restrictionType");
        URIImpl proIncludeProperty = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#includeProperty");
        URIImpl proSubjectRestr = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#subjectRestr");
        URIImpl proPredicateRestr = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#predicateRestr");
        URIImpl proObjectRestr = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#objectRestr");
        URIImpl proRestrOnQuery = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#restrOnQuery");
        URIImpl proIncludeResource = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#includeResource");
        URIImpl proRdfType = new URIImpl(RDF_TYPE);
        URIImpl proHasRole = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#hasRole");
        URIImpl proHasRule = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#hasRule");
        URIImpl resRole = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#Role");
        URIImpl resRule = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#SecurityRule");
        URIImpl resRepositRestr = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#RepositoryRestriction");
        URIImpl resSchemaRestr = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#SchemaRestriction");
        URIImpl resClassesRestr = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#ClassesRestriction");
        URIImpl resInstancesRestr = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#InstancesRestriction");
        URIImpl resClassesOverSchemaRestr = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#ClassesOverSchemaRestriction");
        URIImpl resPaternRestr = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#PatternRestriction");
        URIImpl resPropertiesRestr = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#PropertiesRestriction");
        URIImpl resQueryRestr = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#QueryRestriction");
        URIImpl resUser = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#User");
        URIImpl resRestriction = new URIImpl("http://www.ontotext.com/otk/2002/03/kcs.rdfs#Restriction");
        repos.startTransaction();
        try {
            repos.clearRepository();
        }
        catch (SailUpdateException e) {
            throw new RuntimeException(e);
        }
        repos.commitTransaction();
        ArrayList userz = new ArrayList(this.users);
        ArrayList queList = new ArrayList();
        ArrayList rolz = new ArrayList(this.roles);
        HashSet rulez = new HashSet(RoleImpl.getRules(this.roles, false));
        try {
            for (int ui = 0; ui < userz.size(); ++ui) {
                User usr = (User)userz.get(ui);
                rulez.addAll(usr.getRules());
                URIImpl resCUser = new URIImpl(usr.getUri());
                repos.addStatement(resCUser, proRdfType, resUser);
                repos.addStatement(resCUser, proId, new LiteralImpl(Integer.toString(usr.getId())));
                ArrayList userRulz = new ArrayList(usr.getRules());
                for (int i2 = 0; i2 < userRulz.size(); ++i2) {
                    repos.addStatement(resCUser, proHasRule, new URIImpl(((Rule)userRulz.get(i2)).getUri()));
                }
                ArrayList userRolz = new ArrayList(usr.getRoles());
                for (i = 0; i < userRolz.size(); ++i) {
                    repos.addStatement(resCUser, proHasRole, new URIImpl(((Role)userRolz.get(i)).getUri()));
                }
            }
        }
        catch (Exception x) {
            throw new SailInternalException(x);
        }
        try {
            for (int roi = 0; roi < rolz.size(); ++roi) {
                Role role = (Role)rolz.get(roi);
                rulez.addAll(role.getRules(true));
                URIImpl resCRole = new URIImpl(role.getUri());
                repos.addStatement(resCRole, proRdfType, resRole);
                repos.addStatement(resCRole, proId, new LiteralImpl(Integer.toString(role.getId())));
                repos.addStatement(resCRole, proName, new LiteralImpl(role.getName()));
                repos.addStatement(resCRole, proDescr, new LiteralImpl(role.getDescription()));
                ArrayList parents = new ArrayList(role.getParentRoles());
                for (int i3 = 0; i3 < parents.size(); ++i3) {
                    Role pRole = (Role)parents.get(i3);
                    repos.addStatement(resCRole, proSuperRole, new URIImpl(pRole.getUri()));
                }
                ArrayList rulzList = new ArrayList(role.getRules(true));
                for (i = 0; i < rulzList.size(); ++i) {
                    Rule rule = (Rule)rulzList.get(i);
                    repos.addStatement(resCRole, proIncludeRule, new URIImpl(rule.getUri()));
                }
            }
        }
        catch (Exception x) {
            throw new SailInternalException(x);
        }
        try {
            ArrayList rulz = new ArrayList(rulez);
            for (int rui = 0; rui < rulz.size(); ++rui) {
                Rule rule = (Rule)rulz.get(rui);
                URIImpl resCRule = new URIImpl(rule.getUri());
                repos.addStatement(resCRule, proRdfType, resRule);
                repos.addStatement(resCRule, proId, new LiteralImpl(Integer.toString(rule.getId())));
                repos.addStatement(resCRule, proName, new LiteralImpl(rule.getName()));
                repos.addStatement(resCRule, proRuleRestriction, new URIImpl(rule.getRestriction().getUri()));
                repos.addStatement(resCRule, proDescr, new LiteralImpl(rule.getDescription()));
                if (rule.getReadRight()) {
                    repos.addStatement(resCRule, proRightsGranted, new LiteralImpl(Right.READ.toString()));
                }
                if (rule.getRemoveRight()) {
                    repos.addStatement(resCRule, proRightsGranted, new LiteralImpl(Right.REMOVE.toString()));
                }
                if (rule.getAddRight()) {
                    repos.addStatement(resCRule, proRightsGranted, new LiteralImpl(Right.ADD.toString()));
                }
                if (rule.getAdminRight()) {
                    repos.addStatement(resCRule, proRightsGranted, new LiteralImpl(Right.ADMIN.toString()));
                }
                if (!rule.getHistoryRight()) continue;
                repos.addStatement(resCRule, proRightsGranted, new LiteralImpl(Right.HISTORY.toString()));
            }
        }
        catch (Exception x) {
            throw new SailInternalException(x);
        }
        try {
            ArrayList restrz = new ArrayList(Restriction.getRestrictions());
            for (int ri = 0; ri < restrz.size(); ++ri) {
                Restriction r = (Restriction)restrz.get(ri);
                URIImpl resCR = new URIImpl(r.getUri());
                repos.addStatement(resCR, proId, new LiteralImpl(Integer.toString(r.getId())));
                repos.addStatement(resCR, proName, new LiteralImpl(r.getName()));
                repos.addStatement(resCR, proDescr, new LiteralImpl(r.getDescription()));
                repos.addStatement(resCR, proRestrictionType, new LiteralImpl(Restriction.type2String(r.getType())));
                int type = r.getType();
                switch (type) {
                    case 1: {
                        repos.addStatement(resCR, proRdfType, resRepositRestr);
                        break;
                    }
                    case 2: {
                        repos.addStatement(resCR, proRdfType, resSchemaRestr);
                        break;
                    }
                    case 3: {
                        repos.addStatement(resCR, proRdfType, resClassesRestr);
                        break;
                    }
                    case 4: {
                        repos.addStatement(resCR, proRdfType, resInstancesRestr);
                        break;
                    }
                    case 5: {
                        repos.addStatement(resCR, proRdfType, resPropertiesRestr);
                        break;
                    }
                    case 6: {
                        repos.addStatement(resCR, proRdfType, resPaternRestr);
                        break;
                    }
                    case 7: {
                        repos.addStatement(resCR, proRdfType, resQueryRestr);
                        break;
                    }
                    case 8: {
                        repos.addStatement(resCR, proRdfType, resClassesOverSchemaRestr);
                    }
                }
                switch (type) {
                    case 5: {
                        ArrayList props = new ArrayList(((PropertiesRestriction)r).getProperties());
                        for (int i4 = 0; i4 < props.size(); ++i4) {
                            repos.addStatement(resCR, proIncludeProperty, new URIImpl(((URI)props.get(i4)).getURI()));
                        }
                        break;
                    }
                    case 6: {
                        PatternRestriction pr = (PatternRestriction)r;
                        ArrayList su = new ArrayList(pr.getSubjectRestrictions());
                        for (int i5 = 0; i5 < su.size(); ++i5) {
                            repos.addStatement(resCR, proSubjectRestr, new URIImpl(((Restriction)su.get(i5)).getUri()));
                        }
                        ArrayList pu = new ArrayList(pr.getPredicateRestrictions());
                        for (int i6 = 0; i6 < pu.size(); ++i6) {
                            repos.addStatement(resCR, proPredicateRestr, new URIImpl(((Restriction)pu.get(i6)).getUri()));
                        }
                        ArrayList ou = new ArrayList(pr.getObjectRestrictions());
                        for (int i7 = 0; i7 < ou.size(); ++i7) {
                            repos.addStatement(resCR, proObjectRestr, new URIImpl(((Restriction)ou.get(i7)).getUri()));
                        }
                        break;
                    }
                    case 7: {
                        ArrayList qList = new ArrayList(((QueryRestriction)r).getQueries());
                        for (int i8 = 0; i8 < qList.size(); ++i8) {
                            repos.addStatement(resCR, proRestrOnQuery, new LiteralImpl((String)qList.get(i8)));
                        }
                        break;
                    }
                }
                if (!(r instanceof ResourceRestriction)) continue;
                ArrayList rlist = new ArrayList(((ResourceRestriction)r).getResources());
                for (int i9 = 0; i9 < rlist.size(); ++i9) {
                    repos.addStatement(resCR, proIncludeResource, new URIImpl(((URI)rlist.get(i9)).getURI()));
                }
            }
        }
        catch (Exception x) {
            throw new SailInternalException(x);
        }
    }

    public void importPolicy(Graph graph) {
        int i;
        Resource resCPR;
        Resource cls;
        HashSet<Resource> resSet;
        StatementIterator clses;
        Restriction restr;
        Resource resCIR;
        String descr;
        String name2;
        int id;
        StatementIterator sti;
        ValueFactory factory = graph.getValueFactory();
        URI proId = factory.createURI(BASE_KCS_URI, "id");
        URI proName = factory.createURI(BASE_KCS_URI, "name");
        URI proDescr = factory.createURI(BASE_KCS_URI, "descritpion");
        URI proSuperRole = factory.createURI(BASE_KCS_URI, "superRole");
        URI proIncludeRule = factory.createURI(BASE_KCS_URI, "includeRule");
        URI proRuleRestriction = factory.createURI(BASE_KCS_URI, "ruleRestriction");
        URI proRightsGranted = factory.createURI(BASE_KCS_URI, "rightsGranted");
        URI proRestrictionType = factory.createURI(BASE_KCS_URI, "restrictionType");
        URI proIncludeProperty = factory.createURI(BASE_KCS_URI, "includeProperty");
        URI proSubjectRestr = factory.createURI(BASE_KCS_URI, "subjectRestr");
        URI proPredicateRestr = factory.createURI(BASE_KCS_URI, "predicateRestr");
        URI proObjectRestr = factory.createURI(BASE_KCS_URI, "objectRestr");
        URI proRestrOnQuery = factory.createURI(BASE_KCS_URI, "restrOnQuery");
        URI proIncludeResource = factory.createURI(BASE_KCS_URI, "includeResource");
        URI resUser = factory.createURI(BASE_KCS_URI, "User");
        URI resRole = factory.createURI(BASE_KCS_URI, "Role");
        URI resRule = factory.createURI(BASE_KCS_URI, "SecurityRule");
        URI resRepositoryRestriction = factory.createURI(BASE_KCS_URI, "RepositoryRestriction");
        URI resSchemaRestrction = factory.createURI(BASE_KCS_URI, "SchemaRestrction");
        URI resClassesRestriction = factory.createURI(BASE_KCS_URI, "ClassesRestriction");
        URI resClassesOverSchemaRestriction = factory.createURI(BASE_KCS_URI, "ClassesOverSchemaRestriction");
        URI resInstanceRestriction = factory.createURI(BASE_KCS_URI, "InstancesRestriction");
        URI resPropertiesRestriction = factory.createURI(BASE_KCS_URI, "PropertiesRestriction");
        URI resPatternRestriction = factory.createURI(BASE_KCS_URI, "PatternRestriction");
        URI resQueryRestriction = factory.createURI(BASE_KCS_URI, "QueryRestriction");
        URI resRdfType = factory.createURI(RDF_TYPE);
        URI resRdfResource = factory.createURI(RESOURCE);
        URI proHasRole = factory.createURI(BASE_KCS_URI, "hasRole");
        URI proHasRule = factory.createURI(BASE_KCS_URI, "hasRule");
        HashMap<String, Role> uriVsRole = new HashMap<String, Role>();
        HashMap<String, Rule> uriVsRule = new HashMap<String, Rule>();
        HashMap<String, Restriction> uriVsRestr = new HashMap<String, Restriction>();
        ArrayList<UserImpl> usersList = new ArrayList<UserImpl>();
        try {
            sti = graph.getStatements(null, resRdfType, resUser);
            while (sti.hasNext()) {
                Resource resCUser = sti.next().getSubject();
                id = Integer.parseInt(graph.getStatements(resCUser, proId, null).next().getObject().toString());
                UserImpl user = new UserImpl(id, "", "", "");
                user.setUri(((URI)resCUser).getURI());
                StatementIterator rui = graph.getStatements(resCUser, proHasRule, null);
                HashSet<Rule> rulzSet = new HashSet<Rule>();
                while (rui.hasNext()) {
                    URI rul = (URI)rui.next().getObject();
                    Rule rule = (Rule)uriVsRule.get(rul.getURI());
                    if (null == rule) {
                        rule = new RuleImpl(Integer.parseInt(graph.getStatements(rul, proId, null).next().getObject().toString()), "", "");
                        uriVsRule.put(rul.getURI(), rule);
                        rule.setUri(rul.getURI());
                    }
                    rulzSet.add(rule);
                }
                user.setRules(rulzSet);
                StatementIterator roi = graph.getStatements(resCUser, proHasRole, null);
                HashSet<Role> rolzSet = new HashSet<Role>();
                while (roi.hasNext()) {
                    URI rol = (URI)roi.next().getObject();
                    Role role = (Role)uriVsRule.get(rol.getURI());
                    if (null == role) {
                        role = new RoleImpl(Integer.parseInt(graph.getStatements(rol, proId, null).next().getObject().toString()), "", "");
                        role.setUri(rol.getURI());
                        uriVsRole.put(rol.getURI(), role);
                    }
                    rolzSet.add(role);
                }
                user.setRoles(rolzSet);
                usersList.add(user);
                this.usersById.put(new Integer(user.getId()), user);
                this.users.add(user);
            }
        }
        catch (Exception x) {
            throw new SailInternalException(x);
        }
        try {
            sti = graph.getStatements(null, resRdfType, resRole);
            while (sti.hasNext()) {
                Resource resCRole = sti.next().getSubject();
                id = Integer.parseInt(graph.getStatements(resCRole, proId, null).next().getObject().toString());
                name2 = graph.getStatements(resCRole, proName, null).next().getObject().toString();
                descr = graph.getStatements(resCRole, proDescr, null).next().getObject().toString();
                StatementIterator parenti = graph.getStatements(resCRole, proSuperRole, null);
                Role role = (Role)uriVsRole.get(((URI)resCRole).getURI());
                if (null == role) {
                    role = new RoleImpl(id, name2, descr);
                } else {
                    role.setId(id);
                    role.setName(name2);
                    role.setDescription(descr);
                }
                role.setUri(((URI)resCRole).getURI());
                uriVsRole.put(((URI)resCRole).getURI(), role);
                HashSet<Role> prnts = new HashSet<Role>();
                while (parenti.hasNext()) {
                    URI parent = (URI)parenti.next().getObject();
                    Role mappedRole = (Role)uriVsRole.get(parent.getURI());
                    if (mappedRole == null) {
                        mappedRole = new RoleImpl();
                        uriVsRole.put(((URI)resCRole).getURI(), mappedRole);
                        mappedRole.setUri(((URI)resCRole).getURI());
                    }
                    prnts.add(mappedRole);
                }
                role.setParentRoles(prnts);
            }
        }
        catch (Exception x) {
            throw new SailInternalException(x);
        }
        try {
            sti = graph.getStatements(null, resRdfType, resRule);
            while (sti.hasNext()) {
                Resource resCRule = sti.next().getSubject();
                id = Integer.parseInt(graph.getStatements(resCRule, proId, null).next().getObject().toString());
                name2 = graph.getStatements(resCRule, proName, null).next().getObject().toString();
                descr = graph.getStatements(resCRule, proDescr, null).next().getObject().toString();
                URI restrResource = (URI)graph.getStatements(resCRule, proRuleRestriction, null).next().getObject();
                String restrUri = restrResource.getURI();
                Restriction restr2 = (Restriction)uriVsRestr.get(restrUri);
                if (null == restr2) {
                    String restrType = graph.getStatements(restrResource, proRestrictionType, null).next().getObject().toString();
                    int restrId = Integer.parseInt(graph.getStatements(restrResource, proId, null).next().getObject().toString());
                    restr2 = Restriction.createRestriction(Restriction.type2Int(restrType), restrId);
                    uriVsRestr.put(restrUri, restr2);
                }
                restr2.setUri(restrResource.getURI());
                Rule rule = (Rule)uriVsRule.get(((URI)resCRule).getURI());
                if (null == rule) {
                    rule = new RuleImpl(id, name2, descr);
                    uriVsRule.put(((URI)resCRule).getURI(), rule);
                }
                rule.setId(id);
                rule.setName(name2);
                rule.setDescription(descr);
                rule.setRestriction(restr2);
                rule.setUri(((URI)resCRule).getURI());
                ArrayList rights = new ArrayList();
                StatementIterator ri = graph.getStatements(resCRule, proRightsGranted, null);
                while (ri.hasNext()) {
                    String right = ri.next().getObject().toString();
                    if (right.equals(Right.ADD.toString())) {
                        rule.setAddRight(true);
                        continue;
                    }
                    if (right.equals(Right.ADMIN.toString())) {
                        rule.setAdminRight(true);
                        continue;
                    }
                    if (right.equals(Right.HISTORY.toString())) {
                        rule.setHistoryRight(true);
                        continue;
                    }
                    if (right.equals(Right.READ.toString())) {
                        rule.setReadRight(true);
                        continue;
                    }
                    if (!right.equals(Right.REMOVE.toString())) continue;
                    rule.setRemoveRight(true);
                }
            }
        }
        catch (Exception x) {
            throw new SailInternalException(x);
        }
        try {
            sti = graph.getStatements(null, resRdfType, resInstanceRestriction);
            while (sti.hasNext()) {
                resCIR = sti.next().getSubject();
                id = Integer.parseInt(graph.getStatements(resCIR, proId, null).next().getObject().toString());
                name2 = graph.getStatements(resCIR, proName, null).next().getObject().toString();
                descr = graph.getStatements(resCIR, proDescr, null).next().getObject().toString();
                restr = (Restriction)uriVsRestr.get(((URI)resCIR).getURI());
                if (null == restr) {
                    restr = Restriction.createRestriction(4, id);
                }
                restr.setUri(((URI)resCIR).getURI());
                restr.setName(name2);
                restr.setDescription(descr);
                uriVsRestr.put(((URI)resCIR).getURI(), restr);
                clses = graph.getStatements(resCIR, proIncludeResource, null);
                resSet = new HashSet<Resource>();
                while (clses.hasNext()) {
                    cls = (Resource)clses.next().getObject();
                    resSet.add(cls);
                    this.baseRdfRepository.addStatement(cls, resRdfType, resRdfResource);
                }
                ((ResourceRestriction)restr).setResources(resSet);
            }
        }
        catch (Exception x) {
            throw new SailInternalException(x);
        }
        try {
            sti = graph.getStatements(null, resRdfType, resPropertiesRestriction);
            while (sti.hasNext()) {
                resCPR = sti.next().getSubject();
                id = Integer.parseInt(graph.getStatements(resCPR, proId, null).next().getObject().toString());
                name2 = graph.getStatements(resCPR, proName, null).next().getObject().toString();
                descr = graph.getStatements(resCPR, proDescr, null).next().getObject().toString();
                restr = (Restriction)uriVsRestr.get(((URI)resCPR).getURI());
                if (null == restr) {
                    restr = Restriction.createRestriction(5, id);
                }
                restr.setUri(((URI)resCPR).getURI());
                restr.setName(name2);
                restr.setDescription(descr);
                uriVsRestr.put(((URI)resCPR).getURI(), restr);
                StatementIterator pies = graph.getStatements(resCPR, proIncludeProperty, null);
                HashSet<Resource> propList = new HashSet<Resource>();
                while (pies.hasNext()) {
                    Resource py = (Resource)pies.next().getObject();
                    this.baseRdfRepository.addStatement(py, resRdfType, resRdfResource);
                    propList.add(py);
                }
                ((PropertiesRestriction)restr).setProperties(propList);
            }
        }
        catch (Exception x) {
            throw new SailInternalException(x);
        }
        try {
            sti = graph.getStatements(null, resRdfType, resClassesRestriction);
            while (sti.hasNext()) {
                resCIR = sti.next().getSubject();
                id = Integer.parseInt(graph.getStatements(resCIR, proId, null).next().getObject().toString());
                name2 = graph.getStatements(resCIR, proName, null).next().getObject().toString();
                descr = graph.getStatements(resCIR, proDescr, null).next().getObject().toString();
                restr = (Restriction)uriVsRestr.get(((URI)resCIR).getURI());
                if (null == restr) {
                    restr = Restriction.createRestriction(3, id);
                }
                restr.setUri(((URI)resCIR).getURI());
                restr.setName(name2);
                restr.setDescription(descr);
                uriVsRestr.put(((URI)resCIR).getURI(), restr);
                clses = graph.getStatements(resCIR, proIncludeResource, null);
                resSet = new HashSet();
                while (clses.hasNext()) {
                    cls = (Resource)clses.next().getObject();
                    resSet.add(cls);
                    this.baseRdfRepository.addStatement(cls, resRdfType, resRdfResource);
                }
                ((ResourceRestriction)restr).setResources(resSet);
            }
        }
        catch (Exception x) {
            throw new SailInternalException(x);
        }
        try {
            sti = graph.getStatements(null, resRdfType, resClassesOverSchemaRestriction);
            while (sti.hasNext()) {
                resCIR = sti.next().getSubject();
                id = Integer.parseInt(graph.getStatements(resCIR, proId, null).next().getObject().toString());
                name2 = graph.getStatements(resCIR, proName, null).next().getObject().toString();
                descr = graph.getStatements(resCIR, proDescr, null).next().getObject().toString();
                restr = (Restriction)uriVsRestr.get(((URI)resCIR).getURI());
                if (null == restr) {
                    restr = Restriction.createRestriction(8, id);
                }
                restr.setUri(((URI)resCIR).getURI());
                restr.setName(name2);
                restr.setDescription(descr);
                uriVsRestr.put(((URI)resCIR).getURI(), restr);
                clses = graph.getStatements(resCIR, proIncludeResource, null);
                resSet = new HashSet();
                while (clses.hasNext()) {
                    cls = (Resource)clses.next().getObject();
                    resSet.add(cls);
                    this.baseRdfRepository.addStatement(cls, resRdfType, resRdfResource);
                }
                ((ResourceRestriction)restr).setResources(resSet);
            }
        }
        catch (Exception x) {
            throw new SailInternalException(x);
        }
        try {
            sti = graph.getStatements(null, resRdfType, resPatternRestriction);
            while (sti.hasNext()) {
                resCPR = sti.next().getSubject();
                id = Integer.parseInt(graph.getStatements(resCPR, proId, null).next().getObject().toString());
                name2 = graph.getStatements(resCPR, proName, null).next().getObject().toString();
                descr = graph.getStatements(resCPR, proDescr, null).next().getObject().toString();
                restr = (Restriction)uriVsRestr.get(((URI)resCPR).getURI());
                if (null == restr) {
                    restr = Restriction.createRestriction(6, id);
                }
                restr.setUri(((URI)resCPR).getURI());
                restr.setName(name2);
                restr.setDescription(descr);
                uriVsRestr.put(((URI)resCPR).getURI(), restr);
                StatementIterator subjI = graph.getStatements(resCPR, proSubjectRestr, null);
                while (subjI.hasNext()) {
                    Resource cls2 = (Resource)subjI.next().getObject();
                    this.baseRdfRepository.addStatement(cls2, resRdfType, resRdfResource);
                    StatementIterator restrTypesI = graph.getStatements(cls2, resRdfType, null);
                    String rType = "";
                    while (restrTypesI.hasNext() && (rType = restrTypesI.next().getObject().toString()).indexOf("Restriction") == -1) {
                    }
                    Restriction sRestr = (Restriction)uriVsRestr.get(((URI)cls2).getURI());
                    if (sRestr == null) {
                        rType = graph.getStatements(cls2, proRestrictionType, null).next().getObject().toString();
                        int sRestrId = Integer.parseInt(graph.getStatements(cls2, proId, null).next().getObject().toString());
                        sRestr = Restriction.createRestriction(Restriction.type2Int(rType), sRestrId);
                        uriVsRestr.put(((URI)cls2).getURI(), sRestr);
                    }
                    sRestr.setUri(((URI)cls2).getURI());
                    ((PatternRestriction)restr).addSubjectRestriction((ResourceRestriction)sRestr);
                }
                StatementIterator predI = graph.getStatements(resCPR, proPredicateRestr, null);
                while (predI.hasNext()) {
                    cls = (Resource)predI.next().getObject();
                    this.baseRdfRepository.addStatement(cls, resRdfType, resRdfResource);
                    StatementIterator restrTypesI = graph.getStatements(cls, resRdfType, null);
                    String rType = "";
                    while (restrTypesI.hasNext() && (rType = restrTypesI.next().getObject().toString()).indexOf("Restriction") == -1) {
                    }
                    Restriction sRestr = (Restriction)uriVsRestr.get(((URI)cls).getURI());
                    if (sRestr == null) {
                        rType = graph.getStatements(cls, proRestrictionType, null).next().getObject().toString();
                        int sRestrId = Integer.parseInt(graph.getStatements(cls, proId, null).next().getObject().toString());
                        sRestr = Restriction.createRestriction(Restriction.type2Int(rType), sRestrId);
                        uriVsRestr.put(((URI)cls).getURI(), sRestr);
                    }
                    sRestr.setUri(((URI)cls).getURI());
                    ((PatternRestriction)restr).addPredicateRestriction((PropertiesRestriction)sRestr);
                }
                StatementIterator objI = graph.getStatements(resCPR, proObjectRestr, null);
                HashSet<Resource> objRestrSet = new HashSet<Resource>();
                while (objI.hasNext()) {
                    Resource cls3 = (Resource)objI.next().getObject();
                    this.baseRdfRepository.addStatement(cls3, resRdfType, resRdfResource);
                    objRestrSet.add(cls3);
                    StatementIterator restrTypesI = graph.getStatements(cls3, resRdfType, null);
                    String rType = "";
                    while (restrTypesI.hasNext() && (rType = restrTypesI.next().toString()).indexOf("Restriction") == -1) {
                    }
                    Restriction sRestr = (Restriction)uriVsRestr.get(((URI)cls3).getURI());
                    if (sRestr == null) {
                        rType = graph.getStatements(cls3, proRestrictionType, null).next().getObject().toString();
                        int sRestrId = Integer.parseInt(graph.getStatements(cls3, proId, null).next().getObject().toString());
                        sRestr = Restriction.createRestriction(Restriction.type2Int(rType), sRestrId);
                        uriVsRestr.put(((URI)cls3).getURI(), sRestr);
                    }
                    sRestr.setUri(((URI)cls3).getURI());
                    ((PatternRestriction)restr).addObjectRestriction((ResourceRestriction)sRestr);
                }
            }
        }
        catch (Exception x) {
            throw new SailInternalException(x);
        }
        try {
            sti = graph.getStatements(null, resRdfType, resQueryRestriction);
            while (sti.hasNext()) {
                Resource resCQR = sti.next().getSubject();
                id = Integer.parseInt(graph.getStatements(resCQR, proId, null).next().getObject().toString());
                name2 = graph.getStatements(resCQR, proName, null).next().getObject().toString();
                descr = graph.getStatements(resCQR, proDescr, null).next().getObject().toString();
                restr = (Restriction)uriVsRestr.get(((URI)resCQR).getURI());
                if (null == restr) {
                    restr = Restriction.createRestriction(7, id);
                }
                restr.setUri(((URI)resCQR).getURI());
                restr.setName(name2);
                restr.setDescription(descr);
                uriVsRestr.put(((URI)resCQR).getURI(), restr);
                StatementIterator queryI = graph.getStatements(resCQR, proRestrOnQuery, null);
                while (queryI.hasNext()) {
                    String q = queryI.next().getObject().toString();
                    ((QueryRestriction)restr).addQuery(q);
                }
            }
        }
        catch (Exception x) {
            throw new SailInternalException(x);
        }
        this.rulesById = new HashMap();
        ArrayList vlist = new ArrayList(uriVsRule.values());
        for (i = 0; i < vlist.size(); ++i) {
            Rule r = (Rule)vlist.get(i);
            this.rulesById.put(new Integer(r.getId()), r);
        }
        this.restrictionsById = new HashMap();
        vlist = new ArrayList(uriVsRestr.values());
        for (i = 0; i < vlist.size(); ++i) {
            Restriction r = (Restriction)vlist.get(i);
            this.restrictionsById.put(new Integer(r.getId()), r);
        }
        this.rolesByName = new HashMap();
        this.rolesById = new HashMap();
        this.roles = new HashSet();
        vlist = new ArrayList(uriVsRole.values());
        for (i = 0; i < vlist.size(); ++i) {
            Role r = (Role)vlist.get(i);
            this.rolesById.put(new Integer(r.getId()), r);
            this.rolesByName.put(r.getName(), r);
            this.roles.add(r);
        }
    }

    public void startTableQueryResult() throws IOException {
    }

    public void startTableQueryResult(String[] columnHeaders) throws IOException {
        this.queryResult = new ArrayList();
        this.isQueryReady = false;
    }

    public void endTableQueryResult() throws IOException {
        this.isQueryReady = true;
    }

    public void startTuple() throws IOException {
    }

    public void endTuple() throws IOException {
    }

    public void tupleValue(Value value) throws IOException {
        this.queryResult.add(value);
    }

    public void error(QueryErrorType errType, String msg) throws IOException {
        throw new SailInternalException(msg);
    }

    private void addTransient(Resource subject, URI predicate, Value object) {
        StatementImpl st = new StatementImpl(subject, predicate, object);
        this.transients.add(st);
    }

    private boolean areThereTransients() {
        return this.transients.size() != 0;
    }

    private String removeIrrelevantTransients() {
        StringBuffer added = new StringBuffer();
        StringBuffer filtered2 = new StringBuffer();
        added.append("\nThe following statements were ADDed: \n");
        filtered2.append("\nThe following statements were FILTERed: \n");
        boolean isAdded = false;
        boolean isFiltered = false;
        for (int ix = 0; ix < this.transients.size(); ++ix) {
            Value object;
            URI predicate;
            org.openrdf.model.Statement st = (org.openrdf.model.Statement)this.transients.get(ix);
            Resource subject = st.getSubject();
            if (!this.isStatementAccessible(subject, predicate = st.getPredicate(), object = st.getObject(), Right.ADD)) {
                try {
                    if (this.baseRdfRepository.removeStatements(subject, predicate, object) <= 0) continue;
                    filtered2.append("\n").append(st.toString()).append("\n");
                    isFiltered = true;
                    continue;
                }
                catch (SailUpdateException e) {
                    throw new SailInternalException("Cannot finish the filtering of Tranisient Added Statements.\nCaused by :" + e.getClass() + "\n" + e.getMessage());
                }
            }
            added.append("\n").append(st.toString()).append("\n");
            isAdded = true;
        }
        this.transients = new ArrayList();
        return (isAdded ? added.toString() : "\nNo Statements ADDed.\n") + (isFiltered ? filtered2.toString() : "\nNo FILTERed Statements.\n");
    }

    private void loadLiteralsTable(Connection con, Statement st) throws SQLException {
        ResultSet result2 = st.executeQuery("SELECT * FROM literals");
        while (result2.next()) {
            int id = result2.getInt("id");
            String lang = result2.getString("language");
            String value = result2.getString("label");
            LiteralImpl literal = new LiteralImpl(value, lang);
            this.literalById.put(new Integer(id), literal);
            this.idByLiteral.put(literal, new Integer(id));
        }
        ThreadLog.trace((String)"literals LOADED");
    }

    private void loadNameSpaceTable(Connection con, Statement st) throws SQLException {
        ResultSet result2 = st.executeQuery("SELECT * FROM namespaces");
        while (result2.next()) {
            int id = result2.getInt(1);
            String prefix = result2.getString(2);
            String name2 = result2.getString(3);
            RdbmsNamespace ns = new RdbmsNamespace(id, prefix, name2, false);
            this.namespaces.put(new Integer(id), ns);
        }
        ThreadLog.trace((String)"namespaces LOADED");
    }

    private void loadResourcesTable(Connection con, Statement st) throws SQLException {
        ResultSet result2 = st.executeQuery("SELECT * FROM resources");
        ValueFactoryImpl factory = new ValueFactoryImpl();
        while (result2.next()) {
            int id = result2.getInt(1);
            if (id > this.lastResId) {
                this.lastResId = id;
            }
            int namespace = result2.getInt(2);
            String name2 = result2.getString(3);
            RdbmsNamespace ns = (RdbmsNamespace)this.namespaces.get(new Integer(namespace));
            if (null == ns) {
                throw new SailInternalException("[Unknown] resource [namespace]. Namespace [id]=" + namespace);
            }
            Resource rs = null;
            rs = namespace != 0 ? new URIImpl(ns.getName(), name2) : factory.createBNode();
            this.resById.put(new Integer(id), rs);
            this.idByRes.put(rs, new Integer(id));
            if (id <= lastResourceId) continue;
            lastResourceId = id;
        }
        ThreadLog.trace((String)"restrictions LOADED");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadSecuritySetup() {
        ThreadLog.trace((String)">>>Loading of Security Setup");
        Connection con = null;
        Statement st = null;
        try {
            try {
                con = this.conPool.getConnection();
                st = con.createStatement();
                this.loadNameSpaceTable(con, st);
                this.loadResourcesTable(con, st);
                this.loadLiteralsTable(con, st);
                this.loadRestrictionsTable(con, st);
                this.loadSecurityRulesTable(con, st);
                this.loadRolesTable(con, st);
                this.loadRolesHierarchyTable(con, st);
                this.loadRolesRulesTable(con, st);
                this.loadResourceOrPropertyRestrictionsTable(con, st);
                this.loadQueryRestrictionsTable(con, st);
                this.loadPatternRestrictionsTable(con, st);
                this.loadUsersRolesTable(con, st);
                this.loadUsersRulesTable(con, st);
            }
            catch (SQLException sqle) {
                throw new SailInternalException(sqle);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                st.close();
                con.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new SailInternalException(e);
            }
        }
        try {}
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
        st.close();
        con.close();
        ThreadLog.trace((String)"<<<Loading of Security Setup");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initDatabase() throws SailInternalException {
        ThreadLog.trace((String)">>>initializing Database");
        Connection con = null;
        Statement st = null;
        try {
            try {
                con = this.conPool.getConnection();
                st = con.createStatement();
                this.createSecurityTables(con, st);
                ThreadLog.trace((String)"<<<initializing Database");
            }
            catch (SQLException e) {
                throw new SailInternalException(e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                st.close();
                con.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new SailInternalException(e);
            }
        }
        try {}
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
        st.close();
        con.close();
    }

    private boolean tableExists(Connection con, String tableName) throws SQLException {
        boolean tableExists = false;
        DatabaseMetaData metadata = con.getMetaData();
        ResultSet rs = metadata.getTables(null, null, tableName, null);
        tableExists = rs.next();
        metadata = null;
        rs.close();
        rs = null;
        return tableExists;
    }

    private void createUsersRolesTable(Connection con, Statement st) throws SQLException {
        if (!this.tableExists(con, USERS_ROLES_TABLE)) {
            st.executeUpdate("CREATE TABLE users_roles (user_id INTEGER UNSIGNED NOT NULL,role_id INTEGER UNSIGNED NOT NULL );");
            st.executeUpdate("CREATE UNIQUE INDEX XPKUsersRoles ON users_roles( user_id, role_id );");
            ThreadLog.trace((String)"users_roles CREATED");
        }
    }

    private void loadUsersRolesTable(Connection con, Statement st) throws SQLException {
        ResultSet result2 = st.executeQuery("SELECT * FROM users_roles");
        while (result2.next()) {
            int user_id = result2.getInt(1);
            int role_id = result2.getInt(2);
            User user = this.getUser(user_id);
            Role role = (Role)this.rolesById.get(new Integer(role_id));
            if (null == role) {
                throw new SailInternalException("Unknown [role id] in table users_roles\n[id]=" + role_id);
            }
            if (null == user) {
                try {
                    user = new UserImpl(user_id, "ANONYMOUS" + user_id, "", "ANONYMOUS" + user_id);
                    this.users.add(user);
                    this.usersById.put(new Integer(user_id), user);
                    this.usersByLogin.put(user.getLogin(), user);
                }
                catch (Exception e) {
                    throw new SailInternalException(e);
                }
            }
            Set roles = user.getRoles();
            roles.add(role);
            try {
                user.setRoles(roles);
            }
            catch (Exception e) {
                throw new SailInternalException(e);
            }
        }
        ThreadLog.trace((String)"users_roles LOADED");
    }

    private void createUsersRulesTable(Connection con, Statement st) throws SQLException {
        if (!this.tableExists(con, USERS_RULES_TABLE)) {
            st.executeUpdate("CREATE TABLE users_rules (user_id INTEGER UNSIGNED NOT NULL,rule_id INTEGER UNSIGNED NOT NULL );");
            st.executeUpdate("CREATE UNIQUE INDEX XPKUsersRules ON users_rules( user_id, rule_id );");
            ThreadLog.trace((String)"users_rules CREATED");
        }
    }

    private void loadUsersRulesTable(Connection con, Statement st) throws SQLException {
        ResultSet result2 = st.executeQuery("SELECT * FROM users_rules");
        while (result2.next()) {
            int user_id = result2.getInt(1);
            int rule_id = result2.getInt(2);
            User user = this.getUser(user_id);
            Rule rule = (Rule)this.rulesById.get(new Integer(rule_id));
            if (null == rule) {
                throw new SailInternalException("Unknown [rule id] in table users_rules\n[id]=" + rule_id);
            }
            if (null == user) {
                try {
                    user = new UserImpl(user_id, "ANONYMOUS" + user_id, "", "ANONYMOUS" + user_id);
                    this.users.add(user);
                    this.usersById.put(new Integer(user_id), user);
                    this.usersByLogin.put(user.getLogin(), user);
                }
                catch (Exception e) {
                    throw new SailInternalException(e);
                }
            }
            Set rules = user.getRules();
            rules.add(rule);
            try {
                user.setRules(rules);
            }
            catch (Exception e) {
                throw new SailInternalException(e);
            }
        }
        ThreadLog.trace((String)"users_rules LOADED");
    }

    private void createRolesTable(Connection con, Statement st) throws SQLException {
        if (!this.tableExists(con, ROLES_TABLE)) {
            st.executeUpdate("CREATE TABLE roles (id INTEGER UNSIGNED NOT NULL,name character varying(20),description character varying(255) );");
            st.executeUpdate("CREATE UNIQUE INDEX XPKRoles ON roles( id );");
            ThreadLog.trace((String)"roles CREATED");
        }
    }

    private void loadRolesTable(Connection con, Statement st) throws SQLException {
        ResultSet result2 = st.executeQuery("SELECT * FROM roles");
        while (result2.next()) {
            int id = result2.getInt(1);
            String name2 = result2.getString(2);
            String description = result2.getString(3);
            Role role = this.createRole(id, name2, description, new HashSet(1));
        }
        ThreadLog.trace((String)"roles LOADED");
    }

    private void createRolesHierarchyTable(Connection con, Statement st) throws SQLException {
        if (!this.tableExists(con, ROLES_HIERARCHY_TABLE)) {
            st.executeUpdate("CREATE TABLE roles_hierarchy (role_id INTEGER UNSIGNED NOT NULL,parent_role_id INTEGER UNSIGNED NOT NULL );");
            st.executeUpdate("CREATE UNIQUE INDEX XPKRolesHierarchy ON roles_hierarchy( role_id, parent_role_id );");
            ThreadLog.trace((String)"roles_hierarchy CREATED");
        }
    }

    private void loadRolesHierarchyTable(Connection con, Statement st) throws SQLException {
        ResultSet result2 = st.executeQuery("SELECT * FROM roles_hierarchy");
        while (result2.next()) {
            int role_id = result2.getInt(1);
            int parent_id = result2.getInt(2);
            Role role = (Role)this.rolesById.get(new Integer(role_id));
            Role parent = (Role)this.rolesById.get(new Integer(parent_id));
            if (null == role) {
                throw new SailInternalException("Unknown [role id] in table roles_hierarchy\n[id]=" + role_id);
            }
            if (null == parent) {
                throw new SailInternalException("Unknown [parent role id] in table roles_hierarchy\n[id]=" + parent_id);
            }
            Set parents = role.getParentRoles();
            parents.add(parent);
            try {
                role.setParentRoles(parents);
            }
            catch (Exception e) {
                throw new SailInternalException(e);
            }
        }
        ThreadLog.trace((String)"roles_hierarchy LOADED");
    }

    private void createRolesRulesTable(Connection con, Statement st) throws SQLException {
        if (!this.tableExists(con, ROLES_RULES_TABLE)) {
            st.executeUpdate("CREATE TABLE roles_rules (role_id INTEGER UNSIGNED NOT NULL,rule_id INTEGER UNSIGNED NOT NULL );");
            st.executeUpdate("CREATE UNIQUE INDEX XPKRolesRules ON roles_rules( role_id, rule_id );");
            ThreadLog.trace((String)"roles_rules CREATED");
        }
    }

    private void loadRolesRulesTable(Connection con, Statement st) throws SQLException {
        ResultSet result2 = st.executeQuery("SELECT * FROM roles_rules");
        while (result2.next()) {
            int role_id = result2.getInt(1);
            int rule_id = result2.getInt(2);
            Role role = (Role)this.rolesById.get(new Integer(role_id));
            Rule rule = (Rule)this.rulesById.get(new Integer(rule_id));
            if (null == role) {
                throw new SailInternalException("Unknown [role id] in table roles_rules\n[id]=" + role_id);
            }
            if (null == rule) {
                throw new SailInternalException("Unknown [rule id] in table roles_rules\n[id]=" + rule_id);
            }
            try {
                role.addRule(rule);
            }
            catch (Exception e) {
                throw new SailInternalException(e);
            }
        }
        ThreadLog.trace((String)"roles_rules LOADED");
    }

    private void createSecurityRulesTable(Connection con, Statement st) throws SQLException {
        if (!this.tableExists(con, SECURITY_RULES_TABLE)) {
            String query2 = "CREATE TABLE security_rules (id INTEGER UNSIGNED NOT NULL,name character varying(20), description character varying(255), restriction_id INTEGER UNSIGNED NOT NULL,read_right BOOL , add_right BOOL, remove_right BOOL, admin_right BOOL, history_right BOOL );";
            st.executeUpdate(query2);
            st.executeUpdate("CREATE UNIQUE INDEX XPKSecurityRules ON security_rules( id );");
            ThreadLog.trace((String)"security_rules CREATED");
        }
    }

    private void loadSecurityRulesTable(Connection con, Statement st) throws SQLException {
        ResultSet result2 = st.executeQuery("SELECT * FROM security_rules");
        while (result2.next()) {
            RuleImpl rule;
            int id = result2.getInt(1);
            String name2 = result2.getString(2);
            String description = result2.getString(3);
            try {
                rule = new RuleImpl(id, name2, description);
            }
            catch (Exception e) {
                throw new SailInternalException(e);
            }
            int restrId = result2.getInt(4);
            Restriction restr = this.getRestriction(restrId);
            try {
                rule.setRestriction(restr);
            }
            catch (Exception e) {
                throw new SailInternalException(e);
            }
            rule.setReadRight(result2.getBoolean(5));
            rule.setAddRight(result2.getBoolean(6));
            rule.setRemoveRight(result2.getBoolean(7));
            rule.setAdminRight(result2.getBoolean(8));
            rule.setHistoryRight(result2.getBoolean(9));
            this.rulesById.put(new Integer(id), rule);
        }
        ThreadLog.trace((String)"security_rules LOADED");
    }

    private void createRestrictionsTable(Connection con, Statement st) throws SQLException {
        if (!this.tableExists(con, RESTRICTIONS_TABLE)) {
            String query2 = "CREATE TABLE restrictions (id INTEGER UNSIGNED NOT NULL,type INTEGER UNSIGNED NOT NULL,name character varying(20), description character varying(255) );";
            st.executeUpdate(query2);
            st.executeUpdate("CREATE UNIQUE INDEX XPKRestrictions ON restrictions( id );");
            ThreadLog.trace((String)"restrictions CREATED");
        }
    }

    private void loadRestrictionsTable(Connection con, Statement st) throws SQLException {
        ResultSet result2 = st.executeQuery("SELECT * FROM restrictions");
        while (result2.next()) {
            Restriction restr;
            int id = result2.getInt(1);
            int type = result2.getInt(2);
            String name2 = result2.getString(3);
            String description = result2.getString(4);
            try {
                restr = this.createRestriction(id, type, name2, description);
            }
            catch (Exception e) {
                throw new SailInternalException(e);
            }
            this.restrictionsById.put(new Integer(id), restr);
        }
        ThreadLog.trace((String)"restrictions LOADED");
    }

    private void createResourceOrPropertyRestrictionsTable(Connection con, Statement st) throws SQLException {
        if (!this.tableExists(con, RES_PROP_RESTRS_TABLE)) {
            String query2 = "CREATE TABLE res_propr_restrs (restr_id INTEGER UNSIGNED NOT NULL,resource_id INTEGER UNSIGNED NOT NULL );";
            st.executeUpdate(query2);
            st.executeUpdate("CREATE UNIQUE INDEX XPKResOrPropRestrictions ON res_propr_restrs( restr_id,resource_id );");
            ThreadLog.trace((String)"res_propr_restrs CREATED");
        }
    }

    private void loadResourceOrPropertyRestrictionsTable(Connection con, Statement st) throws SQLException {
        ResultSet result2 = st.executeQuery("SELECT * FROM res_propr_restrs");
        while (result2.next()) {
            int restrId = result2.getInt(1);
            int resourceId = result2.getInt(2);
            Restriction restr = this.getRestriction(restrId);
            Resource res = (Resource)this.resById.get(new Integer(resourceId));
            if (null == restr) {
                throw new SailInternalException("Unknown Restriction [id] in table res_propr_restrs\n[id] = " + restrId);
            }
            if (null == res) {
                throw new SailInternalException("Unknown Resource [id] in table res_propr_restrs\n[id] = " + resourceId);
            }
            int type = restr.getType();
            try {
                switch (type) {
                    case 3: {
                        ResourceRestriction cr = (ClassesRestriction)restr;
                        Set rss = cr.getResources();
                        rss.add(res);
                        cr.setResources(rss);
                        break;
                    }
                    case 8: {
                        ResourceRestriction cr = (ClassesOverSchemaRestriction)restr;
                        Set rss = cr.getResources();
                        rss.add(res);
                        cr.setResources(rss);
                        break;
                    }
                    case 4: {
                        InstancesRestriction ir = (InstancesRestriction)restr;
                        Set rss = ir.getResources();
                        rss.add(res);
                        ir.setResources(rss);
                        break;
                    }
                    case 5: {
                        PropertiesRestriction pr = (PropertiesRestriction)restr;
                        Set rss = pr.getProperties();
                        rss.add(res);
                        pr.setProperties(rss);
                        break;
                    }
                    default: {
                        throw new SailInternalException("res_propr_restrs contains a restriction which type [" + type + "] is neither INSTANCES type, \n" + "neither CLASSES type, neither PROPERTIES type.");
                    }
                }
            }
            catch (Exception e) {
                throw new SailInternalException(e);
            }
        }
        ThreadLog.trace((String)"restrictions LOADED");
    }

    private void createPatternRestrictionsTable(Connection con, Statement st) throws SQLException {
        if (!this.tableExists(con, PATTERN_RESTRS_TABLE)) {
            st.executeUpdate("CREATE TABLE pattern_restrs (pattern_restr_id INTEGER UNSIGNED NOT NULL,cip_restr_id INTEGER UNSIGNED NOT NULL,spo_type INTEGER UNSIGNED NOT NULL );");
            st.executeUpdate("CREATE UNIQUE INDEX XPKPatternRestrictions ON pattern_restrs( pattern_restr_id, cip_restr_id, spo_type );");
            ThreadLog.trace((String)"pattern_restrs CREATED");
        }
    }

    private void loadPatternRestrictionsTable(Connection con, Statement st) throws SQLException {
        ResultSet result2 = st.executeQuery("SELECT * FROM pattern_restrs");
        block8: while (result2.next()) {
            int restr_id = result2.getInt(1);
            int cip_restr_id = result2.getInt(2);
            int spo = result2.getInt(3);
            Restriction restr = (Restriction)this.restrictionsById.get(new Integer(restr_id));
            if (null == restr) {
                throw new SailInternalException("Unknown Restriction [id] in table pattern_restrs\n[id] = " + restr_id);
            }
            Restriction cip = null;
            if (spo != 3 && null == (cip = this.getRestriction(cip_restr_id))) {
                throw new SailInternalException("Unknown Restriction [id] in table pattern_restrs\n[id] = " + cip_restr_id);
            }
            if (!(restr instanceof PatternRestriction)) {
                throw new SailInternalException("All restrictions in the pattern_restrs\n should be PatternRestriction.\nRestriction [id]=" + restr_id + "\n+class:" + restr.getClass());
            }
            PatternRestriction pr = (PatternRestriction)restr;
            switch (spo) {
                case 0: {
                    if (!(cip instanceof ResourceRestriction)) {
                        throw new SailInternalException("Subject Restrictions should be instances of ResourceRestriction\nclass:" + cip.getClass());
                    }
                    pr.addSubjectRestriction((ResourceRestriction)cip);
                    continue block8;
                }
                case 1: {
                    if (!(cip instanceof PropertiesRestriction)) {
                        throw new SailInternalException("Predicate Restrictions should be instances of PropertiesRestriction\nclass:" + cip.getClass());
                    }
                    pr.addPredicateRestriction((PropertiesRestriction)cip);
                    continue block8;
                }
                case 2: {
                    if (!(cip instanceof ResourceRestriction)) {
                        throw new SailInternalException("Object Restrioctions should be instances of ResourceRestriction\nclass:" + cip.getClass());
                    }
                    pr.addObjectRestriction((ResourceRestriction)cip);
                    continue block8;
                }
                case 3: {
                    Literal lit = (Literal)this.literalById.get(new Integer(cip_restr_id));
                    if (null == lit) {
                        throw new SailInternalException("Unknown literal id in table pattern_restrs\n[id]=" + cip_restr_id);
                    }
                    try {
                        pr.addObjectRestriction(lit);
                        continue block8;
                    }
                    catch (Exception e) {
                        throw new SailInternalException(e);
                    }
                }
            }
            throw new SailInternalException("Unknown Subject_Predicate_Object Type\nin table pattern_restrs\n[spo_type]=" + spo);
        }
        ThreadLog.trace((String)"pattern_restrs LOADED");
    }

    private void createQueryRestrictionsTable(Connection con, Statement st) throws SQLException {
        if (!this.tableExists(con, QUERY_RESTRS_TABLE)) {
            st.executeUpdate("CREATE TABLE query_restrs (restr_id INTEGER UNSIGNED NOT NULL,query character varying(255) );");
            ThreadLog.trace((String)"query_restrs CREATED");
        }
    }

    private void loadQueryRestrictionsTable(Connection con, Statement st) throws SQLException {
        ResultSet result2 = st.executeQuery("SELECT * FROM query_restrs");
        while (result2.next()) {
            int id = result2.getInt(1);
            String query2 = result2.getString(2);
            Restriction restr = this.getRestriction(id);
            if (null == restr) {
                throw new SailInternalException("Unknown Restriction [id] in table query_restrs\n[id] = " + id);
            }
            if (!(restr instanceof QueryRestriction)) {
                throw new SailInternalException("All restrictions in the query_restrs\n should be QueryRestrictions.\nRestriction [id]=" + id + "\n+class:" + restr.getClass());
            }
            QueryRestriction qr = (QueryRestriction)restr;
            qr.addQuery(query2);
        }
        ThreadLog.trace((String)"query_restrs LOADED");
    }

    private void dropSecurityTables(Connection con, Statement st) throws SQLException, NullParameterException {
        if (null == con || null == st) {
            throw new NullParameterException("the Connection [con] and java.sql.Statement [st] should not be [null]");
        }
        try {
            st.executeUpdate("DROP TABLE users_roles");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            st.executeUpdate("DROP TABLE users_rules");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            st.executeUpdate("DROP TABLE security_rules");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            st.executeUpdate("DROP TABLE roles");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            st.executeUpdate("DROP TABLE roles_rules");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            st.executeUpdate("DROP TABLE roles_hierarchy");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            st.executeUpdate("DROP TABLE restrictions");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            st.executeUpdate("DROP TABLE res_propr_restrs");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            st.executeUpdate("DROP TABLE pattern_restrs");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            st.executeUpdate("DROP TABLE query_restrs");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ThreadLog.trace((String)"Security Tables DROPPED.");
    }

    private void createSecurityTables(Connection con, Statement st) throws SQLException {
        this.createUsersRolesTable(con, st);
        this.createUsersRulesTable(con, st);
        this.createRolesTable(con, st);
        this.createRolesHierarchyTable(con, st);
        this.createRolesRulesTable(con, st);
        this.createSecurityRulesTable(con, st);
        this.createRestrictionsTable(con, st);
        this.createResourceOrPropertyRestrictionsTable(con, st);
        this.createPatternRestrictionsTable(con, st);
        this.createQueryRestrictionsTable(con, st);
    }

    private void uploadSampleSetup() {
        Connection con = null;
        Statement st = null;
        try {
            con = this.conPool.getConnection();
            st = con.createStatement();
            this.loadNameSpaceTable(con, st);
            this.loadResourcesTable(con, st);
            this.loadLiteralsTable(con, st);
            UserImpl uAdmin = new UserImpl(1, "", "", "");
            UserImpl uAnon = new UserImpl(2, "", "", "");
            UserImpl uTest = new UserImpl(3, "", "", "");
            UserImpl uHR = new UserImpl(4, "", "", "");
            UserImpl uRD = new UserImpl(5, "", "", "");
            UserImpl uEmp = new UserImpl(6, "", "", "");
            UserImpl uQue = new UserImpl(7, "", "", "");
            UserImpl uMitac = new UserImpl(8, "", "", "");
            this.users.add(uAdmin);
            this.users.add(uAnon);
            this.users.add(uTest);
            this.users.add(uHR);
            this.users.add(uRD);
            this.users.add(uEmp);
            this.users.add(uQue);
            this.users.add(uMitac);
            Restriction rsRepository = Restriction.createRepositoryRestriction("repository", "repository");
            RuleImpl ruAdmin = new RuleImpl("doEverything", "do everything with the repository rule");
            ruAdmin.setAddRight(true);
            ruAdmin.setAdminRight(true);
            ruAdmin.setHistoryRight(true);
            ruAdmin.setRemoveRight(true);
            ruAdmin.setReadRight(true);
            ruAdmin.setRestriction(rsRepository);
            Set rulz = uAdmin.getRules();
            rulz.add(ruAdmin);
            uAdmin.setRules(rulz);
            Restriction rsSchema = Restriction.createSchemaRestriction("schema", "schema");
            RuleImpl ruReadSchema = new RuleImpl("readschema", "readschema");
            ruReadSchema.setReadRight(true);
            ruReadSchema.setRestriction(rsSchema);
            Set rulz2 = uTest.getRules();
            rulz2.add(ruReadSchema);
            uTest.setRules(rulz2);
            URIImpl resSkill = null;
            ResourceRestriction rsSkillsSchema = null;
            resSkill = new URIImpl(SKILL);
            rsSkillsSchema = (ResourceRestriction)ResourceRestriction.createClassesOverSchemaRestriction("skillsSchema", "skills hierarchy");
            Set rSet = rsSkillsSchema.getResources();
            rSet.add(resSkill);
            rsSkillsSchema.setResources(rSet);
            ResourceRestriction rsSkills = (ResourceRestriction)ResourceRestriction.createClassesRestriction("skillsInstances", "skills instances");
            Set rSet2 = rsSkills.getResources();
            rSet2.add(resSkill);
            rsSkills.setResources(rSet2);
            RuleImpl ruSkillsSchema = new RuleImpl("skillsSchema", "skills schema");
            ruSkillsSchema.setRestriction(rsSkillsSchema);
            ruSkillsSchema.setAddRight(true);
            ruSkillsSchema.setReadRight(true);
            ruSkillsSchema.setRemoveRight(true);
            RuleImpl ruSkills = new RuleImpl("skills", "skills");
            ruSkills.setRestriction(rsSkills);
            ruSkills.setAddRight(true);
            ruSkills.setReadRight(true);
            ruSkills.setRemoveRight(true);
            Set rulz3 = uHR.getRules();
            rulz3.add(ruSkills);
            rulz3.add(ruSkillsSchema);
            uHR.setRules(rulz3);
            URIImpl resTechSkill = null;
            ResourceRestriction rsTSkills = null;
            resTechSkill = new URIImpl(TECH_SKILL);
            ResourceRestriction rsTSkillsSchema = (ResourceRestriction)ResourceRestriction.createClassesOverSchemaRestriction("TechskillsSchema", "Techskills hierarchy");
            Set rSet3 = rsTSkillsSchema.getResources();
            rSet3.add(resTechSkill);
            rsTSkillsSchema.setResources(rSet3);
            rsTSkills = (ResourceRestriction)ResourceRestriction.createClassesRestriction("TechskillsInstances", "Techskills instances");
            rSet3 = rsTSkills.getResources();
            rSet3.add(resTechSkill);
            rsTSkills.setResources(rSet3);
            RuleImpl ruSkillsSchema2 = new RuleImpl("TechskillsSchema", "Techskills schema");
            ruSkillsSchema2.setRestriction(rsTSkillsSchema);
            ruSkillsSchema2.setAddRight(true);
            ruSkillsSchema2.setReadRight(true);
            ruSkillsSchema2.setRemoveRight(true);
            RuleImpl ruSkills2 = new RuleImpl("Techskills", "Techskills");
            ruSkills2.setRestriction(rsTSkills);
            ruSkills2.setAddRight(true);
            ruSkills2.setReadRight(true);
            ruSkills2.setRemoveRight(true);
            Set rulz4 = uRD.getRules();
            rulz4.add(ruSkills2);
            rulz4.add(ruSkillsSchema2);
            uRD.setRules(rulz4);
            URIImpl resPerson = null;
            URIImpl resHasPosition = null;
            URIImpl resSubClassOf = null;
            URIImpl resHasSkill = null;
            resPerson = new URIImpl(PERSON);
            ResourceRestriction rsPersons = (ResourceRestriction)Restriction.createClassesRestriction("Persons", "Persons");
            Set rSet4 = rsPersons.getResources();
            rSet4.add(resPerson);
            rsPersons.setResources(rSet4);
            resHasPosition = new URIImpl(HAS_POSITION);
            PropertiesRestriction rsHasPosition = (PropertiesRestriction)Restriction.createPropertiesRestriction("hasPosition", "hasPosition");
            Set rSet5 = rsHasPosition.getProperties();
            rSet5.add(resHasPosition);
            rsHasPosition.setProperties(rSet5);
            PatternRestriction rsPersonHasPosition = (PatternRestriction)ResourceRestriction.createPatternRestriction("PersonHasPosition", "PersonHasPosition");
            rsPersonHasPosition.addSubjectRestriction(rsPersons);
            rsPersonHasPosition.addPredicateRestriction(rsHasPosition);
            RuleImpl ruPersonHasPosition = new RuleImpl("PersonHasPositionRead", "PersonHasPositionRead");
            ruPersonHasPosition.setRestriction(rsPersonHasPosition);
            ruPersonHasPosition.setReadRight(true);
            resSubClassOf = new URIImpl(SUB_CLASS_OF);
            PropertiesRestriction rsSubClassOf = (PropertiesRestriction)Restriction.createPropertiesRestriction("subClassOf", "subClassOf");
            Set props = rsSubClassOf.getProperties();
            props.add(resSubClassOf);
            rsSubClassOf.setProperties(props);
            PatternRestriction rsSkillSubClassOf = (PatternRestriction)Restriction.createPatternRestriction("SkillSubClassOf", "rsSkillSubClassOf");
            rsSkillSubClassOf.addSubjectRestriction(rsSkillsSchema);
            rsSkillSubClassOf.addPredicateRestriction(rsSubClassOf);
            RuleImpl ruSkillSubClassOf = new RuleImpl("SkillSubClassOfRead", "SkillSubClassOfRead");
            ruSkillSubClassOf.setRestriction(rsSkillSubClassOf);
            ruSkillSubClassOf.setReadRight(true);
            resHasSkill = new URIImpl(HAS_SKILL);
            PropertiesRestriction rsHasSkill = (PropertiesRestriction)Restriction.createPropertiesRestriction("HasSkill", "HasSkill");
            Set props2 = rsHasSkill.getProperties();
            props2.add(resHasSkill);
            rsHasSkill.setProperties(props2);
            PatternRestriction rsPersonHasTechSkill = (PatternRestriction)Restriction.createPatternRestriction("PersonHasTechSkill", "PersonHasTechSkill");
            rsPersonHasTechSkill.addSubjectRestriction(rsPersons);
            rsPersonHasTechSkill.addPredicateRestriction(rsHasSkill);
            rsPersonHasTechSkill.addObjectRestriction(rsTSkills);
            RuleImpl ruPersonHasTechSkill = new RuleImpl("PersonHasTechSkillRead", "PersonHasTechSkillRead");
            ruPersonHasTechSkill.setRestriction(rsPersonHasTechSkill);
            ruPersonHasTechSkill.setReadRight(true);
            Set rulz5 = uEmp.getRules();
            rulz5.add(ruPersonHasPosition);
            rulz5.add(ruSkillSubClassOf);
            rulz5.add(ruPersonHasTechSkill);
            uEmp.setRules(rulz5);
            QueryRestriction rsQuSchema = (QueryRestriction)Restriction.createQueryRestriction("QuSchema", "QuSchema");
            rsQuSchema.addQuery(HAS_POSITION_QUERY);
            RuleImpl ruQuReadSchema = new RuleImpl("QuReadSchema", "QuReadSchema");
            ruQuReadSchema.setRestriction(rsQuSchema);
            ruQuReadSchema.setReadRight(true);
            Set rulz6 = uQue.getRules();
            rulz6.add(ruQuReadSchema);
            uQue.setRules(rulz6);
            URIImpl resMitac = new URIImpl(MITAC);
            InstancesRestriction rsMitac = (InstancesRestriction)Restriction.createInstancesRestriction("Mitac", "Mitac");
            Set resz = rsMitac.getResources();
            resz.add(resMitac);
            rsMitac.setResources(resz);
            RuleImpl ruMitac = new RuleImpl("MitacRead", "MitacRead");
            ruMitac.setReadRight(true);
            ruMitac.setRestriction(rsMitac);
            Set rulz7 = uMitac.getRules();
            rulz7.add(ruMitac);
            uMitac.setRules(rulz7);
            ArrayList<URIImpl> rez = new ArrayList<URIImpl>();
            rez.add(resHasPosition);
            rez.add(resHasSkill);
            rez.add(resPerson);
            rez.add(resSkill);
            rez.add(resSubClassOf);
            rez.add(resTechSkill);
            rez.add(resMitac);
            this.storeMissingResources(rez);
            this.loadNameSpaceTable(con, st);
            this.loadResourcesTable(con, st);
        }
        catch (SQLException sqle) {
            throw new SailInternalException(sqle);
        }
        catch (Exception npe) {
            throw new SailInternalException(npe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void uploadSampleSetupDirectSQL() {
        Connection con = null;
        Statement st = null;
        try {
            try {
                int hRSkills1Rule2;
                int hRClassRestrId;
                int hRSkills1Rule;
                con = this.conPool.getConnection();
                st = con.createStatement();
                this.dropSecurityTables(con, st);
                this.createSecurityTables(con, st);
                HashMap<String, Integer> resIdsByUri = new HashMap<String, Integer>();
                ResultSet rset = st.executeQuery(" select r.id, concat(n.name, r.localname)  from namespaces n, resources r  where n.id = r.namespace ");
                while (rset.next()) {
                    Integer id = new Integer(rset.getInt(1));
                    String uri2 = rset.getString(2);
                    resIdsByUri.put(uri2, id);
                }
                int restrId = 0;
                int ruleId = 0;
                ++restrId;
                int schemaRestrId = restrId++;
                st.executeUpdate("INSERT INTO restrictions VALUES ( " + schemaRestrId + "," + 2 + "," + "'Schema'" + "," + "'Schema Restriction'" + " );");
                int reposRestrId = restrId;
                st.executeUpdate("INSERT INTO restrictions VALUES ( " + reposRestrId + "," + 1 + "," + "'Repository'" + "," + "'Repository Restriction'" + " );");
                ++ruleId;
                int readSchemaRuleId = ruleId++;
                st.executeUpdate("INSERT INTO security_rules VALUES ( " + readSchemaRuleId + "," + "'ReadSchema'" + "," + "'Allows reading of the Schema of the repository.'" + "," + schemaRestrId + ",1, 0,0,0,0);");
                int doEverythingRuleId = ruleId++;
                st.executeUpdate("INSERT INTO security_rules VALUES ( " + doEverythingRuleId + "," + "'DoEverything'" + "," + "'Allows all actions over the whole repository'" + "," + reposRestrId + ",1,1,1,1,1);");
                int readRepositoryRuleId = 0;
                readRepositoryRuleId = ruleId;
                st.executeUpdate("INSERT INTO security_rules VALUES ( " + readRepositoryRuleId + "," + "'ReadRepository'" + "," + "'Allows readind over the whole repository'" + "," + reposRestrId + ",1,0,0,0,0);");
                st.executeUpdate("INSERT INTO users_rules VALUES (1," + doEverythingRuleId + ");");
                st.executeUpdate("INSERT INTO users_rules VALUES (3," + readSchemaRuleId + ");");
                st.executeUpdate("INSERT INTO users_rules VALUES (4," + readRepositoryRuleId + ");");
                st.executeUpdate("INSERT INTO users_rules VALUES (5," + readRepositoryRuleId + ");");
                boolean skipSkillsRules = false;
                int skillId = 0;
                int skillRestrictionId = 0;
                int skillLevelId = 0;
                try {
                    skillId = (Integer)resIdsByUri.get(SKILL);
                    skillLevelId = (Integer)resIdsByUri.get(SKILL_LEVEL);
                }
                catch (NullPointerException npe) {
                    skipSkillsRules = true;
                }
                if (!skipSkillsRules) {
                    int hRCOSRestrId = 0;
                    hRSkills1Rule = 0;
                    ++restrId;
                    hRCOSRestrId = restrId++;
                    st.executeUpdate("INSERT INTO restrictions VALUES (" + hRCOSRestrId + "," + 8 + "," + "'SkillsHierarchy','Skills Hierarchy');");
                    skillRestrictionId = hRCOSRestrId;
                    ++ruleId;
                    hRSkills1Rule = ruleId++;
                    st.executeUpdate("INSERT INTO security_rules VALUES (" + hRSkills1Rule + "," + "'EditSkillsHierarchy','Allows Editing of the Skill Hierarchy'" + "," + hRCOSRestrId + ",1,1,1,0,0);");
                    st.execute("INSERT INTO res_propr_restrs VALUES (" + hRCOSRestrId + "," + skillId + ");");
                    hRClassRestrId = 0;
                    hRClassRestrId = restrId;
                    st.executeUpdate("INSERT INTO restrictions VALUES (" + hRClassRestrId + "," + 3 + "," + "'SkillsInstances','Skills Instances');");
                    st.execute("INSERT INTO res_propr_restrs VALUES (" + hRClassRestrId + "," + skillId + ");");
                    st.execute("INSERT INTO res_propr_restrs VALUES (" + hRClassRestrId + "," + skillLevelId + ");");
                    hRSkills1Rule2 = 0;
                    hRSkills1Rule2 = ruleId;
                    st.executeUpdate("INSERT INTO security_rules VALUES (" + hRSkills1Rule2 + "," + "'EditSkillsInstances','Allows Editing of the Skill Instances'" + "," + hRClassRestrId + ",1,1,1,0,0);");
                    st.executeUpdate("INSERT INTO users_rules VALUES (4," + hRSkills1Rule + ");");
                    st.executeUpdate("INSERT INTO users_rules VALUES (4," + hRSkills1Rule2 + ");");
                }
                skipSkillsRules = false;
                skillId = 0;
                try {
                    skillId = (Integer)resIdsByUri.get(TECH_SKILL);
                    skillLevelId = (Integer)resIdsByUri.get(SKILL_LEVEL);
                }
                catch (NullPointerException npe) {
                    skipSkillsRules = true;
                }
                if (!skipSkillsRules) {
                    int hrCOSRestrId = 0;
                    hRSkills1Rule = 0;
                    ++restrId;
                    hrCOSRestrId = restrId++;
                    st.executeUpdate("INSERT INTO restrictions VALUES (" + hrCOSRestrId + "," + 8 + "," + "'TechSkillsHierarchy','Technical Skills Hierarchy');");
                    ++ruleId;
                    hRSkills1Rule = ruleId++;
                    st.executeUpdate("INSERT INTO security_rules VALUES (" + hRSkills1Rule + "," + "'EditTechSkillsHierarchy','Allows Editing of the Tech Skill Hierarchy'" + "," + hrCOSRestrId + ",1,1,1,0,0);");
                    st.execute("INSERT INTO res_propr_restrs VALUES (" + hrCOSRestrId + "," + skillId + ");");
                    hRClassRestrId = 0;
                    hRClassRestrId = restrId;
                    st.executeUpdate("INSERT INTO restrictions VALUES (" + hRClassRestrId + "," + 3 + "," + "'TechSkillsInstances','Technical Skills Instances');");
                    st.execute("INSERT INTO res_propr_restrs VALUES (" + hRClassRestrId + "," + skillId + ");");
                    st.execute("INSERT INTO res_propr_restrs VALUES (" + hRClassRestrId + "," + skillLevelId + ");");
                    hRSkills1Rule2 = 0;
                    hRSkills1Rule2 = ruleId;
                    st.executeUpdate("INSERT INTO security_rules VALUES (" + hRSkills1Rule2 + "," + "'EditSkillsInstances','Allows Editing of the Skill Instances'" + "," + hRClassRestrId + ",1,1,1,0,0);");
                    st.executeUpdate("INSERT INTO users_rules VALUES (5," + hRSkills1Rule + ");");
                    st.executeUpdate("INSERT INTO users_rules VALUES (5," + hRSkills1Rule2 + ");");
                }
                int techSkillId = 0;
                skillId = 0;
                int personId = 0;
                int subClassOfId = 0;
                int hasPositionId = 0;
                int hasSkillId = 0;
                boolean skip = false;
                try {
                    skillId = (Integer)resIdsByUri.get(SKILL);
                    techSkillId = (Integer)resIdsByUri.get(TECH_SKILL);
                    personId = (Integer)resIdsByUri.get(PERSON);
                    subClassOfId = (Integer)resIdsByUri.get(SUB_CLASS_OF);
                    hasSkillId = (Integer)resIdsByUri.get(HAS_SKILL);
                    hasPositionId = (Integer)resIdsByUri.get(HAS_POSITION);
                }
                catch (NullPointerException npe) {
                    skip = true;
                }
                if (!skip) {
                    int personRstr = 0;
                    ++restrId;
                    personRstr = restrId++;
                    st.executeUpdate("INSERT INTO restrictions VALUES (" + personRstr + "," + 3 + "," + "'Persons','Persons Restriction');");
                    st.execute("INSERT INTO res_propr_restrs VALUES (" + personRstr + "," + personId + ");");
                    int hasPositionRestr = 0;
                    hasPositionRestr = restrId++;
                    st.executeUpdate("INSERT INTO restrictions VALUES (" + hasPositionRestr + "," + 5 + "," + "'hasPosition','hasPosition Restriction');");
                    st.execute("INSERT INTO res_propr_restrs VALUES (" + hasPositionRestr + "," + hasPositionId + ");");
                    int subClassRestr = 0;
                    subClassRestr = restrId++;
                    st.executeUpdate("INSERT INTO restrictions VALUES (" + subClassRestr + "," + 5 + "," + "'SubClassOf','SubClassOf Restriction');");
                    st.execute("INSERT INTO res_propr_restrs VALUES (" + subClassRestr + "," + subClassOfId + ");");
                    int hasSkillRestr = 0;
                    hasSkillRestr = restrId++;
                    st.executeUpdate("INSERT INTO restrictions VALUES (" + hasSkillRestr + "," + 5 + "," + "'hasSkill','hasSkill Restriction');");
                    st.execute("INSERT INTO res_propr_restrs VALUES (" + hasSkillRestr + "," + hasSkillId + ");");
                    int techSkillsRestr = 0;
                    techSkillsRestr = restrId++;
                    st.executeUpdate("INSERT INTO restrictions VALUES (" + techSkillsRestr + "," + 3 + "," + "'TechSkillInstances','TechSkillInstances');");
                    st.execute("INSERT INTO res_propr_restrs VALUES (" + techSkillsRestr + "," + techSkillId + ");");
                    int ptrnPersonPositionsId = 0;
                    ptrnPersonPositionsId = restrId++;
                    st.executeUpdate("INSERT INTO restrictions VALUES (" + ptrnPersonPositionsId + "," + 6 + "," + "'Person Positions','Person Positions Restriction');");
                    st.executeUpdate("INSERT INTO pattern_restrs VALUES (" + ptrnPersonPositionsId + "," + personRstr + "," + 0 + ");");
                    st.executeUpdate("INSERT INTO pattern_restrs VALUES (" + ptrnPersonPositionsId + "," + hasPositionRestr + "," + 1 + ");");
                    int personPositionsRule = 0;
                    ++ruleId;
                    personPositionsRule = ruleId++;
                    st.executeUpdate("INSERT INTO security_rules VALUES (" + personPositionsRule + "," + "'Read Person Positions Rule','Read Person Positions Rule'" + "," + ptrnPersonPositionsId + ",1,0,0,0,0);");
                    int ptrnSkillsHierarchyRstr = 0;
                    ptrnSkillsHierarchyRstr = restrId++;
                    st.executeUpdate("INSERT INTO restrictions VALUES (" + ptrnSkillsHierarchyRstr + "," + 6 + "," + "'Skills Hierarchy Pattern','Skills Hierarchy Pattern Restriction');");
                    st.executeUpdate("INSERT INTO pattern_restrs VALUES (" + ptrnSkillsHierarchyRstr + "," + skillRestrictionId + "," + 0 + ");");
                    st.executeUpdate("INSERT INTO pattern_restrs VALUES (" + ptrnSkillsHierarchyRstr + "," + subClassRestr + "," + 1 + ");");
                    int readSkillsHierarchyRule = 0;
                    readSkillsHierarchyRule = ruleId++;
                    st.executeUpdate("INSERT INTO security_rules VALUES (" + readSkillsHierarchyRule + "," + "'Read Skills Hierarchy Rule','Read Skills Hierarchy Rule'" + "," + ptrnSkillsHierarchyRstr + ",1,0,0,0,0);");
                    int ptrnTechSkillInstancesRstr = 0;
                    ptrnTechSkillInstancesRstr = restrId;
                    st.executeUpdate("INSERT INTO restrictions VALUES (" + ptrnTechSkillInstancesRstr + "," + 6 + "," + "'Technical Skill Instances Pattern','Technical Skill Instances Pattern Restriction');");
                    st.executeUpdate("INSERT INTO pattern_restrs VALUES (" + ptrnTechSkillInstancesRstr + "," + personRstr + "," + 0 + ");");
                    st.executeUpdate("INSERT INTO pattern_restrs VALUES (" + ptrnTechSkillInstancesRstr + "," + hasSkillRestr + "," + 1 + ");");
                    st.executeUpdate("INSERT INTO pattern_restrs VALUES (" + ptrnTechSkillInstancesRstr + "," + techSkillsRestr + "," + 2 + ");");
                    int readTechSkillsRule = 0;
                    readTechSkillsRule = ruleId;
                    st.executeUpdate("INSERT INTO security_rules VALUES (" + readTechSkillsRule + "," + "'Read Tech Skills Hierarchy Rule','Read Skills Hierarchy Rule'" + "," + ptrnTechSkillInstancesRstr + ",1,0,0,0,0);");
                    st.executeUpdate("INSERT INTO users_rules VALUES (6," + personPositionsRule + ");");
                    st.executeUpdate("INSERT INTO users_rules VALUES (6," + readSkillsHierarchyRule + ");");
                    st.executeUpdate("INSERT INTO users_rules VALUES (6," + readTechSkillsRule + ");");
                }
                ThreadLog.trace((String)"Sample Security Setup UPLOADED.");
            }
            catch (SQLException sqle) {
                throw new SailInternalException(sqle);
            }
            catch (Exception npe) {
                throw new SailInternalException(npe);
            }
            Object var34_43 = null;
        }
        catch (Throwable throwable) {
            Object var34_44 = null;
            try {
                st.close();
                con.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new SailInternalException(e);
            }
        }
        try {}
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
        st.close();
        con.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeSecuritySetup() {
        Connection con = null;
        Statement st = null;
        try {
            try {
                ThreadLog.trace((String)"Store Security Setup ...");
                con = this.conPool.getConnection();
                st = con.createStatement();
                ResultSet rset = st.executeQuery(" select r.id, concat(n.name, r.localname)  from namespaces n, resources r  where n.id = r.namespace ");
                while (rset.next()) {
                    Integer id = new Integer(rset.getInt(1));
                    String uri2 = rset.getString(2);
                    resIdsByUri.put(uri2, id);
                }
                this.dropSecurityTables(con, st);
                this.createSecurityTables(con, st);
                ArrayList userz = new ArrayList(this.users);
                HashSet queSet = new HashSet();
                ArrayList queList = new ArrayList();
                ArrayList rolez = new ArrayList(this.roles);
                HashSet rulez = new HashSet(RoleImpl.getRules(this.roles, false));
                for (int ui = 0; ui < userz.size(); ++ui) {
                    User usr = (User)userz.get(ui);
                    queSet.addAll(usr.toSql());
                    rulez.addAll(usr.getRules());
                }
                ArrayList rolz = new ArrayList(rolez);
                for (int roi = 0; roi < rolz.size(); ++roi) {
                    Role role = (Role)rolz.get(roi);
                    rulez.addAll(role.getRules(true));
                    queSet.addAll(role.toSql());
                }
                ArrayList rulz = new ArrayList(rulez);
                for (int rui = 0; rui < rulz.size(); ++rui) {
                    Rule rule = (Rule)rulz.get(rui);
                    queSet.addAll(rule.toSql());
                }
                ArrayList restrz = new ArrayList(Restriction.getRestrictions());
                for (int ri = 0; ri < restrz.size(); ++ri) {
                    Restriction r = (Restriction)restrz.get(ri);
                    queSet.addAll(r.toSql(this.idByLiteral, this.idByRes));
                }
                queList = new ArrayList(queSet);
                for (int qi = 0; qi < queList.size(); ++qi) {
                    int result2;
                    String q = queList.get(qi).toString();
                    try {
                        int result22 = st.executeUpdate(q);
                    }
                    catch (Exception x) {
                        result2 = st.executeUpdate(q);
                    }
                    if (result2 > 0) continue;
                    throw new SecurityException("The following query did not change the repository :\n" + q);
                }
                ThreadLog.trace((String)"Security Setup STORED.");
            }
            catch (SQLException sqle) {
                throw new SailInternalException(sqle);
            }
            catch (SecurityException se) {
                throw new SailInternalException(se);
            }
            catch (Exception npe) {
                throw new SailInternalException(npe);
            }
            Object var17_25 = null;
        }
        catch (Throwable throwable) {
            Object var17_26 = null;
            try {
                st.close();
                con.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new SailInternalException(e);
            }
        }
        try {}
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
        st.close();
        con.close();
    }

    private void storeMissingResources(ArrayList resourcez) {
        try {
            this.baseRdfRepository.startTransaction();
            URIImpl resType = new URIImpl(RDF_TYPE);
            URIImpl resResource = new URIImpl(RESOURCE);
            for (int i = 0; i < resourcez.size(); ++i) {
                Resource res = (Resource)resourcez.get(i);
                if (this.idByRes.get(res) != null) continue;
                this.baseRdfRepository.addStatement(res, resType, resResource);
            }
            this.baseRdfRepository.commitTransaction();
        }
        catch (SailUpdateException e) {
            throw new SailInternalException(e);
        }
    }

    boolean isQuAccessible(QueryRestriction rst, Resource res) {
        boolean is = false;
        ArrayList qus = new ArrayList(rst.getQueries());
        for (int i = 0; i < qus.size(); ++i) {
            String query2 = qus.get(i).toString();
            this.queryResult = (ArrayList)this.queryResults.get(query2);
            if (this.queryResult == null) {
                try {
                    RqlEngine queryEngine = new RqlEngine(this.baseRdfSchemaSource);
                    Query queryModel = null;
                    queryModel = queryEngine.parseQuery(query2);
                    queryEngine.evaluateQuery(queryModel, this);
                }
                catch (MalformedQueryException me) {
                    throw new SailInternalException(me);
                }
                catch (QueryEvaluationException qee) {
                    throw new SailInternalException(qee);
                }
                catch (IOException ioe) {
                    throw new SailInternalException(ioe);
                }
                while (!this.isQueryReady) {
                    boolean k = false;
                }
                this.queryResults.put(query2, this.queryResult);
            }
            for (int ri = 0; ri < this.queryResult.size(); ++ri) {
                Value v = (Value)this.queryResult.get(ri);
                if (!(v instanceof URI)) continue;
                URI rr = (URI)v;
                if (!((URI)res).getLocalName().equals(rr.getLocalName()) || !((URI)res).getNamespace().equals(rr.getNamespace())) continue;
                is = true;
                break;
            }
            if (is) break;
        }
        return is;
    }

    public void addListener(SailChangedListener listener) {
        this.baseRdfRepository.addListener(listener);
    }

    public void removeListener(SailChangedListener listener) {
        this.baseRdfRepository.removeListener(listener);
    }
}

