/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.omm.security;

import java.util.ArrayList;
import org.openrdf.sesame.sailimpl.omm.security.NullParameterException;
import org.openrdf.sesame.sailimpl.omm.security.Restriction;
import org.openrdf.sesame.sailimpl.omm.security.Right;
import org.openrdf.sesame.sailimpl.omm.security.Rule;

public class RuleImpl
implements Rule {
    private int id;
    private String name = null;
    private String description = null;
    private boolean read = false;
    private boolean add = false;
    private boolean remove = false;
    private boolean admin = false;
    private boolean history = false;
    private String uri = null;
    private Restriction restriction = null;
    private static int lastId = 0;

    public RuleImpl(int id, String name2, String description) throws NullParameterException {
        if (null == name2 || null == description) {
            throw new NullParameterException("Rule [name] and [description] should not be [null].");
        }
        this.id = id;
        if (id > lastId) {
            lastId = id;
        }
        this.name = name2;
        this.description = description;
    }

    public RuleImpl(String name2, String description) throws NullParameterException {
        if (null == name2 || null == description) {
            throw new NullParameterException("Rule [name] and [description] should not be [null].");
        }
        this.id = ++lastId;
        this.name = name2;
        this.description = description;
    }

    public void setRestriction(Restriction restriction) throws NullParameterException {
        if (null == restriction) {
            throw new NullParameterException("The rule's [restriction] should not be [null]");
        }
        this.restriction = restriction;
    }

    public Restriction getRestriction() {
        return this.restriction;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name2) throws NullParameterException {
        if (null == name2) {
            throw new NullParameterException("Rule [name] should not be [null].");
        }
        this.name = name2;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String descr) throws NullParameterException {
        if (null == descr) {
            throw new NullParameterException("Rule [description] should not be [null].");
        }
        this.description = descr;
    }

    public void setReadRight(boolean granted) {
        this.read = granted;
    }

    public void setAddRight(boolean granted) {
        this.add = granted;
    }

    public void setRemoveRight(boolean granted) {
        this.remove = granted;
    }

    public void setHistoryRight(boolean granted) {
        this.history = granted;
    }

    public void setAdminRight(boolean granted) {
        this.admin = granted;
    }

    public boolean getReadRight() {
        return this.read;
    }

    public boolean getAddRight() {
        return this.add;
    }

    public boolean getRemoveRight() {
        return this.remove;
    }

    public boolean getHistoryRight() {
        return this.history;
    }

    public boolean getAdminRight() {
        return this.admin;
    }

    public ArrayList toSql() {
        ArrayList<String> list = new ArrayList<String>(3);
        StringBuffer query2 = new StringBuffer();
        query2.append("INSERT INTO ");
        query2.append("security_rules");
        query2.append(" VALUES ");
        query2.append("(").append(this.id);
        query2.append(",'");
        query2.append(this.name);
        query2.append("','");
        query2.append(this.description);
        query2.append("',");
        query2.append(this.restriction.getId());
        query2.append(",");
        query2.append(this.read ? 1 : 0);
        query2.append(",");
        query2.append(this.add ? 1 : 0);
        query2.append(",");
        query2.append(this.remove ? 1 : 0);
        query2.append(",");
        query2.append(this.admin ? 1 : 0);
        query2.append(",");
        query2.append(this.history ? 1 : 0).append(");");
        list.add(query2.toString());
        return list;
    }

    public void grantRight(Right right) {
        if (right.equals((Object)Right.ADD)) {
            this.setAddRight(true);
        } else if (right.equals((Object)Right.ADMIN)) {
            this.setAdminRight(true);
        } else if (right.equals((Object)Right.HISTORY)) {
            this.setHistoryRight(true);
        } else if (right.equals((Object)Right.READ)) {
            this.setReadRight(true);
        } else if (right.equals((Object)Right.REMOVE)) {
            this.setRemoveRight(true);
        }
    }

    public void setUri(String uri2) {
        this.uri = uri2;
    }

    public String getUri() {
        return this.uri;
    }
}

