/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.omm.security;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.sesame.sailimpl.omm.security.NullParameterException;
import org.openrdf.sesame.sailimpl.omm.security.Role;
import org.openrdf.sesame.sailimpl.omm.security.Rule;

public class RoleImpl
implements Role {
    private int id;
    private String name = null;
    private String description = null;
    private Set rules = new HashSet();
    private Set parentRoles = new HashSet();
    private String uri = null;
    static int lastId = 0;

    public RoleImpl(int id, String name2, String description) throws NullParameterException {
        if (null == name2 || null == description) {
            throw new NullParameterException("Role [name] and [description] should not be [null].");
        }
        this.id = id;
        if (id > lastId) {
            lastId = id;
        }
        this.name = name2;
        this.description = description;
    }

    public RoleImpl() {
        this.id = ++lastId;
    }

    public void setDescription(String descr) {
        this.description = descr;
    }

    public String getDescription() {
        return this.description;
    }

    public void addRule(Rule rule) throws NullParameterException {
        if (null == rule) {
            throw new NullParameterException("Added [rule] should not be [null].");
        }
        this.rules.add(rule);
    }

    public void removeRule(Rule rule) throws NullParameterException {
        if (null == rule) {
            throw new NullParameterException("Removed [rule] should not be [null].");
        }
        this.rules.remove(rule);
    }

    public Set getRules(boolean direct) {
        HashSet result2;
        if (direct) {
            result2 = this.rules;
        } else {
            result2 = new HashSet();
            result2.addAll(this.rules);
            ArrayList parents = new ArrayList(this.parentRoles);
            for (int i = 0; i < parents.size(); ++i) {
                Role pr = (Role)parents.get(i);
                result2.addAll(pr.getRules(direct));
            }
        }
        return result2;
    }

    public Set getParentRoles() {
        return this.parentRoles;
    }

    public void setParentRoles(Set parents) throws NullParameterException {
        if (null == parents) {
            throw new NullParameterException("Set of parent roles [parents] should not be [null].");
        }
        this.parentRoles = parents;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String roleName) throws NullParameterException {
        if (null == roleName) {
            throw new NullParameterException("Role [name] should not be [null].");
        }
    }

    public ArrayList toSql() {
        ArrayList<String> list = new ArrayList<String>(3);
        StringBuffer query2 = new StringBuffer();
        query2.append("INSERT INTO ");
        query2.append("roles");
        query2.append(" VALUES ");
        query2.append("(").append(this.id);
        query2.append(",'");
        query2.append(this.name);
        query2.append("','");
        query2.append(this.description).append("');");
        list.add(query2.toString());
        ArrayList rulz = new ArrayList(this.rules);
        for (int ri = 0; ri < rulz.size(); ++ri) {
            query2 = new StringBuffer();
            Rule rule = (Rule)rulz.get(ri);
            query2.append("INSERT INTO ");
            query2.append("roles_rules");
            query2.append(" VALUES ");
            query2.append("(").append(this.id);
            query2.append(",");
            query2.append(rule.getId());
            query2.append(");");
            list.add(query2.toString());
        }
        ArrayList parentz = new ArrayList(this.parentRoles);
        for (int pi = 0; pi < parentz.size(); ++pi) {
            query2 = new StringBuffer();
            Role role = (Role)parentz.get(pi);
            query2.append("INSERT INTO ");
            query2.append("roles_hierarchy");
            query2.append(" VALUES ");
            query2.append("(").append(this.id);
            query2.append(",");
            query2.append(role.getId());
            query2.append(");");
            list.add(query2.toString());
        }
        return list;
    }

    public static Set getRules(Set roles, boolean direct) {
        ArrayList list = new ArrayList(roles);
        HashSet result2 = new HashSet();
        for (int i = 0; i < list.size(); ++i) {
            Role role = (Role)list.get(i);
            result2.addAll(role.getRules(direct));
        }
        return result2;
    }

    public void setUri(String uri2) {
        this.uri = uri2;
    }

    public String getUri() {
        return this.uri;
    }
}

