/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.omm.security;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.sesame.sailimpl.omm.security.NullParameterException;
import org.openrdf.sesame.sailimpl.omm.security.PropertiesRestriction;
import org.openrdf.sesame.sailimpl.omm.security.ResourceRestriction;
import org.openrdf.sesame.sailimpl.omm.security.Restriction;
import org.openrdf.sesame.sailimpl.omm.security.SecurityException;

public class PatternRestriction
extends Restriction {
    public static final int SPO_SUBJECT = 0;
    public static final int SPO_PREDICATE = 1;
    public static final int SPO_OBJECT = 2;
    public static final int SPO_OBJECT_LITERAL = 3;
    Set subjectRestrictions = new HashSet();
    Set predicateRestrictions = new HashSet();
    Set objectRestrictions = new HashSet();

    public PatternRestriction(int id, String name2, String description) {
        super(id, 6, name2, description);
    }

    public void addSubjectRestriction(ResourceRestriction subjRestr) {
        if (subjRestr.type == 3 || subjRestr.type == 4 || subjRestr.type == 8) {
            this.subjectRestrictions.add(subjRestr);
        }
    }

    public void addPredicateRestriction(PropertiesRestriction propRestr) {
        this.predicateRestrictions.add(propRestr);
    }

    public void addObjectRestriction(ResourceRestriction objRestr) {
        if (objRestr.type == 3 || objRestr.type == 4 || objRestr.type == 8) {
            this.objectRestrictions.add(objRestr);
        }
    }

    public void addObjectRestriction(Literal literal) throws NullParameterException {
        this.objectRestrictions.add(literal);
    }

    public Set getSubjectRestrictions() {
        return this.subjectRestrictions;
    }

    public Set getPredicateRestrictions() {
        return this.predicateRestrictions;
    }

    public Set getObjectRestrictions() {
        return this.objectRestrictions;
    }

    public ArrayList toSql(Map idByLiteral, Map idByRes) throws NullParameterException, SecurityException {
        if (idByRes == null) {
            throw new NullParameterException("[ids by resources] map should not be [null].");
        }
        if (idByLiteral == null) {
            throw new NullParameterException("[ids by resources] map should not be [null].");
        }
        ArrayList list = super.toSql(idByLiteral, idByRes);
        StringBuffer query2 = null;
        ArrayList subjectz = new ArrayList(this.subjectRestrictions);
        for (int si = 0; si < subjectz.size(); ++si) {
            ResourceRestriction r = (ResourceRestriction)subjectz.get(si);
            query2 = new StringBuffer();
            query2.append("INSERT INTO ");
            query2.append("pattern_restrs");
            query2.append(" VALUES ");
            query2.append("(");
            query2.append(this.id);
            query2.append(",");
            query2.append(r.getId());
            query2.append(",");
            query2.append(0);
            query2.append(");");
            list.add(query2.toString());
        }
        ArrayList predz = new ArrayList(this.predicateRestrictions);
        for (int pi = 0; pi < predz.size(); ++pi) {
            PropertiesRestriction r = (PropertiesRestriction)predz.get(pi);
            query2 = new StringBuffer();
            query2.append("INSERT INTO ");
            query2.append("pattern_restrs");
            query2.append(" VALUES ");
            query2.append("(");
            query2.append(this.id);
            query2.append(",");
            query2.append(r.getId());
            query2.append(",");
            query2.append(1);
            query2.append(");");
            list.add(query2.toString());
        }
        ArrayList objectz = new ArrayList(this.objectRestrictions);
        for (int oi = 0; oi < objectz.size(); ++oi) {
            ResourceRestriction r = (ResourceRestriction)objectz.get(oi);
            query2 = new StringBuffer();
            query2.append("INSERT INTO ");
            query2.append("pattern_restrs");
            query2.append(" VALUES ");
            query2.append("(");
            query2.append(this.id);
            query2.append(",");
            query2.append(r.getId());
            query2.append(",");
            query2.append(2);
            query2.append(");");
            list.add(query2.toString());
        }
        return list;
    }
}

