/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.nativerdf.datastore;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.openrdf.sesame.sailimpl.nativerdf.datastore.TransferUtil;

public class HashFile {
    private static final int ITEM_SIZE = 12;
    private static final long HEADER_LENGTH = 12L;
    private static final int INIT_BUCKET_COUNT = 64;
    private static final int INIT_BUCKET_SIZE = 8;
    private File _file;
    private HashFile0 _hashFile;
    private File _txnFile;
    private HashFile0 _txnHashFile;
    private boolean _isolatedTransaction;

    public HashFile(File file) throws IOException {
        this._file = file;
        this._file.createNewFile();
        this._hashFile = new HashFile0(this._file);
    }

    public void startTransaction(boolean isolateTransaction) throws IOException {
        this._isolatedTransaction = isolateTransaction;
        if (isolateTransaction) {
            this._txnFile = new File(this._file.getParentFile(), "txn_" + this._file.getName());
            RandomAccessFile txnRaf = this._createEmptyFile(this._txnFile);
            FileChannel txnChannel = txnRaf.getChannel();
            this._hashFile.sync();
            FileChannel channel = this._hashFile.getFileChannel();
            TransferUtil.transferTo(channel, 0L, channel.size(), txnChannel);
            this._txnHashFile = new HashFile0(this._txnFile, txnRaf);
        } else {
            this._txnHashFile = this._hashFile;
        }
    }

    public void commitTransaction() throws IOException {
        if (this._isolatedTransaction) {
            this._hashFile.close();
            this._hashFile = null;
            this._txnHashFile.sync();
            this._txnHashFile.close();
            this._txnHashFile = null;
            this._file.delete();
            boolean success = this._txnFile.renameTo(this._file);
            if (!success) {
                throw new IOException("Unable to rename file '" + this._txnFile + "' to '" + this._file + "'");
            }
            this._hashFile = new HashFile0(this._file);
            this._txnFile = null;
        } else {
            this._txnHashFile = null;
            this._hashFile.sync();
        }
    }

    public void rollbackTransaction() throws IOException {
        if (!this._isolatedTransaction) {
            throw new IOException("Unisolated transactions cannot be rolled back");
        }
        this._txnHashFile.close();
        this._txnHashFile = null;
        this._txnFile.delete();
        this._txnFile = null;
    }

    public void storeOffset(int hash, long dataOffset) throws IOException {
        this._txnHashFile.storeOffset(hash, dataOffset);
    }

    public void clear() throws IOException {
        this._txnHashFile.clear();
    }

    public OffsetIterator getOffsetIterator(int hash, boolean dirtyReads) throws IOException {
        HashFile0 hashFile = dirtyReads ? this._txnHashFile : this._hashFile;
        return new OffsetIterator(hashFile, hash);
    }

    public void close() throws IOException {
        if (this._txnHashFile != null && this._isolatedTransaction) {
            this.rollbackTransaction();
        }
        this._hashFile.close();
    }

    private RandomAccessFile _createEmptyFile(File file) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        raf.setLength(0L);
        return raf;
    }

    public static void main(String[] args) throws Exception {
        HashFile hashFile = new HashFile(new File(args[0]));
        hashFile._hashFile.dumpContents(System.out);
        hashFile.close();
    }

    public static class OffsetIterator {
        private HashFile0 _hashFile;
        private int _queryHash;
        private ByteBuffer _bucketBuffer;
        private long _bucketOffset;
        private int _slotNo;

        private OffsetIterator(HashFile0 hashFile, int hash) throws IOException {
            this._hashFile = hashFile;
            this._queryHash = hash;
            this._bucketBuffer = ByteBuffer.allocate(this._hashFile.getRecordSize());
            this._bucketOffset = this._hashFile._getBucketOffset(hash);
            this._hashFile.getFileChannel().read(this._bucketBuffer, this._bucketOffset);
            this._slotNo = -1;
        }

        public long next() throws IOException {
            while (this._bucketBuffer != null) {
                ++this._slotNo;
                while (this._slotNo < this._hashFile.getBucketSize()) {
                    if (this._bucketBuffer.getInt(12 * this._slotNo) == this._queryHash) {
                        return this._bucketBuffer.getLong(12 * this._slotNo + 4);
                    }
                    ++this._slotNo;
                }
                int overflowID = this._bucketBuffer.getInt(12 * this._hashFile.getBucketSize());
                if (overflowID == 0) {
                    this._bucketBuffer = null;
                    this._bucketOffset = 0L;
                    continue;
                }
                this._bucketOffset = this._hashFile._getOverflowBucketOffset(overflowID);
                this._bucketBuffer.clear();
                this._hashFile.getFileChannel().read(this._bucketBuffer, this._bucketOffset);
                this._slotNo = -1;
            }
            return -1L;
        }
    }

    class HashFile0 {
        private File _file;
        private RandomAccessFile _raf;
        private FileChannel _fileChannel;
        private int _bucketCount;
        private int _bucketSize;
        private int _itemCount;
        private float _loadFactor = 0.75f;
        private int _recordSize;
        private ByteBuffer _txnBucket;

        public HashFile0(File file) throws IOException {
            this(file, new RandomAccessFile(file, "rw"));
        }

        public HashFile0(File file, RandomAccessFile raf) throws IOException {
            this._file = file;
            this._raf = raf;
            this._fileChannel = raf.getChannel();
            if (this._fileChannel.size() == 0L) {
                this._bucketCount = 64;
                this._bucketSize = 8;
                this._itemCount = 0;
                this._recordSize = 12 * this._bucketSize + 4;
                this._writeFileHeader();
                this._writeEmptyBuckets(12L, this._bucketCount);
            } else {
                this._readFileHeader();
                this._recordSize = 12 * this._bucketSize + 4;
            }
            this._txnBucket = ByteBuffer.allocate(this._recordSize);
        }

        public FileChannel getFileChannel() {
            return this._fileChannel;
        }

        public int getBucketCount() {
            return this._bucketCount;
        }

        public int getBucketSize() {
            return this._bucketSize;
        }

        public int getItemCount() {
            return this._itemCount;
        }

        public int getRecordSize() {
            return this._recordSize;
        }

        public void storeOffset(int hash, long dataOffset) throws IOException {
            long bucketOffset = this._getBucketOffset(hash);
            this._storeOffset(bucketOffset, hash, dataOffset);
            ++this._itemCount;
            if ((float)this._itemCount >= this._loadFactor * (float)this._bucketCount * (float)this._bucketSize) {
                this._increaseHashTable();
            }
        }

        private void _storeOffset(long bucketOffset, int hash, long dataOffset) throws IOException {
            boolean offsetStored = false;
            while (!offsetStored) {
                this._txnBucket.clear();
                this._fileChannel.read(this._txnBucket, bucketOffset);
                int slotID = this._findEmptySlotInBucket(this._txnBucket);
                if (slotID >= 0) {
                    this._txnBucket.putInt(12 * slotID, hash);
                    this._txnBucket.putLong(12 * slotID + 4, dataOffset);
                    this._txnBucket.rewind();
                    this._fileChannel.write(this._txnBucket, bucketOffset);
                    offsetStored = true;
                    continue;
                }
                int overflowID = this._txnBucket.getInt(12 * this._bucketSize);
                if (overflowID == 0) {
                    overflowID = this._createOverflowBucket();
                    this._txnBucket.putInt(12 * this._bucketSize, overflowID);
                    this._txnBucket.rewind();
                    this._fileChannel.write(this._txnBucket, bucketOffset);
                }
                bucketOffset = this._getOverflowBucketOffset(overflowID);
            }
        }

        public void clear() throws IOException {
            this._fileChannel.truncate(12L + (long)this._bucketCount * (long)this._recordSize);
            this._writeEmptyBuckets(12L, this._bucketCount);
            this._itemCount = 0;
        }

        public void sync() throws IOException {
            this._writeFileHeader();
            this._fileChannel.force(false);
        }

        public void close() throws IOException {
            this._raf.close();
            this._raf = null;
            this._fileChannel = null;
        }

        private void _writeFileHeader() throws IOException {
            ByteBuffer buf = ByteBuffer.allocate(12);
            buf.putInt(0, this._bucketCount);
            buf.putInt(4, this._bucketSize);
            buf.putInt(8, this._itemCount);
            this._fileChannel.write(buf, 0L);
        }

        private void _readFileHeader() throws IOException {
            ByteBuffer buf = ByteBuffer.allocate(12);
            this._fileChannel.read(buf, 0L);
            this._bucketCount = buf.getInt(0);
            this._bucketSize = buf.getInt(4);
            this._itemCount = buf.getInt(8);
        }

        private long _getBucketOffset(int hash) {
            int bucketNo = hash % this._bucketCount;
            if (bucketNo < 0) {
                bucketNo += this._bucketCount;
            }
            return 12L + (long)bucketNo * (long)this._recordSize;
        }

        private long _getOverflowBucketOffset(int bucketID) {
            return 12L + ((long)this._bucketCount + (long)bucketID - 1L) * (long)this._recordSize;
        }

        private int _createOverflowBucket() throws IOException {
            long offset = this._fileChannel.size();
            this._writeEmptyBuckets(offset, 1);
            return (int)((offset - 12L) / (long)this._recordSize) - this._bucketCount + 1;
        }

        private void _writeEmptyBuckets(long fileOffset, int bucketCount) throws IOException {
            ByteBuffer emptyBucket = ByteBuffer.allocate(this._recordSize);
            for (int i = 0; i < bucketCount; ++i) {
                this._fileChannel.write(emptyBucket, fileOffset + (long)i * (long)this._recordSize);
                emptyBucket.rewind();
            }
        }

        private int _findEmptySlotInBucket(ByteBuffer bucket) {
            for (int slotNo = 0; slotNo < this._bucketSize; ++slotNo) {
                if (bucket.getLong(12 * slotNo + 4) != 0L) continue;
                return slotNo;
            }
            return -1;
        }

        private void _increaseHashTable() throws IOException {
            long oldTableSize = 12L + (long)this._bucketCount * (long)this._recordSize;
            long newTableSize = 12L + (long)this._bucketCount * (long)this._recordSize * 2L;
            long oldFileSize = this._fileChannel.size();
            File tmpFile = new File(this._file.getParentFile(), "rehash_" + this._file.getName());
            RandomAccessFile tmpRaf = HashFile.this._createEmptyFile(tmpFile);
            FileChannel tmpChannel = tmpRaf.getChannel();
            TransferUtil.transferTo(this._fileChannel, oldTableSize, oldFileSize, tmpChannel);
            this._writeEmptyBuckets(oldTableSize, this._bucketCount);
            this._bucketCount *= 2;
            this._fileChannel.truncate(newTableSize);
            ByteBuffer bucket = ByteBuffer.allocate(this._recordSize);
            ByteBuffer newBucket = ByteBuffer.allocate(this._recordSize);
            for (long bucketOffset = 12L; bucketOffset < oldTableSize; bucketOffset += (long)this._recordSize) {
                this._fileChannel.read(bucket, bucketOffset);
                boolean bucketChanged = false;
                long newBucketOffset = 0L;
                for (int slotNo = 0; slotNo < this._bucketSize; ++slotNo) {
                    int hash;
                    long newOffset;
                    long dataOffset = bucket.getLong(12 * slotNo + 4);
                    if (dataOffset == 0L || (newOffset = this._getBucketOffset(hash = bucket.getInt(12 * slotNo))) == bucketOffset) continue;
                    newBucket.putInt(hash);
                    newBucket.putLong(dataOffset);
                    bucket.putInt(12 * slotNo, 0);
                    bucket.putLong(12 * slotNo + 4, 0L);
                    bucketChanged = true;
                    newBucketOffset = newOffset;
                }
                if (bucketChanged) {
                    newBucket.flip();
                    this._fileChannel.write(newBucket, newBucketOffset);
                    newBucket.clear();
                }
                if (bucket.getInt(12 * this._bucketSize) != 0) {
                    bucket.putInt(12 * this._bucketSize, 0);
                    bucketChanged = true;
                }
                if (bucketChanged) {
                    bucket.rewind();
                    this._fileChannel.write(bucket, bucketOffset);
                }
                bucket.clear();
            }
            long tmpFileSize = tmpChannel.size();
            for (long bucketOffset = 0L; bucketOffset < tmpFileSize; bucketOffset += (long)this._recordSize) {
                tmpChannel.read(bucket, bucketOffset);
                for (int slotNo = 0; slotNo < this._bucketSize; ++slotNo) {
                    long dataOffset = bucket.getLong(12 * slotNo + 4);
                    if (dataOffset == 0L) continue;
                    int hash = bucket.getInt(12 * slotNo);
                    long newBucketOffset = this._getBucketOffset(hash);
                    this._storeOffset(newBucketOffset, hash, dataOffset);
                    bucket.putInt(12 * slotNo, 0);
                    bucket.putLong(12 * slotNo + 4, 0L);
                }
                bucket.clear();
            }
            tmpRaf.close();
            tmpFile.delete();
        }

        public void dumpContents(PrintStream out) throws IOException {
            int overflowID;
            long offset;
            int hash;
            int slotNo;
            int bucketNo;
            out.println();
            out.println("*** hash file contents ***");
            out.println("_bucketCount=" + this._bucketCount);
            out.println("_bucketSize=" + this._bucketSize);
            out.println("_itemCount=" + this._itemCount);
            ByteBuffer buf = ByteBuffer.allocate(this._recordSize);
            this._fileChannel.position(12L);
            out.println("---Buckets---");
            for (bucketNo = 1; bucketNo <= this._bucketCount; ++bucketNo) {
                buf.clear();
                this._fileChannel.read(buf);
                out.print("Bucket " + bucketNo + ": ");
                for (slotNo = 0; slotNo < this._bucketSize; ++slotNo) {
                    hash = buf.getInt(12 * slotNo);
                    offset = buf.getLong(12 * slotNo + 4);
                    if (slotNo > 0) {
                        out.print(" ");
                    }
                    out.print("[" + this.toHexString(hash) + "," + offset + "]");
                }
                overflowID = buf.getInt(12 * this._bucketSize);
                out.println("---> " + overflowID);
            }
            out.println("---Overflow Buckets---");
            bucketNo = 0;
            while (this._fileChannel.position() < this._fileChannel.size()) {
                buf.clear();
                this._fileChannel.read(buf);
                out.print("Bucket " + ++bucketNo + ": ");
                for (slotNo = 0; slotNo < this._bucketSize; ++slotNo) {
                    hash = buf.getInt(12 * slotNo);
                    offset = buf.getLong(12 * slotNo + 4);
                    if (slotNo > 0) {
                        out.print(" ");
                    }
                    out.print("[" + this.toHexString(hash) + "," + offset + "]");
                }
                overflowID = buf.getInt(12 * this._bucketSize);
                out.println("---> " + overflowID);
            }
            out.println("*** end of hash file contents ***");
            out.println();
        }

        private String toHexString(int decimal) {
            String hex = Integer.toHexString(decimal);
            StringBuffer result2 = new StringBuffer(8);
            for (int i = hex.length(); i < 8; ++i) {
                result2.append("0");
            }
            result2.append(hex);
            return result2.toString();
        }
    }
}

