/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.memory;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.rio.ParseException;
import org.openrdf.rio.StatementHandlerException;
import org.openrdf.rio.ntriples.NTriplesParser;
import org.openrdf.rio.rdfxml.RdfXmlParser;
import org.openrdf.rio.turtle.TurtleParser;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.sail.NamespaceIterator;
import org.openrdf.sesame.sail.SailInitializationException;
import org.openrdf.sesame.sail.SailInternalException;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sail.query.Query;
import org.openrdf.sesame.sail.query.QueryOptimizer;
import org.openrdf.sesame.sail.util.EmptyStatementIterator;
import org.openrdf.sesame.sailimpl.memory.BNodeNode;
import org.openrdf.sesame.sailimpl.memory.LiteralNode;
import org.openrdf.sesame.sailimpl.memory.MemNamespaceIterator;
import org.openrdf.sesame.sailimpl.memory.MemStatement;
import org.openrdf.sesame.sailimpl.memory.MemStatementIterator;
import org.openrdf.sesame.sailimpl.memory.Namespace;
import org.openrdf.sesame.sailimpl.memory.ResourceNode;
import org.openrdf.sesame.sailimpl.memory.StatementList;
import org.openrdf.sesame.sailimpl.memory.URINode;
import org.openrdf.sesame.sailimpl.memory.ValueNode;

public class RdfSource
implements org.openrdf.sesame.sail.RdfSource,
ValueFactory {
    public static final String FILE_KEY = "file";
    public static final String DATA_FORMAT_KEY = "dataFormat";
    public static final String COMPRESS_FILE_KEY = "compressFile";
    protected StatementList _statements = new StatementList(256);
    protected Map _uriNodesMap;
    protected Map _bNodeNodesMap;
    protected Map _literalNodesMap;
    protected Map _namespacesTable = new HashMap();
    protected List _namespacesList = new ArrayList();
    protected boolean _exportStatusUpToDate;
    protected int _nextNsPrefixId = 1;
    protected File _file;
    protected RDFFormat _dataFormat;
    protected boolean _compressFile;
    private String _bnodePrefix;
    private int _nextBNodeID;

    public RdfSource() {
        this._uriNodesMap = new HashMap();
        this._bNodeNodesMap = new HashMap();
        this._literalNodesMap = new HashMap();
        this._addDefaultNamespaces();
        this._updateBNodePrefix();
    }

    void _addDefaultNamespaces() {
        this._registerNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#", true);
        this._registerNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#", true);
    }

    protected void _updateBNodePrefix() {
        this._bnodePrefix = "node" + Long.toString(System.currentTimeMillis(), 32) + "x";
        this._nextBNodeID = 1;
    }

    public void initialize(Map configParams) throws SailInitializationException {
        String fileStr = (String)configParams.get(FILE_KEY);
        File file = null;
        if (fileStr != null) {
            file = new File(fileStr);
        }
        String dataFormatStr = (String)configParams.get(DATA_FORMAT_KEY);
        RDFFormat dataFormat = RDFFormat.RDFXML;
        if (dataFormatStr != null && (dataFormat = RDFFormat.forValue(dataFormatStr)) == null) {
            throw new SailInitializationException("Illegal dataFormat value: " + dataFormatStr);
        }
        String compressFileStr = (String)configParams.get(COMPRESS_FILE_KEY);
        boolean compressFile = "yes".equalsIgnoreCase(compressFileStr) || "true".equalsIgnoreCase(compressFileStr) || "on".equalsIgnoreCase(compressFileStr);
        this.initialize(file, dataFormat, compressFile);
    }

    public void initialize() throws SailInitializationException {
        this.initialize(null, null, false);
    }

    public void initialize(File file, RDFFormat dataFormat, boolean compressFile) throws SailInitializationException {
        this._dataFormat = dataFormat;
        this._compressFile = compressFile;
        if (file != null) {
            this._file = file;
            if (this._file.exists()) {
                if (!this._file.canRead()) {
                    throw new SailInitializationException("File is not readable: " + this._file.getPath());
                }
                this._readFromFile();
                this._exportStatusUpToDate = false;
            }
        }
    }

    public void shutDown() {
    }

    public ValueFactory getValueFactory() {
        return this;
    }

    public StatementIterator getStatements(Resource subj, URI pred, Value obj) {
        StatementList l;
        ResourceNode subjNode = null;
        URINode predNode = null;
        ValueNode objNode = null;
        if (subj != null && (subjNode = this._getResourceNode(subj)) == null) {
            return new EmptyStatementIterator();
        }
        if (pred != null && (predNode = this._getURINode(pred)) == null) {
            return new EmptyStatementIterator();
        }
        if (obj != null && (objNode = this._getValueNode(obj)) == null) {
            return new EmptyStatementIterator();
        }
        StatementList smallestList = this._statements;
        if (subjNode != null && (l = subjNode.getSubjectStatementList()).size() < smallestList.size()) {
            smallestList = l;
        }
        if (predNode != null && (l = predNode.getPredicateStatementList()).size() < smallestList.size()) {
            smallestList = l;
        }
        if (objNode != null && (l = objNode.getObjectStatementList()).size() < smallestList.size()) {
            smallestList = l;
        }
        return new MemStatementIterator(smallestList, subjNode, predNode, objNode);
    }

    public boolean hasStatement(Resource subj, URI pred, Value obj) {
        StatementIterator stIter = this.getStatements(subj, pred, obj);
        boolean result2 = stIter.hasNext();
        stIter.close();
        return result2;
    }

    public Query optimizeQuery(Query qc) {
        QueryOptimizer.optimizeQuery(qc);
        return qc;
    }

    public NamespaceIterator getNamespaces() {
        if (!this._exportStatusUpToDate) {
            this._updateExportedNamespaces();
        }
        return new MemNamespaceIterator(this._namespacesList);
    }

    protected MemStatement _addStatement(Resource subj, URI pred, Value obj) {
        ValueNode objNode;
        URINode predNode;
        boolean newNodeCreated = false;
        ResourceNode subjNode = this._getResourceNode(subj);
        if (subjNode == null) {
            subjNode = this._createResourceNode(subj);
            newNodeCreated = true;
        }
        if ((predNode = this._getURINode(pred)) == null) {
            predNode = this._createURINode(pred);
            newNodeCreated = true;
        }
        if ((objNode = this._getValueNode(obj)) == null) {
            objNode = this._createValueNode(obj);
            newNodeCreated = true;
        }
        if (!newNodeCreated) {
            StatementIterator statIter = this.getStatements(subjNode, predNode, objNode);
            if (statIter.hasNext()) {
                MemStatement st = (MemStatement)statIter.next();
                statIter.close();
                return st;
            }
            statIter.close();
        }
        MemStatement st = new MemStatement(subjNode, predNode, objNode);
        this._statements.add(st);
        subjNode.addSubjectStatement(st);
        predNode.addPredicateStatement(st);
        objNode.addObjectStatement(st);
        return st;
    }

    protected boolean _isOwnValueNode(Value value) {
        return value instanceof ValueNode && ((ValueNode)value).getRdfSource() == this;
    }

    protected ValueNode _getValueNode(Value value) {
        if (value instanceof Resource) {
            return this._getResourceNode((Resource)value);
        }
        if (value instanceof Literal) {
            return this._getLiteralNode((Literal)value);
        }
        throw new RuntimeException("value is not a Resource or Literal: " + value);
    }

    protected ResourceNode _getResourceNode(Resource resource) {
        if (resource instanceof URI) {
            return this._getURINode((URI)resource);
        }
        if (resource instanceof BNode) {
            return this._getBNodeNode((BNode)resource);
        }
        throw new RuntimeException("resource is not a URI or BNode");
    }

    protected URINode _getURINode(URI uri2) {
        if (this._isOwnValueNode(uri2)) {
            return (URINode)uri2;
        }
        return (URINode)this._uriNodesMap.get(uri2);
    }

    protected BNodeNode _getBNodeNode(BNode bNode) {
        if (this._isOwnValueNode(bNode)) {
            return (BNodeNode)bNode;
        }
        return (BNodeNode)this._bNodeNodesMap.get(bNode);
    }

    protected LiteralNode _getLiteralNode(Literal literal) {
        if (this._isOwnValueNode(literal)) {
            return (LiteralNode)literal;
        }
        return (LiteralNode)this._literalNodesMap.get(literal);
    }

    protected ValueNode _createValueNode(Value value) {
        if (value instanceof Resource) {
            return this._createResourceNode((Resource)value);
        }
        if (value instanceof Literal) {
            return this._createLiteralNode((Literal)value);
        }
        throw new RuntimeException("value is not a Resource or Literal");
    }

    protected ResourceNode _createResourceNode(Resource resource) {
        if (resource instanceof URI) {
            return this._createURINode((URI)resource);
        }
        if (resource instanceof BNode) {
            return this._createBNodeNode((BNode)resource);
        }
        throw new RuntimeException("resource is not a URI or BNode");
    }

    protected URINode _createURINode(URI uri2) {
        String namespace = uri2.getNamespace();
        Namespace n = (Namespace)this._namespacesTable.get(namespace);
        if (n == null) {
            n = this._registerNamespace(namespace, false);
        } else {
            namespace = n.getName();
        }
        URINode uriNode = new URINode(this, namespace, uri2.getLocalName());
        URINode existingNode = this._uriNodesMap.put(uriNode, uriNode);
        if (existingNode != null) {
            throw new SailInternalException("Created a duplicate URINode for uri " + uri2);
        }
        return uriNode;
    }

    protected BNodeNode _createBNodeNode(BNode bNode) {
        BNodeNode bNodeNode = new BNodeNode(this, bNode.getID());
        BNodeNode existingNode = this._bNodeNodesMap.put(bNodeNode, bNodeNode);
        if (existingNode != null) {
            throw new SailInternalException("Created a duplicate BNodeNode for bNode " + bNode);
        }
        return bNodeNode;
    }

    protected LiteralNode _createLiteralNode(Literal literal) {
        LiteralNode literalNode = null;
        literalNode = literal.getDatatype() != null ? new LiteralNode(this, literal.getLabel(), literal.getDatatype()) : (literal.getLanguage() != null ? new LiteralNode(this, literal.getLabel(), literal.getLanguage()) : new LiteralNode(this, literal.getLabel()));
        LiteralNode existingNode = this._literalNodesMap.put(literalNode, literalNode);
        if (existingNode != null) {
            throw new SailInternalException("Created a duplicate LiteralNode for literal " + literal);
        }
        return literalNode;
    }

    protected Namespace _registerNamespace(String name2, boolean export) {
        return this._registerNamespace("ns" + this._nextNsPrefixId++, name2, export);
    }

    protected Namespace _registerNamespace(String prefix, String name2, boolean export) {
        Namespace namespace = new Namespace(prefix, name2, export);
        this._namespacesTable.put(name2, namespace);
        this._namespacesList.add(namespace);
        return namespace;
    }

    protected void _updateExportedNamespaces() {
        int i;
        HashSet<String> namespacesSet = new HashSet<String>();
        for (i = 0; i < this._statements.size(); ++i) {
            Statement st = this._statements.get(i);
            URI pred = st.getPredicate();
            namespacesSet.add(pred.getNamespace());
        }
        for (i = 0; i < this._namespacesList.size(); ++i) {
            Namespace namespace = (Namespace)this._namespacesList.get(i);
            namespace.setExported(namespacesSet.contains(namespace.getName()));
        }
        this._exportStatusUpToDate = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _readFromFile() throws SailInitializationException {
        if (this._file.length() == 0L) {
            return;
        }
        try {
            RdfXmlParser parser = null;
            if (this._dataFormat == RDFFormat.RDFXML) {
                parser = new RdfXmlParser((ValueFactory)this);
            } else if (this._dataFormat == RDFFormat.NTRIPLES) {
                parser = new NTriplesParser((ValueFactory)this);
            } else if (this._dataFormat == RDFFormat.TURTLE) {
                parser = new TurtleParser((ValueFactory)this);
            } else {
                throw new SailInitializationException("Illegal value for data format: " + this._dataFormat.toString());
            }
            parser.setNamespaceListener((org.openrdf.rio.NamespaceListener)new NamespaceListener());
            parser.setStatementHandler((org.openrdf.rio.StatementHandler)new StatementHandler());
            InputStream in = new FileInputStream(this._file);
            try {
                if (this._compressFile) {
                    in = new GZIPInputStream(in, 4096);
                }
                in = new BufferedInputStream(in, 4096);
                parser.parse(in, "file://" + this._file.getPath());
            }
            finally {
                in.close();
            }
        }
        catch (ParseException e) {
            throw new SailInitializationException("Parse error on line " + e.getLineNumber(), e);
        }
        catch (IOException e) {
            throw new SailInitializationException("I/O error on reading file " + this._file, e);
        }
        catch (StatementHandlerException e) {
            throw new RuntimeException("Unexpected StatementHandlerException: " + e.getMessage());
        }
    }

    public URI createURI(String uri2) {
        URIImpl tempURI = new URIImpl(uri2);
        URINode node = this._getURINode(tempURI);
        if (node == null) {
            node = this._createURINode(tempURI);
        }
        return node;
    }

    public URI createURI(String namespace, String localName) {
        URIImpl tempURI = new URIImpl(namespace, localName);
        URINode node = this._getURINode(tempURI);
        if (node == null) {
            node = this._createURINode(tempURI);
        }
        return node;
    }

    public BNode createBNode() {
        if (this._nextBNodeID == Integer.MAX_VALUE) {
            this._updateBNodePrefix();
        }
        return this.createBNode(this._bnodePrefix + this._nextBNodeID++);
    }

    public BNode createBNode(String nodeId) {
        BNodeImpl tempBNode = new BNodeImpl(nodeId);
        BNodeNode node = this._getBNodeNode(tempBNode);
        if (node == null) {
            node = this._createBNodeNode(tempBNode);
        }
        return node;
    }

    public Literal createLiteral(String value) {
        LiteralImpl tempLiteral = new LiteralImpl(value);
        LiteralNode node = this._getLiteralNode(tempLiteral);
        if (node == null) {
            node = this._createLiteralNode(tempLiteral);
        }
        return node;
    }

    public Literal createLiteral(String value, String language2) {
        LiteralImpl tempLiteral = new LiteralImpl(value, language2);
        LiteralNode node = this._getLiteralNode(tempLiteral);
        if (node == null) {
            node = this._createLiteralNode(tempLiteral);
        }
        return node;
    }

    public Literal createLiteral(String value, URI datatype) {
        LiteralImpl tempLiteral = new LiteralImpl(value, datatype);
        LiteralNode node = this._getLiteralNode(tempLiteral);
        if (node == null) {
            node = this._createLiteralNode(tempLiteral);
        }
        return node;
    }

    public Statement createStatement(Resource subject, URI predicate, Value object) {
        Statement result2 = null;
        StatementIterator stIter = this.getStatements(subject, predicate, object);
        if (stIter.hasNext()) {
            result2 = stIter.next();
        }
        stIter.close();
        if (result2 == null) {
            result2 = new MemStatement(subject, predicate, object);
        }
        return result2;
    }

    class StatementHandler
    implements org.openrdf.rio.StatementHandler {
        StatementHandler() {
        }

        public void handleStatement(Resource subject, URI predicate, Value object) {
            RdfSource.this._addStatement(subject, predicate, object);
        }
    }

    class NamespaceListener
    implements org.openrdf.rio.NamespaceListener {
        NamespaceListener() {
        }

        public void handleNamespace(String prefix, String uri2) {
            if (!RdfSource.this._namespacesTable.containsKey(uri2)) {
                RdfSource.this._registerNamespace(prefix, uri2, true);
            }
        }
    }
}

