/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.memory;

import java.io.File;
import java.io.IOException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.rio.RdfDocumentWriter;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.export.RdfExport;
import org.openrdf.sesame.sail.LiteralIterator;
import org.openrdf.sesame.sail.SailInitializationException;
import org.openrdf.sesame.sail.SailUpdateException;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sail.util.EmptyStatementIterator;
import org.openrdf.sesame.sailimpl.memory.MemLiteralIterator;
import org.openrdf.sesame.sailimpl.memory.MemStatement;
import org.openrdf.sesame.sailimpl.memory.MemStatementIterator;
import org.openrdf.sesame.sailimpl.memory.RdfMTInferencer;
import org.openrdf.sesame.sailimpl.memory.RdfRepository;
import org.openrdf.sesame.sailimpl.memory.ResourceNode;
import org.openrdf.sesame.sailimpl.memory.StatementList;
import org.openrdf.sesame.sailimpl.memory.URINode;
import org.openrdf.sesame.sailimpl.memory.ValueNode;

public class RdfSchemaRepository
extends RdfRepository
implements org.openrdf.sesame.sail.RdfSchemaRepository {
    protected URINode RDF_TYPE_NODE;
    protected URINode RDF_PROPERTY_NODE;
    protected URINode RDF_SUBJECT_NODE;
    protected URINode RDF_PREDICATE_NODE;
    protected URINode RDF_OBJECT_NODE;
    protected URINode RDF_STATEMENT_NODE;
    protected URINode RDF_LIST_NODE;
    protected URINode RDF_FIRST_NODE;
    protected URINode RDF_REST_NODE;
    protected URINode RDF_NIL_NODE;
    protected URINode RDF_BAG_NODE;
    protected URINode RDF_SEQ_NODE;
    protected URINode RDF_ALT_NODE;
    protected URINode RDF_XMLLITERAL_NODE;
    protected URINode RDF_VALUE_NODE;
    protected URINode RDFS_RESOURCE_NODE;
    protected URINode RDFS_LITERAL_NODE;
    protected URINode RDFS_CLASS_NODE;
    protected URINode RDFS_CONTAINER_NODE;
    protected URINode RDFS_CONTAINERMEMBERSHIPPROPERTY_NODE;
    protected URINode RDFS_DOMAIN_NODE;
    protected URINode RDFS_RANGE_NODE;
    protected URINode RDFS_SUBCLASSOF_NODE;
    protected URINode RDFS_SUBPROPERTYOF_NODE;
    protected URINode RDFS_LABEL_NODE;
    protected URINode RDFS_COMMENT_NODE;
    protected URINode RDFS_SEEALSO_NODE;
    protected URINode RDFS_ISDEFINEDBY_NODE;
    protected URINode RDFS_MEMBER_NODE;
    protected URINode RDFS_DATATYPE_NODE;
    private boolean _statementsRemoved = false;
    private RdfMTInferencer _inferencer = new RdfMTInferencer(this);

    public void initialize(File file, RDFFormat dataFormat, boolean compressFile) throws SailInitializationException {
        this._initRdfPrimitives();
        super.initialize(file, dataFormat, compressFile);
        this._inferencer.notifyNewStatements(this._statements);
        this._inferencer.initialize();
    }

    protected void _initRdfPrimitives() {
        this.RDF_TYPE_NODE = this._createURINode(URIImpl.RDF_TYPE);
        this.RDF_PROPERTY_NODE = this._createURINode(URIImpl.RDF_PROPERTY);
        this.RDF_SUBJECT_NODE = this._createURINode(URIImpl.RDF_SUBJECT);
        this.RDF_PREDICATE_NODE = this._createURINode(URIImpl.RDF_PREDICATE);
        this.RDF_OBJECT_NODE = this._createURINode(URIImpl.RDF_OBJECT);
        this.RDF_STATEMENT_NODE = this._createURINode(URIImpl.RDF_STATEMENT);
        this.RDF_LIST_NODE = this._createURINode(URIImpl.RDF_LIST);
        this.RDF_FIRST_NODE = this._createURINode(URIImpl.RDF_FIRST);
        this.RDF_REST_NODE = this._createURINode(URIImpl.RDF_REST);
        this.RDF_NIL_NODE = this._createURINode(URIImpl.RDF_NIL);
        this.RDF_BAG_NODE = this._createURINode(URIImpl.RDF_BAG);
        this.RDF_SEQ_NODE = this._createURINode(URIImpl.RDF_SEQ);
        this.RDF_ALT_NODE = this._createURINode(URIImpl.RDF_ALT);
        this.RDF_XMLLITERAL_NODE = this._createURINode(URIImpl.RDF_XMLLITERAL);
        this.RDF_VALUE_NODE = this._createURINode(URIImpl.RDF_VALUE);
        this.RDFS_RESOURCE_NODE = this._createURINode(URIImpl.RDFS_RESOURCE);
        this.RDFS_LITERAL_NODE = this._createURINode(URIImpl.RDFS_LITERAL);
        this.RDFS_CLASS_NODE = this._createURINode(URIImpl.RDFS_CLASS);
        this.RDFS_CONTAINER_NODE = this._createURINode(URIImpl.RDFS_CONTAINER);
        this.RDFS_CONTAINERMEMBERSHIPPROPERTY_NODE = this._createURINode(URIImpl.RDFS_CONTAINERMEMBERSHIPPROPERTY);
        this.RDFS_DOMAIN_NODE = this._createURINode(URIImpl.RDFS_DOMAIN);
        this.RDFS_RANGE_NODE = this._createURINode(URIImpl.RDFS_RANGE);
        this.RDFS_SUBCLASSOF_NODE = this._createURINode(URIImpl.RDFS_SUBCLASSOF);
        this.RDFS_SUBPROPERTYOF_NODE = this._createURINode(URIImpl.RDFS_SUBPROPERTYOF);
        this.RDFS_LABEL_NODE = this._createURINode(URIImpl.RDFS_LABEL);
        this.RDFS_COMMENT_NODE = this._createURINode(URIImpl.RDFS_COMMENT);
        this.RDFS_SEEALSO_NODE = this._createURINode(URIImpl.RDFS_SEEALSO);
        this.RDFS_ISDEFINEDBY_NODE = this._createURINode(URIImpl.RDFS_ISDEFINEDBY);
        this.RDFS_MEMBER_NODE = this._createURINode(URIImpl.RDFS_MEMBER);
        this.RDFS_DATATYPE_NODE = this._createURINode(URIImpl.RDFS_DATATYPE);
    }

    public StatementIterator getStatements(Resource subj, URI pred, Value obj) {
        return this.getStatements(subj, pred, obj, false);
    }

    public boolean hasStatement(Resource subj, URI pred, Value obj) {
        return this.hasStatement(subj, pred, obj, false);
    }

    public StatementIterator getExplicitStatements(Resource subj, URI pred, Value obj) {
        return this.getStatements(subj, pred, obj, true);
    }

    public StatementIterator getStatements(Resource subj, URI pred, Value obj, boolean explicitOnly) {
        StatementList l;
        ResourceNode subjNode = null;
        URINode predNode = null;
        ValueNode objNode = null;
        if (subj != null && (subjNode = this._getResourceNode(subj)) == null) {
            return new EmptyStatementIterator();
        }
        if (pred != null && (predNode = this._getURINode(pred)) == null) {
            return new EmptyStatementIterator();
        }
        if (obj != null && (objNode = this._getValueNode(obj)) == null) {
            return new EmptyStatementIterator();
        }
        StatementList smallestList = this._statements;
        if (subjNode != null && (l = subjNode.getSubjectStatementList()).size() < smallestList.size()) {
            smallestList = l;
        }
        if (predNode != null && (l = predNode.getPredicateStatementList()).size() < smallestList.size()) {
            smallestList = l;
        }
        if (objNode != null && (l = objNode.getObjectStatementList()).size() < smallestList.size()) {
            smallestList = l;
        }
        return new MemStatementIterator(smallestList, subjNode, predNode, objNode, explicitOnly);
    }

    public boolean hasExplicitStatement(Resource subj, URI pred, Value obj) {
        return this.hasStatement(subj, pred, obj, true);
    }

    public boolean hasStatement(Resource subj, URI pred, Value obj, boolean explicitOnly) {
        StatementIterator stIter = this.getStatements(subj, pred, obj, explicitOnly);
        boolean result2 = stIter.hasNext();
        stIter.close();
        return result2;
    }

    public StatementIterator getClasses() {
        return this.getStatements(null, this.RDF_TYPE_NODE, this.RDFS_CLASS_NODE);
    }

    public boolean isClass(Resource resource) {
        return this.hasStatement(resource, this.RDF_TYPE_NODE, this.RDFS_CLASS_NODE);
    }

    public StatementIterator getProperties() {
        return this.getStatements(null, this.RDF_TYPE_NODE, this.RDF_PROPERTY_NODE);
    }

    public boolean isProperty(Resource resource) {
        return this.hasStatement(resource, this.RDF_TYPE_NODE, this.RDF_PROPERTY_NODE);
    }

    public StatementIterator getSubClassOf(Resource subClass, Resource superClass) {
        return this.getStatements(subClass, this.RDFS_SUBCLASSOF_NODE, superClass);
    }

    public boolean isSubClassOf(Resource subClass, Resource superClass) {
        return this.hasStatement(subClass, this.RDFS_SUBCLASSOF_NODE, superClass);
    }

    public StatementIterator getDirectSubClassOf(Resource subClass, Resource superClass) {
        ResourceNode subClassNode = null;
        ResourceNode superClassNode = null;
        if (superClass != null && subClass != null) {
            superClassNode = this._getResourceNode(superClass);
            if (superClassNode == null) {
                return new EmptyStatementIterator();
            }
            subClassNode = this._getResourceNode(subClass);
            if (subClassNode == null) {
                return new EmptyStatementIterator();
            }
            StatementIterator iter2 = superClassNode.getDirectSubClassStatements();
            StatementList list = new StatementList();
            while (iter2.hasNext()) {
                Statement st = iter2.next();
                if (!st.getSubject().equals(subClass)) continue;
                list.add(st);
                break;
            }
            iter2.close();
            return new MemStatementIterator(list);
        }
        if (superClass != null) {
            superClassNode = this._getResourceNode(superClass);
            if (superClassNode == null) {
                return new EmptyStatementIterator();
            }
            if (subClass == null) {
                return superClassNode.getDirectSubClassStatements();
            }
        }
        if (subClass != null) {
            subClassNode = this._getResourceNode(subClass);
            if (subClassNode == null) {
                return new EmptyStatementIterator();
            }
            if (superClass == null) {
                StatementIterator superClassIter = this.getStatements(subClass, this.RDFS_SUBCLASSOF_NODE, null, false);
                StatementList directSuperClasses = new StatementList();
                if (!superClassIter.hasNext()) {
                    return new EmptyStatementIterator();
                }
                Statement rdfsResourceStatement = null;
                while (superClassIter.hasNext()) {
                    Statement st = superClassIter.next();
                    superClassNode = (ResourceNode)st.getObject();
                    if (superClassNode.equals(this.RDFS_RESOURCE_NODE)) {
                        rdfsResourceStatement = st;
                        continue;
                    }
                    if (!superClassNode.isDirectSubClass(subClass)) continue;
                    directSuperClasses.add(st);
                }
                superClassIter.close();
                if (directSuperClasses.size() == 0 && rdfsResourceStatement != null) {
                    directSuperClasses.add(rdfsResourceStatement);
                }
                return new MemStatementIterator(directSuperClasses);
            }
        }
        MemStatementIterator subClassIter = new MemStatementIterator(this.RDFS_SUBCLASSOF_NODE.getPredicateStatementList());
        StatementList directSubClassStatements = new StatementList();
        while (subClassIter.hasNext()) {
            Statement st = subClassIter.next();
            ResourceNode subject = (ResourceNode)st.getSubject();
            StatementIterator iter3 = subject.getDirectSubClassStatements();
            while (iter3.hasNext()) {
                directSubClassStatements.add(iter3.next());
            }
            iter3.close();
        }
        subClassIter.close();
        return new MemStatementIterator(directSubClassStatements);
    }

    public boolean isDirectSubClassOf(Resource subClass, Resource superClass) {
        StatementIterator stIter = this.getDirectSubClassOf(subClass, superClass);
        boolean result2 = stIter.hasNext();
        stIter.close();
        return result2;
    }

    public StatementIterator getSubPropertyOf(Resource subProperty, Resource superProperty) {
        return this.getStatements(subProperty, this.RDFS_SUBPROPERTYOF_NODE, superProperty);
    }

    public boolean isSubPropertyOf(Resource subProperty, Resource superProperty) {
        return this.hasStatement(subProperty, this.RDFS_SUBPROPERTYOF_NODE, superProperty);
    }

    public StatementIterator getDirectSubPropertyOf(Resource subProp, Resource superProp) {
        ResourceNode subPropNode = null;
        ResourceNode superPropNode = null;
        if (superProp != null && subProp != null) {
            superPropNode = this._getResourceNode(superProp);
            if (superPropNode == null) {
                return new EmptyStatementIterator();
            }
            subPropNode = this._getResourceNode(subProp);
            if (subPropNode == null) {
                return new EmptyStatementIterator();
            }
            StatementIterator iter2 = superPropNode.getDirectSubPropertyStatements();
            StatementList list = new StatementList();
            while (iter2.hasNext()) {
                Statement st = iter2.next();
                if (!st.getSubject().equals(subProp)) continue;
                list.add(st);
                break;
            }
            iter2.close();
            return new MemStatementIterator(list);
        }
        if (superProp != null) {
            superPropNode = this._getResourceNode(superProp);
            if (superPropNode == null) {
                return new EmptyStatementIterator();
            }
            if (subProp == null) {
                return superPropNode.getDirectSubPropertyStatements();
            }
        }
        if (subProp != null) {
            subPropNode = this._getResourceNode(subProp);
            if (subPropNode == null) {
                return new EmptyStatementIterator();
            }
            if (superProp == null) {
                StatementIterator superPropIter = this.getStatements(subProp, this.RDFS_SUBPROPERTYOF_NODE, null, false);
                StatementList directSuperProps = new StatementList();
                while (superPropIter.hasNext()) {
                    Statement st = superPropIter.next();
                    superPropNode = (ResourceNode)st.getObject();
                    if (!superPropNode.isDirectSubProperty(subProp)) continue;
                    directSuperProps.add(st);
                }
                superPropIter.close();
                return new MemStatementIterator(directSuperProps);
            }
        }
        MemStatementIterator subPropIter = new MemStatementIterator(this.RDFS_SUBPROPERTYOF_NODE.getPredicateStatementList());
        StatementList directSubPropStatements = new StatementList();
        while (subPropIter.hasNext()) {
            Statement st = subPropIter.next();
            ResourceNode subject = (ResourceNode)st.getSubject();
            StatementIterator iter3 = subject.getDirectSubPropertyStatements();
            while (iter3.hasNext()) {
                directSubPropStatements.add(iter3.next());
            }
            iter3.close();
        }
        subPropIter.close();
        return new MemStatementIterator(directSubPropStatements);
    }

    public boolean isDirectSubPropertyOf(Resource subProperty, Resource superProperty) {
        StatementIterator stIter = this.getDirectSubPropertyOf(subProperty, superProperty);
        boolean result2 = stIter.hasNext();
        stIter.close();
        return result2;
    }

    public StatementIterator getDomain(Resource prop, Resource domain) {
        return this.getStatements(prop, this.RDFS_DOMAIN_NODE, domain);
    }

    public StatementIterator getRange(Resource prop, Resource range2) {
        return this.getStatements(prop, this.RDFS_RANGE_NODE, range2);
    }

    public StatementIterator getType(Resource anInstance, Resource aClass) {
        return this.getStatements(anInstance, this.RDF_TYPE_NODE, aClass);
    }

    public boolean isType(Resource anInstance, Resource aClass) {
        return this.hasStatement(anInstance, this.RDF_TYPE_NODE, aClass);
    }

    public StatementIterator getDirectType(Resource anInstance, Resource aClass) {
        ResourceNode instanceNode = null;
        ResourceNode classNode = null;
        if (anInstance != null && aClass != null) {
            classNode = this._getResourceNode(aClass);
            if (classNode == null) {
                return new EmptyStatementIterator();
            }
            instanceNode = this._getResourceNode(anInstance);
            if (instanceNode == null) {
                return new EmptyStatementIterator();
            }
            StatementIterator iter2 = instanceNode.getDirectTypeStatements();
            StatementList list = new StatementList();
            while (iter2.hasNext()) {
                Statement st = iter2.next();
                if (!st.getObject().equals(classNode)) continue;
                list.add(st);
                break;
            }
            iter2.close();
            return new MemStatementIterator(list);
        }
        if (anInstance != null) {
            instanceNode = this._getResourceNode(anInstance);
            if (instanceNode == null) {
                return new EmptyStatementIterator();
            }
            if (aClass == null) {
                return instanceNode.getDirectTypeStatements();
            }
        }
        if (aClass != null) {
            classNode = this._getResourceNode(aClass);
            if (classNode == null) {
                return new EmptyStatementIterator();
            }
            if (anInstance == null) {
                StatementList directInstances = new StatementList();
                StatementIterator instanceIter = this.getStatements(null, this.RDF_TYPE_NODE, classNode, false);
                while (instanceIter.hasNext()) {
                    Statement st = instanceIter.next();
                    if (!((ResourceNode)st.getSubject()).isDirectType(aClass)) continue;
                    directInstances.add(st);
                }
                instanceIter.close();
                return new MemStatementIterator(directInstances);
            }
        }
        MemStatementIterator typeIter = new MemStatementIterator(this.RDF_TYPE_NODE.getPredicateStatementList());
        StatementList directTypeStatements = new StatementList();
        while (typeIter.hasNext()) {
            Statement st = typeIter.next();
            ResourceNode subject = (ResourceNode)st.getSubject();
            StatementIterator iter3 = subject.getDirectTypeStatements();
            while (iter3.hasNext()) {
                directTypeStatements.add(iter3.next());
            }
            iter3.close();
        }
        typeIter.close();
        return new MemStatementIterator(directTypeStatements);
    }

    public boolean isDirectType(Resource anInstance, Resource aClass) {
        StatementIterator stIter = this.getDirectType(anInstance, aClass);
        boolean result2 = stIter.hasNext();
        stIter.close();
        return result2;
    }

    public LiteralIterator getLiterals(String label, String language2, URI datatype) {
        return new MemLiteralIterator(this._literalNodesMap.values(), label, language2, datatype);
    }

    public void commitTransaction() {
        this._clearAllCaches();
        if (this._statementsRemoved) {
            this._removeInferredStatements();
            this._inferencer.notifyNewStatements(this._statements);
            this._inferencer.initialize();
        } else {
            this._inferencer.doInferencing();
        }
        this._statementsRemoved = false;
        super.commitTransaction();
    }

    public void addStatement(Resource subj, URI pred, Value obj) throws SailUpdateException {
        if (!this.transactionStarted()) {
            throw new SailUpdateException("no transaction started.");
        }
        MemStatement st = this._addStatement(subj, pred, obj);
        this._inferencer.notifyNewStatement(st);
        this._sailChangedEvent.setStatementsAdded(true);
    }

    public int removeStatements(Resource subj, URI pred, Value obj) throws SailUpdateException {
        if (!this.transactionStarted()) {
            throw new SailUpdateException("no transaction started.");
        }
        int nrOfStatements = super.removeStatements(subj, pred, obj);
        if (nrOfStatements > 0) {
            this._statementsRemoved = true;
            this._sailChangedEvent.setStatementsRemoved(true);
        }
        return nrOfStatements;
    }

    protected boolean _matchesForRemoval(Statement st, Resource subj, URI pred, Value obj) {
        return ((MemStatement)st).isExplicit() && super._matchesForRemoval(st, subj, pred, obj);
    }

    public void clearRepository() throws SailUpdateException {
        super.clearRepository();
        this._initRdfPrimitives();
        this._inferencer.initialize();
    }

    protected MemStatement _getMemStatement(Resource subj, URI pred, Value obj) {
        MemStatement result2 = null;
        StatementIterator iter2 = this.getStatements(subj, pred, obj, false);
        if (iter2.hasNext()) {
            result2 = (MemStatement)iter2.next();
        }
        iter2.close();
        return result2;
    }

    protected MemStatement _addStatement(Resource subj, URI pred, Value obj) {
        MemStatement st = super._addStatement(subj, pred, obj);
        st.setExplicit(true);
        return st;
    }

    protected void _exportData(RdfDocumentWriter docWriter) throws IOException {
        RdfExport rdfExport = new RdfExport();
        rdfExport.exportRdf(this, docWriter, true, true, true, false);
    }

    private void _removeInferredStatements() {
        int size2 = this._statements.size();
        for (int i = size2 - 1; i >= 0; --i) {
            MemStatement st = (MemStatement)this._statements.get(i);
            if (st.isExplicit()) continue;
            ResourceNode rn = (ResourceNode)st.getSubject();
            rn.removeSubjectStatement(st);
            URINode un = (URINode)st.getPredicate();
            un.removePredicateStatement(st);
            ValueNode vn = (ValueNode)st.getObject();
            vn.removeObjectStatement(st);
            this._statements.remove(i);
        }
    }

    private void _clearAllCaches() {
        MemStatementIterator allTypeRelations = new MemStatementIterator(this.RDF_TYPE_NODE.getPredicateStatementList());
        while (allTypeRelations.hasNext()) {
            Statement st = allTypeRelations.next();
            ((ResourceNode)st.getSubject()).clearCache();
        }
        allTypeRelations.close();
    }
}

