/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.memory;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.GZIPOutputStream;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RdfDocumentWriter;
import org.openrdf.rio.ntriples.NTriplesWriter;
import org.openrdf.rio.rdfxml.RdfXmlWriter;
import org.openrdf.rio.turtle.TurtleWriter;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.export.RdfExport;
import org.openrdf.sesame.sail.SailChangedListener;
import org.openrdf.sesame.sail.SailInitializationException;
import org.openrdf.sesame.sail.SailInternalException;
import org.openrdf.sesame.sail.SailUpdateException;
import org.openrdf.sesame.sail.util.SailChangedEventImpl;
import org.openrdf.sesame.sailimpl.memory.Namespace;
import org.openrdf.sesame.sailimpl.memory.RdfSource;
import org.openrdf.sesame.sailimpl.memory.ResourceNode;
import org.openrdf.sesame.sailimpl.memory.StatementList;
import org.openrdf.sesame.sailimpl.memory.URINode;
import org.openrdf.sesame.sailimpl.memory.ValueNode;

public class RdfRepository
extends RdfSource
implements org.openrdf.sesame.sail.RdfRepository {
    public static final String SYNC_DELAY_KEY = "syncDelay";
    protected boolean _transactionStarted = false;
    protected boolean _contentsChanged;
    protected SailChangedEventImpl _sailChangedEvent;
    protected long _syncDelay;
    protected Timer _syncTimer;
    protected List _sailChangedListeners;

    public RdfRepository() {
        this._file = null;
        this._syncDelay = 0L;
        this._sailChangedListeners = new ArrayList(0);
    }

    public void initialize(Map configParams) throws SailInitializationException {
        super.initialize(configParams);
        String syncDelay = (String)configParams.get(SYNC_DELAY_KEY);
        if (syncDelay != null) {
            try {
                this.setSyncDelay(Long.parseLong(syncDelay));
            }
            catch (NumberFormatException e) {
                throw new SailInitializationException("Illegal value for syncDelay parameter: " + syncDelay);
            }
        }
    }

    public void initialize(File file, RDFFormat dataFormat, boolean compressFile) throws SailInitializationException {
        super.initialize(file, dataFormat, compressFile);
        this._contentsChanged = false;
        if (this._file != null) {
            if (this._file.exists()) {
                if (!this._file.canWrite()) {
                    throw new SailInitializationException("File is not writeable: " + this._file.getPath());
                }
            } else {
                try {
                    boolean created;
                    File parentDir = this._file.getParentFile();
                    if (parentDir != null && !parentDir.exists() && !(created = parentDir.mkdirs())) {
                        throw new SailInitializationException("Unable to create directory for file " + this._file.getPath());
                    }
                    this._file.createNewFile();
                    if (this._compressFile) {
                        this._contentsChanged = true;
                    }
                }
                catch (IOException e) {
                    throw new SailInitializationException("Unable to create file " + this._file.getPath(), e);
                }
            }
        }
    }

    public void shutDown() {
        this.sync();
        super.shutDown();
    }

    public void startTransaction() {
        this._stopSyncTimer();
        this._transactionStarted = true;
        this._contentsChanged = true;
        this._sailChangedEvent = new SailChangedEventImpl();
    }

    public void commitTransaction() {
        this._exportStatusUpToDate = false;
        this._transactionStarted = false;
        this._notifySailChanged(this._sailChangedEvent);
        this._sailChangedEvent = null;
        this._startSyncTimer();
    }

    public boolean transactionStarted() {
        return this._transactionStarted;
    }

    public void addStatement(Resource subj, URI pred, Value obj) throws SailUpdateException {
        if (!this.transactionStarted()) {
            throw new SailUpdateException("no transaction started.");
        }
        this._addStatement(subj, pred, obj);
        this._sailChangedEvent.setStatementsAdded(true);
    }

    public int removeStatements(Resource subj, URI pred, Value obj) throws SailUpdateException {
        ValueNode objNode;
        if (!this.transactionStarted()) {
            throw new SailUpdateException("no transaction started.");
        }
        if (subj == null && pred == null && obj == null) {
            int result2 = this._statements.size();
            this.clearRepository();
            return result2;
        }
        ResourceNode subjNode = subj == null ? null : this._getResourceNode(subj);
        URINode predNode = pred == null ? null : this._getURINode(pred);
        ValueNode valueNode = objNode = obj == null ? null : this._getValueNode(obj);
        if (subjNode == null && subj != null || predNode == null && pred != null || objNode == null && obj != null) {
            return 0;
        }
        boolean patternHasWildcards = subjNode == null || predNode == null || objNode == null;
        int oldSize = this._statements.size();
        for (int i = oldSize - 1; i >= 0; --i) {
            Statement st = this._statements.get(i);
            if (!this._matchesForRemoval(st, subjNode, predNode, objNode)) continue;
            ResourceNode rn = (ResourceNode)st.getSubject();
            rn.removeSubjectStatement(st);
            URINode un = (URINode)st.getPredicate();
            un.removePredicateStatement(st);
            ValueNode vn = (ValueNode)st.getObject();
            vn.removeObjectStatement(st);
            this._statements.remove(i);
            this._sailChangedEvent.setStatementsRemoved(true);
            if (patternHasWildcards) continue;
            return 1;
        }
        return oldSize - this._statements.size();
    }

    public void clearRepository() throws SailUpdateException {
        if (!this.transactionStarted()) {
            throw new SailUpdateException("no transaction started.");
        }
        this._statements = new StatementList(256);
        this._namespacesTable = new HashMap();
        this._namespacesList = new ArrayList();
        this._nextNsPrefixId = 1;
        this._addDefaultNamespaces();
        this._uriNodesMap = new HashMap();
        this._bNodeNodesMap = new HashMap();
        this._literalNodesMap = new HashMap();
        this._updateBNodePrefix();
        this._sailChangedEvent.setStatementsRemoved(true);
    }

    public void changeNamespacePrefix(String namespace, String prefix) throws SailUpdateException {
        Iterator iter2 = this._namespacesList.iterator();
        while (iter2.hasNext()) {
            Namespace ns = (Namespace)iter2.next();
            if (!ns.getPrefix().equals(prefix) || ns.getName().equals(namespace)) continue;
            throw new SailUpdateException("Prefix '" + prefix + "' is already used for another namespace");
        }
        Namespace n = (Namespace)this._namespacesTable.get(namespace);
        if (n != null) {
            n.setPrefix(prefix);
        }
    }

    protected boolean _matchesForRemoval(Statement st, Resource subj, URI pred, Value obj) {
        return !(subj != null && !subj.equals(st.getSubject()) || pred != null && !((Object)pred).equals(st.getPredicate()) || obj != null && !obj.equals(st.getObject()));
    }

    public void setSyncDelay(long syncDelay) {
        this._syncDelay = syncDelay;
    }

    public long getSyncDelay() {
        return this._syncDelay;
    }

    protected synchronized void _startSyncTimer() {
        if (this._syncDelay == 0L) {
            this.sync();
        } else if (this._syncDelay > 0L) {
            this._syncTimer = new Timer();
            TimerTask tt = new TimerTask(){

                public void run() {
                    RdfRepository.this.sync();
                }
            };
            this._syncTimer.schedule(tt, this._syncDelay);
        }
    }

    protected synchronized void _stopSyncTimer() {
        if (this._syncTimer != null) {
            this._syncTimer.cancel();
            this._syncTimer = null;
        }
    }

    public void sync() {
        if (this._contentsChanged && this._file != null) {
            this._writeToFile();
            this._contentsChanged = false;
        }
    }

    protected void _writeToFile() {
        try {
            OutputStream out = new FileOutputStream(this._file);
            if (this._compressFile) {
                out = new GZIPOutputStream(out, 1024);
            }
            RdfXmlWriter docWriter = null;
            if (this._dataFormat == RDFFormat.RDFXML) {
                docWriter = new RdfXmlWriter(out);
            } else if (this._dataFormat == RDFFormat.NTRIPLES) {
                docWriter = new NTriplesWriter(out);
            } else if (this._dataFormat == RDFFormat.TURTLE) {
                docWriter = new TurtleWriter(out);
            } else {
                throw new SailInternalException("Illegal value for data format: " + this._dataFormat.toString());
            }
            this._exportData((RdfDocumentWriter)docWriter);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            throw new SailInternalException(e);
        }
    }

    protected void _exportData(RdfDocumentWriter docWriter) throws IOException {
        RdfExport rdfExport = new RdfExport();
        rdfExport.exportRdf(this, docWriter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SailChangedListener listener) {
        List list = this._sailChangedListeners;
        synchronized (list) {
            this._sailChangedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SailChangedListener listener) {
        List list = this._sailChangedListeners;
        synchronized (list) {
            this._sailChangedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _notifySailChanged(SailChangedEventImpl event) {
        List list = this._sailChangedListeners;
        synchronized (list) {
            if (this._sailChangedListeners != null && event.sailChanged()) {
                Iterator listeners = this._sailChangedListeners.iterator();
                while (listeners.hasNext()) {
                    SailChangedListener listener = (SailChangedListener)listeners.next();
                    listener.sailChanged(event);
                }
            }
        }
    }
}

