/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.memory;

import org.openrdf.model.Statement;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sailimpl.memory.MemStatement;
import org.openrdf.sesame.sailimpl.memory.ResourceNode;
import org.openrdf.sesame.sailimpl.memory.StatementList;
import org.openrdf.sesame.sailimpl.memory.URINode;
import org.openrdf.sesame.sailimpl.memory.ValueNode;

class MemStatementIterator
implements StatementIterator {
    private StatementList _statements;
    private int _statementCount;
    private int _nextStatementIdx;
    private ResourceNode _subject;
    private URINode _predicate;
    private ValueNode _object;
    private boolean _explicitOnly;

    public MemStatementIterator(StatementList statements) {
        this(statements, null, null, null, false);
    }

    public MemStatementIterator(StatementList statements, ResourceNode subject, URINode predicate, ValueNode object) {
        this(statements, subject, predicate, object, false);
    }

    public MemStatementIterator(StatementList statements, ResourceNode subject, URINode predicate, ValueNode object, boolean explicitOnly) {
        this._statements = statements;
        this._statementCount = this._statements.size();
        this._subject = subject;
        this._predicate = predicate;
        this._object = object;
        this._explicitOnly = explicitOnly;
        this._nextStatementIdx = -1;
        this._findNextStatement();
    }

    private boolean _findNextStatement() {
        ++this._nextStatementIdx;
        while (this._nextStatementIdx < this._statementCount) {
            MemStatement st = (MemStatement)this._statements.get(this._nextStatementIdx);
            if (!(this._explicitOnly && !st.isExplicit() || this._subject != null && this._subject != st.getSubject() || this._predicate != null && this._predicate != st.getPredicate() || this._object != null && this._object != st.getObject())) {
                return true;
            }
            ++this._nextStatementIdx;
        }
        return false;
    }

    public boolean hasNext() {
        return this._nextStatementIdx < this._statementCount;
    }

    public Statement next() {
        Statement result2 = this._statements.get(this._nextStatementIdx);
        this._findNextStatement();
        return result2;
    }

    public void close() {
        this._statements = null;
        this._nextStatementIdx = this._statementCount;
        this._subject = null;
        this._predicate = null;
        this._object = null;
    }
}

