/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sail.query;

import java.util.Collection;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.sesame.sail.query.BooleanExpr;
import org.openrdf.sesame.sail.query.SailQueryException;
import org.openrdf.sesame.sail.query.StringExpr;

public class StringCompare
implements BooleanExpr {
    public static final int EQ = 1;
    public static final int NE = 2;
    private StringExpr _leftArg;
    private StringExpr _rightArg;
    private int _operator;

    public StringCompare(StringExpr leftArg, StringExpr rightArg) {
        this(leftArg, rightArg, 1);
    }

    public StringCompare(StringExpr leftArg, StringExpr rightArg, int op) {
        if (op != 1 && op != 2) {
            throw new IllegalArgumentException("Illegal operator value: " + op);
        }
        this._leftArg = leftArg;
        this._rightArg = rightArg;
        this._operator = op;
    }

    public StringExpr getLeftArg() {
        return this._leftArg;
    }

    public StringExpr getRightArg() {
        return this._rightArg;
    }

    public int getOperator() {
        return this._operator;
    }

    public boolean isTrue(RdfSource rdfSource) throws SailQueryException {
        String leftVal = this._leftArg.getString();
        String rightVal = this._rightArg.getString();
        boolean result2 = leftVal == null ? rightVal == null : leftVal.equals(rightVal);
        if (this._operator == 2) {
            result2 = !result2;
        }
        return result2;
    }

    public void getVariables(Collection variables) {
        this._leftArg.getVariables(variables);
        this._rightArg.getVariables(variables);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(32);
        buf.append('(');
        buf.append(this._leftArg.toString());
        buf.append(this._operator == 1 ? " = " : " != ");
        buf.append(this._rightArg.toString());
        buf.append(')');
        return buf.toString();
    }
}

