/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sail.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.sesame.sail.query.GraphPattern;
import org.openrdf.sesame.sail.query.GraphPatternQuery;
import org.openrdf.sesame.sail.query.QueryAnswer;
import org.openrdf.sesame.sail.query.QueryAnswerListener;
import org.openrdf.sesame.sail.query.TriplePattern;
import org.openrdf.sesame.sail.query.Var;

public class ConstructQuery
extends GraphPatternQuery {
    private TriplePattern[] _projection;
    private Set _anonymousVars = new HashSet(8);

    public ConstructQuery(boolean distinct2, List projection, GraphPattern graphPattern) {
        this(distinct2, 0, Integer.MAX_VALUE, projection, graphPattern);
    }

    public ConstructQuery(boolean distinct2, int offset, int limit, List projection, GraphPattern graphPattern) {
        super(distinct2, offset, limit, graphPattern);
        this.setProjection(projection);
    }

    public TriplePattern[] getProjection() {
        return this._projection;
    }

    public void setProjection(List projection) {
        TriplePattern[] projArray = new TriplePattern[projection.size()];
        projArray = projection.toArray(projArray);
        this.setProjection(projArray);
    }

    public void setProjection(TriplePattern[] projection) {
        this._projection = projection;
        this._anonymousVars.clear();
        for (int i = 0; i < projection.length; ++i) {
            TriplePattern tp = projection[i];
            if (tp.getSubjectVar().isAnonymous()) {
                this._anonymousVars.add(tp.getSubjectVar());
            }
            if (tp.getPredicateVar().isAnonymous()) {
                this._anonymousVars.add(tp.getPredicateVar());
            }
            if (!tp.getObjectVar().isAnonymous()) continue;
            this._anonymousVars.add(tp.getObjectVar());
        }
    }

    public void getProjectionVariables(Collection variables) {
        for (int i = 0; i < this._projection.length; ++i) {
            this._projection[i].getVariables(variables);
        }
    }

    public String[] getColumnHeaders() {
        return new String[]{"subject", "predicate", "object"};
    }

    protected boolean _reportQueryAnswer(RdfSource rdfSource, QueryAnswerListener listener) throws IOException {
        int i;
        ArrayList<Var> filledVars = new ArrayList<Var>(8);
        ValueFactory valFactory = rdfSource.getValueFactory();
        Iterator iter2 = this._anonymousVars.iterator();
        while (iter2.hasNext()) {
            Var var = (Var)iter2.next();
            if (var.hasValue()) continue;
            var.setValue(valFactory.createBNode());
            filledVars.add(var);
        }
        boolean reportMore = true;
        for (i = 0; reportMore && i < this._projection.length; ++i) {
            TriplePattern tp = this._projection[i];
            Value subject = tp.getSubjectVar().getValue();
            Value predicate = tp.getPredicateVar().getValue();
            Value object = tp.getObjectVar().getValue();
            if (subject == null || predicate == null || object == null) continue;
            Value[] values = new Value[]{subject, predicate, object};
            reportMore = listener.queryAnswer(new QueryAnswer(values));
        }
        for (i = 0; i < filledVars.size(); ++i) {
            Var var = (Var)filledVars.get(i);
            var.setValue(null);
        }
        return reportMore;
    }

    public String toString() {
        StringBuffer result2 = new StringBuffer(256);
        result2.append("construct ");
        if (this.isDistinct()) {
            result2.append("distinct ");
        }
        for (int i = 0; i < this._projection.length; ++i) {
            if (i > 0) {
                result2.append(", ");
            }
            result2.append(this._projection[i].toString());
        }
        result2.append("\nfrom\n");
        result2.append(this.getGraphPattern().toString());
        if (this.hasLimit()) {
            result2.append("\nlimit ").append(this.getLimit());
        }
        if (this.hasOffset()) {
            result2.append("\noffset ").append(this.getOffset());
        }
        return result2.toString();
    }
}

