/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sail;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.sesame.sail.Sail;
import org.openrdf.sesame.sail.StackedSail;
import org.openrdf.sesame.sail.StatementIterator;

public class SailUtil {
    public static Sail findSailInStack(Sail topSail, Class sailClass) {
        if (sailClass == null) {
            return null;
        }
        Sail currentSail = topSail;
        while (currentSail != null && !sailClass.isInstance(currentSail)) {
            if (currentSail instanceof StackedSail) {
                currentSail = ((StackedSail)currentSail).getBaseSail();
                continue;
            }
            currentSail = null;
        }
        return currentSail;
    }

    public static boolean modelsEqual(RdfSource rdfSource1, RdfSource rdfSource2) {
        List model1 = SailUtil._getListFromSource(rdfSource1);
        List model2 = SailUtil._getListFromSource(rdfSource2);
        if (model1.size() != model2.size()) {
            return false;
        }
        return SailUtil._isSubset(model1, model2);
    }

    private static List _getListFromSource(RdfSource source) {
        LinkedList<Statement> model = new LinkedList<Statement>();
        StatementIterator statIter = source.getStatements(null, null, null);
        while (statIter.hasNext()) {
            model.add(statIter.next());
        }
        statIter.close();
        return model;
    }

    public static boolean isSubset(RdfSource rdfSource1, RdfSource rdfSource2) {
        List model1 = SailUtil._getListFromSource(rdfSource1);
        List model2 = SailUtil._getListFromSource(rdfSource2);
        if (model1.size() > model2.size()) {
            return false;
        }
        return SailUtil._isSubset(model1, model2);
    }

    private static boolean _isSubset(List model1, List model2) {
        Iterator iter1 = model1.iterator();
        while (iter1.hasNext()) {
            Statement st = (Statement)iter1.next();
            if (st.getSubject() instanceof BNode || st.getObject() instanceof BNode) continue;
            boolean removed = model2.remove(st);
            if (removed) {
                iter1.remove();
                continue;
            }
            return false;
        }
        boolean result2 = SailUtil._matchModels(model1, model2, new HashMap(), 0);
        return result2;
    }

    protected static boolean _matchModels(List model1, List model2, Map bNodeMapping, int idx) {
        boolean result2 = false;
        Statement st1 = null;
        while (!(idx >= model1.size() || (st1 = (Statement)model1.get(idx)).getSubject() instanceof BNode && !bNodeMapping.containsKey(st1.getSubject()) || st1.getObject() instanceof BNode && !bNodeMapping.containsKey(st1.getObject()))) {
            ++idx;
        }
        if (idx < model1.size()) {
            List matchingStats = SailUtil._findMatchingStatements(st1, model2, bNodeMapping);
            Iterator iter2 = matchingStats.iterator();
            while (iter2.hasNext()) {
                Statement st2 = (Statement)iter2.next();
                HashMap<Value, Value> newBNodeMapping = new HashMap<Value, Value>(bNodeMapping);
                if (st1.getSubject() instanceof BNode && st2.getSubject() instanceof BNode) {
                    newBNodeMapping.put(st1.getSubject(), st2.getSubject());
                }
                if (st1.getObject() instanceof BNode && st2.getObject() instanceof BNode) {
                    newBNodeMapping.put(st1.getObject(), st2.getObject());
                }
                if (!(result2 = SailUtil._matchModels(model1, model2, newBNodeMapping, idx + 1))) continue;
                break;
            }
        } else {
            result2 = SailUtil._modelsEqual(model1, model2, bNodeMapping);
        }
        return result2;
    }

    protected static List _findMatchingStatements(Statement st, List model, Map bNodeMapping) {
        ArrayList<Statement> result2 = new ArrayList<Statement>();
        Iterator iter2 = model.iterator();
        while (iter2.hasNext()) {
            Statement modelSt = (Statement)iter2.next();
            if (!SailUtil._statementsMatch(st, modelSt, bNodeMapping)) continue;
            result2.add(modelSt);
        }
        return result2;
    }

    protected static boolean _statementsMatch(Statement st1, Statement st2, Map bNodeMapping) {
        URI pred2;
        URI pred1 = st1.getPredicate();
        if (!((Object)pred1).equals(pred2 = st2.getPredicate())) {
            return false;
        }
        Resource subj1 = st1.getSubject();
        Resource subj2 = st2.getSubject();
        if (!(subj1 instanceof BNode) && !subj1.equals(subj2)) {
            return false;
        }
        BNode mappedBNode = (BNode)bNodeMapping.get(subj1);
        if (mappedBNode != null && !subj2.equals(mappedBNode)) {
            return false;
        }
        Value obj1 = st1.getObject();
        Value obj2 = st2.getObject();
        if (!(obj1 instanceof BNode) && !obj1.equals(obj2)) {
            return false;
        }
        BNode mappedBNode2 = (BNode)bNodeMapping.get(obj1);
        return mappedBNode2 == null || obj2.equals(mappedBNode2);
    }

    protected static boolean _modelsEqual(List model1, List model2, Map bNodeMapping) {
        for (int i1 = 0; i1 < model1.size(); ++i1) {
            Statement st2;
            int i2;
            Statement st1 = (Statement)model1.get(i1);
            for (i2 = 0; i2 < model2.size() && !SailUtil._statementsMatch(st1, st2 = (Statement)model2.get(i2), bNodeMapping); ++i2) {
            }
            if (i2 < model2.size()) continue;
            return false;
        }
        return true;
    }
}

