/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.repository.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.config.RepositoryListBuilder;
import org.openrdf.sesame.config.RepositoryListListener;
import org.openrdf.sesame.config.RepositoryListReader;
import org.openrdf.sesame.config.UnknownRepositoryException;
import org.openrdf.sesame.constants.QueryResultFormat;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.repository.RepositoryList;
import org.openrdf.sesame.repository.SesameRepository;
import org.openrdf.sesame.repository.SesameService;
import org.openrdf.sesame.repository.remote.HTTPRepository;
import org.openrdf.util.http.CookieManager;
import org.openrdf.util.http.HttpClientUtil;
import org.openrdf.util.xml.XMLReaderFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class HTTPService
implements SesameService {
    private static final String LIST_REPOS_SERVLET = "servlets/listRepositories";
    private static final String LOGIN_SERVLET = "servlets/login";
    private static final String LOGOUT_SERVLET = "servlets/logout";
    private URL _serverURL;
    private URL _listReposURL;
    private URL _loginURL;
    private URL _logoutURL;
    private CookieManager _cookieManager;
    private QueryResultFormat _defaultTableQueryResultFormat = null;
    private RDFFormat _defaultGraphQueryResultFormat = null;

    public HTTPService(URL serverURL) {
        if (serverURL == null) {
            throw new IllegalArgumentException("serverURL must be specified");
        }
        this._serverURL = serverURL;
        try {
            this._listReposURL = HTTPService.resolveURL(serverURL, LIST_REPOS_SERVLET);
            this._loginURL = HTTPService.resolveURL(serverURL, LOGIN_SERVLET);
            this._logoutURL = HTTPService.resolveURL(serverURL, LOGOUT_SERVLET);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid base URL");
        }
        this._cookieManager = new CookieManager();
    }

    public void setDefaultTableQueryResultFormat(QueryResultFormat format2) {
        this._defaultTableQueryResultFormat = format2;
    }

    public void setDefaultGraphQueryResultFormat(RDFFormat format2) {
        this._defaultGraphQueryResultFormat = format2;
    }

    public void login(String username, String password) throws AccessDeniedException, IOException {
        if (username == null || username.trim().length() == 0) {
            throw new IllegalArgumentException("Illegal user name: " + username);
        }
        HashMap<String, String> postParams = new HashMap<String, String>(2);
        postParams.put("user", username.trim());
        if (password != null && password.trim().length() > 0) {
            postParams.put("password", password.trim());
        }
        HttpURLConnection conn = (HttpURLConnection)this._loginURL.openConnection();
        HttpClientUtil.preparePostRequest((HttpURLConnection)conn, postParams);
        conn.connect();
        int responseCode = conn.getResponseCode();
        if (responseCode != 200) {
            if (responseCode == 403) {
                throw new AccessDeniedException(conn.getResponseMessage());
            }
            throw new IOException(this._loginURL.toString() + ": " + conn.getResponseMessage());
        }
        this._cookieManager.clear();
        this._cookieManager.extractCookies((URLConnection)conn);
    }

    public void logout() throws IOException {
        HttpURLConnection conn = (HttpURLConnection)this._logoutURL.openConnection();
        HttpClientUtil.preparePostRequest((HttpURLConnection)conn, new HashMap(0));
        conn.connect();
        this._cookieManager.clear();
        conn.disconnect();
    }

    public RepositoryList getRepositoryList() throws IOException {
        RepositoryListBuilder listBuilder = new RepositoryListBuilder();
        this._listRepositories(listBuilder);
        return listBuilder.getRepositoryList();
    }

    protected void _listRepositories(RepositoryListListener list) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)this._listReposURL.openConnection();
        this._cookieManager.setCookies((URLConnection)conn);
        HttpClientUtil.setAcceptGZIPEncoding((URLConnection)conn);
        conn.connect();
        InputStream resultStream = HttpClientUtil.getInputStream((URLConnection)conn);
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            RepositoryListReader rlReader = new RepositoryListReader(xmlReader);
            rlReader.read(resultStream, list);
            resultStream.close();
        }
        catch (SAXException e) {
            Exception ne = e.getException();
            String msg = ne != null ? ne.getMessage() : e.getMessage();
            IOException ioe = new IOException("Unable to parse query results from Sesame: " + msg);
            ioe.initCause(e);
            throw ioe;
        }
    }

    public SesameRepository getRepository(String repositoryID) throws UnknownRepositoryException, IOException {
        RepositoryList repList = this.getRepositoryList();
        if (repList.getRepository(repositoryID) == null) {
            throw new UnknownRepositoryException(repositoryID);
        }
        try {
            HTTPRepository result2 = new HTTPRepository(this._serverURL, repositoryID, this._cookieManager);
            if (this._defaultTableQueryResultFormat != null) {
                result2.setTableQueryResultFormat(this._defaultTableQueryResultFormat);
            }
            if (this._defaultGraphQueryResultFormat != null) {
                result2.setGraphQueryResultFormat(this._defaultGraphQueryResultFormat);
            }
            return result2;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    static URL resolveURL(URL baseURL, String relPath) throws MalformedURLException {
        String protocol = baseURL.getProtocol();
        String host = baseURL.getHost();
        int port = baseURL.getPort();
        String file = baseURL.getFile();
        if (!file.endsWith("/")) {
            file = file + "/";
        }
        return new URL(protocol, host, port, file + relPath);
    }
}

