/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.serql.parser;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.rio.ntriples.NTriplesUtil;
import org.openrdf.sesame.query.GraphQuery;
import org.openrdf.sesame.query.TableQuery;
import org.openrdf.sesame.query.serql.parser.ParseException;
import org.openrdf.sesame.query.serql.parser.PathElement;
import org.openrdf.sesame.query.serql.parser.ReifiedPathElement;
import org.openrdf.sesame.query.serql.parser.SerqlParserConstants;
import org.openrdf.sesame.query.serql.parser.SerqlParserTokenManager;
import org.openrdf.sesame.query.serql.parser.SimpleCharStream;
import org.openrdf.sesame.query.serql.parser.Token;
import org.openrdf.sesame.sail.query.And;
import org.openrdf.sesame.sail.query.BooleanConstant;
import org.openrdf.sesame.sail.query.BooleanExpr;
import org.openrdf.sesame.sail.query.CompareAll;
import org.openrdf.sesame.sail.query.CompareAny;
import org.openrdf.sesame.sail.query.ConstructQuery;
import org.openrdf.sesame.sail.query.Datatype;
import org.openrdf.sesame.sail.query.Exists;
import org.openrdf.sesame.sail.query.GraphPattern;
import org.openrdf.sesame.sail.query.In;
import org.openrdf.sesame.sail.query.Intersect;
import org.openrdf.sesame.sail.query.IsBNode;
import org.openrdf.sesame.sail.query.IsLiteral;
import org.openrdf.sesame.sail.query.IsResource;
import org.openrdf.sesame.sail.query.IsURI;
import org.openrdf.sesame.sail.query.Label;
import org.openrdf.sesame.sail.query.Lang;
import org.openrdf.sesame.sail.query.Like;
import org.openrdf.sesame.sail.query.LiteralExpr;
import org.openrdf.sesame.sail.query.LocalName;
import org.openrdf.sesame.sail.query.Minus;
import org.openrdf.sesame.sail.query.Namespace;
import org.openrdf.sesame.sail.query.Not;
import org.openrdf.sesame.sail.query.Null;
import org.openrdf.sesame.sail.query.Or;
import org.openrdf.sesame.sail.query.ProjectionElem;
import org.openrdf.sesame.sail.query.Query;
import org.openrdf.sesame.sail.query.ResourceExpr;
import org.openrdf.sesame.sail.query.SelectQuery;
import org.openrdf.sesame.sail.query.StringConstant;
import org.openrdf.sesame.sail.query.Union;
import org.openrdf.sesame.sail.query.ValueCompare;
import org.openrdf.sesame.sail.query.ValueExpr;
import org.openrdf.sesame.sail.query.Var;
import org.openrdf.util.xml.XmlDatatypeUtil;

public class SerqlParser
implements SerqlParserConstants {
    public static final String SERQL_NS = "http://www.openrdf.org/schema/serql#";
    public static final URI SERQL_DIRECTSUBCLASSOF = new URIImpl("http://www.openrdf.org/schema/serql#directSubClassOf");
    public static final URI SERQL_DIRECTSUBPROPERTYOF = new URIImpl("http://www.openrdf.org/schema/serql#directSubPropertyOf");
    public static final URI SERQL_DIRECTTYPE = new URIImpl("http://www.openrdf.org/schema/serql#directType");
    public static final URI XSD_INTEGER = new URIImpl("http://www.w3.org/2001/XMLSchema#integer");
    public static final URI XSD_DECIMAL = new URIImpl("http://www.w3.org/2001/XMLSchema#decimal");
    static final Var RDF_TYPE_VAR = new Var("_rdfType", URIImpl.RDF_TYPE);
    static final Var RDF_STATEMENT_VAR = new Var("_rdfStatement", URIImpl.RDF_STATEMENT);
    static final Var RDF_SUBJECT_VAR = new Var("_rdfSubject", URIImpl.RDF_SUBJECT);
    static final Var RDF_PREDICATE_VAR = new Var("_rdfPredicate", URIImpl.RDF_PREDICATE);
    static final Var RDF_OBJECT_VAR = new Var("_rdfObject", URIImpl.RDF_OBJECT);
    protected Map _namespaces = new HashMap(16);
    protected List _sharedVars = new ArrayList(16);
    protected List _unboundVars = new ArrayList(16);
    protected VarTreeNode _currentTreeNode = new VarTreeNode();
    protected int _varNo = 0;
    public SerqlParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[52];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    protected void _checkUnboundVars() throws ParseException {
        if (!this._unboundVars.isEmpty()) {
            String msg = "Unbound variable(s): ";
            for (int i = 0; i < this._unboundVars.size(); ++i) {
                Var var = (Var)this._unboundVars.get(i);
                if (i > 0) {
                    msg = msg + ", ";
                }
                msg = msg + var.getName();
            }
            throw new ParseException(msg);
        }
    }

    protected void _checkVariableScoping() throws ParseException {
        while (!this._currentTreeNode.isRoot()) {
            this._currentTreeNode = this._currentTreeNode.getParent();
        }
        this._checkVariableScoping(this._currentTreeNode);
    }

    protected void _checkVariableScoping(VarTreeNode current) throws ParseException {
        block3: {
            block2: {
                List children = current.getChildren();
                if (children.size() <= 0) break block2;
                for (int i = 0; i < children.size(); ++i) {
                    VarTreeNode child = (VarTreeNode)children.get(i);
                    this._checkVariableScoping(child);
                }
                break block3;
            }
            VarTreeNode parent = current.getParent();
            if (parent == null) break block3;
            List sharedVars = current.getSharedWithSiblings();
            int sharedCount = sharedVars.size();
            for (int i = 0; i < sharedCount; ++i) {
                Var sharedVar = (Var)sharedVars.get(i);
                if (parent.containsVar(sharedVar)) continue;
                throw new ParseException("Shared variable " + sharedVar.getName() + " not bound in parent path expression.");
            }
        }
    }

    protected void _setNamespacePrefix(String prefix, String namespace) throws ParseException {
        if (this._namespaces.containsKey(prefix)) {
            throw new ParseException("Prefix \"" + prefix + "\" already in use.");
        }
        this._namespaces.put(prefix, namespace);
    }

    protected String _getNamespace(String prefix) {
        String result2 = (String)this._namespaces.get(prefix);
        if (result2 == null) {
            if ("rdf".equals(prefix)) {
                result2 = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
            } else if ("rdfs".equals(prefix)) {
                result2 = "http://www.w3.org/2000/01/rdf-schema#";
            } else if ("xsd".equals(prefix)) {
                result2 = "http://www.w3.org/2001/XMLSchema#";
            } else if ("owl".equals(prefix)) {
                result2 = "http://www.w3.org/2002/07/owl#";
            } else if ("serql".equals(prefix)) {
                result2 = SERQL_NS;
            }
        }
        return result2;
    }

    protected Var _getSharedVar(String varName) {
        Var var;
        Iterator i = this._sharedVars.iterator();
        while (i.hasNext()) {
            var = (Var)i.next();
            if (!var.getName().equals(varName)) continue;
            this._currentTreeNode.addVariable(var);
            return var;
        }
        var = new Var(varName);
        this._sharedVars.add(var);
        this._unboundVars.add(var);
        this._currentTreeNode.addVariable(var);
        return var;
    }

    protected Var _createAnonymousVar() {
        Var result2 = new Var("_" + this._varNo++);
        result2.setAnonymous(true);
        return result2;
    }

    protected URI _parseURI(String uri2) throws ParseException {
        if (uri2.startsWith("<")) {
            return this._parseFullURI(uri2);
        }
        return this._parseQName(uri2);
    }

    protected URI _parseFullURI(String uri2) throws ParseException {
        return new URIImpl(uri2.substring(1, uri2.length() - 1));
    }

    protected URI _parseQName(String uri2) throws ParseException {
        int colonIdx = uri2.indexOf(":");
        String prefix = uri2.substring(0, colonIdx);
        String localName = uri2.substring(colonIdx + 1);
        String namespace = this._getNamespace(prefix);
        if (namespace == null) {
            throw new ParseException("Prefix \"" + prefix + "\" not defined.");
        }
        return new URIImpl(namespace + localName);
    }

    protected BNode _parseBNode(String bnode) throws ParseException {
        return new BNodeImpl(bnode.substring(2));
    }

    protected Literal _parseLiteral(String literal) throws ParseException {
        int endLabelIdx = this._findEndOfLabel(literal);
        int startLangIdx = literal.indexOf("@", endLabelIdx);
        int startDtIdx = literal.indexOf("^^", Math.max(endLabelIdx, startLangIdx));
        String label = literal.substring(1, endLabelIdx);
        label = NTriplesUtil.unescapeString((String)label);
        if (startLangIdx != -1) {
            String language2 = literal.substring(startLangIdx + 1);
            return new LiteralImpl(label, language2);
        }
        if (startDtIdx != -1) {
            String dtString = literal.substring(startDtIdx + 2);
            URI datatype = this._parseURI(dtString);
            if (XmlDatatypeUtil.isBuiltInDatatype((String)datatype.getURI())) {
                try {
                    label = XmlDatatypeUtil.normalize((String)label, (String)datatype.getURI());
                }
                catch (IllegalArgumentException e) {
                    throw new ParseException(e.getMessage());
                }
            }
            return new LiteralImpl(label, datatype);
        }
        return new LiteralImpl(label);
    }

    private int _findEndOfLabel(String literal) throws ParseException {
        boolean previousWasBackslash = false;
        for (int i = 1; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            if (c == '\"' && !previousWasBackslash) {
                return i;
            }
            if (c == '\\' && !previousWasBackslash) {
                previousWasBackslash = true;
                continue;
            }
            if (!previousWasBackslash) continue;
            previousWasBackslash = false;
        }
        throw new ParseException("Could not find end of literal label");
    }

    protected ParseException _createParseException(Token currentTokenVal, String[] tokenImage) {
        int length = tokenImage.length;
        String[] newTokenImage = new String[length + 1];
        newTokenImage[0] = "<EOF>";
        for (int i = 0; i < length; ++i) {
            newTokenImage[i + 1] = tokenImage[i];
        }
        int[][] expectedTokenSequences = new int[1][length];
        for (int i = 0; i < length; ++i) {
            expectedTokenSequences[0][i] = i + 1;
        }
        return new ParseException(currentTokenVal, expectedTokenSequences, newTokenImage);
    }

    public final TableQuery parseTableQuery() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                this.namespace_list();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        Query qc = this.table_query_set();
        this.jj_consume_token(0);
        this._checkUnboundVars();
        this._checkVariableScoping();
        return new TableQuery(qc);
    }

    public final Query table_query_set() throws ParseException {
        Query result2 = null;
        Query rightArg = null;
        boolean all = false;
        result2 = this.table_query();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 49: 
            case 50: 
            case 51: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 49: {
                        this.jj_consume_token(49);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 53: {
                                this.jj_consume_token(53);
                                all = true;
                                break;
                            }
                            default: {
                                this.jj_la1[1] = this.jj_gen;
                            }
                        }
                        rightArg = this.table_query_set();
                        result2 = new Union(result2, rightArg, all);
                        break block0;
                    }
                    case 50: {
                        this.jj_consume_token(50);
                        rightArg = this.table_query_set();
                        result2 = new Minus(result2, rightArg, all);
                        break block0;
                    }
                    case 51: {
                        this.jj_consume_token(51);
                        rightArg = this.table_query_set();
                        result2 = new Intersect(result2, rightArg, all);
                        break block0;
                    }
                }
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        return result2;
    }

    public final Query table_query() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                Query qc = this.table_query_set();
                this.jj_consume_token(18);
                return qc;
            }
            case 24: {
                Query qc = this.select_query();
                return qc;
            }
        }
        this.jj_la1[4] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final GraphQuery parseGraphQuery() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                this.namespace_list();
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        Query qc = this.graph_query_set();
        this.jj_consume_token(0);
        this._checkUnboundVars();
        this._checkVariableScoping();
        return new GraphQuery(qc, new HashMap(this._namespaces));
    }

    public final Query graph_query_set() throws ParseException {
        Query result2 = null;
        Query rightArg = null;
        boolean all = false;
        result2 = this.graph_query();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 49: 
            case 50: 
            case 51: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 49: {
                        this.jj_consume_token(49);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 53: {
                                this.jj_consume_token(53);
                                all = true;
                                break;
                            }
                            default: {
                                this.jj_la1[6] = this.jj_gen;
                            }
                        }
                        rightArg = this.graph_query_set();
                        result2 = new Union(result2, rightArg, all);
                        break block0;
                    }
                    case 50: {
                        this.jj_consume_token(50);
                        rightArg = this.graph_query_set();
                        result2 = new Minus(result2, rightArg, all);
                        break block0;
                    }
                    case 51: {
                        this.jj_consume_token(51);
                        rightArg = this.graph_query_set();
                        result2 = new Intersect(result2, rightArg, all);
                        break block0;
                    }
                }
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        return result2;
    }

    public final Query graph_query() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                Query qc = this.graph_query_set();
                this.jj_consume_token(18);
                return qc;
            }
            case 25: {
                Query qc = this.construct_query();
                return qc;
            }
        }
        this.jj_la1[9] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void namespace_list() throws ParseException {
        this.jj_consume_token(22);
        this.jj_consume_token(23);
        this.namespace();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(13);
            this.namespace();
        }
    }

    public final void namespace() throws ParseException {
        Token prefixToken = this.jj_consume_token(72);
        this.jj_consume_token(6);
        ResourceExpr uri2 = this.full_uri();
        String prefix = prefixToken.image;
        this._setNamespacePrefix(prefix, uri2.getString());
    }

    public final Query select_query() throws ParseException {
        boolean distinct2 = false;
        GraphPattern graphPattern = new GraphPattern();
        boolean hasLimit = false;
        boolean hasOffset = false;
        int limit = -1;
        int offset = -1;
        this.jj_consume_token(24);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 26: {
                this.jj_consume_token(26);
                distinct2 = true;
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        ArrayList<ProjectionElem> projection = this.projection();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                this.jj_consume_token(27);
                this.graph_pattern(graphPattern);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: {
                this.jj_consume_token(29);
                limit = this.pos_integer();
                hasLimit = true;
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                offset = this.pos_integer();
                hasOffset = true;
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
        if (projection == null) {
            HashSet gpVariables = new HashSet();
            graphPattern.getVariables(gpVariables);
            ArrayList projVars = new ArrayList(this._sharedVars);
            projVars.retainAll(gpVariables);
            projection = new ArrayList<ProjectionElem>(projVars.size());
            for (int i = 0; i < projVars.size(); ++i) {
                Var var = (Var)projVars.get(i);
                projection.add(new ProjectionElem(var));
            }
        }
        if (projection.isEmpty()) {
            throw new ParseException("Select clause does not contain any variables.");
        }
        SelectQuery result2 = new SelectQuery(distinct2, projection, graphPattern);
        if (hasLimit) {
            result2.setLimit(limit);
        }
        if (hasOffset) {
            result2.setOffset(offset);
        }
        return result2;
    }

    public final Query construct_query() throws ParseException {
        boolean distinct2 = false;
        GraphPattern constructExpressions = null;
        GraphPattern graphPattern = new GraphPattern();
        boolean hasLimit = false;
        boolean hasOffset = false;
        int limit = -1;
        int offset = -1;
        this.jj_consume_token(25);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 26: {
                this.jj_consume_token(26);
                distinct2 = true;
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                this.jj_consume_token(12);
                break;
            }
            case 15: 
            case 19: {
                constructExpressions = new GraphPattern();
                this.path_expr_list(constructExpressions);
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                this.jj_consume_token(27);
                this.graph_pattern(graphPattern);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: {
                this.jj_consume_token(29);
                limit = this.pos_integer();
                hasLimit = true;
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                offset = this.pos_integer();
                hasOffset = true;
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        if (constructExpressions == null) {
            constructExpressions = graphPattern;
        }
        ArrayList constructList = new ArrayList(constructExpressions.getPathExpressionsRecursively());
        ConstructQuery result2 = new ConstructQuery(distinct2, constructList, graphPattern);
        if (hasLimit) {
            result2.setLimit(limit);
        }
        if (hasOffset) {
            result2.setOffset(offset);
        }
        return result2;
    }

    public final List projection() throws ParseException {
        ArrayList<ProjectionElem> projection = new ArrayList<ProjectionElem>(16);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                this.jj_consume_token(12);
                return null;
            }
            case 21: 
            case 23: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 56: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 81: 
            case 82: 
            case 83: {
                ProjectionElem projElem = this.projection_elem();
                projection.add(projElem);
                block7: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 13: {
                            break;
                        }
                        default: {
                            this.jj_la1[20] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(13);
                    projElem = this.projection_elem();
                    projection.add(projElem);
                }
                return projection;
            }
        }
        this.jj_la1[21] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ProjectionElem projection_elem() throws ParseException {
        String alias = null;
        ValueExpr item = this.var_or_value();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 48: {
                this.jj_consume_token(48);
                alias = this.string();
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
            }
        }
        return new ProjectionElem(item, alias);
    }

    public final void graph_pattern(GraphPattern graphPattern) throws ParseException {
        this.path_expr_list(graphPattern);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                BooleanExpr where = this.boolean_expr();
                graphPattern.addConstraint(where);
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
            }
        }
    }

    public final void path_expr_list(GraphPattern graphPattern) throws ParseException {
        this.path_expr(graphPattern);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: {
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(13);
            this.path_expr(graphPattern);
        }
    }

    public final void path_expr(GraphPattern graphPattern) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                PathElement pe = this.path_expr_head(graphPattern);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: 
                    case 19: 
                    case 21: 
                    case 68: 
                    case 71: 
                    case 72: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 19: 
                            case 21: 
                            case 68: 
                            case 71: 
                            case 72: {
                                this.path_expr_tail(pe.getObjectVars(), graphPattern);
                                break block0;
                            }
                            case 14: {
                                this.jj_consume_token(14);
                                this.path_expr_tail(pe.getSubjectVars(), graphPattern);
                                break block0;
                            }
                        }
                        this.jj_la1[25] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[26] = this.jj_gen;
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                GraphPattern optionalGP = new GraphPattern();
                VarTreeNode node = new VarTreeNode();
                this._currentTreeNode.addChild(node);
                this._currentTreeNode = node;
                this.graph_pattern(optionalGP);
                this.jj_consume_token(20);
                graphPattern.addOptional(optionalGP);
                this._currentTreeNode = this._currentTreeNode.getParent();
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final PathElement path_expr_head(GraphPattern graphPattern) throws ParseException {
        List leftNode = this.node(graphPattern);
        Var edge = this.edge();
        List rightNode = this.node(graphPattern);
        PathElement pe = new PathElement(leftNode, edge, rightNode);
        graphPattern.addAll(pe.getTriplePatterns());
        return pe;
    }

    public final void path_expr_tail(List leftNode, GraphPattern graphPattern) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: 
            case 68: 
            case 71: 
            case 72: {
                Var edge = this.edge();
                List rightNode = this.node(graphPattern);
                PathElement pe = new PathElement(leftNode, edge, rightNode);
                graphPattern.addAll(pe.getTriplePatterns());
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: 
                    case 19: 
                    case 21: 
                    case 68: 
                    case 71: 
                    case 72: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 19: 
                            case 21: 
                            case 68: 
                            case 71: 
                            case 72: {
                                this.path_expr_tail(rightNode, graphPattern);
                                break block0;
                            }
                            case 14: {
                                this.jj_consume_token(14);
                                this.path_expr_tail(leftNode, graphPattern);
                                break block0;
                            }
                        }
                        this.jj_la1[28] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[29] = this.jj_gen;
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                GraphPattern optionalGP = new GraphPattern();
                VarTreeNode node = new VarTreeNode();
                this._currentTreeNode.addChild(node);
                this._currentTreeNode = node;
                Var edge = this.edge();
                List rightNode = this.node(optionalGP);
                PathElement pe = new PathElement(leftNode, edge, rightNode);
                optionalGP.addAll(pe.getTriplePatterns());
                block11 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: 
                    case 19: 
                    case 21: 
                    case 68: 
                    case 71: 
                    case 72: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 19: 
                            case 21: 
                            case 68: 
                            case 71: 
                            case 72: {
                                this.path_expr_tail(rightNode, optionalGP);
                                break block11;
                            }
                            case 14: {
                                this.jj_consume_token(14);
                                this.path_expr_tail(leftNode, optionalGP);
                                break block11;
                            }
                        }
                        this.jj_la1[30] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[31] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 28: {
                        this.jj_consume_token(28);
                        BooleanExpr where = this.boolean_expr();
                        optionalGP.addConstraint(where);
                        break;
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                    }
                }
                this.jj_consume_token(20);
                graphPattern.addOptional(optionalGP);
                this._currentTreeNode = this._currentTreeNode.getParent();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: {
                        this.jj_consume_token(14);
                        this.path_expr_tail(leftNode, graphPattern);
                        break block0;
                    }
                }
                this.jj_la1[33] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Var edge() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: 
            case 72: {
                Var var = this.var();
                this._unboundVars.remove(var);
                return var;
            }
            case 68: 
            case 71: {
                ResourceExpr uri2 = this.uri();
                Var var = this._createAnonymousVar();
                var.setValue(uri2.getValue());
                return var;
            }
        }
        this.jj_la1[35] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final List node(GraphPattern graphPattern) throws ParseException {
        ArrayList<Var> nodeElements = new ArrayList<Var>(4);
        this.jj_consume_token(15);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: 
            case 21: 
            case 56: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 81: 
            case 82: 
            case 83: {
                Var var = this.node_elem(graphPattern);
                nodeElements.add(var);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 13: {
                            break;
                        }
                        default: {
                            this.jj_la1[36] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(13);
                    var = this.node_elem(graphPattern);
                    nodeElements.add(var);
                }
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
            }
        }
        this.jj_consume_token(16);
        if (nodeElements.isEmpty()) {
            nodeElements.add(this._createAnonymousVar());
        }
        for (int i = 0; i < nodeElements.size() - 1; ++i) {
            Var var1 = (Var)nodeElements.get(i);
            for (int j = i + 1; j < nodeElements.size(); ++j) {
                Var var2 = (Var)nodeElements.get(j);
                if (var1.hasValue() && var2.hasValue()) continue;
                graphPattern.addConstraint(new ValueCompare(var1, var2, 2));
            }
        }
        return nodeElements;
    }

    public final Var node_elem(GraphPattern graphPattern) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: 
            case 72: {
                Var var = this.var();
                this._unboundVars.remove(var);
                return var;
            }
            case 56: 
            case 68: 
            case 70: 
            case 71: 
            case 81: 
            case 82: 
            case 83: {
                ValueExpr valueExpr = this.uri_bnode_or_literal();
                Var var = this._createAnonymousVar();
                var.setValue(valueExpr.getValue());
                return var;
            }
            case 15: {
                Var var = this.reified_stat(graphPattern);
                return var;
            }
        }
        this.jj_la1[38] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Var reified_stat(GraphPattern graphPattern) throws ParseException {
        List leftNode = this.node(graphPattern);
        Var edge = this.edge();
        List rightNode = this.node(graphPattern);
        Var id = this._createAnonymousVar();
        ReifiedPathElement reifiedPE = new ReifiedPathElement(id, leftNode, edge, rightNode);
        graphPattern.addAll(reifiedPE.getTriplePatterns());
        return id;
    }

    public final BooleanExpr boolean_expr() throws ParseException {
        BooleanExpr result2 = this.and_expr();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: {
                this.jj_consume_token(35);
                BooleanExpr rightExpr = this.boolean_expr();
                result2 = new Or(result2, rightExpr);
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
            }
        }
        return result2;
    }

    public final BooleanExpr and_expr() throws ParseException {
        BooleanExpr result2 = this.boolean_elem();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: {
                this.jj_consume_token(34);
                BooleanExpr rightExpr = this.and_expr();
                result2 = new And(result2, rightExpr);
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
            }
        }
        return result2;
    }

    public final BooleanExpr boolean_elem() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                BooleanExpr expr = this.boolean_expr();
                this.jj_consume_token(18);
                return expr;
            }
            case 31: {
                this.jj_consume_token(31);
                return BooleanConstant.TRUE;
            }
            case 32: {
                this.jj_consume_token(32);
                return BooleanConstant.FALSE;
            }
            case 33: {
                this.jj_consume_token(33);
                BooleanExpr expr = this.boolean_elem();
                return new Not(expr);
            }
            case 21: 
            case 23: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 56: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 81: 
            case 82: 
            case 83: {
                BooleanExpr expr = this.any_all_like_or_in();
                return expr;
            }
            case 44: {
                this.jj_consume_token(44);
                this.jj_consume_token(17);
                Var var = this.var();
                this.jj_consume_token(18);
                return new IsResource(var);
            }
            case 47: {
                this.jj_consume_token(47);
                this.jj_consume_token(17);
                Var var = this.var();
                this.jj_consume_token(18);
                return new IsLiteral(var);
            }
            case 46: {
                this.jj_consume_token(46);
                this.jj_consume_token(17);
                Var var = this.var();
                this.jj_consume_token(18);
                return new IsURI(var);
            }
            case 45: {
                this.jj_consume_token(45);
                this.jj_consume_token(17);
                Var var = this.var();
                this.jj_consume_token(18);
                return new IsBNode(var);
            }
            case 55: {
                this.jj_consume_token(55);
                this.jj_consume_token(17);
                Query qc = this.table_query_set();
                this.jj_consume_token(18);
                return new Exists(qc);
            }
        }
        this.jj_la1[41] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final BooleanExpr any_all_like_or_in() throws ParseException {
        boolean ignoreCase = false;
        ValueExpr leftValue = this.var_or_value();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                int op = this.comp_op();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: 
                    case 23: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 56: 
                    case 68: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 81: 
                    case 82: 
                    case 83: {
                        ValueExpr rightValue = this.var_or_value();
                        return new ValueCompare(leftValue, rightValue, op);
                    }
                    case 52: {
                        this.jj_consume_token(52);
                        this.jj_consume_token(17);
                        Query qc = this.table_query_set();
                        this.jj_consume_token(18);
                        return new CompareAny(leftValue, qc, op);
                    }
                    case 53: {
                        this.jj_consume_token(53);
                        this.jj_consume_token(17);
                        Query qc = this.table_query_set();
                        this.jj_consume_token(18);
                        return new CompareAll(leftValue, qc, op);
                    }
                }
                this.jj_la1[42] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 36: {
                this.jj_consume_token(36);
                String pattern = this.string();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 37: {
                        this.jj_consume_token(37);
                        this.jj_consume_token(38);
                        ignoreCase = true;
                        break;
                    }
                    default: {
                        this.jj_la1[43] = this.jj_gen;
                    }
                }
                return new Like(leftValue, new StringConstant(pattern), ignoreCase);
            }
            case 54: {
                this.jj_consume_token(54);
                this.jj_consume_token(17);
                Query qc = this.table_query_set();
                this.jj_consume_token(18);
                if (qc.getColumnHeaders().length != 1) {
                    throw new ParseException("Query argument for IN operator must have exactly one column.");
                }
                return new In(leftValue, qc);
            }
        }
        this.jj_la1[44] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int comp_op() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                return 1;
            }
            case 7: {
                this.jj_consume_token(7);
                return 2;
            }
            case 8: {
                this.jj_consume_token(8);
                return 3;
            }
            case 9: {
                this.jj_consume_token(9);
                return 4;
            }
            case 10: {
                this.jj_consume_token(10);
                return 5;
            }
            case 11: {
                this.jj_consume_token(11);
                return 6;
            }
        }
        this.jj_la1[45] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueExpr var_or_value() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: 
            case 72: {
                Var expr = this.var();
                return expr;
            }
            case 23: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 56: 
            case 68: 
            case 70: 
            case 71: 
            case 81: 
            case 82: 
            case 83: {
                ValueExpr expr = this.value();
                return expr;
            }
        }
        this.jj_la1[46] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueExpr uri_bnode_or_literal() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 68: 
            case 71: {
                ResourceExpr expr = this.uri();
                return expr;
            }
            case 70: {
                ResourceExpr expr = this.bnode();
                return expr;
            }
            case 56: 
            case 81: 
            case 82: 
            case 83: {
                LiteralExpr expr = this.literal();
                return expr;
            }
        }
        this.jj_la1[47] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Var var() throws ParseException {
        String varName = this.nc_name();
        return this._getSharedVar(varName);
    }

    public final ValueExpr value() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 68: 
            case 71: {
                ResourceExpr expr = this.uri();
                return expr;
            }
            case 70: {
                ResourceExpr expr = this.bnode();
                return expr;
            }
            case 56: 
            case 81: 
            case 82: 
            case 83: {
                LiteralExpr expr = this.literal();
                return expr;
            }
            case 43: {
                Null expr = this._null();
                return expr;
            }
            case 41: {
                this.jj_consume_token(41);
                this.jj_consume_token(17);
                Var var = this.var();
                this.jj_consume_token(18);
                return new Datatype(var);
            }
            case 40: {
                this.jj_consume_token(40);
                this.jj_consume_token(17);
                Var var = this.var();
                this.jj_consume_token(18);
                return new Lang(var);
            }
            case 39: {
                this.jj_consume_token(39);
                this.jj_consume_token(17);
                Var var = this.var();
                this.jj_consume_token(18);
                return new Label(var);
            }
            case 23: {
                this.jj_consume_token(23);
                this.jj_consume_token(17);
                Var var = this.var();
                this.jj_consume_token(18);
                return new Namespace(var);
            }
            case 42: {
                this.jj_consume_token(42);
                this.jj_consume_token(17);
                Var var = this.var();
                this.jj_consume_token(18);
                return new LocalName(var);
            }
        }
        this.jj_la1[48] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResourceExpr uri() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 68: {
                ResourceExpr expr = this.full_uri();
                return expr;
            }
            case 71: {
                ResourceExpr expr = this.qname();
                return expr;
            }
        }
        this.jj_la1[49] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResourceExpr full_uri() throws ParseException {
        Token uriToken = this.jj_consume_token(68);
        URI uri2 = this._parseFullURI(uriToken.image);
        ResourceExpr result2 = new ResourceExpr(uri2);
        return result2;
    }

    public final ResourceExpr qname() throws ParseException {
        Token uriToken = this.jj_consume_token(71);
        return new ResourceExpr(this._parseQName(uriToken.image));
    }

    public final ResourceExpr bnode() throws ParseException {
        Token bnodeToken = this.jj_consume_token(70);
        return new ResourceExpr(this._parseBNode(bnodeToken.image));
    }

    public final LiteralExpr literal() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 56: {
                Token token = this.jj_consume_token(56);
                return new LiteralExpr(this._parseLiteral(token.image));
            }
            case 81: {
                Token token = this.jj_consume_token(81);
                return new LiteralExpr(new LiteralImpl(XmlDatatypeUtil.normalizeInteger((String)token.image), XSD_INTEGER));
            }
            case 82: {
                Token token = this.jj_consume_token(82);
                return new LiteralExpr(new LiteralImpl(XmlDatatypeUtil.normalizeInteger((String)token.image), XSD_INTEGER));
            }
            case 83: {
                Token token = this.jj_consume_token(83);
                return new LiteralExpr(new LiteralImpl(XmlDatatypeUtil.normalizeDecimal((String)token.image), XSD_DECIMAL));
            }
        }
        this.jj_la1[50] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String nc_name() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 72: {
                Token token = this.jj_consume_token(72);
                return token.image;
            }
            case 21: {
                Token token = this.jj_consume_token(21);
                return token.image;
            }
        }
        this.jj_la1[51] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String string() throws ParseException {
        Token token;
        try {
            token = this.jj_consume_token(56);
        }
        catch (ParseException e) {
            throw this._createParseException(e.currentToken, new String[]{"<STRING>"});
        }
        Literal literal = this._parseLiteral(token.image);
        if (literal.getLanguage() != null || literal.getDatatype() != null) {
            throw new ParseException("Expected <STRING>, found <LITERAL>: " + literal.toString());
        }
        return literal.getLabel();
    }

    public final int pos_integer() throws ParseException {
        Token token = this.jj_consume_token(81);
        try {
            return Integer.parseInt(token.image);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
    }

    public final Null _null() throws ParseException {
        this.jj_consume_token(43);
        return new Null();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{0x400000, 0, 0, 0, 0x1020000, 0x400000, 0, 0, 0, 0x2020000, 8192, 0x4000000, 0x8000000, 0x20000000, 0x40000000, 0x4000000, 561152, 0x8000000, 0x20000000, 0x40000000, 8192, 0xA01000, 0, 0x10000000, 8192, 2637824, 2637824, 557056, 2637824, 2637824, 2637824, 2637824, 0x10000000, 16384, 0x280000, 0x200000, 8192, 0x208000, 0x208000, 0, 0, -2136866816, 0xA00000, 0, 4032, 4032, 0xA00000, 0, 0x800000, 0, 0, 0x200000};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0x200000, 917504, 917504, 0, 0, 0x200000, 917504, 917504, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16781184, 65536, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1000000, 0x1000000, 8, 4, 25231235, 19926912, 32, 0x400010, 0, 16781184, 0x1000000, 16781184, 0, 0x1000000, 0};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 917968, 0, 0, 0, 400, 400, 0, 400, 400, 400, 400, 0, 0, 400, 400, 0, 917968, 917968, 0, 0, 917968, 917968, 0, 0, 0, 917968, 917712, 917712, 144, 917504, 256};
    }

    public SerqlParser(InputStream stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new SerqlParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 52; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 52; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SerqlParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new SerqlParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 52; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 52; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SerqlParser(SerqlParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 52; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(SerqlParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 52; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[84];
        for (i = 0; i < 84; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 52; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 84; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        SerqlParser.jj_la1_0();
        SerqlParser.jj_la1_1();
        SerqlParser.jj_la1_2();
    }

    static class VarTreeNode {
        private VarTreeNode _parent;
        private List _variables = new ArrayList(8);
        private List _children = new ArrayList(4);

        public void addVariable(Var var) {
            this._variables.add(var);
        }

        public void addChild(VarTreeNode child) {
            this._children.add(child);
            child.setParent(this);
        }

        public void setParent(VarTreeNode parent) {
            this._parent = parent;
        }

        public List getVariables() {
            return this._variables;
        }

        public boolean containsVar(Var var) {
            return this._variables.contains(var);
        }

        public List getChildren() {
            return this._children;
        }

        public VarTreeNode getParent() {
            return this._parent;
        }

        public boolean isRoot() {
            return this._parent == null;
        }

        public String toString() {
            StringBuffer result2 = new StringBuffer(32);
            result2.append("(");
            for (int i = 0; i < this._variables.size(); ++i) {
                Var var = (Var)this._variables.get(i);
                result2.append(var.getName());
                result2.append(" ");
            }
            result2.append(")");
            return result2.toString();
        }

        public List getSharedWithSiblings() {
            if (this.isRoot()) {
                return new ArrayList(0);
            }
            ArrayList allVars = new ArrayList(this._variables);
            List siblings = this._parent.getChildren();
            int siblingCount = siblings.size();
            for (int i = 0; i < siblingCount; ++i) {
                VarTreeNode sibling = (VarTreeNode)siblings.get(i);
                if (this.equals(sibling)) continue;
                allVars.addAll(sibling.getVariables());
            }
            ArrayList<Var> result2 = new ArrayList<Var>();
            int varCount = allVars.size();
            for (int i = 0; i < varCount; ++i) {
                Var var = (Var)allVars.get(i);
                int occurrences = 0;
                for (int j = 0; j < siblingCount; ++j) {
                    VarTreeNode sibling = (VarTreeNode)siblings.get(j);
                    if (!sibling.containsVar(var)) continue;
                    ++occurrences;
                }
                if (occurrences <= true) continue;
                result2.add(var);
            }
            return result2;
        }
    }
}

