/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model;

import java.io.IOException;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.query.rql.model.PropertyQuery;
import org.openrdf.sesame.query.rql.model.iterators.NestedResourceIterator;
import org.openrdf.sesame.query.rql.model.iterators.StatementObjectIterator;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.ResourceIterator;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sail.ValueIterator;

public class SuperPropertyOf
implements PropertyQuery {
    protected PropertyQuery _propQ;
    protected boolean _recursive;

    public SuperPropertyOf(PropertyQuery propQ, boolean recursive) {
        this._propQ = propQ;
        this._recursive = recursive;
    }

    public void evaluate(RdfSchemaSource rss, TableQueryResultListener listener) throws QueryEvaluationException {
        ValueIterator iter2 = null;
        try {
            String[] columnHeaders = new String[]{this.getQuery()};
            listener.startTableQueryResult(columnHeaders);
            iter2 = this.getProperties(rss);
            while (iter2.hasNext()) {
                listener.startTuple();
                listener.tupleValue(iter2.next());
                listener.endTuple();
            }
            listener.endTableQueryResult();
        }
        catch (IOException e) {
            throw new QueryEvaluationException(e);
        }
        finally {
            if (iter2 != null) {
                iter2.close();
            }
        }
    }

    public PropertyQuery getArgument() {
        return this._propQ;
    }

    public ValueIterator getResources(RdfSchemaSource rss) throws QueryEvaluationException {
        return this.getProperties(rss);
    }

    public ResourceIterator getProperties(RdfSchemaSource rss) throws QueryEvaluationException {
        ResourceIterator propIter = this._propQ.getProperties(rss);
        return new Iterator(rss, propIter);
    }

    public boolean returnsSet() {
        return true;
    }

    public String getQuery() {
        return this.toString();
    }

    public String toString() {
        if (this._recursive) {
            return "superPropertyOf(" + this._propQ.toString() + ")";
        }
        return "superPropertyOf^(" + this._propQ.toString() + ")";
    }

    class Iterator
    extends NestedResourceIterator {
        protected RdfSchemaSource _rss;

        public Iterator(RdfSchemaSource rss, ResourceIterator propIter) {
            super(propIter);
            this._rss = rss;
        }

        public ResourceIterator getInnerIterator(Value property) {
            StatementIterator statIter = SuperPropertyOf.this._recursive ? this._rss.getSubPropertyOf((Resource)property, null) : this._rss.getDirectSubPropertyOf((Resource)property, null);
            return new StatementObjectIterator(statIter);
        }
    }
}

