/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model;

import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.query.rql.model.BooleanQuery;
import org.openrdf.sesame.query.rql.model.Domain;
import org.openrdf.sesame.query.rql.model.Intersection;
import org.openrdf.sesame.query.rql.model.Projection;
import org.openrdf.sesame.query.rql.model.Query;
import org.openrdf.sesame.query.rql.model.Range;
import org.openrdf.sesame.query.rql.model.ResourceQuery;
import org.openrdf.sesame.query.rql.model.Selector;
import org.openrdf.sesame.query.rql.model.URI;
import org.openrdf.sesame.query.rql.model.Var;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.ResourceIterator;
import org.openrdf.sesame.sail.ValueIterator;

public class SfwQuery
implements ResourceQuery {
    protected List _select;
    protected List _from;
    protected BooleanQuery _where;

    public SfwQuery(List select, List from2, BooleanQuery where) {
        this._select = select;
        this._from = from2;
        this._where = where;
    }

    public void evaluate(RdfSchemaSource rss, TableQueryResultListener listener) throws QueryEvaluationException {
        try {
            int size2 = this._select.size();
            Query projection = null;
            String[] columnHeaders = new String[size2];
            for (int i = 0; i < size2; ++i) {
                projection = (Query)this._select.get(i);
                columnHeaders[i] = projection.getQuery();
            }
            listener.startTableQueryResult(columnHeaders);
            boolean instantiated = this._findNext(rss, true);
            while (instantiated) {
                if (this._where == null || this._where.isTrue(rss)) {
                    this._exportResults(rss, listener);
                }
                instantiated = this._findNext(rss, false);
            }
            listener.endTableQueryResult();
        }
        catch (IOException e) {
            for (int i = this._from.size() - 1; i >= 0; --i) {
                Selector selector = (Selector)this._from.get(i);
                selector.clear();
            }
            throw new QueryEvaluationException(e);
        }
    }

    public ValueIterator getResources(RdfSchemaSource rss) throws QueryEvaluationException {
        return new SfwIterator(rss);
    }

    private boolean _findNext(RdfSchemaSource rss, boolean firstCall) throws QueryEvaluationException {
        Selector selector;
        int index;
        int lastIndex = this._from.size() - 1;
        if (firstCall) {
            index = 0;
            selector = (Selector)this._from.get(index);
            selector.initialize(rss);
        } else {
            index = lastIndex;
            selector = (Selector)this._from.get(index);
        }
        while (true) {
            if (selector.selectNext(rss)) {
                if (index == lastIndex) {
                    return true;
                }
                selector = (Selector)this._from.get(++index);
                selector.initialize(rss);
                continue;
            }
            selector.clear();
            if (index == 0) {
                return false;
            }
            selector = (Selector)this._from.get(--index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _exportResults(RdfSchemaSource rss, TableQueryResultListener listener) throws QueryEvaluationException {
        try {
            listener.startTuple();
            int selectSize = this._select.size();
            for (int i = 0; i < selectSize; ++i) {
                ResourceIterator iter2;
                ResourceQuery q = (ResourceQuery)this._select.get(i);
                if (q instanceof Var) {
                    Var var = (Var)q;
                    Value varValue = var.getValue();
                    listener.tupleValue(varValue);
                    continue;
                }
                if (q instanceof URI) {
                    URI uri2 = (URI)q;
                    listener.tupleValue(uri2.getValue());
                    continue;
                }
                if (q instanceof Domain) {
                    Domain domain = (Domain)q;
                    iter2 = domain.getClasses(rss);
                    try {
                        listener.tupleValue(iter2.next());
                        continue;
                    }
                    finally {
                        iter2.close();
                    }
                }
                if (q instanceof Range) {
                    Range range2 = (Range)q;
                    iter2 = range2.getClasses(rss);
                    try {
                        listener.tupleValue(iter2.next());
                        continue;
                    }
                    finally {
                        iter2.close();
                    }
                }
                if (!q.returnsSet()) continue;
                ResourceIterator iter3 = (ResourceIterator)q.getResources(rss);
                Intersection qResources = new Intersection();
                while (iter3.hasNext()) {
                    qResources.add((Resource)iter3.next());
                }
                try {
                    listener.tupleValue(qResources);
                    continue;
                }
                finally {
                    iter3.close();
                }
            }
            listener.endTuple();
        }
        catch (IOException e) {
            throw new QueryEvaluationException(e);
        }
    }

    public List getFromPart() {
        return this._from;
    }

    public void setFromPart(List from2) {
        this._from = from2;
    }

    public BooleanQuery getWherePart() {
        return this._where;
    }

    public void setWherePart(BooleanQuery newWhere) {
        this._where = newWhere;
    }

    public List getProjection() {
        return this._select;
    }

    public boolean returnsSet() {
        return true;
    }

    public String getQuery() {
        return this.toString();
    }

    public String toString() {
        StringBuffer result2 = new StringBuffer();
        result2.append("select ");
        int selectSize = this._select.size();
        if (selectSize == 0) {
            result2.append("*");
        } else {
            for (int i = 0; i < selectSize; ++i) {
                ResourceQuery q = (ResourceQuery)this._select.get(i);
                result2.append(q.toString());
                if (i >= selectSize - 1) continue;
                result2.append(", ");
            }
        }
        result2.append("\nfrom\n");
        int nofSelectors = this._from.size();
        for (int i = 0; i < nofSelectors; ++i) {
            Selector selector = (Selector)this._from.get(i);
            result2.append("\t");
            result2.append(selector.toString());
            if (i < nofSelectors - 1) {
                result2.append(", ");
            }
            result2.append("\n");
        }
        if (this._where != null) {
            result2.append("where ");
            result2.append(this._where.toString());
        }
        return result2.toString();
    }

    class SfwIterator
    implements ValueIterator {
        protected RdfSchemaSource _rss;
        protected boolean _hasNext;
        protected ResourceQuery[] _projQuery;
        protected int _projSize;
        protected int _projCounter;

        public SfwIterator(RdfSchemaSource rss) throws QueryEvaluationException {
            this._rss = rss;
            this._projCounter = 0;
            this._hasNext = false;
            this._projSize = SfwQuery.this._select.size();
            this._projQuery = new ResourceQuery[this._projSize];
            for (int i = 0; i < this._projSize; ++i) {
                this._projQuery[i] = (ResourceQuery)SfwQuery.this._select.get(i);
            }
            boolean resultFound = SfwQuery.this._findNext(rss, true);
            while (resultFound) {
                if (SfwQuery.this._where == null || SfwQuery.this._where.isTrue(rss)) {
                    this._hasNext = true;
                    break;
                }
                resultFound = SfwQuery.this._findNext(rss, false);
            }
        }

        public boolean hasNext() {
            return this._hasNext;
        }

        public Value next() throws QueryEvaluationException {
            if (this._hasNext) {
                Projection result2 = new Projection(SfwQuery.this._select.size());
                for (int i = 0; i < SfwQuery.this._select.size(); ++i) {
                    ValueIterator valIter = this._projQuery[i].getResources(this._rss);
                    if (valIter.hasNext()) {
                        result2.add(valIter.next());
                        continue;
                    }
                    result2.add(null);
                }
                boolean resultFound = SfwQuery.this._findNext(this._rss, false);
                this._hasNext = false;
                while (resultFound) {
                    if (SfwQuery.this._where == null || SfwQuery.this._where.isTrue(this._rss)) {
                        this._hasNext = true;
                        break;
                    }
                    resultFound = SfwQuery.this._findNext(this._rss, false);
                }
                return result2;
            }
            throw new NoSuchElementException();
        }

        public void close() {
            if (this._hasNext) {
                this._hasNext = false;
                for (int i = SfwQuery.this._from.size() - 1; i >= 0; --i) {
                    Selector selector = (Selector)SfwQuery.this._from.get(i);
                    selector.clear();
                }
            }
        }

        protected void finalize() {
            this.close();
        }
    }
}

