/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model;

import org.openrdf.model.Value;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.rql.model.BooleanQuery;
import org.openrdf.sesame.query.rql.model.Projection;
import org.openrdf.sesame.query.rql.model.ResourceQuery;
import org.openrdf.sesame.query.rql.model.SfwQuery;
import org.openrdf.sesame.query.rql.model.URI;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.ValueIterator;

public class In
implements BooleanQuery {
    protected ResourceQuery _arg1;
    protected ResourceQuery _arg2;

    public In(ResourceQuery arg1, ResourceQuery arg2) {
        this._arg1 = arg1;
        this._arg2 = arg2;
    }

    public ResourceQuery getArg1() {
        return this._arg1;
    }

    public ResourceQuery getArg2() {
        return this._arg2;
    }

    public boolean isTrue(RdfSchemaSource rss) throws QueryEvaluationException {
        ValueIterator iter1 = this._arg1.getResources(rss);
        if (iter1 == null) {
            throw new QueryEvaluationException("left operand is NULL in " + this.getQuery());
        }
        if (!iter1.hasNext()) {
            iter1.close();
            throw new QueryEvaluationException("left operand is missing in " + this.getQuery());
        }
        Value val1 = iter1.next();
        if (iter1.hasNext()) {
            iter1.close();
            throw new QueryEvaluationException("left operand has multiple values " + this.getQuery());
        }
        iter1.close();
        ValueIterator iter2 = null;
        iter2 = this._arg2 instanceof URI ? ((URI)this._arg2).getInstances(rss) : this._arg2.getResources(rss);
        if (iter2 == null) {
            throw new QueryEvaluationException("right operand is NULL in " + this.getQuery());
        }
        boolean result2 = false;
        if (this._arg2 instanceof SfwQuery) {
            while (iter2.hasNext()) {
                Projection projection = (Projection)iter2.next();
                if (projection.size() > 1) {
                    iter2.close();
                    throw new QueryEvaluationException("right operand of IN may only contain one variable.");
                }
                Value val2 = projection.get(0);
                if (!val1.equals(val2)) continue;
                result2 = true;
                break;
            }
        } else {
            while (iter2.hasNext()) {
                Value val2 = iter2.next();
                if (!val1.equals(val2)) continue;
                result2 = true;
                break;
            }
        }
        iter2.close();
        return result2;
    }

    public String getQuery() {
        return this.toString();
    }

    public String toString() {
        return this._arg1.toString() + " in " + this._arg2.toString();
    }
}

