/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model;

import java.io.IOException;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.query.rql.model.ClassQuery;
import org.openrdf.sesame.query.rql.model.Intersection;
import org.openrdf.sesame.query.rql.model.PropertyQuery;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.ResourceIterator;
import org.openrdf.sesame.sail.ValueIterator;

public class Domain
implements ClassQuery {
    protected PropertyQuery _propQ;

    public Domain(PropertyQuery propQ) {
        this._propQ = propQ;
    }

    public void evaluate(RdfSchemaSource rss, TableQueryResultListener listener) throws QueryEvaluationException {
        ResourceIterator iter2 = this.getClasses(rss);
        try {
            String[] columnHeaders = new String[]{this.getQuery()};
            listener.startTableQueryResult(columnHeaders);
            iter2 = this.getClasses(rss);
            while (iter2.hasNext()) {
                listener.startTuple();
                listener.tupleValue(iter2.next());
                listener.endTuple();
            }
            iter2.close();
            listener.endTableQueryResult();
        }
        catch (IOException e) {
            iter2.close();
            throw new QueryEvaluationException(e);
        }
    }

    public ValueIterator getResources(RdfSchemaSource rss) throws QueryEvaluationException {
        return this.getClasses(rss);
    }

    public ResourceIterator getClasses(RdfSchemaSource rss) throws QueryEvaluationException {
        ResourceIterator propIter = this._propQ.getProperties(rss);
        return new Iterator(rss, propIter);
    }

    public boolean returnsSet() {
        return false;
    }

    public String getQuery() {
        return "domain(" + this._propQ.toString() + ")";
    }

    public String toString() {
        return "domain(" + this._propQ.toString() + ")";
    }

    static class Iterator
    implements ResourceIterator {
        protected RdfSchemaSource _rss;
        protected ResourceIterator _propIter;

        public Iterator(RdfSchemaSource rss, ResourceIterator propIter) {
            this._rss = rss;
            this._propIter = propIter;
        }

        public boolean hasNext() throws QueryEvaluationException {
            return this._propIter.hasNext();
        }

        public Value next() throws QueryEvaluationException {
            Resource property = (Resource)this._propIter.next();
            Intersection intersect2 = new Intersection(this._rss.getDomain(property, null));
            return intersect2.minimize(this._rss);
        }

        public Resource nextResource() throws QueryEvaluationException {
            return (Resource)this.next();
        }

        public void close() {
            this._propIter.close();
        }

        protected void finalize() {
            this.close();
        }
    }
}

