/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model;

import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.sesame.query.rql.model.DataVar;
import org.openrdf.sesame.query.rql.model.PropertyVar;
import org.openrdf.sesame.query.rql.model.Selector;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.ResourceIterator;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sail.util.EmptyStatementIterator;

public class DataPathSelector
implements Selector {
    protected DataVar _sourceVar;
    protected PropertyVar _propVar;
    protected DataVar _targetVar;
    protected boolean _propIsExtended;
    protected ResourceIterator _propertyIter;
    protected StatementIterator _statementIter;
    protected boolean _sourceVarLocked;
    protected boolean _propVarLocked;
    protected boolean _targetVarLocked;
    protected boolean _sourceAndTargetAreEqual;

    public DataPathSelector(DataVar sourceVar, PropertyVar propVar, DataVar targetVar, boolean propIsExtended) {
        this._sourceVar = sourceVar;
        this._propVar = propVar;
        this._targetVar = targetVar;
        this._propIsExtended = propIsExtended;
    }

    public PropertyVar getPropertyVar() {
        return this._propVar;
    }

    public DataVar getSourceVar() {
        return this._sourceVar;
    }

    public DataVar getTargetVar() {
        return this._targetVar;
    }

    public void initialize(RdfSchemaSource rss) {
        this._sourceVarLocked = this._sourceVar.hasValue();
        this._propVarLocked = this._propVar.hasValue();
        this._targetVarLocked = this._targetVar.hasValue();
        if (!this._sourceVarLocked && !this._targetVarLocked) {
            this._sourceVar.setValue(URIImpl.RDF_TYPE);
            this._sourceAndTargetAreEqual = this._targetVar.hasValue();
            this._sourceVar.setValue(null);
        }
        try {
            Resource sourceValue = (Resource)this._sourceVar.getValue();
            URI propValue = (URI)this._propVar.getValue();
            Value targetValue = this._targetVar.getValue();
            this._statementIter = this._propIsExtended ? rss.getStatements(sourceValue, propValue, targetValue) : rss.getExplicitStatements(sourceValue, propValue, targetValue);
        }
        catch (ClassCastException e) {
            this._statementIter = new EmptyStatementIterator();
        }
    }

    public boolean selectNext(RdfSchemaSource rss) {
        while (this._statementIter.hasNext()) {
            Statement st = this._statementIter.next();
            if (this._sourceAndTargetAreEqual && !st.getSubject().equals(st.getObject())) continue;
            if (!this._sourceVarLocked) {
                this._sourceVar.setValue(st.getSubject());
            }
            if (!this._propVarLocked) {
                this._propVar.setValue(st.getPredicate());
            }
            if (!this._targetVarLocked) {
                this._targetVar.setValue(st.getObject());
            }
            return true;
        }
        if (!this._sourceVarLocked) {
            this._sourceVar.setValue(null);
        }
        if (!this._propVarLocked) {
            this._propVar.setValue(null);
        }
        if (!this._targetVarLocked) {
            this._targetVar.setValue(null);
        }
        return false;
    }

    public void clear() {
        if (this._statementIter != null) {
            this._statementIter.close();
            if (!this._sourceVarLocked) {
                this._sourceVar.setValue(null);
            }
            if (!this._propVarLocked) {
                this._propVar.setValue(null);
            }
            if (!this._targetVarLocked) {
                this._targetVar.setValue(null);
            }
        }
    }

    public String toString() {
        StringBuffer result2 = new StringBuffer();
        result2.append("{");
        if (this._sourceVar != null) {
            result2.append(this._sourceVar.toString());
        }
        result2.append("}");
        if (!this._propIsExtended) {
            result2.append("^");
        }
        result2.append(this._propVar.toString());
        result2.append("{");
        if (this._targetVar != null) {
            result2.append(this._targetVar.toString());
        }
        result2.append("}");
        return result2.toString();
    }
}

