/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.query.rql.model.ClassQuery;
import org.openrdf.sesame.query.rql.model.DataQuery;
import org.openrdf.sesame.query.rql.model.PropertyQuery;
import org.openrdf.sesame.query.rql.model.ResourceQuery;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.ResourceIterator;
import org.openrdf.sesame.sail.ValueIterator;

public class ArraySelection
implements ClassQuery,
PropertyQuery,
DataQuery {
    protected ResourceQuery _resourceQ;
    protected int _startIdx;
    protected int _endIdx;

    public ArraySelection(ResourceQuery resourceQ, int startIdx, int endIdx) {
        this._resourceQ = resourceQ;
        this._startIdx = startIdx;
        this._endIdx = endIdx;
    }

    public void evaluate(RdfSchemaSource rss, TableQueryResultListener listener) throws QueryEvaluationException {
        ValueIterator iter2 = null;
        try {
            listener.startTableQueryResult();
            iter2 = this.getResources(rss);
            while (iter2.hasNext()) {
                Value value = iter2.next();
                listener.startTuple();
                listener.tupleValue(value);
                listener.endTuple();
            }
            listener.endTableQueryResult();
        }
        catch (IOException e) {
            throw new QueryEvaluationException(e);
        }
        finally {
            if (iter2 != null) {
                iter2.close();
            }
        }
    }

    public ValueIterator getResources(RdfSchemaSource rss) throws QueryEvaluationException {
        return new ValIterator(this._resourceQ.getResources(rss));
    }

    public ResourceIterator getClasses(RdfSchemaSource rss) throws QueryEvaluationException {
        if (this._resourceQ instanceof ClassQuery) {
            return new ResIterator(((ClassQuery)this._resourceQ).getClasses(rss));
        }
        throw new QueryEvaluationException("Not a ClassQuery: " + this._resourceQ.getQuery());
    }

    public ResourceIterator getProperties(RdfSchemaSource rss) throws QueryEvaluationException {
        if (this._resourceQ instanceof PropertyQuery) {
            return new ResIterator(((PropertyQuery)this._resourceQ).getProperties(rss));
        }
        throw new QueryEvaluationException("Not a PropertyQuery: " + this._resourceQ.getQuery());
    }

    public ValueIterator getInstances(RdfSchemaSource rss) throws QueryEvaluationException {
        if (this._resourceQ instanceof DataQuery) {
            return this.getResources(rss);
        }
        throw new QueryEvaluationException("Not a DataQuery: " + this._resourceQ.getQuery());
    }

    public boolean returnsSet() {
        return this._endIdx > this._startIdx;
    }

    public String getQuery() {
        return this.toString();
    }

    public String toString() {
        StringBuffer result2 = new StringBuffer();
        result2.append(this._resourceQ.toString());
        result2.append(" [");
        result2.append(this._startIdx);
        result2.append(", ");
        result2.append(this._endIdx);
        result2.append("]");
        return result2.toString();
    }

    class ResIterator
    extends ValIterator
    implements ResourceIterator {
        public ResIterator(ResourceIterator iter2) throws QueryEvaluationException {
            super(iter2);
        }

        public Resource nextResource() throws QueryEvaluationException {
            return (Resource)this.next();
        }
    }

    class ValIterator
    implements ValueIterator {
        protected int _curIndex;
        protected ValueIterator _sourceArray;

        public ValIterator(ValueIterator sourceArray) throws QueryEvaluationException {
            this._sourceArray = sourceArray;
            this._curIndex = 1;
            while (sourceArray.hasNext() && this._curIndex < ArraySelection.this._startIdx) {
                sourceArray.next();
                ++this._curIndex;
            }
        }

        public boolean hasNext() throws QueryEvaluationException {
            return this._curIndex <= ArraySelection.this._endIdx && this._sourceArray.hasNext();
        }

        public Value next() throws QueryEvaluationException {
            if (this.hasNext()) {
                ++this._curIndex;
                return this._sourceArray.next();
            }
            throw new NoSuchElementException();
        }

        public void close() {
            this._curIndex = ArraySelection.this._endIdx + 1;
            this._sourceArray.close();
        }

        protected void finalize() {
            this.close();
        }
    }
}

