/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query;

import java.io.IOException;
import java.io.OutputStream;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.query.QueryErrorType;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.util.xml.XmlWriter;

public class VarBindingRdfWriter
implements TableQueryResultListener {
    private RDFFormat _rdfFormat;
    private OutputStream _out;
    private XmlWriter _xmlWriter;
    private String[] _varNames;
    private int _currentColumn;

    public VarBindingRdfWriter(OutputStream out) {
        this(RDFFormat.RDFXML, out);
    }

    public VarBindingRdfWriter(RDFFormat rdfFormat, OutputStream out) {
        this._rdfFormat = rdfFormat;
        this._out = out;
    }

    public void startTableQueryResult() throws IOException {
        throw new IOException("This output format requires column header reporting");
    }

    public void startTableQueryResult(String[] columnHeaders) throws IOException {
        this._xmlWriter = new XmlWriter(this._out);
        this._xmlWriter.setPrettyPrint(true);
        this._xmlWriter.startDocument();
        this._xmlWriter.setAttribute("xmlns:rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this._xmlWriter.setAttribute("xmlns:rs", "http://jena.hpl.hp.com/2003/03/result-set#");
        this._xmlWriter.startTag("rdf:RDF");
        this._xmlWriter.emptyLine();
        this._xmlWriter.comment("  This is an experimental results format. See\n  http://www.w3.org/2003/03/rdfqr-tests/recording-query-results.html\n  for more info about this format.");
        this._xmlWriter.emptyLine();
        this._xmlWriter.setAttribute("rdf:about", "");
        this._xmlWriter.startTag("rs:ResultSet");
        this._varNames = new String[columnHeaders.length];
        for (int i = 0; i < columnHeaders.length; ++i) {
            this._varNames[i] = columnHeaders[i];
            this._xmlWriter.textElement("rs:resultVariable", this._varNames[i]);
        }
    }

    public void endTableQueryResult() throws IOException {
        this._xmlWriter.endTag("rs:ResultSet");
        this._xmlWriter.endTag("rdf:RDF");
        this._xmlWriter.endDocument();
        this._out.close();
    }

    public void startTuple() throws IOException {
        this._xmlWriter.startTag("rs:solution");
        this._xmlWriter.startTag("rs:ResultSolution");
        this._currentColumn = 0;
    }

    public void endTuple() throws IOException {
        this._xmlWriter.endTag("rs:ResultSolution");
        this._xmlWriter.endTag("rs:solution");
    }

    public void tupleValue(Value value) throws IOException {
        this._xmlWriter.setAttribute("rdf:parseType", "Resource");
        this._xmlWriter.startTag("rs:binding");
        this._xmlWriter.textElement("rs:variable", this._varNames[this._currentColumn]);
        if (value instanceof URI) {
            this._writeURI((URI)value);
        } else if (value instanceof BNode) {
            this._writeBNode((BNode)value);
        } else if (value instanceof Literal) {
            this._writeLiteral((Literal)value);
        } else if (value == null) {
            this._writeNull();
        }
        this._xmlWriter.endTag("rs:binding");
        ++this._currentColumn;
    }

    private void _writeURI(URI uri2) throws IOException {
        this._xmlWriter.setAttribute("rdf:resource", uri2.getURI());
        this._xmlWriter.emptyElement("rs:value");
    }

    private void _writeBNode(BNode bNode) throws IOException {
        this._xmlWriter.setAttribute("rdf:nodeID", bNode.getID());
        this._xmlWriter.emptyElement("rs:value");
    }

    private void _writeLiteral(Literal literal) throws IOException {
        if (literal.getLanguage() != null) {
            this._xmlWriter.setAttribute("xml:lang", literal.getLanguage());
        }
        if (literal.getDatatype() != null) {
            this._xmlWriter.setAttribute("rdf:datatype", literal.getDatatype().getURI());
        }
        this._xmlWriter.textElement("rs:value", literal.getLabel());
    }

    private void _writeNull() throws IOException {
        this._xmlWriter.setAttribute("rdf:resource", "http://jena.hpl.hp.com/2003/03/result-set#undef");
        this._xmlWriter.emptyElement("rs:value");
    }

    public void error(QueryErrorType errType, String msg) throws IOException {
        if (this._xmlWriter == null) {
            this.startTableQueryResult(new String[0]);
        }
        this._xmlWriter.startTag("error");
        this._xmlWriter.textElement("msg", msg);
        this._xmlWriter.endTag("error");
    }
}

