/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query;

import java.io.IOException;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.sesame.sail.query.Query;
import org.openrdf.sesame.sail.query.QueryAnswer;
import org.openrdf.sesame.sail.query.QueryAnswerListener;
import org.openrdf.sesame.sail.query.SailQueryException;

public class TableQuery {
    private Query _query;

    public TableQuery(Query query2) {
        this._query = query2;
    }

    public Query getQuery() {
        return this._query;
    }

    public void optimize(RdfSource source) {
        this._query = source.optimizeQuery(this._query);
    }

    public void evaluate(RdfSource rdfSource, TableQueryResultListener listener) throws QueryEvaluationException {
        try {
            listener.startTableQueryResult(this._query.getColumnHeaders());
            this._query.evaluate(rdfSource, new QAL2TQRL(listener));
            listener.endTableQueryResult();
        }
        catch (SailQueryException e) {
            throw new QueryEvaluationException(e);
        }
        catch (IOException e) {
            throw new QueryEvaluationException(e);
        }
    }

    public String toString() {
        return "TableQuery [" + super.toString() + "]";
    }

    private static class QAL2TQRL
    implements QueryAnswerListener {
        private TableQueryResultListener _listener;

        public QAL2TQRL(TableQueryResultListener listener) {
            this._listener = listener;
        }

        public boolean queryAnswer(QueryAnswer qa) throws IOException {
            this._listener.startTuple();
            for (int i = 0; i < qa.getValueCount(); ++i) {
                this._listener.tupleValue(qa.getValue(i));
            }
            this._listener.endTuple();
            return true;
        }

        public void clear() {
        }
    }
}

