/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sesame.Sesame;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.config.ConfigurationException;
import org.openrdf.sesame.config.RepositoryConfig;
import org.openrdf.sesame.query.GraphQueryResultListener;
import org.openrdf.sesame.repository.local.LocalRepository;
import org.openrdf.sesame.sail.RdfRepository;
import org.openrdf.sesame.sail.SailUpdateException;
import org.openrdf.sesame.sailimpl.memory.RdfRepositoryConfig;

public class QueryResultsGraphBuilder
implements GraphQueryResultListener {
    private LocalRepository _repository;
    private RdfRepository _sail;
    private Map _namespacesTable = new HashMap(16);

    public Graph getGraph() {
        try {
            return this._repository.getGraph();
        }
        catch (AccessDeniedException e) {
            throw new RuntimeException(e);
        }
    }

    public void startGraphQueryResult() throws IOException {
        try {
            RepositoryConfig config = new RepositoryConfig("", true, true);
            config.stackSail(new RdfRepositoryConfig());
            this._repository = Sesame.getService().createRepository(config);
            this._sail = (RdfRepository)this._repository.getSail();
            this._sail.startTransaction();
        }
        catch (ConfigurationException e) {
            IOException ioe = new IOException("Unable to create memory repository");
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void endGraphQueryResult() {
        Iterator iter2 = this._namespacesTable.entrySet().iterator();
        while (iter2.hasNext()) {
            Map.Entry entry = iter2.next();
            String namespace = (String)entry.getKey();
            String prefix = (String)entry.getValue();
            try {
                this._sail.changeNamespacePrefix(namespace, prefix);
            }
            catch (SailUpdateException e) {}
        }
        this._namespacesTable.clear();
        this._sail.commitTransaction();
    }

    public void namespace(String prefix, String name2) {
        this._namespacesTable.put(name2, prefix);
    }

    public void triple(Resource subj, URI pred, Value obj) throws IOException {
        try {
            this._sail.addStatement(subj, pred, obj);
        }
        catch (SailUpdateException e) {
            IOException ioe = new IOException("Unable to add statement to memory sail");
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void reportError(String msg) throws IOException {
    }
}

