/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.export;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.rio.RdfDocumentWriter;
import org.openrdf.sesame.sail.NamespaceIterator;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.sesame.sail.StatementIterator;

public class RdfExport {
    public void exportRdf(RdfSource rs, RdfDocumentWriter rdfDocWriter, boolean niceOutput) throws IOException {
        this._setNamespaces(rs, rdfDocWriter);
        rdfDocWriter.startDocument();
        this._writeStatements(rs, rdfDocWriter, niceOutput);
        rdfDocWriter.endDocument();
    }

    protected void _writeStatements(RdfSource rs, RdfDocumentWriter rdfDocWriter, boolean niceOutput) throws IOException {
        if (niceOutput) {
            HashSet<Resource> subjects = new HashSet<Resource>();
            StatementIterator statIter = rs.getStatements(null, null, null);
            while (statIter.hasNext()) {
                Statement st = statIter.next();
                subjects.add(st.getSubject());
            }
            statIter.close();
            Iterator subjIter = subjects.iterator();
            while (subjIter.hasNext()) {
                Resource subject = (Resource)subjIter.next();
                this._writeSubjStatements(rs, rdfDocWriter, subject);
            }
        } else {
            StatementIterator statIter = rs.getStatements(null, null, null);
            while (statIter.hasNext()) {
                Statement st = statIter.next();
                rdfDocWriter.writeStatement(st.getSubject(), st.getPredicate(), st.getObject());
            }
            statIter.close();
        }
    }

    private void _writeSubjStatements(RdfSource rs, RdfDocumentWriter rdfDocWriter, Resource subj) throws IOException {
        StatementIterator statIter = rs.getStatements(subj, null, null);
        while (statIter.hasNext()) {
            Statement st = statIter.next();
            rdfDocWriter.writeStatement(subj, st.getPredicate(), st.getObject());
        }
        statIter.close();
    }

    public void exportRdf(RdfSchemaSource rss, RdfDocumentWriter rdfDocWriter, boolean exportOnto, boolean exportData, boolean explicitOnly, boolean niceOutput) throws IOException {
        this._setNamespaces(rss, rdfDocWriter);
        rdfDocWriter.startDocument();
        if (exportOnto && exportData) {
            this._writeStatements(rss, rdfDocWriter, explicitOnly, niceOutput);
        } else if (exportOnto) {
            this._writeClassDefs(rss, rdfDocWriter, explicitOnly, niceOutput);
            this._writePropertyDefs(rss, rdfDocWriter, explicitOnly, niceOutput);
        } else if (exportData) {
            this._writeDataStatements(rss, rdfDocWriter, explicitOnly, niceOutput);
        }
        rdfDocWriter.endDocument();
    }

    protected void _writeStatements(RdfSchemaSource rss, RdfDocumentWriter rdfDocWriter, boolean explicitOnly, boolean niceOutput) throws IOException {
        if (niceOutput) {
            rdfDocWriter.writeComment("All statement");
            HashSet<Resource> subjects = new HashSet<Resource>();
            StatementIterator statIter = explicitOnly ? rss.getExplicitStatements(null, null, null) : rss.getStatements(null, null, null);
            while (statIter.hasNext()) {
                Statement st = statIter.next();
                subjects.add(st.getSubject());
            }
            statIter.close();
            Iterator subjIter = subjects.iterator();
            while (subjIter.hasNext()) {
                Resource subject = (Resource)subjIter.next();
                this._writeSubjStatements(rss, rdfDocWriter, explicitOnly, subject);
            }
        } else {
            StatementIterator statIter = explicitOnly ? rss.getExplicitStatements(null, null, null) : rss.getStatements(null, null, null);
            while (statIter.hasNext()) {
                Statement st = statIter.next();
                rdfDocWriter.writeStatement(st.getSubject(), st.getPredicate(), st.getObject());
            }
            statIter.close();
        }
    }

    protected void _writeClassDefs(RdfSchemaSource rss, RdfDocumentWriter rdfDocWriter, boolean explicitOnly, boolean niceOutput) throws IOException {
        if (niceOutput) {
            rdfDocWriter.writeComment("Class definitions");
        }
        StatementIterator classIter = rss.getClasses();
        while (classIter.hasNext()) {
            Resource classRes = classIter.next().getSubject();
            this._writeSubjStatements(rss, rdfDocWriter, explicitOnly, classRes);
        }
        classIter.close();
    }

    protected void _writePropertyDefs(RdfSchemaSource rss, RdfDocumentWriter rdfDocWriter, boolean explicitOnly, boolean niceOutput) throws IOException {
        if (niceOutput) {
            rdfDocWriter.writeComment("Property definitions");
        }
        StatementIterator propIter = rss.getProperties();
        while (propIter.hasNext()) {
            Resource property = propIter.next().getSubject();
            this._writeSubjStatements(rss, rdfDocWriter, explicitOnly, property);
        }
        propIter.close();
    }

    protected void _writeDataStatements(RdfSchemaSource rss, RdfDocumentWriter rdfDocWriter, boolean explicitOnly, boolean niceOutput) throws IOException {
        if (niceOutput) {
            rdfDocWriter.writeComment("Data statements");
            HashSet<Resource> subjects = new HashSet<Resource>();
            StatementIterator statIter = explicitOnly ? rss.getExplicitStatements(null, null, null) : rss.getStatements(null, null, null);
            while (statIter.hasNext()) {
                Statement st = statIter.next();
                subjects.add(st.getSubject());
            }
            statIter.close();
            StatementIterator classIter = rss.getClasses();
            while (classIter.hasNext()) {
                subjects.remove(classIter.next().getSubject());
            }
            classIter.close();
            StatementIterator propIter = rss.getProperties();
            while (propIter.hasNext()) {
                subjects.remove(propIter.next().getSubject());
            }
            propIter.close();
            Iterator subjIter = subjects.iterator();
            while (subjIter.hasNext()) {
                Resource subject = (Resource)subjIter.next();
                this._writeSubjStatements(rss, rdfDocWriter, explicitOnly, subject);
            }
        } else {
            HashSet<Resource> classesAndProperties = new HashSet<Resource>();
            StatementIterator classIter = rss.getClasses();
            while (classIter.hasNext()) {
                classesAndProperties.add(classIter.next().getSubject());
            }
            classIter.close();
            StatementIterator propIter = rss.getProperties();
            while (propIter.hasNext()) {
                classesAndProperties.add(propIter.next().getSubject());
            }
            propIter.close();
            StatementIterator statIter = explicitOnly ? rss.getExplicitStatements(null, null, null) : rss.getStatements(null, null, null);
            while (statIter.hasNext()) {
                Statement st = statIter.next();
                Resource subject = st.getSubject();
                if (classesAndProperties.contains(subject)) continue;
                rdfDocWriter.writeStatement(subject, st.getPredicate(), st.getObject());
            }
            statIter.close();
        }
    }

    private void _writeSubjStatements(RdfSchemaSource rss, RdfDocumentWriter rdfDocWriter, boolean explicitOnly, Resource subj) throws IOException {
        StatementIterator statIter = explicitOnly ? rss.getExplicitStatements(subj, null, null) : rss.getStatements(subj, null, null);
        while (statIter.hasNext()) {
            Statement st = statIter.next();
            rdfDocWriter.writeStatement(subj, st.getPredicate(), st.getObject());
        }
        statIter.close();
    }

    private void _setNamespaces(RdfSource rs, RdfDocumentWriter rdfDocWriter) throws IOException {
        NamespaceIterator nsIter = rs.getNamespaces();
        while (nsIter.hasNext()) {
            nsIter.next();
            String prefix = nsIter.getPrefix();
            String name2 = nsIter.getName();
            if (prefix == null) continue;
            rdfDocWriter.setNamespace(prefix, name2);
        }
        nsIter.close();
    }
}

