/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config.ui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.SystemConfigListener;
import org.openrdf.sesame.config.ui.ColumnData;

public abstract class XTableModel
extends AbstractTableModel
implements SystemConfigListener {
    protected SystemConfig _config;
    protected ColumnData[] _columns;
    protected List _rows;

    public XTableModel(SystemConfig config, ColumnData[] columns) {
        this._config = config;
        this._columns = columns;
        this._rows = new ArrayList();
        this._config.addListener(this);
    }

    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public int getColumnCount() {
        return this._columns.length;
    }

    public String getColumnName(int column) {
        return this._columns[column].title;
    }

    public int getColumnWidth(int column) {
        return this._columns[column].width;
    }

    public int getColumnAlignment(int column) {
        return this._columns[column].alignment;
    }

    public abstract int getIdentifyingColumn();

    public int getRowCount() {
        return this._rows.size();
    }

    public int getRowIndex(String rowID) {
        for (int i = 0; i < this._rows.size(); ++i) {
            RowData row = (RowData)this._rows.get(i);
            if (!rowID.equals(row.getIdentifier())) continue;
            return i;
        }
        return -1;
    }

    public void addNewRow(int rowIdx) {
        this._rows.add(rowIdx, this._createRow());
        this.fireTableRowsInserted(rowIdx, rowIdx);
    }

    protected abstract RowData _createRow();

    public void removeNewRow() {
        int size2 = this._rows.size();
        for (int i = 0; i < size2; ++i) {
            RowData row = (RowData)this._rows.get(i);
            if (!row.isNew()) continue;
            this._rows.remove(i);
            this.fireTableRowsDeleted(i, i);
            return;
        }
    }

    public boolean rowIsNew(int rowIdx) {
        RowData row = (RowData)this._rows.get(rowIdx);
        return row.isNew();
    }

    public boolean valueIsNew(int row, int column) {
        return this.getValueAt(row, column) == null;
    }

    protected abstract class RowData
    implements Comparable {
        protected RowData() {
        }

        public abstract String getIdentifier();

        public abstract boolean isNew();

        public int compareTo(Object other) {
            RowData row = (RowData)other;
            return this.getIdentifier().compareTo(row.getIdentifier());
        }
    }
}

