/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config.ui;

import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.ui.IntTextField;
import org.openrdf.sesame.config.ui.UserTableModel;
import org.openrdf.sesame.config.ui.XCellEditor;
import org.openrdf.sesame.config.ui.XTable;
import org.openrdf.sesame.config.ui.util.Util;

public class UserTable
extends XTable {
    public UserTable(SystemConfig config) {
        super(config);
        this.setXTableModel(new UserTableModel(config));
    }

    protected TableCellRenderer _createCellRenderer(int columnNo) {
        if (columnNo == 0 || columnNo == 1 || columnNo == 2 || columnNo == 3) {
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setHorizontalAlignment(this._model.getColumnAlignment(columnNo));
            return renderer;
        }
        return null;
    }

    protected TableCellEditor _createCellEditor(int columnNo) {
        XCellEditor editor = null;
        if (columnNo == 0) {
            editor = new IdCellEditor(this);
        } else if (columnNo == 1) {
            editor = new LoginCellEditor(this);
        } else if (columnNo == 2) {
            editor = new XCellEditor(new JTextField(), (XTable)this);
        } else if (columnNo == 3) {
            editor = new XCellEditor(new JTextField(), (XTable)this);
        }
        return editor;
    }

    public void editingStopped(ChangeEvent e) {
        int row = this.getEditingRow();
        super.editingStopped(e);
        if (this._model.rowIsNew(row)) {
            if (this._model.valueIsNew(row, 2)) {
                this.editCellAt(row, 2);
            } else if (this._model.valueIsNew(row, 3)) {
                this.editCellAt(row, 3);
            }
        }
    }

    public void removeRow() {
        String login = this.getIdentifierForSelectedRow();
        if (login == null) {
            this._showWarningDialog("No user selected.", "Remove User");
            return;
        }
        if (Util.showYesNoDialog(this._getOwner(), "Are you sure you want to remove user '" + login + "'?", "Remove User") == 0) {
            int row = this.getSelectedRow();
            this._config.removeUser(login);
            this.selectPreviousRowTo(row);
        }
    }

    class LoginCellEditor
    extends XCellEditor {
        public LoginCellEditor(UserTable userTable) {
            super(new JTextField(), (XTable)userTable);
        }

        public boolean isValid() {
            String newLogin = this.getCellEditorValue().toString();
            if (newLogin.length() == 0) {
                UserTable.this._showWarningDialog("Login required.", "Edit User");
                return false;
            }
            String oldLogin = (String)this._value;
            if (!newLogin.equals(oldLogin) && UserTable.this._config.hasUser(newLogin)) {
                UserTable.this._showWarningDialog(newLogin + " already exists.", "Edit User");
                return false;
            }
            return true;
        }
    }

    class IdCellEditor
    extends XCellEditor {
        public IdCellEditor(UserTable userTable) {
            super(new IntTextField(), (XTable)userTable);
        }

        public boolean isValid() {
            int newId;
            IntTextField text2 = (IntTextField)this.getComponent();
            Integer integerValue = (Integer)this._value;
            int oldId = integerValue;
            if (oldId != (newId = text2.getInt()) && (newId == 1 || newId == 2)) {
                UserTable.this._showWarningDialog("User ID's 1 and 2 are reserved for the ADMIN and\nANONYMOUS accounts respectively. Create these\naccounts only if you need them.", "Edit User");
            }
            return true;
        }
    }
}

