/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config.ui;

import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.handlers.SystemConfigFileHandler;
import org.openrdf.util.http.HttpClientUtil;

class ServerIOPanel
extends JPanel
implements ActionListener,
KeyListener {
    public static final int LOAD = 1;
    public static final int STORE = 2;
    protected JTextField _serverUrlField = new JTextField(30);
    protected JPasswordField _passwordField = new JPasswordField(10);
    protected JLabel _storeNote;
    protected JButton _actionButton = new JButton("Load");
    protected JButton _cancelButton = new JButton("Cancel");
    protected int _mode = 1;
    protected JDialog _dialog;
    protected SystemConfig _config;

    public ServerIOPanel() {
        this._storeNote = new JLabel("Note: any changes will be effective immediately.");
        Font font = this._storeNote.getFont().deriveFont(0);
        this._storeNote.setFont(font);
        this._storeNote.setVisible(false);
        GridBagLayout gridBag = new GridBagLayout();
        this.setLayout(gridBag);
        this._addComponent(this, gridBag, new JLabel("Server URL:"), 0, 0, 2, 1, 0, 0, 17, 0, 4, 8, 0, 8);
        this._addComponent(this, gridBag, this._serverUrlField, 0, 1, 2, 1, 1, 0, 17, 2, 0, 8, 0, 8);
        this._addComponent(this, gridBag, new JLabel("(Current) admin password:"), 0, 2, 1, 1, 0, 0, 17, 0, 8, 8, 0, 4);
        this._addComponent(this, gridBag, this._passwordField, 1, 2, 1, 1, 1, 0, 17, 2, 8, 0, 0, 8);
        this._addComponent(this, gridBag, this._storeNote, 0, 3, 2, 1, 1, 0, 17, 0, 8, 8, 0, 8);
        this._addComponent(this, gridBag, new JSeparator(), 0, 4, 2, 1, 1, 0, 10, 2, 8, 8, 0, 8);
        this._addComponent(this, gridBag, this._cancelButton, 0, 5, 1, 1, 0, 0, 17, 0, 8, 8, 8, 4);
        this._addComponent(this, gridBag, this._actionButton, 1, 5, 1, 1, 0, 0, 13, 0, 8, 4, 8, 8);
        this._actionButton.addActionListener(this);
        this._cancelButton.addActionListener(this);
        this._actionButton.addKeyListener(this);
        this._serverUrlField.addKeyListener(this);
        this._passwordField.addKeyListener(this);
        this._serverUrlField.setText("http://localhost:8080/sesame/");
        this._serverUrlField.selectAll();
        this._serverUrlField.requestFocus();
    }

    public String getServerURL() {
        return this._serverUrlField.getText().trim();
    }

    public SystemConfig showLoadDialog(JFrame parent) {
        this.setMode(1);
        this._showDialog(parent);
        return this._config;
    }

    public void showSendDialog(JFrame parent, SystemConfig config) {
        this._config = config;
        this.setMode(2);
        this._showDialog(parent);
    }

    protected void _showDialog(JFrame parent) {
        if (this._dialog != null) {
            this.hideDialog();
        }
        this._dialog = new JDialog((Frame)parent, true);
        Container cpane = this._dialog.getContentPane();
        cpane.add(this);
        if (this._mode == 1) {
            this._dialog.setTitle("Load from Server");
        } else {
            this._dialog.setTitle("Send to Server");
        }
        this._dialog.pack();
        this._dialog.setLocationRelativeTo(parent);
        this._dialog.setVisible(true);
    }

    public void hideDialog() {
        if (this._dialog != null) {
            this._dialog.setVisible(false);
            this._dialog.dispose();
            this._dialog = null;
        }
    }

    public void setMode(int mode) {
        if (mode != 1 && mode != 2) {
            throw new IllegalArgumentException("Unknown mode");
        }
        if (this._mode != mode) {
            this._mode = mode;
            this._storeNote.setVisible(this._mode == 2);
            this._switchModes();
        }
    }

    protected void _switchModes() {
        if (this._mode == 1) {
            this._actionButton.setText("Load");
        } else {
            this._actionButton.setText("Send");
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._actionButton) {
            if (this._mode == 1) {
                boolean success = this._loadData();
                if (success) {
                    this.hideDialog();
                }
            } else {
                boolean success = this._storeData();
                if (success) {
                    this.hideDialog();
                }
            }
        } else if (e.getSource() == this._cancelButton) {
            this.hideDialog();
        }
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            if (this._mode == 1) {
                boolean success = this._loadData();
                if (success) {
                    this.hideDialog();
                }
            } else {
                boolean success = this._storeData();
                if (success) {
                    this.hideDialog();
                }
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    private void _addComponent(Container cont, GridBagLayout gridBag, JComponent comp, int x, int y, int width, int height, int weightX, int weightY, int anchor, int fill2, int padTop, int padLeft, int padBottom, int padRight) {
        GridBagConstraints gbc = new GridBagConstraints(x, y, width, height, weightX, weightY, anchor, fill2, new Insets(padTop, padLeft, padBottom, padRight), 0, 0);
        gridBag.setConstraints(comp, gbc);
        cont.add(comp);
    }

    protected boolean _loadData() {
        String serverURL = this._serverUrlField.getText().trim();
        String password = new String(this._passwordField.getPassword()).trim();
        if (serverURL.length() == 0) {
            this._showInputError("Please specify a server URL");
            return false;
        }
        if (!serverURL.endsWith("/")) {
            serverURL = serverURL + "/";
        }
        serverURL = serverURL + "servlets/config";
        HashMap<String, String> postParams = new HashMap<String, String>();
        postParams.put("action", "getConfig");
        if (password.length() > 0) {
            postParams.put("password", password);
        }
        try {
            URL url = new URL(serverURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            HttpClientUtil.prepareMultipartPostRequest((HttpURLConnection)conn, postParams, (String)"UTF-8");
            conn.connect();
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                String responseMsg = conn.getResponseMessage();
                this._showCommunicationError("The server returned code " + responseCode + ": " + responseMsg);
                return false;
            }
            InputStream resultStream = conn.getInputStream();
            this._config = SystemConfigFileHandler.readConfiguration(resultStream);
            resultStream.close();
            conn.disconnect();
            return true;
        }
        catch (MalformedURLException e) {
            this._showInputError("The specified server URL is not a legal URL");
            return false;
        }
        catch (IOException e) {
            this._showCommunicationError(this._createErrorMessage(e));
            return false;
        }
    }

    protected boolean _storeData() {
        String serverURL = this._serverUrlField.getText().trim();
        String password = new String(this._passwordField.getPassword()).trim();
        if (serverURL.length() == 0) {
            this._showInputError("Please specify a server URL");
            return false;
        }
        if (!serverURL.endsWith("/")) {
            serverURL = serverURL + "/";
        }
        serverURL = serverURL + "servlets/config";
        try {
            StringWriter stringWriter = new StringWriter(4096);
            SystemConfigFileHandler.writeConfiguration(this._config, stringWriter);
            stringWriter.close();
            String config = stringWriter.toString();
            HashMap<String, String> postParams = new HashMap<String, String>();
            postParams.put("action", "setConfig");
            if (password.length() > 0) {
                postParams.put("password", password);
            }
            postParams.put("config", config);
            URL url = new URL(serverURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            HttpClientUtil.prepareMultipartPostRequest((HttpURLConnection)conn, postParams, (String)"UTF-8");
            conn.connect();
            int responseCode = conn.getResponseCode();
            conn.disconnect();
            if (responseCode != 200) {
                String responseMsg = conn.getResponseMessage();
                this._showCommunicationError("The server returned code " + responseCode + ": " + responseMsg);
                return false;
            }
            JOptionPane.showMessageDialog(this, "The configuration was sent successfully", "Configuration sent", 1);
            return true;
        }
        catch (MalformedURLException e) {
            this._showInputError("The specified server URL is not a legal URL");
            return false;
        }
        catch (IOException e) {
            this._showCommunicationError(this._createErrorMessage(e));
            return false;
        }
    }

    protected void _showInputError(String msg) {
        JOptionPane.showMessageDialog(this, msg, "Input error", 0);
    }

    protected void _showCommunicationError(String msg) {
        JOptionPane.showMessageDialog(this, msg, "Communication error", 0);
    }

    protected String _createErrorMessage(IOException e) {
        if (e instanceof UnknownHostException) {
            return "Unknown host: " + e.getMessage();
        }
        if (e instanceof ConnectException) {
            return "Connection refused by host";
        }
        if (e instanceof FileNotFoundException) {
            return "Unable to find required Sesame service";
        }
        return e.getMessage();
    }
}

