/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import org.openrdf.sesame.config.RepositoryConfig;
import org.openrdf.sesame.config.SailConfig;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.UserInfo;
import org.openrdf.util.log.ThreadLog;
import org.openrdf.util.xml.SimpleSAXAdapter;
import org.openrdf.util.xml.SimpleSAXListener;
import org.openrdf.util.xml.SimpleSAXParser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class SystemConfigReader {
    private SimpleSAXParser _simpleSAXParser;

    public SystemConfigReader(XMLReader xmlReader) {
        this._simpleSAXParser = new SimpleSAXParser(xmlReader);
    }

    public synchronized SystemConfig read(InputStream inputStream2) throws SAXException, IOException {
        SystemConfigParser parser = new SystemConfigParser();
        this._simpleSAXParser.setListener((SimpleSAXListener)parser);
        this._simpleSAXParser.parse(inputStream2);
        return parser.getSystemConfig();
    }

    public synchronized SystemConfig read(Reader reader2) throws SAXException, IOException {
        SystemConfigParser parser = new SystemConfigParser();
        this._simpleSAXParser.setListener((SimpleSAXListener)parser);
        this._simpleSAXParser.parse(reader2);
        return parser.getSystemConfig();
    }

    static class SystemConfigParser
    extends SimpleSAXAdapter {
        private SystemConfig _config;
        private UserInfo _currentUser;
        private RepositoryConfig _currentRepository;
        private SailConfig _currentSail;
        private boolean _inAcl;

        SystemConfigParser() {
        }

        public SystemConfig getSystemConfig() {
            return this._config;
        }

        public void startDocument() {
            this._currentUser = null;
            this._currentRepository = null;
            this._currentSail = null;
            this._inAcl = false;
        }

        public void endDocument() throws SAXException {
            if (this._config.getAdminPassword() == null) {
                ThreadLog.warning((String)"admin password was not set!!!");
            }
        }

        public void startTag(String tagName, Map atts, String text2) {
            block59: {
                if (tagName.equals("system-conf")) {
                    this._config = new SystemConfig();
                } else if (tagName.equals("admin")) {
                    String password = (String)atts.get("password");
                    if (password == null) {
                        ThreadLog.error((String)"'password' attribute missing in 'admin' element");
                        return;
                    }
                    this._config.setAdminPassword(password);
                } else if (tagName.equals("log")) {
                    String dir = (String)atts.get("dir");
                    if (dir == null) {
                        ThreadLog.error((String)"'dir' attribute missing in 'log' element");
                        return;
                    }
                    this._config.setLogDir(dir);
                    int logLevel = 2;
                    String logLevelStr = (String)atts.get("level");
                    if (logLevelStr != null) {
                        try {
                            logLevel = Integer.parseInt(logLevelStr);
                            if (logLevel >= 0 && logLevel <= 5) {
                                this._config.setLogLevel(logLevel);
                                break block59;
                            }
                            ThreadLog.error((String)"value of 'level' attribute in 'log' element should be a number between 0 and 5");
                        }
                        catch (NumberFormatException e) {
                            ThreadLog.error((String)"value of 'level' attribute in 'log' element should be a number between 0 and 5");
                        }
                    }
                } else if (tagName.equals("tmp")) {
                    String dir = (String)atts.get("dir");
                    if (dir == null) {
                        ThreadLog.error((String)"'dir' attribute missing in 'tmp' element");
                        return;
                    }
                    this._config.setTmpDir(dir);
                } else if (tagName.equals("rmi-factory")) {
                    String facClass = (String)atts.get("class");
                    if (facClass == null || facClass.trim().length() == 0) {
                        ThreadLog.error((String)"'class' attribute missing in 'rmi-factory' element");
                    }
                    int portInt = 1099;
                    String port = (String)atts.get("port");
                    if (port != null) {
                        try {
                            portInt = Integer.parseInt(port);
                        }
                        catch (NumberFormatException e) {
                            ThreadLog.error((String)"value of 'port' attribute in 'rmi-factory' element should be a positive number");
                        }
                    }
                    this._config.setRMIFactory(facClass, portInt);
                    String rmiEnabled = (String)atts.get("enabled");
                    if (rmiEnabled == null) {
                        ThreadLog.warning((String)"'enabled' attribute missing in 'rmi-factory' element");
                    }
                    this._config.setRMIEnabled(rmiEnabled == null || rmiEnabled.equals("true"));
                } else if (tagName.equals("systemprop")) {
                    String key = (String)atts.get("key");
                    if (key == null) {
                        ThreadLog.error((String)"'key' attribute missing in 'systemprop' element");
                        return;
                    }
                    String value = (String)atts.get("value");
                    if (value == null) {
                        ThreadLog.error((String)"'value' attribute missing in 'systemprop' element");
                        return;
                    }
                    this._config.setSystemProp(key, value);
                } else if (tagName.equals("user") && !this._inAcl) {
                    this._currentUser = null;
                    this._currentRepository = null;
                    String login = (String)atts.get("login");
                    if (login == null) {
                        ThreadLog.error((String)"'login' attribute missing in 'user' element");
                        return;
                    }
                    this._currentUser = new UserInfo(login.trim());
                    String userID = (String)atts.get("id");
                    if (userID != null) {
                        try {
                            this._currentUser.setID(Integer.parseInt(userID.trim()));
                        }
                        catch (NumberFormatException e) {
                            ThreadLog.error((String)"value of 'id' attribute in 'user' element should be a positive number");
                        }
                    }
                } else if (tagName.equals("fullname")) {
                    this._currentUser.setFullName(text2.trim());
                } else if (tagName.equals("password")) {
                    this._currentUser.setPassword(text2.trim());
                } else if (tagName.equals("repository")) {
                    String id = (String)atts.get("id");
                    if (id == null) {
                        ThreadLog.error((String)"'id' attribute missing in 'repository' element");
                        return;
                    }
                    this._currentRepository = new RepositoryConfig(id);
                    this._currentUser = null;
                } else if (tagName.equals("title")) {
                    this._currentRepository.setTitle(text2.trim());
                } else if (tagName.equals("sail")) {
                    if (this._currentRepository != null) {
                        String sailClass = (String)atts.get("class");
                        if (sailClass == null) {
                            ThreadLog.error((String)"'class' attribute missing in 'sail' element");
                            return;
                        }
                        this._currentSail = new SailConfig(sailClass);
                        this._currentRepository.addSail(this._currentSail);
                    }
                } else if (tagName.equals("param")) {
                    if (this._currentSail != null) {
                        String paramName = (String)atts.get("name");
                        String paramValue = (String)atts.get("value");
                        if (paramName == null) {
                            ThreadLog.error((String)"'name' attribute missing in 'param' element");
                            return;
                        }
                        if (paramValue == null) {
                            ThreadLog.error((String)"'value' attribute missing in 'param' element");
                            return;
                        }
                        this._currentSail.setParameter(paramName, paramValue);
                    }
                } else if (tagName.equals("acl")) {
                    if (this._currentRepository != null) {
                        this._inAcl = true;
                        String worldReadable = (String)atts.get("worldReadable");
                        String worldWriteable = (String)atts.get("worldWriteable");
                        if (worldWriteable == null) {
                            worldWriteable = (String)atts.get("worldWritable");
                        }
                        this._currentRepository.setWorldReadable(worldReadable != null && worldReadable.equals("true"));
                        this._currentRepository.setWorldWriteable(worldWriteable != null && worldWriteable.equals("true"));
                    }
                } else if (tagName.equals("user") && this._inAcl) {
                    String login = (String)atts.get("login");
                    String readAccess = (String)atts.get("readAccess");
                    String writeAccess = (String)atts.get("writeAccess");
                    if (login == null) {
                        ThreadLog.error((String)"'login' attribute missing in 'user' element for acl");
                        return;
                    }
                    UserInfo userInfo = this._config.getUserInfo(login);
                    if (userInfo == null) {
                        ThreadLog.error((String)("user '" + login + "' not defined"));
                        return;
                    }
                    if (readAccess != null && readAccess.equals("true")) {
                        userInfo.addReadAccess(this._currentRepository);
                    }
                    if (writeAccess != null && writeAccess.equals("true")) {
                        userInfo.addWriteAccess(this._currentRepository);
                    }
                }
            }
        }

        public void endTag(String tagName) {
            if (tagName.equals("user") && !this._inAcl) {
                if (this._currentUser != null) {
                    this._addCurrentUser();
                    this._currentUser = null;
                }
            } else if (tagName.equals("repository")) {
                if (this._currentRepository != null) {
                    this._addCurrentRepository();
                    this._currentRepository = null;
                    this._inAcl = false;
                }
            } else if (tagName.equals("acl")) {
                this._inAcl = false;
            }
        }

        private void _addCurrentUser() {
            boolean correctConfig = true;
            String login = this._currentUser.getLogin();
            if (this._currentUser.getFullName() == null) {
                ThreadLog.error((String)("fullname missing for user " + login));
                correctConfig = false;
            }
            if (this._currentUser.getPassword() == null) {
                ThreadLog.error((String)("password missing for user " + login));
                correctConfig = false;
            }
            if (this._currentUser.getID() == 0) {
                ThreadLog.warning((String)("id attribute missing for user " + login + "; using default"));
            }
            if (correctConfig) {
                ThreadLog.trace((String)("user " + login + " was parsed correctly"));
                this._config.addUserInfo(this._currentUser);
            } else {
                ThreadLog.warning((String)("ignoring user " + login));
            }
        }

        private void _addCurrentRepository() {
            boolean correctConfig = true;
            String id = this._currentRepository.getRepositoryId();
            if (this._currentRepository.getTitle() == null) {
                ThreadLog.error((String)("title missing for repository " + id));
                correctConfig = false;
            }
            if (!this._currentRepository.hasASail()) {
                ThreadLog.error((String)("no sail defined for repository " + id));
                correctConfig = false;
            }
            if (correctConfig) {
                ThreadLog.trace((String)("repository " + id + " was parsed correctly"));
                this._config.addRepositoryConfig(this._currentRepository);
            } else {
                ThreadLog.warning((String)("ignoring repository " + id));
            }
        }
    }
}

