/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config;

import java.util.HashMap;
import java.util.Map;
import org.openrdf.sesame.config.RepositoryConfig;

public class UserInfo
implements Cloneable {
    private int _id;
    private String _login;
    private String _fullName;
    private String _password;
    private Map _readAccessMap;
    private Map _writeAccessMap;

    public UserInfo(String login) {
        this._login = login;
        this._readAccessMap = new HashMap();
        this._writeAccessMap = new HashMap();
    }

    public UserInfo(int id, String login, String fullName, String password) {
        this(login);
        this._id = id;
        this._fullName = fullName;
        this._password = password;
    }

    public int getID() {
        return this._id;
    }

    public void setID(int id) {
        this._id = id;
    }

    public String getLogin() {
        return this._login;
    }

    public void setLogin(String login) {
        this._login = login;
    }

    public String getFullName() {
        return this._fullName;
    }

    public void setFullName(String fullName) {
        this._fullName = fullName;
    }

    public String getPassword() {
        return this._password;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public boolean hasReadAccess(String repositoryId) {
        return this._readAccessMap.containsKey(repositoryId);
    }

    public void addReadAccess(RepositoryConfig repConfig) {
        this._readAccessMap.put(repConfig.getRepositoryId(), repConfig);
    }

    public void removeReadAccess(RepositoryConfig repConfig) {
        this._readAccessMap.remove(repConfig.getRepositoryId());
    }

    public boolean hasWriteAccess(String repositoryId) {
        return this._writeAccessMap.containsKey(repositoryId);
    }

    public void addWriteAccess(RepositoryConfig repConfig) {
        this._writeAccessMap.put(repConfig.getRepositoryId(), repConfig);
    }

    public void removeWriteAccess(RepositoryConfig repConfig) {
        this._writeAccessMap.remove(repConfig.getRepositoryId());
    }

    public void addReadWriteAccess(RepositoryConfig repConfig) {
        this.addReadAccess(repConfig);
        this.addWriteAccess(repConfig);
    }

    public boolean hasReadOrWriteAccess(String repositoryId) {
        return this.hasReadAccess(repositoryId) || this.hasWriteAccess(repositoryId);
    }

    public boolean equals(Object other) {
        if (other instanceof UserInfo) {
            UserInfo o = (UserInfo)other;
            return this._login.equals(o.getLogin()) && this._fullName.equals(o.getFullName()) && this._password.equals(o.getPassword()) && this._id == o.getID();
        }
        return false;
    }

    public int hashCode() {
        return this._login.hashCode();
    }

    public Object clone() {
        try {
            UserInfo clone2 = (UserInfo)super.clone();
            clone2._readAccessMap = new HashMap(this._readAccessMap);
            clone2._writeAccessMap = new HashMap(this._writeAccessMap);
            return clone2;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

