/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.openrdf.sesame.config.RepositoryConfig;
import org.openrdf.sesame.config.SailConfig;
import org.openrdf.sesame.config.SystemConfigListener;
import org.openrdf.sesame.config.UserInfo;

public class SystemConfig {
    protected String _adminPassword = "";
    protected String _logDir;
    protected int _logLevel = 0;
    protected String _tmpDir;
    protected boolean _rmiEnabled;
    protected String _rmiFactoryClass;
    protected int _rmiPort;
    protected Properties _systemProps = new Properties();
    protected HashMap _userMap = new HashMap();
    protected List _userList = new ArrayList();
    protected HashMap _repositoryMap = new HashMap();
    protected ArrayList _repositoryList = new ArrayList();
    protected List _listeners = new ArrayList();

    public void setAdminPassword(String password) {
        this._adminPassword = password;
        this._notifyListeners();
    }

    public String getAdminPassword() {
        return this._adminPassword;
    }

    public void setLogDir(String logDir) {
        this._logDir = logDir;
        this._notifyListeners();
    }

    public String getLogDir() {
        return this._logDir;
    }

    public void setLogLevel(int logLevel) {
        this._logLevel = logLevel;
        this._notifyListeners();
    }

    public int getLogLevel() {
        return this._logLevel;
    }

    public void setTmpDir(String tmpDir) {
        this._tmpDir = tmpDir;
        this._notifyListeners();
    }

    public String getTmpDir() {
        return this._tmpDir;
    }

    public void setSystemProp(String key, String value) {
        this._systemProps.setProperty(key, value);
        this._notifyListeners();
    }

    public String getSystemProp(String key) {
        return this._systemProps.getProperty(key);
    }

    public Properties getSystemProps() {
        return this._systemProps;
    }

    public void setRMIEnabled(boolean rmiEnabled) {
        if (this._rmiEnabled != rmiEnabled) {
            this._rmiEnabled = rmiEnabled;
            this._notifyListeners();
        }
    }

    public boolean isRMIEnabled() {
        return this._rmiEnabled;
    }

    public void setRMIFactory(String rmiFactoryClass, int port) {
        this._rmiFactoryClass = rmiFactoryClass;
        this._rmiPort = port;
        this._notifyListeners();
    }

    public String getRMIFactoryClass() {
        return this._rmiFactoryClass;
    }

    public int getRMIPort() {
        return this._rmiPort;
    }

    public void addUserInfo(UserInfo ui) {
        this._userMap.put(ui.getLogin(), ui);
        this._userList.add(ui);
        this._notifyListeners();
    }

    public void removeUser(String login) {
        UserInfo user = (UserInfo)this._userMap.remove(login);
        this._userList.remove(user);
        this._notifyListeners();
    }

    public UserInfo getUserInfo(String login) {
        return (UserInfo)this._userMap.get(login);
    }

    public UserInfo getUserInfo(int userID) {
        for (int i = 0; i < this._userList.size(); ++i) {
            UserInfo ui = (UserInfo)this._userList.get(i);
            if (ui.getID() != userID) continue;
            return ui;
        }
        return null;
    }

    public Set getUsernames() {
        return Collections.unmodifiableSet(this._userMap.keySet());
    }

    public List getUserInfoList() {
        return Collections.unmodifiableList(this._userList);
    }

    public List getUsersForRepository(RepositoryConfig repConfig) {
        ArrayList<UserInfo> result2 = new ArrayList<UserInfo>();
        String repositoryId = repConfig.getRepositoryId();
        for (int i = 0; i < this._userList.size(); ++i) {
            UserInfo userInfo = (UserInfo)this._userList.get(i);
            if (!userInfo.hasReadOrWriteAccess(repositoryId)) continue;
            result2.add(userInfo);
        }
        return result2;
    }

    public int getUnusedUserId() {
        int[] usedIDs = new int[this._userList.size()];
        for (int i = 0; i < this._userList.size(); ++i) {
            UserInfo userInfo = (UserInfo)this._userList.get(i);
            usedIDs[i] = userInfo.getID();
        }
        Arrays.sort(usedIDs);
        int nextUserId = 3;
        while (Arrays.binarySearch(usedIDs, nextUserId) >= 0) {
            ++nextUserId;
        }
        return nextUserId;
    }

    public void setUserId(String login, int id) {
        this.getUserInfo(login).setID(id);
        this._notifyListeners();
    }

    public void setUserLogin(String oldLogin, String newLogin) {
        UserInfo userInfo = this.getUserInfo(oldLogin);
        userInfo.setLogin(newLogin);
        this._userMap.remove(oldLogin);
        this._userMap.put(newLogin, userInfo);
        this._notifyListeners();
    }

    public void setUserFullName(String login, String fullName) {
        this.getUserInfo(login).setFullName(fullName);
        this._notifyListeners();
    }

    public void setUserPassword(String login, String password) {
        this.getUserInfo(login).setPassword(password);
        this._notifyListeners();
    }

    public void addRepositoryConfig(RepositoryConfig ri) {
        RepositoryConfig oldInfo = this._repositoryMap.put(ri.getRepositoryId(), ri);
        if (oldInfo != null) {
            this._repositoryList.remove(oldInfo);
        }
        this._repositoryList.add(ri);
        this._notifyListeners();
    }

    public RepositoryConfig getRepositoryConfig(String id) {
        return (RepositoryConfig)this._repositoryMap.get(id);
    }

    public List getRepositoryConfigList() {
        return Collections.unmodifiableList(this._repositoryList);
    }

    public List getSails(String id) {
        return this.getRepositoryConfig(id).getSailList();
    }

    public Map getParameters(String id, String sailClass) {
        return this.getRepositoryConfig(id).getSail(sailClass).getConfigParameters();
    }

    public void setRepositoryId(String oldId, String newId) {
        RepositoryConfig repository = this.getRepositoryConfig(oldId);
        repository.setRepositoryId(newId);
        this._repositoryMap.remove(oldId);
        this._repositoryMap.put(newId, repository);
        this._notifyListeners();
    }

    public void setRepositoryTitle(String id, String title) {
        this.getRepositoryConfig(id).setTitle(title);
        this._notifyListeners();
    }

    public boolean isWorldReadable(String id) {
        return this.getRepositoryConfig(id).isWorldReadable();
    }

    public void setWorldReadable(String id, boolean worldReadable) {
        this.getRepositoryConfig(id).setWorldReadable(worldReadable);
        this._notifyListeners();
    }

    public boolean isWorldWriteable(String id) {
        return this.getRepositoryConfig(id).isWorldWriteable();
    }

    public void setWorldWriteable(String id, boolean worldWriteable) {
        this.getRepositoryConfig(id).setWorldWriteable(worldWriteable);
        this._notifyListeners();
    }

    public void setSail(String id, String oldClass, String newClass) {
        this.getRepositoryConfig(id).getSail(oldClass).setSailClass(newClass);
        this._notifyListeners();
    }

    public void setParameterKey(String id, String sailClass, String oldKey, String newKey) {
        this.getRepositoryConfig(id).getSail(sailClass).setParameterKey(oldKey, newKey);
        this._notifyListeners();
    }

    public void setParameterValue(String id, String sailClass, String key, String value) {
        this.getRepositoryConfig(id).getSail(sailClass).setParameter(key, value);
        this._notifyListeners();
    }

    public boolean hasAnUser() {
        return !this._userList.isEmpty();
    }

    public boolean hasUser(String login) {
        return this._userMap.containsKey(login);
    }

    public boolean hasARepository() {
        return !this._repositoryList.isEmpty();
    }

    public boolean hasRepository(String id) {
        return this._repositoryMap.containsKey(id);
    }

    public boolean hasASail(String id) {
        return this.getRepositoryConfig(id).hasASail();
    }

    public boolean hasSail(String id, String sailClass) {
        return this.getRepositoryConfig(id).hasSail(sailClass);
    }

    public boolean hasParameter(String id, String sailClass, String key) {
        return this.getRepositoryConfig(id).getSail(sailClass).hasParameter(key);
    }

    public void addUser(int id, String login, String fullName, String password) {
        this.addUserInfo(new UserInfo(id, login, fullName, password));
    }

    public void addRepository(String id, String title) {
        this.addRepositoryConfig(new RepositoryConfig(id, title));
    }

    public RepositoryConfig cloneRepository(String origID, String cloneID) {
        RepositoryConfig repConfig = this.getRepositoryConfig(origID);
        repConfig = (RepositoryConfig)repConfig.clone();
        repConfig.setRepositoryId(cloneID);
        this.addRepositoryConfig(repConfig);
        return repConfig;
    }

    public void addSail(String id, String sailClass, int idx) {
        this.getRepositoryConfig(id).addSail(new SailConfig(sailClass), idx);
        this._notifyListeners();
    }

    public void setParameter(String id, String sailClass, String key, String value) {
        this.getRepositoryConfig(id).getSail(sailClass).setParameter(key, value);
        this._notifyListeners();
    }

    public void removeRepository(String id) {
        RepositoryConfig repository = (RepositoryConfig)this._repositoryMap.remove(id);
        this._repositoryList.remove(repository);
        this._notifyListeners();
    }

    public void removeSail(String id, String sailClass) {
        RepositoryConfig repository = this.getRepositoryConfig(id);
        repository.removeSail(repository.getSail(sailClass));
        this._notifyListeners();
    }

    public void removeParameter(String id, String sailClass, String key) {
        this.getRepositoryConfig(id).getSail(sailClass).removeParameter(key);
        this._notifyListeners();
    }

    public void sailUp(String id, String sailClass) {
        this.getRepositoryConfig(id).sailUp(sailClass);
        this._notifyListeners();
    }

    public void sailDown(String id, String sailClass) {
        this.getRepositoryConfig(id).sailDown(sailClass);
        this._notifyListeners();
    }

    public boolean hasReadAccess(String id, String login) {
        UserInfo user;
        boolean result2 = false;
        RepositoryConfig repository = this.getRepositoryConfig(id);
        if (repository.isWorldReadable()) {
            result2 = true;
        } else if (login != null && (user = this.getUserInfo(login)) != null) {
            result2 = user.hasReadAccess(id);
        }
        return result2;
    }

    public void setReadAccess(String id, String login, boolean readAccess) {
        UserInfo user = this.getUserInfo(login);
        RepositoryConfig repository = this.getRepositoryConfig(id);
        if (readAccess) {
            user.addReadAccess(repository);
        } else {
            user.removeReadAccess(repository);
        }
        this._notifyListeners();
    }

    public boolean hasWriteAccess(String id, String login) {
        UserInfo user;
        boolean result2 = false;
        RepositoryConfig repository = this.getRepositoryConfig(id);
        if (repository.isWorldWriteable()) {
            result2 = true;
        } else if (login != null && (user = this.getUserInfo(login)) != null) {
            result2 = user.hasWriteAccess(id);
        }
        return result2;
    }

    public void setWriteAccess(String id, String login, boolean writeAccess) {
        UserInfo user = this.getUserInfo(login);
        RepositoryConfig repository = this.getRepositoryConfig(id);
        if (writeAccess) {
            user.addWriteAccess(repository);
        } else {
            user.removeWriteAccess(repository);
        }
        this._notifyListeners();
    }

    public boolean hasReadOrWriteAccess(String id, String login) {
        return this.hasReadAccess(id, login) || this.hasWriteAccess(id, login);
    }

    public boolean hasReadAndWriteAccess(String id, String login) {
        return this.hasReadAccess(id, login) && this.hasWriteAccess(id, login);
    }

    public void setSystemConfig(SystemConfig other) {
        this._adminPassword = other._adminPassword;
        this._logDir = other._logDir;
        this._logLevel = other._logLevel;
        this._tmpDir = other._tmpDir;
        this._rmiEnabled = other._rmiEnabled;
        this._rmiFactoryClass = other._rmiFactoryClass;
        this._rmiPort = other._rmiPort;
        this._systemProps = new Properties(other._systemProps);
        this._userMap = new HashMap(other._userMap);
        this._userList = new ArrayList(other._userList);
        this._repositoryMap = new HashMap(other._repositoryMap);
        this._repositoryList = new ArrayList(other._repositoryList);
        this._notifyListeners();
    }

    public void addListener(SystemConfigListener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(SystemConfigListener listener) {
        this._listeners.remove(listener);
    }

    protected void _notifyListeners() {
        Iterator i = this._listeners.iterator();
        while (i.hasNext()) {
            SystemConfigListener listener = (SystemConfigListener)i.next();
            listener.configurationChanged();
        }
    }
}

