/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openrdf.sesame.config.RepositoryInfo;
import org.openrdf.sesame.config.SailConfig;

public class RepositoryConfig
implements RepositoryInfo,
Cloneable {
    private static final Class RDF_SOURCE_CLASS;
    private static final Class RDF_REPOSITORY_CLASS;
    private static final Class RDF_SCHEMA_SOURCE_CLASS;
    private static final Class RDF_SCHEMA_REPOSITORY_CLASS;
    private String _id;
    private String _title;
    private boolean _worldReadable;
    private boolean _worldWriteable;
    private List _sailList;

    public RepositoryConfig(String id) {
        this(id, null);
    }

    public RepositoryConfig(String id, String title) {
        this(id, title, false, false);
    }

    public RepositoryConfig(String id, boolean worldReadable, boolean worldWriteable) {
        this(id, null, worldReadable, worldWriteable);
    }

    public RepositoryConfig(String id, String title, boolean worldReadable, boolean worldWriteable) {
        this._id = id;
        this._title = title;
        this._worldReadable = worldReadable;
        this._worldWriteable = worldWriteable;
        this._sailList = new LinkedList();
    }

    public String getRepositoryId() {
        return this._id;
    }

    public void setRepositoryId(String id) {
        this._id = id;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public boolean isWorldReadable() {
        return this._worldReadable;
    }

    public void setWorldReadable(boolean worldReadable) {
        this._worldReadable = worldReadable;
    }

    public boolean isWorldWriteable() {
        return this._worldWriteable;
    }

    public void setWorldWriteable(boolean worldWriteable) {
        this._worldWriteable = worldWriteable;
    }

    public void makePrivate() {
        this.setWorldReadable(false);
        this.setWorldWriteable(false);
    }

    public void makePublic() {
        this.setWorldReadable(true);
        this.setWorldWriteable(true);
    }

    public boolean isReadable() {
        if (this._sailList.size() > 0) {
            SailConfig topSail = (SailConfig)this._sailList.get(0);
            try {
                Class<?> sailClass = Class.forName(topSail.getSailClass());
                return RDF_SOURCE_CLASS.isAssignableFrom(sailClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isWriteable() {
        if (this._sailList.size() > 0) {
            SailConfig topSail = (SailConfig)this._sailList.get(0);
            try {
                Class<?> sailClass = Class.forName(topSail.getSailClass());
                return RDF_REPOSITORY_CLASS.isAssignableFrom(sailClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    public void stackSail(SailConfig sailConfig) {
        this._sailList.add(0, sailConfig);
    }

    public void addSail(SailConfig sailConfig) {
        this._sailList.add(sailConfig);
    }

    public void addSail(SailConfig sailConfig, int index) {
        this._sailList.add(index, sailConfig);
    }

    public boolean removeSail(SailConfig sailConfig) {
        return this._sailList.remove(sailConfig);
    }

    public SailConfig removeSail(int index) {
        return (SailConfig)this._sailList.remove(index);
    }

    public List getSailList() {
        return Collections.unmodifiableList(this._sailList);
    }

    public void setSailList(List sailList) {
        this._sailList = sailList;
    }

    public boolean hasASail() {
        return !this._sailList.isEmpty();
    }

    public boolean hasSail(String sailClass) {
        return this.getSail(sailClass) != null;
    }

    public SailConfig getSail(String sailClass) {
        Iterator iter2 = this._sailList.iterator();
        while (iter2.hasNext()) {
            SailConfig sailConfig = (SailConfig)iter2.next();
            if (!sailConfig.getSailClass().equals(sailClass)) continue;
            return sailConfig;
        }
        return null;
    }

    public String getSailType() {
        String sailType = null;
        SailConfig topSailConfig = (SailConfig)this._sailList.get(0);
        String sailClassName = topSailConfig.getSailClass();
        try {
            Class<?> sailClass = Class.forName(sailClassName);
            if (RDF_SCHEMA_REPOSITORY_CLASS.isAssignableFrom(sailClass)) {
                sailType = "org.openrdf.sesame.sail.RdfSchemaRepository";
            } else if (RDF_REPOSITORY_CLASS.isAssignableFrom(sailClass)) {
                sailType = "org.openrdf.sesame.sail.RdfRepository";
            } else if (RDF_SCHEMA_SOURCE_CLASS.isAssignableFrom(sailClass)) {
                sailType = "org.openrdf.sesame.sail.RdfSchemaSource";
            } else if (RDF_SOURCE_CLASS.isAssignableFrom(sailClass)) {
                sailType = "org.openrdf.sesame.sail.RdfSource";
            }
        }
        catch (ClassNotFoundException ignore) {
            // empty catch block
        }
        return sailType;
    }

    public void sailUp(String sailClass) {
        int idx;
        SailConfig sailConfig = null;
        for (idx = 0; idx < this._sailList.size() && !(sailConfig = (SailConfig)this._sailList.get(idx)).getSailClass().equals(sailClass); ++idx) {
        }
        if (idx > 0 && idx < this._sailList.size()) {
            this._sailList.remove(idx);
            this._sailList.add(idx - 1, sailConfig);
        }
    }

    public void sailDown(String sailClass) {
        int idx;
        SailConfig sailConfig = null;
        for (idx = 0; idx < this._sailList.size() && !(sailConfig = (SailConfig)this._sailList.get(idx)).getSailClass().equals(sailClass); ++idx) {
        }
        if (idx < this._sailList.size() - 1) {
            this._sailList.remove(idx);
            this._sailList.add(idx + 1, sailConfig);
        }
    }

    public Object clone() {
        try {
            RepositoryConfig clone2 = (RepositoryConfig)super.clone();
            clone2._sailList = new LinkedList();
            Iterator iter2 = this._sailList.iterator();
            while (iter2.hasNext()) {
                SailConfig sailConfig = (SailConfig)iter2.next();
                clone2._sailList.add((SailConfig)sailConfig.clone());
            }
            return clone2;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            RDF_SOURCE_CLASS = Class.forName("org.openrdf.sesame.sail.RdfSource");
            RDF_REPOSITORY_CLASS = Class.forName("org.openrdf.sesame.sail.RdfRepository");
            RDF_SCHEMA_SOURCE_CLASS = Class.forName("org.openrdf.sesame.sail.RdfSchemaSource");
            RDF_SCHEMA_REPOSITORY_CLASS = Class.forName("org.openrdf.sesame.sail.RdfSchemaRepository");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

