/*
 * Decompiled with CFR 0.152.
 */
package org.junit.rules;

import java.io.File;
import java.io.IOException;
import org.junit.rules.ExternalResource;

public class TemporaryFolder
extends ExternalResource {
    private File folder;

    protected void before() throws Throwable {
        this.create();
    }

    protected void after() {
        this.delete();
    }

    public void create() throws IOException {
        this.folder = File.createTempFile("junit", "");
        this.folder.delete();
        this.folder.mkdir();
    }

    public File newFile(String fileName) throws IOException {
        File file = new File(this.folder, fileName);
        file.createNewFile();
        return file;
    }

    public File newFolder(String folderName) {
        File file = new File(this.folder, folderName);
        file.mkdir();
        return file;
    }

    public File getRoot() {
        return this.folder;
    }

    public void delete() {
        this.recursiveDelete(this.folder);
    }

    private void recursiveDelete(File file) {
        File[] files2 = file.listFiles();
        if (files2 != null) {
            for (File each : files2) {
                this.recursiveDelete(each);
            }
        }
        file.delete();
    }
}

